//----------------------------------------------------------------------------
// MS Windows Style .ini File Interface for C++
// This is the first version.
// Programed by xuyifeng, 1995.10, china
//----------------------------------------------------------------------------
// Test history:
//         Compiler              OS                          TEST
//         ---------------------------------------------------------------
//         Watcom  C++ 10.0a     Rational System DOS4GW      100% tested
//         Borland C++ 3.1       DOS                         100% tested
//----------------------------------------------------------------------------
#if (_MSC_VER >= 1400)
#define _CRT_SECURE_NO_DEPRECATE 1
#define _CRT_NONSTDC_NO_DEPRECATE 1
#endif

#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include <string.h>
#include <ctype.h>
#include <fstream>
#include <iostream>

#include "profile.h"
//------------------------------------------------------------------------------
// titlePos: get a section title position & length in a string.
//------------------------------------------------------------------------------
static char *titlePos( char *buf, int *len )
{
	char *p = buf, *q;

	while( *p && isspace(*p) ) p++;
	if( *p != '[' )
		return 0;

	q = p+1;
	while( *q && *q != ']' ) q++;
	if( *q != ']' )
		return 0;
	if( len )
		*len = int(q - p - 1);
	return p+1;
}

//------------------------------------------------------------------------------
// isTitleLine: check if a string is a section title line
//------------------------------------------------------------------------------
static int isTitleLine( char *bufPtr )
{
	return titlePos( bufPtr, 0 ) != 0;
}

//------------------------------------------------------------------------------
// containTitle: check if a string contain a section a title
//------------------------------------------------------------------------------
static int containTitle( char *buf, const char *section )
{
	char *p;
	int len;

	p = titlePos( buf, &len );
	if( p )
	{
	   if( strlen( section ) == 0 || len && strnicmp( section, p, len ) == 0 )
		   return true;
	}
	return false;
}

//------------------------------------------------------------------------------
// gotoSection: move file position to start line of a section
//------------------------------------------------------------------------------
static int gotoSection( std::fstream &is, const char *section )
{
	char line[256];
	while( is.getline( line, 256 ) )
	   if( containTitle( line, section ) )
		   return true;
	return false;
}

//------------------------------------------------------------------------------
// textPos: get content's position of a entry
//------------------------------------------------------------------------------
static char *textPos( char *buf, const char *entry )
{
	if( buf[0] == ';' ) // it is comment line
		return 0;

	char *p = strchr( buf, '=' );
	if( !p )
		return 0;

	int len = int(p - buf);
	if( strlen(entry) == 0 || len && strnicmp( buf, entry, len ) == 0 )
		return p+1;

	return 0;
}

//------------------------------------------------------------------------------
// stripQuotationChar: strip a pair of quotation chars in a string
//------------------------------------------------------------------------------
static void stripQuotationChar( char *buf )
{
	char *p;
	char *q;

	p = buf;
	while( *p && isspace(*p) ) p++;

	if( !(*p == '\"' || *p == '\'') )
		return;

	q = p+strlen(p);
	while( *q != *p && q > p ) q--;
	if( q == p )
		return;
	int len = int(q - p - 1);
	memmove( buf, p+1, len );
	buf[len] = 0;
}

//------------------------------------------------------------------------------
// readEntry: read content of entry
//------------------------------------------------------------------------------
static int readEntry( std::fstream &is, const char *entry, char *buf, int bufSize,
					  int strip )
{
	char lineBuf[256];
	char *p, *cur;
	int  len;

	cur  = buf;
	*cur = '\0';
	len  = -1;
	while( is.getline( lineBuf, 256 ) )
	{
		if( isTitleLine( lineBuf ) )       // section is ended
			break;

		p = textPos( lineBuf, entry );     // not equal this entry
		if( p == 0 )
			continue;

		if( strip )
			stripQuotationChar( p );

		len = strlen(p);
		if( bufSize-1 < len )
			len = bufSize-1;

		strncpy( cur, p, len );
		cur[len] = 0;
		break;
	}

	return len;
}

//------------------------------------------------------------------------------
// getProfileString:
//------------------------------------------------------------------------------
int getProfileString( const char *section,
					  const char *entry,
					  const char *defaultString,
					  char *buffer,
					  int   bufLen,
					  const char *fileName )
{
	std::fstream is( fileName, std::ios::in );
	int len = -1;

	if( gotoSection( is, section ) )
		len = readEntry(is, entry, buffer, bufLen, true);

	if( len < 0 ) //can not read entry, use default string
	{
		strncpy( buffer, defaultString, bufLen-1 );
		buffer[bufLen-1] = 0;
		len = strlen(buffer);
	}
	return len;
}

//----------------------------------------------------------------------------
// getProfileInt:
//----------------------------------------------------------------------------
int getProfileInt( const char *section,
				   const char *entry,
				   int defaultInt,
				   const char *fileName )
{
	char buf[256];
    char iBuf[34];   //"34" is max space "itoa" required under 32 bit C++

	itoa( defaultInt, iBuf, 10 );
	getProfileString( section, entry, iBuf, buf, 256, fileName );
	return atoi( buf );
}

float getProfileFloat( const char *section,
				   const char *entry,
				   float defaultInt,
				   const char *fileName )
{
	char buf[256];
    char iBuf[68];   //"34" is max space "itoa" required under 32 bit C++

	itoa((int) defaultInt, iBuf, 20 );
	getProfileString( section, entry, iBuf, buf, 256, fileName );
	return (float) atof(buf );
}

static void writeEntry( std::fstream & os, const char *entry, const char *string )
{
    os << entry << '=' << string << std::endl;
}

//------------------------------------------------------------------------------
// writeProfileString:
//------------------------------------------------------------------------------
int writeProfileString( const char *section,
						const char *entry,
						const char *string,
						const char *fileName )
{
    char path [_MAX_PATH];
	char drive[_MAX_DRIVE];
	char dir  [_MAX_DIR];
	char file [_MAX_FNAME];
	char ext  [_MAX_EXT];
	char buf  [256];

	int  titleFound, entryFound;

    // work better on network!
    _splitpath( path, drive, dir, file, ext );
    _makepath(  path, drive, dir, tmpnam(0), "" );

    std::fstream is( fileName, std::ios::in  );
    std::fstream os( path,     std::ios::out );

    if( !os || entry == 0 )     //maybe can not create file or invalid entry
		return 0;

	titleFound = false;
	entryFound = false;
	while( is.getline(buf, 256) )
	{
		os << buf << std::endl;
		if( containTitle(buf, section) )
		{
			titleFound = true;
			break;
		}
	}

	if( !titleFound )   // add section
	{
		os << '[' << section << ']' << std::endl;
		writeEntry( os, entry, string );
	}
	else
	{
	   while( is.getline(buf, 256) )
	   {
		 if( isTitleLine( buf ) )     // section ended, but still not found the entry
			 break;

		 if( textPos( buf, entry ) )  // entry found, so rewrite it
		 {
			 entryFound = true;
			 break;
		 }
		 os << buf << std::endl;
	   }

	   writeEntry( os, entry, string );

	   if( is.gcount() > 0 && !entryFound )
		   os << buf << std::endl;

	   while( is.getline(buf, 256) )  // copy left lines
			  os << buf << std::endl;
	}
	is.close();
	os.close();
	unlink( fileName );
    rename( path, fileName );
	return strlen(string);
}