#include <iostream>
#include <string>
#include <fstream>
#include <conio.h>

#include "THUHandler.h"

int main(int argc, char **argv)
{
	if (argc < 2)
	{
		std::cerr << "Error: Must supply THU file to load\nSyntax: THUParser.exe \"THUFile.thu\"\n";
		return 1;
	}
	char *szFilePath = argv[1];

	std::string szOutputFile = std::string(szFilePath) + ".txt";
	std::ofstream Output(szOutputFile.c_str());
	if (false == Output.is_open())
	{
		std::cerr << "Error: Failed to create output file!\n";
		return 2;
	}

	CTHUHandler hTHUHandler;
	if (false == hTHUHandler.Load(szFilePath))
	{
		std::cerr << "Error: Failed to open \'" << szFilePath << "\'!\n";
		return 2;
	}

	// Print out data
	Output << "Contents of " << szFilePath << ":\n\n";
	Output << "Texture Count: " << hTHUHandler.GetTextureCount() << "\n\n";
	CTHUHandler::TEXTURES textures = hTHUHandler.GetTextures();
	for (CTHUHandler::TEXTURES::iterator i = textures.begin(); i != textures.end(); i++)
	{
		char *szFile = new char [i->dwFileLength+1];
		strncpy(szFile, i->pchFile, i->dwFileLength);
		szFile[i->dwFileLength] = '\0';
		Output << "Texture \'" << szFile << "\':\n"
			<< "\tIdentifier: \'" << i->dwIdentifier << "\'\n"
			<< "\tData Offset: \'" << i->dwDataOffset << "\'\n"
			<< "\tUnknown1: \'" << i->dwUnknown1 << "\'\n"
			<< "\tUnknown2: \'" << i->dwUnknown2 << "\'\n"
			<< "\tWidth: \'" << i->dwWidth << "\'\n"
			<< "\tHeight: \'" << i->dwHeight << "\'\n"
			<< "\tDimension Multiplier: \'" << i->dwDimMult << "\'\n"
			<< "\tPixel Format: \'" << i->dwPixelFormat << "\'\n\n";
		delete [] szFile;
	}

	std::cout << "Success! Outputted to " << szOutputFile << '\n';
	return 0;
}