// THUUpdaterDlg.cpp : implementation file
//

#include "stdafx.h"
#include "THUUpdater.h"
#include "THUUpdaterDlg.h"
#include "THUHandler.h"
#include ".\thuupdaterdlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define DEFAULT_TEXTURE_PATH		"C:\\Westwood\\Renegade\\Data"
#define TEXTURE_FOLDER_PATH_SIZE	512

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CTHUUpdaterDlg dialog



CTHUUpdaterDlg::CTHUUpdaterDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CTHUUpdaterDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	this->m_pD3DObject = NULL;
	this->m_pD3DDevice = NULL;
}

CTHUUpdaterDlg::~CTHUUpdaterDlg(void)
{
	if (NULL != this->m_pD3DDevice)
	{
		this->m_pD3DDevice->Release();
		this->m_pD3DDevice = NULL;
	}
	if (NULL != this->m_pD3DObject)
	{
		this->m_pD3DObject->Release();
		this->m_pD3DObject = NULL;
	}
}

void CTHUUpdaterDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CTHUUpdaterDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTONADD, OnBnClickedButtonadd)
	ON_LBN_SELCHANGE(IDC_LISTTHUFILES, OnLbnSelchangeListthufiles)
	ON_BN_CLICKED(IDC_BUTTONREMOVE, OnBnClickedButtonremove)
	ON_BN_CLICKED(IDC_BUTTONTEXTUREPATH, OnBnClickedButtontexturepath)
	ON_BN_CLICKED(IDC_BUTTONUPDATE, OnBnClickedButtonupdate)
END_MESSAGE_MAP()


// CTHUUpdaterDlg message handlers

BOOL CTHUUpdaterDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Initialize DX items
	// Create the object
	if (NULL == (this->m_pD3DObject = Direct3DCreate9(D3D_SDK_VERSION))) return FALSE;
	
	// Create the device
	D3DPRESENT_PARAMETERS D3PP;
	ZeroMemory(&D3PP, sizeof(D3DPRESENT_PARAMETERS));
	D3PP.Windowed = true;
	D3PP.SwapEffect = D3DSWAPEFFECT_DISCARD;
	if (FAILED(this->m_pD3DObject->CreateDevice(D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, this->m_hWnd,
		D3DCREATE_HARDWARE_VERTEXPROCESSING, &D3PP, &this->m_pD3DDevice))) return FALSE;

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// Initialize dialog objects
	CEdit *pTexturePath = (CEdit*)this->GetDlgItem(IDC_EDITTEXTUREPATH);
	if (NULL != pTexturePath) pTexturePath->SetWindowText(DEFAULT_TEXTURE_PATH);

	// Disable the clear/udpate buttons off the bat
	CButton *pRemoveButton = (CButton*)this->GetDlgItem(IDC_BUTTONREMOVE);
	if (NULL != pRemoveButton) pRemoveButton->EnableWindow(FALSE);
	CButton *pUpdateButton = (CButton*)this->GetDlgItem(IDC_BUTTONUPDATE);
	if (NULL != pUpdateButton) pUpdateButton->EnableWindow(FALSE);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CTHUUpdaterDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CTHUUpdaterDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// AddTextToLog - Add text to the log
void CTHUUpdaterDlg::AddTextToLog(char const* text)
{
	// Get log object
	CEdit *pLog = (CEdit*)this->GetDlgItem(IDC_EDITLOG);
	if (NULL == pLog) return;

	// Append text onto the end of it
	CString szLogData;
	pLog->GetWindowText(szLogData);
	szLogData += text;
	szLogData += "\r\n";

	// Update and show the dialog
	pLog->SetWindowText(szLogData);
	pLog->UpdateWindow();
}
void CTHUUpdaterDlg::OnBnClickedButtonadd()
{
	// Create and show a common open dialog
	CFileDialog hOpenDialog(true, "THU", NULL, OFN_FILEMUSTEXIST|OFN_PATHMUSTEXIST,
		"THU Files (*.thu)|*.thu||");
	if (IDOK == hOpenDialog.DoModal())
	{
		CString szFilePath = hOpenDialog.GetPathName();

		// Add it to the list (avoid duplications)
		CListBox *pTHUFileList = (CListBox*)this->GetDlgItem(IDC_LISTTHUFILES);
		if (NULL == pTHUFileList) return;
		int nCount = pTHUFileList->GetCount();
		for (int i = 0; i < nCount; i++)
		{
			CString szEntry;
			pTHUFileList->GetText(i, szEntry);
			if (szEntry == szFilePath) return;
		}

		// No duplicates!
		pTHUFileList->AddString(szFilePath);
		this->OnLbnSelchangeListthufiles();
	}
}

void CTHUUpdaterDlg::OnLbnSelchangeListthufiles()
{
	CListBox *pTHUFileList = (CListBox*)this->GetDlgItem(IDC_LISTTHUFILES);
	if (NULL == pTHUFileList) return;
	int nCount = pTHUFileList->GetCount();

	CButton *pRemoveButton = (CButton*)this->GetDlgItem(IDC_BUTTONREMOVE);
	CButton *pUpdateButton = (CButton*)this->GetDlgItem(IDC_BUTTONUPDATE);

	// Check count; if less than 0, disable remove and build buttons
	if (nCount <= 0)
	{
		if (NULL != pRemoveButton) pRemoveButton->EnableWindow(FALSE);
		if (NULL != pUpdateButton) pUpdateButton->EnableWindow(FALSE);
		pRemoveButton->SetWindowText("Clear");
	}
	else
	{
		int nSelCount = pTHUFileList->GetSelCount();
		if (NULL != pUpdateButton) pUpdateButton->EnableWindow(TRUE);
		if (NULL != pRemoveButton)
		{
			pRemoveButton->EnableWindow(TRUE);

			// If count is greater than zero, display remove.  Otherwise, display clear.
			if (nSelCount >= 1)
				pRemoveButton->SetWindowText("Remove");
			else
				pRemoveButton->SetWindowText("Clear");
		}
	}
}

void CTHUUpdaterDlg::OnBnClickedButtonremove()
{
	CListBox *pTHUFileList = (CListBox*)this->GetDlgItem(IDC_LISTTHUFILES);
	if (NULL == pTHUFileList) return;
	int nSelCount = pTHUFileList->GetSelCount();

	// If nothing selected, remove all entries
	if (nSelCount <= 0)
	{
		// Remove all entries
		while (0 < pTHUFileList->DeleteString(0));
	}
	else
	{
		// Remove selected entries
		int nCount = pTHUFileList->GetCount();
		CArray<int,int> aListBoxSel;
		aListBoxSel.SetSize(nSelCount);
		int nTotal = pTHUFileList->GetSelItems(nSelCount, aListBoxSel.GetData());
		for (int i = 0; i < nTotal; i++)
		{
			pTHUFileList->DeleteString(aListBoxSel.GetAt(i));
			// Compinsate for loss of item (decrement all items in front of it)
			for (int j = 0; j < nTotal; j++)
			{
				if (aListBoxSel.GetAt(j) > aListBoxSel.GetAt(i))
					aListBoxSel.GetAt(j)--;
			}
		}
	}
	this->OnLbnSelchangeListthufiles();
}

void CTHUUpdaterDlg::OnBnClickedButtontexturepath()
{
	// Get the level listbox
	CEdit *pTexturePath = (CEdit*)this->GetDlgItem(IDC_EDITTEXTUREPATH);
	if (NULL == pTexturePath) return;

	// Create and show a folder browser dialog
	BROWSEINFO hBrowseInfo;
	LPCITEMIDLIST pIDL;
	char szFolderPath[TEXTURE_FOLDER_PATH_SIZE];

	// Fill browseinfo struct
	ZeroMemory(&hBrowseInfo, sizeof(BROWSEINFO));
	hBrowseInfo.hwndOwner = this->m_hWnd;
	hBrowseInfo.lpszTitle = "Select Location of Texture Files...";

	// Get user-selected level folder
	if (NULL != (pIDL = SHBrowseForFolder(&hBrowseInfo)) && TRUE == SHGetPathFromIDList(pIDL, szFolderPath))
	{
		// Update the edit box's text with it
		pTexturePath->SetWindowText(szFolderPath);
	}
}

void CTHUUpdaterDlg::OnBnClickedButtonupdate()
{
	// Get log item
	CEdit *pLog = (CEdit*)this->GetDlgItem(IDC_EDITLOG);
	if (NULL == pLog) return;
	pLog->SetWindowText(""); // Clear log

	// Get texture path
	CEdit *pTexturePath = (CEdit*)this->GetDlgItem(IDC_EDITTEXTUREPATH);
	if (NULL == pTexturePath) return;
	CString szTexturePath; pTexturePath->GetWindowText(szTexturePath);

	// Get selected THU files
	CListBox *pTHUFileList = (CListBox*)this->GetDlgItem(IDC_LISTTHUFILES);
	if (NULL == pTHUFileList) return;
	int nSelCount = pTHUFileList->GetSelCount(), nTotal = 0;
	CArray<int,int> aListBoxSel;
	if (nSelCount <= 0)
	{
		nSelCount = pTHUFileList->GetCount();
		aListBoxSel.SetSize(nSelCount);
		for (int i = 0; i < nSelCount; i++)
			aListBoxSel.ElementAt(i) = i;
		nTotal = nSelCount;
	}
	else
	{
		aListBoxSel.SetSize(nSelCount);
		nTotal = pTHUFileList->GetSelItems(nSelCount, aListBoxSel.GetData());
	}

	// For each THU file selected...
	CTHUHandler hTHUHandler;
	CString szTHUFile;
	bool bMadeChanges = false;
	IDirect3DTexture9 *pTextureElement = NULL;
	D3DXIMAGE_INFO hTextureInfo;
	for (int i = 0; i < nTotal; i++)
	{
		// Get the THU file to work on this time around
		int line = aListBoxSel.GetAt(i);
		pTHUFileList->GetText(line, szTHUFile);
		bool bOpened = hTHUHandler.Load(szTHUFile.GetString());
		AddTextToLog("------------------------------------------------------------------------");
		AddTextToLog(CString("THU File: ") + szTHUFile);
		AddTextToLog(CString("Status: ") + (true == bOpened ? "OK" : "Failed to open"));
		if (true == bOpened)
		{
			char texturecountmsg[256];
			sprintf(texturecountmsg, "Texture Count: %d", hTHUHandler.GetTextureCount());
			AddTextToLog(texturecountmsg);
		}
		AddTextToLog("------------------------------------------------------------------------\r\n");

		// Cycle through each texture
		bMadeChanges = false;
		CTHUHandler::TEXTURES *TextureList = &hTHUHandler.GetTextures();
		if (NULL != TextureList)
		{
			for (CTHUHandler::TEXTURES::iterator i = TextureList->begin(); i != TextureList->end(); i++)
			{
				ZeroMemory(&hTextureInfo, sizeof(D3DXIMAGE_INFO));

				// Load the texture element
				char *szTextureName = new char [i->dwFileLength + 1];
				if (NULL == szTextureName) continue;
				strncpy(szTextureName, i->pchFile, i->dwFileLength);
				szTextureName[i->dwFileLength] = '\0';
				CString szTextureFile = szTexturePath + "\\" + szTextureName;
				delete [] szTextureName;
				if (FAILED(D3DXCreateTextureFromFileEx(this->m_pD3DDevice, szTextureFile.GetString(), 0, 0, 0, 0, D3DFMT_UNKNOWN,
					D3DPOOL_SYSTEMMEM, D3DX_DEFAULT, D3DX_DEFAULT, 0, &hTextureInfo,
					NULL, &pTextureElement))) continue;

				// Compare the sizes
				if (i->dwWidth != hTextureInfo.Width || i->dwHeight != hTextureInfo.Height)
				{
					// Update the texture element
					AddTextToLog(CString("Texture element \'") + szTextureFile + CString("\' size changed, updating..."));
					i->dwWidth = hTextureInfo.Width;
					i->dwHeight = hTextureInfo.Height;
					bMadeChanges = true;
				}

				// Release texture element
				pTextureElement->Release();
				pTextureElement = NULL;
			}
		}

		// Update it
		if (true == bMadeChanges)
		{
			if (false == hTHUHandler.Update())
				AddTextToLog("ERROR: Failed to update the THU file!");
			else
				AddTextToLog("THU file updated successfully!");
		}
		else
		{
			AddTextToLog("No changes made to this THU file.");
		}

		// Close the THU handler
		AddTextToLog("\r\n");
		hTHUHandler.Unload();
	}
}
