/*	Renegade Scripts.dll
	Resource loader class
	Copyright 2007 Jonathan Wilson, Mark Sararu

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <process.h> /* _beginthread, _endthread */
#include "scripts.h"
#include "shadereng.h"
#include "resourcemanager.h"

ResourceLoaderClass *ResourceFactory;

bool RunLoaderThread;
ResourceLoadTask::ResourceLoadTask()
{
	Data = 0;
}
ResourceLoadTask::ResourceLoadTask(void *data)
{
	Data = data;
}
bool ResourceLoadTask::RunResourceLoadTask(void *arg)
{
	DWORD dwWaitResult; 
	dwWaitResult = WaitForSingleObject(arg,250);
	switch (dwWaitResult) 
	{
		case WAIT_OBJECT_0: 
 			this->LoadResource();
			ReleaseMutex(arg);
			break; 
		case WAIT_TIMEOUT: 
			return false; 
			break;
	}
	return true;
}
void ResourceLoadTask::LoadResource()
{

}

ResourceLoaderClass::ResourceLoaderClass()
{
	RunLoaderThread = true;
	LoadTasks = new LoadTaskList();
	Mutex = CreateMutex(NULL,false,NULL);
	TaskThreadHandle = (HANDLE)_beginthreadex(NULL,0,ResourceLoaderClass::ProcessTasks,this,0,&TaskThreadID);
}

ResourceLoaderClass::~ResourceLoaderClass()
{
	delete LoadTasks;
}

void ResourceLoaderClass::SetPriority(int priority)
{
	SetThreadPriority(TaskThreadHandle,priority);
}
unsigned int WINAPI ResourceLoaderClass::ProcessTasks(void *data)
{
	SetThreadName((unsigned long)-1,"ResourceLoaderThread");
	ResourceLoaderClass *loader = (ResourceLoaderClass *) data;
	LoadTaskListNode *node;
	while (RunLoaderThread)
	{
		node = loader->LoadTasks->Head;
		if (node != NULL)
		{
			node->Data->RunResourceLoadTask(loader->Mutex);
			delete node->Data;
			loader->LoadTasks->RemoveNode(loader->LoadTasks->Head);
			delete node;
			node = 0;
		}
		else 
		{
			Sleep(100);
		}
	}
	_endthreadex(0);
	return 0;
}

void ResourceLoaderClass::EnqueueTask(ResourceLoadTask *task, ResourceLoadPriority priority)
{
	if (priority == RESOURCELOADPRIORITY_HIGH)
	{
		LoadTasks->PrependNode(new LoadTaskListNode(task));
	}
	else
	{
		LoadTasks->AppendNode(new LoadTaskListNode(task));
	}
}

void ResourceLoaderClass::ProcessTaskImmediate(ResourceLoadTask *task)
{
	task->RunResourceLoadTask(Mutex);
}
