/*	Renegade Scripts.dll
	Cube texture class and loader
	Copyright 2007 Mark Sararu

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <d3d9.h>
#include <d3dx9.h>
#include <d3d8caps.h>
#include "scripts.h"
#include "shadereng.h"
#include "resourcemanager.h"
#include "cubetexture.h"

CubeTextureClass::CubeTextureClass(const char* name)
{
	Initialized = false;
	Name = (char*) name;
	IsMissing = false;
	D3DTexture = 0;
}
void CubeTextureClass::Delete_This()
{
	D3DTexture->Release();
}
void CubeTextureClass::Initialize()
{
	TextureLoadTask = new CubeTextureLoadTask(this);
	ResourceFactory->EnqueueTask(TextureLoadTask,RESOURCELOADPRIORITY_NORMAL);
}


const unsigned char defaultCubeTextureConst[12417] = 
{
	0x44,0x44,0x53,0x20,0x7c,0x00,0x00,0x00,0x07,0x10,0x00,0x00,0x40,0x00,0x00,0x00,0x40,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x20,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x44,0x58,0x54,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x10,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0b,0x32,0xea,0x31,0x0b,0x0b,0x0f,0x0f,0x4c,0x3a,0x2b,0x32,
	0x3d,0x05,0xfd,0xf5,0xae,0x42,0x4c,0x3a,0x2f,0xad,0xaf,0xbd,0x10,0x4b,0xae,0x42,0x2d,0x0d,0x2d,0x3d,
	0xf6,0x8c,0x10,0x43,0xfb,0xf2,0xf3,0xf9,0x97,0x74,0xd4,0x5b,0x2d,0xad,0x3d,0x3d,0xfd,0x95,0xb8,0x74,
	0x2d,0x2d,0x2d,0x2d,0x7f,0xc7,0x7c,0xae,0x4b,0xcb,0xc9,0x49,0x2e,0x85,0x0d,0x85,0x7e,0x7a,0x50,0x7a,
	0x0d,0x85,0xcc,0x7c,0xfe,0xfa,0x7a,0xea,0xed,0x84,0x0c,0x7d,0xee,0xb3,0xea,0xf2,0x2d,0x85,0x0d,0x85,
	0x09,0x0b,0x02,0x82,0x2c,0x85,0x0d,0x85,0xf5,0x6d,0xed,0xed,0x0d,0x85,0xec,0x7c,0x00,0x82,0xa0,0xa0,
	0x0c,0x85,0xcb,0x7c,0xb8,0xb8,0xee,0xb6,0xeb,0x84,0x0c,0x7d,0xaa,0xa0,0x40,0xaa,0x0b,0x32,0xea,0x31,
	0x0b,0x2e,0x0f,0x02,0x4c,0x3a,0x0b,0x32,0x3f,0xaf,0xad,0x2f,0x8d,0x42,0x4c,0x3a,0x2d,0x2f,0x3d,0x2d,
	0xf0,0x4a,0xae,0x42,0x05,0x35,0x05,0x35,0x92,0x5b,0x10,0x4b,0x09,0x2f,0x2d,0x2d,0x77,0x6c,0xb3,0x5b,
	0x2d,0x2d,0x2d,0x2d,0xdc,0x95,0xb8,0x74,0x2d,0x2d,0x2d,0x2d,0x5f,0xbf,0x7d,0xa6,0xc9,0xc9,0xc9,0xc9,
	0x2e,0x85,0x0d,0x85,0x78,0xf8,0x68,0xe0,0x0d,0x85,0xcc,0x7c,0xea,0xe8,0x4a,0xe8,0x0d,0x85,0xcc,0x7c,
	0x2f,0x2f,0x2b,0xad,0x2d,0x85,0x0c,0x85,0x82,0x83,0xc3,0xc3,0x2d,0x85,0x0d,0x85,0xef,0xef,0x7b,0x7e,
	0x0d,0x85,0xcc,0x7c,0x20,0x80,0xa8,0x60,0x0c,0x85,0xcc,0x7c,0xff,0xae,0xbf,0x2d,0x0d,0x85,0xec,0x7c,
	0xff,0xbf,0xeb,0xe2,0x2b,0x32,0x0b,0x32,0xd5,0xd5,0xfd,0xfd,0x4c,0x3a,0x2c,0x32,0xf5,0x3d,0xf5,0x3d,
	0x8d,0x42,0x4c,0x3a,0xad,0xbd,0x3d,0xbd,0xef,0x4a,0x8d,0x42,0x2d,0x2f,0x3d,0x3d,0x92,0x5b,0xef,0x4a,
	0x2f,0x2d,0xad,0x2d,0x56,0x6c,0xb3,0x5b,0x2d,0x2d,0x2d,0x2d,0xdc,0x95,0x97,0x74,0x2d,0x2d,0x2d,0x2d,
	0x9f,0xc7,0x5e,0xa6,0xcd,0x8d,0x8d,0x0d,0x4f,0x8d,0x0d,0x85,0x76,0xfc,0xdc,0x74,0x0d,0x85,0xcc,0x7c,
	0x72,0xf8,0x68,0xe0,0x0d,0x85,0xcc,0x7c,0xa9,0x8d,0x89,0xcb,0x2d,0x85,0x0d,0x85,0xeb,0xfb,0x59,0x5f,
	0x2d,0x85,0x0d,0x7d,0x70,0xcc,0xd3,0x7d,0x0c,0x85,0xcc,0x7c,0x6a,0x7a,0x5e,0x57,0x0d,0x85,0xcc,0x7c,
	0xad,0xad,0xad,0xad,0x0d,0x85,0xec,0x7c,0xc2,0xe3,0xf2,0xf2,0x2b,0x3a,0x0a,0x32,0xbb,0xaa,0x02,0x00,
	0x4c,0x3a,0x2b,0x3a,0xbd,0xbd,0x3f,0x2b,0x8d,0x42,0x4c,0x3a,0xbd,0xad,0xbd,0x3d,0xef,0x4a,0x8d,0x42,
	0x3d,0x3d,0xbd,0xad,0x72,0x53,0xef,0x4a,0x2d,0x2d,0x2d,0xad,0x36,0x6c,0x92,0x5b,0x2d,0x0d,0x2d,0x2d,
	0x9b,0x8d,0x77,0x6c,0x2d,0x2d,0x2d,0x2d,0x7f,0xc7,0x1d,0x9e,0x0d,0x09,0x0d,0x0d,0x91,0x8d,0x0d,0x85,
	0x76,0x54,0x5e,0x54,0x0d,0x85,0xed,0x7c,0x7c,0x50,0x50,0x73,0x0d,0x85,0xcc,0x7c,0x8b,0x01,0x03,0x03,
	0x2d,0x85,0x0d,0x85,0x5b,0x5b,0x53,0x63,0x0d,0x85,0xec,0x7c,0xa0,0x00,0xe2,0xc0,0x0c,0x85,0xcc,0x7c,
	0x7f,0xef,0xfa,0xeb,0x0d,0x85,0xcc,0x7c,0xa9,0x8b,0x83,0x8b,0xec,0x84,0xcc,0x74,0x82,0xa2,0xca,0x22,
	0x6c,0x42,0x2b,0x3a,0xff,0xfe,0xa2,0xa0,0x6c,0x42,0x4c,0x3a,0xd5,0xff,0xff,0xdf,0x8d,0x42,0x4c,0x3a,
	0x3f,0xad,0x3b,0xab,0xce,0x42,0x8d,0x42,0x2d,0x2d,0x2d,0x2d,0x71,0x53,0xef,0x4a,0xad,0x25,0xa5,0xb5,
	0x78,0x95,0xf4,0x63,0x55,0x54,0x5a,0x51,0x5a,0x85,0x56,0x6c,0x2d,0x2d,0x2d,0x2d,0x9f,0xcf,0xfd,0x95,
	0x2d,0x2d,0x2d,0x2d,0x92,0x8d,0x0d,0x85,0x54,0x5c,0x54,0x5c,0x0d,0x85,0xcc,0x7c,0x60,0x68,0x68,0x68,
	0x2d,0x85,0xcc,0x7c,0x89,0x8f,0xa9,0xa9,0x2d,0x85,0x0d,0x85,0x42,0x48,0xc1,0x42,0x0d,0x85,0xec,0x7c,
	0xe8,0xcc,0x8a,0xaf,0x0c,0x85,0xec,0x7c,0xea,0xa2,0x2b,0xb2,0x0d,0x85,0xec,0x7c,0xff,0xef,0xcd,0x15,
	0x0c,0x85,0xed,0x7c,0xfa,0x7b,0x72,0xfa,0xcd,0x4a,0x6c,0x42,0x5f,0x7f,0xfa,0xe8,0x8c,0x42,0x6c,0x42,
	0x55,0x5f,0xee,0x88,0x6c,0x42,0x8d,0x3a,0xe8,0xfa,0xee,0xfb,0xce,0x42,0x8d,0x42,0x2d,0x2d,0x2f,0x2d,
	0x51,0x53,0xcf,0x42,0x2f,0x2d,0x2f,0xad,0x38,0x8d,0x72,0x53,0xf9,0xfd,0xed,0xc3,0x5a,0x85,0x35,0x64,
	0x2d,0x2d,0x35,0xb5,0xbf,0xcf,0xbc,0x8d,0x2d,0x2d,0x2d,0xa5,0x92,0x8d,0x0d,0x85,0x54,0x5c,0x54,0x56,
	0x0d,0x85,0xec,0x7c,0x50,0x53,0x73,0x7c,0x0d,0x85,0xec,0x74,0x8b,0x83,0x8a,0x02,0x2d,0x85,0x0d,0x85,
	0xc3,0x4f,0x5f,0x47,0x2d,0x85,0xec,0x7c,0xff,0xef,0xe3,0xfb,0x0d,0x85,0xcc,0x7c,0xaa,0xf0,0x60,0x60,
	0x0c,0x85,0xed,0x7c,0xff,0xcd,0xf5,0xfd,0x0d,0x85,0xec,0x7c,0xbd,0xfd,0xeb,0x6a,0x0e,0x5b,0xad,0x4a,
	0x5f,0x7a,0xfc,0xf0,0xad,0x4a,0x8c,0x42,0x55,0x5a,0x68,0x60,0x8d,0x42,0x8c,0x42,0x2b,0x2b,0x28,0x0a,
	0xce,0x4a,0x8d,0x42,0x2f,0x2d,0x2f,0x2f,0x51,0x53,0xce,0x42,0x2f,0xad,0x2f,0xad,0x7d,0xdf,0x34,0x74,
	0xe9,0x89,0x09,0x09,0xbc,0xc6,0x35,0x64,0xd5,0xd7,0xd6,0xd4,0x3e,0xc7,0x5a,0x85,0x2d,0x2d,0x2d,0x2d,
	0x50,0x8d,0x0d,0x85,0x5c,0x5c,0x5c,0x5c,0x0d,0x85,0xec,0x7c,0x78,0xf8,0x78,0x70,0x0d,0x85,0xed,0x7c,
	0x0a,0x02,0x2a,0x22,0x2c,0x85,0xed,0x7c,0x6a,0xee,0xaa,0xee,0x0d,0x85,0xec,0x7c,0xa2,0x82,0x0c,0x24,
	0x0c,0x85,0xcc,0x7c,0xf2,0xfa,0x7a,0xf8,0x0d,0x85,0xec,0x7c,0xeb,0xbb,0x19,0xb6,0x0d,0x85,0xcc,0x7c,
	0xb8,0xf8,0xf8,0x98,0x4f,0x63,0xcd,0x4a,0x7e,0x7a,0x78,0x7a,0xcd,0x4a,0xad,0x42,0x54,0x7c,0x5c,0x7c,
	0xad,0x42,0x8d,0x42,0xdf,0xb7,0xff,0xb7,0xce,0x4a,0x8d,0x42,0x2f,0x2f,0x2f,0x2f,0xd6,0x84,0xef,0x4a,
	0xd5,0x55,0xf5,0x85,0x5d,0xdf,0xb2,0x5b,0x09,0x0d,0x0d,0x0d,0x3d,0xdf,0x96,0x74,0x56,0x56,0x7a,0xc0,
	0x1d,0xc7,0x19,0x7d,0x0d,0x0d,0x0d,0x0d,0x4f,0x8d,0x0d,0x85,0x58,0x57,0x5a,0x55,0x0d,0x85,0xec,0x7c,
	0xea,0xa2,0xca,0xaa,0x0d,0x85,0xed,0x7c,0x0a,0x02,0x23,0x0b,0x2d,0x85,0xec,0x7c,0xba,0xfe,0xfc,0xfa,
	0x2c,0x85,0xed,0x7c,0xbf,0xbf,0x2f,0xbf,0x2d,0x85,0xcc,0x7c,0xd8,0xd8,0xb8,0xf8,0x0c,0x85,0xcc,0x7c,
	0xee,0x9e,0x96,0x94,0xec,0x84,0xcc,0x7c,0x08,0x0e,0xb7,0xf7,0x2e,0x5b,0xad,0x4a,0xe8,0xf8,0xfa,0x7a,
	0xcd,0x4a,0x8c,0x42,0xf8,0xfa,0x7a,0x5e,0xad,0x42,0x8d,0x42,0xff,0xd7,0xdd,0x55,0xce,0x4a,0x8d,0x42,
	0x2f,0xaf,0x2f,0xbd,0xfc,0xce,0xef,0x4a,0xc5,0xa5,0x25,0x25,0x7d,0xdf,0x34,0x6c,0x09,0x83,0xe0,0xe0,
	0x3c,0xd7,0x35,0x6c,0xc0,0xc0,0x40,0x60,0x3c,0xd7,0xb7,0x74,0x8d,0x8d,0xad,0x8d,0x2c,0x85,0xaf,0x7c,
	0xa1,0xa1,0x21,0x23,0x0d,0x85,0xec,0x7c,0xaa,0x22,0xaa,0xa0,0xed,0x84,0x0c,0x7d,0x7a,0x78,0xec,0xee,
	0x2d,0x8d,0x0c,0x7d,0x5f,0x77,0x77,0x7f,0x2c,0x85,0xed,0x7c,0xbf,0xff,0xaf,0x3f,0x2d,0x85,0xcc,0x7c,
	0xf8,0x78,0x7a,0xdc,0x0c,0x85,0xec,0x7c,0x75,0x7d,0x4d,0x4c,0xec,0x7c,0xcc,0x7c,0xf5,0x9e,0x7c,0xf2,
	0xee,0x52,0x8c,0x42,0xe8,0xfa,0x7e,0x57,0x8d,0x4a,0x6c,0x42,0xa0,0xa8,0x6a,0x56,0x8d,0x42,0x6c,0x3a,
	0x2a,0x22,0xab,0xbf,0xce,0x42,0x8d,0x42,0x2f,0x3d,0xad,0xa5,0x1d,0xd7,0xef,0x4a,0x35,0x35,0x95,0x95,
	0x7d,0xdf,0xb5,0x84,0x60,0x62,0xe0,0xa0,0xbb,0xc6,0x55,0x6c,0x60,0x72,0x5b,0x5f,0x1c,0xd7,0xf7,0x84,
	0x8d,0x8b,0x8b,0x8b,0x2c,0x85,0xef,0x84,0xa9,0xab,0xab,0xea,0x0d,0x85,0xec,0x7c,0xb0,0x20,0x00,0x20,
	0x0d,0x85,0xed,0x7c,0xbe,0xfa,0xb2,0xea,0x2d,0x85,0x0d,0x85,0xf7,0xff,0x9d,0xd7,0x0d,0x85,0xec,0x7c,
	0x2e,0x2e,0x8e,0xaa,0x0d,0x85,0xec,0x7c,0x5c,0x50,0x5c,0xfc,0xed,0x8c,0x0c,0x7d,0xd7,0x77,0xdd,0xd7,
	0xec,0x84,0xcc,0x7c,0x92,0x68,0x2a,0x0a,0x8c,0x42,0x4b,0x3a,0xa0,0xea,0xfe,0x57,0x6c,0x42,0x4b,0x3a,
	0xa8,0xbe,0xfd,0x55,0x8d,0x42,0x4c,0x3a,0xab,0xaf,0xbf,0xbd,0xce,0x42,0x8d,0x42,0x35,0xb5,0x35,0x35,
	0x3d,0xdf,0xef,0x4a,0x95,0x15,0x35,0x15,0x5d,0xdf,0xbc,0xc6,0x80,0xa8,0x8b,0x89,0xfc,0xce,0x75,0x74,
	0xf6,0xf4,0xe4,0x64,0xfb,0xce,0x99,0x95,0x83,0x03,0x83,0x81,0x2f,0x85,0x0d,0x85,0x56,0xf4,0xd4,0xd6,
	0x0d,0x85,0xec,0x7c,0xa8,0x38,0xb0,0x20,0x0d,0x85,0xec,0x7c,0xea,0xf0,0xf8,0xfa,0x0d,0x85,0xec,0x7c,
	0x2a,0x0e,0x2f,0x05,0x0d,0x85,0xed,0x7c,0xa2,0xc0,0xa2,0xb2,0x0c,0x85,0xed,0x7c,0xba,0xbb,0x82,0x8a,
	0xec,0x8c,0x0d,0x7d,0x75,0xf7,0xd7,0x7d,0x0d,0x85,0xec,0x7c,0x95,0x95,0xdf,0xfa,0x4b,0x3a,0x0a,0x32,
	0x20,0xaa,0xff,0xff,0x4c,0x3a,0x2b,0x3a,0x2b,0x3d,0xf5,0xd5,0x6c,0x42,0x4c,0x3a,0x2d,0xad,0x35,0xb5,
	0xce,0x42,0x6d,0x42,0x2f,0xaf,0x2d,0xaf,0x7d,0xe7,0xef,0x4a,0x35,0x35,0x25,0x25,0x5d,0xdf,0xdb,0xce,
	0x81,0xa3,0x82,0x02,0xbb,0xc6,0x75,0x74,0x44,0x64,0x4e,0x6a,0xbb,0xc6,0xf7,0x7c,0x83,0x81,0x81,0x81,
	0x2c,0x85,0xcf,0x84,0x2b,0xa9,0x8b,0x2b,0x0d,0x85,0xed,0x7c,0xa0,0x80,0x80,0xc0,0x0c,0x85,0xed,0x7c,
	0xba,0x9b,0x1b,0xd6,0x0d,0x85,0xec,0x7c,0x0d,0x29,0x09,0xa7,0x0d,0x85,0xed,0x7c,0xa2,0x03,0x0a,0x02,
	0x0d,0x85,0xed,0x7c,0x20,0x80,0xa0,0x80,0x0d,0x85,0xed,0x7c,0xa0,0x00,0xa0,0x80,0x0c,0x85,0xec,0x7c,
	0x7a,0x52,0x5a,0x5e,0x2b,0x3a,0xea,0x31,0xab,0xaf,0xff,0xd7,0x2b,0x3a,0x0b,0x32,0x2a,0x29,0xa9,0xa5,
	0x6c,0x3a,0x2b,0x3a,0x2f,0x2f,0x2f,0x0b,0xce,0x42,0x6d,0x3a,0x2d,0x2f,0x29,0x2f,0x3d,0xd7,0x71,0x5b,
	0x05,0x05,0x2d,0xad,0x7e,0xdf,0x19,0xb6,0x82,0x88,0x8b,0x89,0xfc,0xce,0x96,0x74,0x63,0x62,0x60,0x40,
	0x9a,0xc6,0x17,0x85,0x81,0x83,0xa3,0xa3,0x2d,0x85,0x0d,0x85,0xb5,0xf5,0xb5,0xd5,0x0d,0x85,0xec,0x7c,
	0xc0,0xc0,0xc0,0xc2,0xec,0x84,0x0d,0x7d,0xe3,0xaa,0xbb,0xbb,0x0d,0x85,0xec,0x7c,0xbf,0xbf,0xa7,0xa6,
	0x0d,0x85,0x2b,0x75,0x88,0x28,0x88,0x28,0x0d,0x85,0xec,0x7c,0xa0,0x88,0xa8,0x20,0x0d,0x85,0xed,0x7c,
	0x08,0x08,0x2c,0x20,0x0d,0x85,0xec,0x7c,0x5c,0x5c,0xf0,0x50,0x0a,0x32,0xea,0x31,0x2f,0xbd,0xb5,0x95,
	0x2b,0x3a,0x0b,0x32,0x3d,0x35,0x3d,0xb5,0x6d,0x3a,0x2b,0x3a,0x2f,0x2d,0x2f,0x2d,0xce,0x42,0x8d,0x3a,
	0x25,0x2d,0x05,0x39,0x98,0xa5,0x30,0x53,0x2d,0x0d,0x89,0x2b,0x5d,0xdf,0x57,0x9d,0x89,0xc9,0xe1,0xe3,
	0xfb,0xce,0xd7,0x84,0x40,0x40,0xc0,0x80,0xdb,0xc6,0x37,0x8d,0xe3,0xe3,0xeb,0xe9,0x2c,0x85,0x0d,0x85,
	0xd5,0xbd,0xff,0x9d,0x0d,0x85,0xec,0x7c,0xe2,0xc8,0xe0,0xc8,0xec,0x84,0x0c,0x75,0x2a,0x0a,0x28,0x38,
	0xcc,0x84,0xec,0x7c,0x7d,0x67,0x7f,0xf7,0x0d,0x85,0xec,0x7c,0x02,0x02,0x2b,0x2b,0x0d,0x85,0x2d,0x7d,
	0x00,0x00,0xa2,0xa0,0x2d,0x85,0x0d,0x85,0x75,0x57,0xff,0xdf,0x0d,0x85,0xec,0x7c,0xea,0x82,0x80,0x00,
	0x0b,0x32,0xca,0x29,0xab,0xaf,0xab,0xab,0x2c,0x3a,0x0b,0x32,0xa5,0x3d,0xa5,0x05,0x6d,0x3a,0x2c,0x32,
	0x39,0x0e,0x09,0x0e,0xef,0x4a,0x8e,0x3a,0x3d,0xad,0x3f,0x2d,0x7d,0xdf,0x91,0x5b,0x3d,0x2d,0x0d,0x0d,
	0x5d,0xdf,0x77,0x9d,0xe2,0x60,0x70,0x70,0xfb,0xd6,0xf9,0xad,0xcf,0xed,0x4d,0x6d,0x39,0xae,0xb6,0x74,
	0x89,0x8d,0x8d,0x8d,0x2d,0x85,0x0d,0x85,0xf5,0xb5,0xbd,0xb7,0x0d,0x85,0xec,0x7c,0xe8,0xc0,0xe0,0xa0,
	0x0d,0x85,0xed,0x7c,0xff,0x73,0x4c,0x7b,0xcd,0x84,0xec,0x7c,0xff,0xd7,0x97,0xd7,0xed,0x84,0x0c,0x7d,
	0xbe,0xfa,0xec,0x7a,0x2d,0x85,0xec,0x7c,0x2e,0xaf,0xaf,0xff,0x0d,0x85,0x2d,0x7d,0x88,0xa0,0x80,0x08,
	0x0d,0x85,0x2d,0x7d,0x02,0x02,0x8a,0x0a,0x0b,0x32,0xea,0x31,0xd5,0x95,0x95,0x15,0x4c,0x3a,0x0b,0x32,
	0xb5,0xbd,0xad,0x3d,0x8d,0x3a,0x4c,0x3a,0xb5,0x2d,0x25,0x2d,0x57,0x95,0xae,0x42,0x55,0xd5,0x95,0x35,
	0x3d,0xd7,0x71,0x53,0x01,0x03,0x02,0x00,0x3d,0xd7,0x37,0x95,0x70,0x70,0x78,0x58,0xdb,0xce,0x98,0x9d,
	0x4b,0x4f,0x6e,0x4f,0x39,0xae,0xb5,0x74,0x8d,0x89,0x89,0xc9,0x2d,0x85,0x0d,0x85,0xdf,0x5f,0x77,0xff,
	0x0d,0x85,0xec,0x7c,0x80,0x80,0xc0,0xe8,0x0d,0x85,0xcc,0x7c,0x4a,0x68,0x62,0xc8,0xec,0x84,0xcc,0x7c,
	0x4b,0xef,0xcb,0x82,0x0c,0x85,0xed,0x7c,0xad,0x29,0x09,0x3b,0x0d,0x85,0xec,0x7c,0xac,0x8a,0xaa,0x22,
	0x2d,0x85,0x0d,0x85,0x57,0x5d,0x59,0xc9,0x2d,0x85,0x0d,0x85,0x5f,0x5f,0xbd,0xdd,0x2c,0x85,0x0d,0x85,
	0xab,0xbf,0xbb,0x2b,0x2d,0x85,0x0d,0x85,0x2a,0x22,0x0a,0x08,0x2d,0x85,0x0d,0x85,0xa8,0x00,0x20,0x88,
	0x2d,0x85,0x0c,0x85,0xea,0xe2,0xca,0xe8,0x0d,0x85,0xec,0x7c,0x88,0x88,0xa0,0xc0,0x0d,0x85,0xec,0x7c,
	0x0e,0x26,0x37,0x1f,0x2d,0x85,0x0d,0x85,0x97,0xdf,0x97,0x9f,0x91,0x8d,0x0d,0x85,0x15,0x1d,0x9d,0xb5,
	0x9e,0xcf,0xbb,0x95,0x78,0x68,0x68,0x68,0xf9,0x7c,0x93,0x53,0x68,0x78,0x78,0x78,0x72,0x53,0x4d,0x32,
	0xf8,0x78,0x7a,0x7e,0x2c,0x32,0x47,0x19,0xe8,0xf8,0x78,0x7e,0x48,0x21,0xc4,0x10,0x68,0x78,0x7a,0x5e,
	0x06,0x19,0x63,0x08,0xde,0xdf,0x9f,0x37,0x2e,0x5b,0x05,0x19,0xc9,0x6b,0x7b,0xdf,0x8f,0x63,0x47,0x21,
	0xad,0x09,0x83,0xc2,0x2d,0x85,0x0d,0x85,0xab,0x8b,0x2b,0x2f,0x2d,0x85,0x0c,0x85,0xaa,0x82,0x28,0x8a,
	0x2d,0x85,0x0c,0x85,0xb8,0x20,0x80,0x20,0x2d,0x85,0x0c,0x85,0xa2,0x82,0xc2,0x8b,0x0d,0x85,0x0c,0x7d,
	0xa8,0xa8,0xa0,0xa8,0xec,0x84,0x0d,0x7d,0xc8,0xe2,0xce,0xab,0x0d,0x85,0x2c,0x7d,0xc2,0x80,0x88,0x00,
	0x70,0x8d,0x0d,0x85,0x1d,0x15,0x9d,0xbd,0x1d,0xc7,0x5a,0x85,0x40,0x40,0x40,0x60,0xb7,0x74,0x51,0x4b,
	0x78,0x78,0x78,0x78,0x10,0x43,0xeb,0x29,0xf8,0xf8,0x78,0x7a,0xea,0x29,0x27,0x19,0xf8,0x78,0x7a,0x5a,
	0x06,0x19,0xa4,0x08,0xf8,0x78,0x78,0x5a,0xc4,0x10,0x63,0x08,0x3f,0x37,0xb7,0xb7,0x6f,0x63,0xe5,0x18,
	0x97,0x25,0x2d,0x0b,0x8f,0x63,0x63,0x08,0x60,0x58,0x5c,0xd7,0x2d,0x85,0x0c,0x85,0xae,0x8a,0x02,0x02,
	0x2d,0x85,0x0c,0x85,0xaa,0x80,0xc0,0xe8,0x2d,0x85,0x0d,0x85,0xa8,0xb2,0xeb,0xef,0x2d,0x85,0x0d,0x85,
	0xcb,0x8b,0x0b,0xab,0x0d,0x85,0xed,0x7c,0x20,0x02,0x22,0x88,0x0d,0x85,0xec,0x7c,0xba,0xbe,0x9e,0xb2,
	0x0d,0x85,0x2d,0x7d,0x00,0x02,0x08,0x0a,0x50,0x8d,0x0d,0x85,0x3d,0xb5,0xbd,0xb5,0x1d,0xbf,0x39,0x85,
	0x60,0x70,0x60,0x70,0x76,0x6c,0x10,0x4b,0x78,0x78,0x78,0x78,0xaf,0x42,0xca,0x29,0x68,0xf8,0x78,0x78,
	0xa9,0x29,0x06,0x11,0xf8,0x78,0x78,0x5a,0xe5,0x10,0x84,0x08,0x68,0x68,0x78,0xf8,0x0a,0x3a,0x83,0x08,
	0xd5,0xd5,0x95,0x35,0xb0,0x6b,0xa8,0x29,0xc9,0x63,0xe2,0x80,0xb0,0x6b,0x83,0x08,0xb5,0xaf,0x0a,0x00,
	0x0d,0x8d,0x4c,0x85,0xea,0xfe,0xfa,0xfa,0x2d,0x85,0x0d,0x85,0x68,0xc0,0xa0,0x88,0x2c,0x85,0x0d,0x85,
	0xa9,0x2f,0xab,0x8e,0x2d,0x85,0x0d,0x85,0x8b,0x0a,0x82,0x0a,0x0d,0x85,0xed,0x7c,0xaa,0x20,0x28,0x08,
	0x0d,0x85,0xec,0x7c,0xb8,0x28,0xb2,0xba,0x2d,0x85,0x0d,0x85,0x7f,0x5f,0x5f,0x55,0x2e,0x8d,0x0d,0x85,
	0x29,0x29,0x25,0x29,0x1d,0xbf,0xf8,0x74,0x60,0x70,0x70,0x70,0x35,0x64,0xcf,0x42,0x78,0x68,0x78,0x78,
	0x8e,0x3a,0xa9,0x29,0x78,0x78,0x78,0x78,0x89,0x21,0x06,0x11,0x58,0x7c,0x78,0x7a,0xe5,0x10,0x83,0x08,
	0x78,0xe8,0xf0,0xe0,0xcd,0x4a,0xc4,0x10,0x35,0x35,0xa5,0xb5,0xd4,0x8c,0xb0,0x6b,0xad,0x09,0x81,0x79,
	0xb3,0x8c,0x4f,0x63,0xba,0x3e,0x2f,0x2d,0x4d,0x8d,0x2d,0x85,0xd5,0xd5,0x75,0x95,0x2d,0x85,0x0d,0x85,
	0xa0,0x80,0x08,0x20,0x2d,0x85,0x0d,0x85,0x2a,0xae,0x8e,0x28,0x2d,0x85,0x0d,0x85,0x2a,0x82,0x08,0xa2,
	0x0d,0x85,0x0c,0x7d,0xa8,0xa0,0x28,0xa8,0x0c,0x85,0xec,0x7c,0xa8,0x88,0x28,0x80,0x0d,0x85,0xed,0x7c,
	0x82,0x82,0xaa,0x20,0x2d,0x85,0x0e,0x85,0x29,0x0b,0x0b,0x2b,0xfd,0xbe,0xd8,0x74,0x70,0x70,0x70,0x70,
	0x15,0x64,0xcf,0x42,0x78,0x78,0x78,0x78,0x6d,0x3a,0xa9,0x21,0x78,0x78,0xf8,0x78,0xa9,0x21,0x06,0x19,
	0x7a,0x7a,0xf8,0xf8,0x06,0x11,0xc5,0x10,0x5e,0x5e,0x7c,0x78,0xc9,0x31,0xa4,0x08,0x35,0xb5,0x55,0xd5,
	0x8f,0x63,0x68,0x21,0x82,0xeb,0xfd,0x55,0x11,0x7c,0xc9,0x31,0x0a,0x2b,0xad,0xbd,0x0c,0x95,0x2d,0x85,
	0x5f,0x7d,0x77,0x77,0x4d,0x8d,0x2d,0x85,0x57,0x5f,0x7f,0x7a,0x2d,0x85,0x0c,0x85,0xaa,0x20,0xa0,0x80,
	0x2d,0x85,0x0c,0x85,0xaa,0xe0,0x8a,0xf8,0x0d,0x85,0x2d,0x7d,0x02,0x22,0x22,0x02,0x0d,0x85,0x0d,0x7d,
	0xf0,0x30,0xc0,0x0c,0x0d,0x85,0xec,0x7c,0xaa,0x22,0x0a,0x2a,0x6f,0x8d,0x0d,0x85,0x9d,0x9d,0x9d,0x1d,
	0x1d,0xbf,0xd8,0x74,0x70,0x70,0x70,0x70,0x15,0x64,0xcf,0x3a,0x78,0x78,0x78,0x78,0x6e,0x3a,0xca,0x29,
	0x78,0x78,0x70,0x78,0xa9,0x21,0x27,0x19,0x78,0x78,0x78,0x5e,0x06,0x19,0xa4,0x08,0xe8,0x68,0xf8,0x7a,
	0xa4,0x08,0x42,0x08,0x20,0xe8,0xf8,0x7a,0xc4,0x10,0x21,0x00,0x20,0xff,0xd7,0xb5,0xb0,0x6b,0x26,0x19,
	0x2d,0x25,0x0d,0x29,0x0e,0x95,0x2c,0x85,0x77,0xdf,0x7d,0x57,0x4d,0x8d,0x2d,0x85,0x5f,0x7e,0x72,0x50,
	0x4d,0x8d,0x2d,0x85,0x5f,0x7d,0xd5,0xd5,0x2d,0x85,0x0d,0x85,0xf0,0xe0,0xe0,0xc8,0x0d,0x85,0x2d,0x7d,
	0x02,0xa0,0x82,0x00,0x2d,0x85,0x0d,0x85,0x55,0x5f,0x7f,0xf7,0x0c,0x85,0xed,0x7c,0x2a,0x22,0x2a,0x22,
	0xb2,0x95,0x0d,0x85,0x95,0x1d,0x15,0x15,0x1d,0xc7,0xb8,0x6c,0x70,0x70,0x70,0x70,0x15,0x64,0xaf,0x3a,
	0x78,0x78,0x78,0x7c,0x6d,0x32,0x89,0x21,0x68,0xf8,0xf8,0x78,0x89,0x21,0xe5,0x10,0xe8,0xf8,0x78,0x7a,
	0xe5,0x10,0x83,0x08,0xe8,0x78,0x7c,0x7a,0x84,0x08,0x22,0x00,0xe8,0xfa,0x78,0xfe,0xe5,0x10,0x21,0x00,
	0x95,0x95,0x35,0x95,0xd0,0x6b,0xc9,0x31,0x2d,0x0d,0x29,0x2d,0x2d,0x85,0x0d,0x85,0x2b,0x0b,0x2b,0x0f,
	0x4d,0x8d,0x0d,0x85,0x7a,0xfa,0xfa,0xbe,0x2d,0x85,0x2c,0x85,0x82,0x02,0x02,0x00,0x2d,0x85,0x0c,0x85,
	0xa2,0xc0,0x80,0x00,0x2d,0x85,0x0d,0x85,0xd7,0xf7,0x7f,0xb7,0x2c,0x85,0x0d,0x85,0x5f,0x7f,0x5e,0x7e,
	0x0c,0x85,0xed,0x7c,0xaa,0xe2,0xe8,0x80,0xb1,0x95,0xcb,0x7c,0x3f,0x37,0x3f,0x3f,0xdd,0xb6,0x77,0x6c,
	0x70,0x70,0x70,0x70,0xd4,0x5b,0x8d,0x3a,0x78,0x78,0x78,0x78,0x2c,0x32,0x88,0x21,0x78,0x78,0x78,0x78,
	0x68,0x21,0xe5,0x10,0x78,0x7e,0x58,0x7a,0xc5,0x10,0x63,0x08,0xf0,0xf8,0x78,0x7c,0x63,0x08,0x21,0x00,
	0xf8,0x78,0x7e,0x7c,0x06,0x19,0x21,0x00,0x95,0x95,0x95,0x35,0x4e,0x5b,0xa8,0x29,0x2d,0x2d,0xad,0xad,
	0x2d,0x85,0x0d,0x85,0xaf,0xfa,0xf2,0xdf,0x2d,0x85,0x0c,0x85,0x0a,0x0b,0x02,0x02,0x2d,0x8d,0x2d,0x85,
	0x57,0x5b,0x57,0x57,0x2c,0x8d,0x2d,0x85,0xfa,0xef,0xea,0xbe,0x2c,0x85,0x0d,0x85,0xad,0xb5,0xb5,0xb7,
	0x2d,0x85,0x0d,0x85,0x5e,0x5e,0x5e,0x58,0x0d,0x85,0xec,0x7c,0xa8,0x88,0xe2,0xaa,0xb2,0x95,0x0c,0x85,
	0x15,0x35,0x15,0xb5,0x3e,0xc7,0x76,0x6c,0x78,0x78,0x78,0x78,0xb3,0x53,0x8e,0x3a,0x78,0x78,0x78,0x78,
	0x2c,0x32,0x88,0x21,0x78,0x58,0x78,0x78,0x47,0x21,0xc4,0x10,0x78,0xf8,0x78,0xf0,0xc4,0x10,0x63,0x08,
	0x7c,0x7a,0x7e,0x7c,0x83,0x08,0x21,0x00,0x5e,0x5f,0xdf,0x2f,0x0a,0x3a,0x42,0x00,0xb5,0x2d,0x2f,0x2d,
	0x0d,0x5b,0xc9,0x31,0x6b,0x7a,0xe2,0x02,0x2c,0x85,0x0d,0x85,0xff,0x9f,0x57,0x72,0x2d,0x85,0x0d,0x85,
	0x2a,0x82,0x8a,0x2b,0x4d,0x8d,0x2d,0x85,0x55,0xf5,0xfd,0xdd,0x4d,0x8d,0x2d,0x85,0x77,0x55,0x7d,0x5f,
	0x0c,0x85,0x0d,0x7d,0xae,0xbe,0xbe,0xbf,0x2d,0x85,0x0d,0x85,0x7a,0x72,0xaa,0x02,0x0d,0x85,0xed,0x7c,
	0xe8,0xc8,0xa8,0x20,0x91,0x8d,0x0d,0x85,0x15,0x15,0x15,0x15,0xdd,0xb6,0x77,0x6c,0x70,0x70,0x70,0x70,
	0xd4,0x5b,0x8e,0x3a,0x78,0x78,0x78,0x78,0x4c,0x32,0x88,0x21,0x78,0x7c,0x78,0x78,0x48,0x19,0xc5,0x10,
	0x78,0xf8,0x78,0x78,0xc4,0x10,0x43,0x08,0xfa,0xf8,0x7a,0xfa,0x62,0x08,0x21,0x00,0x2e,0x5e,0x5e,0x5f,
	0x8c,0x4a,0x21,0x00,0x2d,0x2d,0x2d,0x2d,0x11,0x74,0x2e,0x5b,0xad,0x0b,0x0b,0xab,0x2d,0x85,0x0d,0x85,
	0xfe,0xef,0xfb,0xbe,0x2d,0x85,0x0d,0x85,0x2b,0x22,0x0a,0x02,0x4d,0x8d,0x2d,0x85,0xff,0xfe,0x7b,0x7e,
	0x4d,0x8d,0x0d,0x85,0xea,0x7a,0xfe,0x7f,0x2c,0x85,0x0d,0x7d,0x17,0xf5,0x3d,0xff,0x2d,0x85,0x0d,0x85,
	0x02,0x82,0x02,0x88,0x0d,0x85,0x0d,0x7d,0x28,0x88,0x00,0x80,0x91,0x8d,0x0c,0x85,0x1d,0x9d,0x9d,0xdd,
	0x5e,0xc7,0x97,0x6c,0x78,0x78,0x78,0x78,0xf4,0x5b,0x8e,0x3a,0x78,0x78,0x58,0x78,0x4c,0x32,0x68,0x21,
	0x78,0xf8,0x78,0x7a,0x47,0x19,0xc5,0x10,0x78,0x78,0x78,0x7c,0xa4,0x10,0x42,0x00,0xe8,0xf8,0xf8,0x78,
	0x42,0x08,0x00,0x00,0xf8,0xea,0xfa,0xf8,0x0a,0x3a,0x00,0x00,0x2d,0xb5,0xd5,0x55,0x4e,0x5b,0x42,0x00,
	0x00,0xaa,0xff,0xd5,0x2d,0x85,0x0c,0x85,0xba,0x2e,0xbe,0x2b,0x2d,0x85,0x0c,0x85,0x28,0x80,0xb8,0xe2,
	0x2d,0x85,0x0d,0x85,0x80,0x80,0x8a,0xa2,0x2d,0x85,0x0c,0x85,0xaa,0xb2,0x2e,0x2a,0x2c,0x85,0x0d,0x85,
	0x9f,0xde,0xf6,0xbc,0x2d,0x85,0x0c,0x85,0xa2,0xe2,0x8a,0xe2,0x0c,0x85,0x2d,0x7d,0x2a,0x28,0x2a,0x0a,
	0x2d,0x85,0xce,0x7c,0xa8,0xe2,0x68,0x6a,0x1d,0xbf,0x97,0x6c,0x78,0x78,0x78,0x78,0xf4,0x5b,0x6d,0x3a,
	0x78,0x78,0x78,0x78,0x2c,0x32,0x68,0x19,0x78,0x78,0x78,0x78,0x47,0x19,0xa4,0x08,0xf8,0x78,0xf8,0x78,
	0xa4,0x10,0x42,0x00,0x78,0x78,0x7a,0x5a,0x42,0x08,0x01,0x00,0xfa,0xfa,0xfa,0xfa,0x20,0x00,0x00,0x00,
	0x5f,0x57,0x5f,0x57,0xc5,0x18,0x00,0x00,0x25,0x35,0xb5,0xd5,0x2d,0x85,0x0c,0x85,0xf2,0xdf,0x5e,0x57,
	0x2d,0x85,0x0d,0x85,0xfa,0xbf,0xb5,0xb5,0x2d,0x85,0x0d,0x85,0xea,0xd2,0xfe,0xd7,0x2d,0x85,0x0c,0x85,
	0x2a,0x23,0x2a,0x02,0x2d,0x85,0x0d,0x85,0x2a,0xa2,0xba,0x20,0x2d,0x85,0x0c,0x85,0xee,0xee,0x82,0xc0,
	0x2d,0x85,0x0d,0x85,0x51,0x45,0x51,0x51,0x2d,0x85,0xcd,0x7c,0x68,0x6a,0x60,0x68,0xdc,0xb6,0xb7,0x74,
	0x70,0x70,0x70,0x70,0xf4,0x5b,0x8d,0x3a,0x78,0x78,0x78,0x78,0x2c,0x32,0x47,0x19,0x78,0x78,0x78,0xf8,
	0x27,0x19,0xa4,0x08,0x78,0xf8,0x78,0x7c,0x84,0x08,0x42,0x00,0x6c,0x58,0x5c,0x58,0x63,0x00,0x00,0x00,
	0x7f,0xdf,0x5f,0x7c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x63,0x08,0x00,0x00,0x95,0xb5,0x35,0xb5,
	0x2c,0x85,0xed,0x84,0xee,0xbf,0xaf,0x2b,0x2c,0x85,0x0d,0x85,0xbd,0xff,0x5e,0xca,0x0d,0x85,0x0c,0x7d,
	0x2a,0x22,0xaa,0xa0,0x2d,0x85,0x0d,0x85,0x02,0x82,0x02,0xf0,0x2d,0x85,0x0c,0x85,0x32,0xa8,0x32,0x2a,
	0x2d,0x85,0x0c,0x85,0xc0,0x80,0x80,0xc8,0x2d,0x85,0x0d,0x85,0x7b,0x7b,0x72,0x72,0x2d,0x85,0xad,0x7c,
	0x60,0x60,0x60,0x60,0xdb,0xb6,0xb7,0x74,0x70,0x78,0x78,0x78,0x14,0x64,0xae,0x3a,0x78,0x78,0x58,0x78,
	0x4c,0x32,0x68,0x21,0x78,0x78,0x78,0x78,0x27,0x19,0x83,0x08,0x78,0x78,0x78,0x78,0x83,0x08,0x21,0x00,
	0xbc,0xb8,0xfe,0x58,0x0a,0x32,0x01,0x00,0x5f,0x7a,0x62,0xeb,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xa8,0x29,0x21,0x00,0xd5,0xb5,0x25,0x2d,0x2d,0x85,0x0d,0x85,0xa5,0xc5,0xe9,0x80,0x2d,0x85,0x0d,0x85,
	0xea,0x7f,0x5f,0x7b,0x0d,0x85,0x0c,0x7d,0xa8,0x2a,0x2a,0x0a,0x2d,0x85,0x0d,0x85,0xde,0x96,0xf7,0xfd,
	0x2d,0x8d,0x0d,0x85,0x26,0x25,0x25,0x25,0x2d,0x85,0x0c,0x85,0xa8,0xfc,0xec,0xe6,0x2d,0x85,0x0d,0x85,
	0xf3,0x7f,0x53,0x57,0x2d,0x85,0xad,0x7c,0x60,0x48,0xe8,0xe0,0xba,0xb6,0x76,0x6c,0x78,0x78,0x78,0x78,
	0xd3,0x5b,0xae,0x3a,0x78,0x58,0x5c,0x5c,0x53,0x74,0xaa,0x21,0x5f,0x5f,0x7a,0x42,0x68,0x21,0xa4,0x08,
	0x7a,0x58,0x78,0xe8,0x84,0x08,0x21,0x00,0x5a,0x7c,0x78,0xf8,0x8c,0x4a,0x01,0x00,0x7d,0x5d,0x8d,0x2d,
	0x8c,0x4a,0x00,0x00,0x55,0x5d,0xea,0x80,0x87,0x29,0x21,0x00,0x2d,0x2d,0x35,0xbf,0x4d,0x85,0x0d,0x85,
	0x7a,0x7a,0x5e,0x5f,0x2c,0x85,0x0d,0x85,0x7f,0xfd,0x5f,0xd5,0x2c,0x85,0x0d,0x85,0xf7,0xff,0x97,0xff,
	0x2d,0x85,0x0d,0x85,0xfb,0xff,0x9f,0xfe,0x2d,0x85,0x0d,0x85,0x05,0x0d,0x25,0x85,0x2c,0x85,0x0d,0x85,
	0x66,0x77,0x55,0xd5,0x2d,0x85,0x0d,0x85,0x53,0x53,0x53,0x54,0x2c,0x85,0xce,0x7c,0x68,0x6a,0x60,0x62,
	0xba,0xbe,0x96,0x6c,0x78,0x70,0x78,0x70,0xd3,0x5b,0x6d,0x3a,0x78,0x58,0x78,0x78,0x79,0xc6,0x50,0x5b,
	0x69,0xc9,0x2b,0x09,0xb4,0x8c,0x26,0x19,0x55,0x57,0x56,0x5c,0xc5,0x10,0x42,0x00,0x7e,0x58,0x78,0xf8,
	0x8b,0x4a,0x21,0x00,0x35,0xd5,0x55,0x55,0x2e,0x5b,0x63,0x08,0x00,0x02,0x0b,0x2d,0x2d,0x5b,0x47,0x21,
	0x57,0xf8,0x88,0x00,0x2d,0x85,0x0d,0x85,0xfa,0xe2,0xae,0x2e,0x2c,0x85,0x0d,0x85,0x7f,0x7f,0x5e,0x5e,
	0x0c,0x85,0xcc,0x7c,0xa2,0xe8,0xf8,0x60,0x0d,0x85,0xec,0x7c,0x2b,0x0f,0x2d,0xbd,0x2d,0x85,0x0d,0x85,
	0x82,0x82,0x0a,0x22,0x2d,0x85,0x0d,0x85,0xff,0x7a,0xfa,0xf8,0x2d,0x85,0x0d,0x85,0xbf,0xb7,0x7f,0xf7,
	0x2c,0x85,0x0d,0x85,0xb7,0x95,0xd5,0x79,0x2d,0x85,0x0c,0x85,0xee,0xfa,0xc2,0xef,0x2d,0x85,0x0d,0x85,
	0xaf,0xbe,0xee,0xfe,0x2c,0x85,0x0d,0x85,0xee,0x7a,0x7f,0x7a,0x2c,0x8d,0x0d,0x7d,0x5f,0x5f,0xe5,0xfd,
	0x2d,0x85,0x0d,0x85,0x0d,0x05,0xff,0x15,0x2d,0x85,0x0c,0x85,0xe2,0x7a,0x5c,0x57,0x0d,0x85,0xec,0x7c,
	0xbe,0x2e,0x0a,0x02,0xec,0x84,0x0d,0x7d,0xf7,0x75,0xbd,0xb7,0x2d,0x85,0x0c,0x85,0xfa,0xe2,0x88,0x20,
	0x2c,0x85,0x0d,0x85,0x5f,0x7f,0x7e,0x7a,0x0d,0x85,0xec,0x7c,0x60,0xc8,0xac,0xea,0x0d,0x85,0xec,0x7c,
	0x9d,0xaf,0x0b,0x0b,0x2c,0x85,0x0d,0x85,0xaf,0x25,0xdd,0xd5,0x2d,0x85,0x0c,0x85,0xe0,0xa2,0x22,0xae,
	0x2d,0x85,0x0d,0x85,0x5e,0xda,0xa2,0xb2,0x2c,0x85,0xed,0x7c,0x82,0xe3,0xee,0x6e,0x2d,0x85,0xec,0x7c,
	0xaf,0x3f,0xaf,0xbf,0x2d,0x85,0x0c,0x85,0xfa,0xf0,0xb2,0xdf,0x2d,0x85,0x0d,0x85,0x5c,0xf6,0xe2,0xeb,
	0x0d,0x85,0x2c,0x75,0xa2,0x0a,0x20,0x22,0x0d,0x85,0xec,0x7c,0x0a,0x8b,0xfb,0x2e,0x0c,0x85,0xed,0x7c,
	0xaa,0x0e,0xaa,0x22,0x0d,0x85,0xcc,0x7c,0x00,0xc0,0xf2,0x78,0x2d,0x85,0xcc,0x7c,0xfe,0x7f,0xf7,0x2f,
	0x2d,0x85,0x0d,0x85,0x00,0x8a,0xfe,0xa8,0x2d,0x85,0x0d,0x85,0x78,0xe2,0xae,0xca,0x2d,0x85,0xec,0x7c,
	0xff,0xfe,0xea,0xbe,0x0d,0x85,0xec,0x7c,0xab,0x27,0xb7,0xca,0x2c,0x85,0x0d,0x85,0xd5,0x7f,0x7b,0xf5,
	0x2d,0x85,0x0d,0x85,0x8f,0x8b,0x2f,0xfd,0x2e,0x85,0x0d,0x85,0xea,0x7f,0x57,0x55,0x2c,0x85,0x0d,0x85,
	0x57,0xdd,0xe9,0x8b,0x0d,0x85,0x2c,0x75,0x88,0x02,0xaa,0x08,0x2d,0x85,0x0c,0x85,0x7d,0xdf,0x75,0x7f,
	0x0d,0x85,0x2c,0x7d,0xee,0xaa,0x22,0x00,0x0d,0x85,0xec,0x7c,0xa8,0x88,0xa2,0x23,0x0d,0x85,0x2c,0x7d,
	0x00,0x00,0x28,0x23,0x0c,0x85,0xed,0x7c,0xea,0xf2,0x78,0xba,0x0d,0x85,0xec,0x7c,0xde,0x2f,0x0b,0x00,
	0x2d,0x85,0x0d,0x85,0xfd,0xd6,0xf5,0x55,0x2c,0x85,0x0d,0x85,0x2b,0xbe,0x8a,0xbb,0x2c,0x8d,0x0c,0x7d,
	0xa0,0x88,0x8a,0xaa,0x2d,0x85,0x0d,0x85,0x55,0x5f,0xfe,0x0b,0x2c,0x85,0x0d,0x85,0x57,0x6b,0xfe,0x58,
	0x0d,0x85,0xcc,0x7c,0x07,0xb6,0xb8,0x80,0x0c,0x85,0x0d,0x7d,0xeb,0xab,0xbf,0xff,0x2d,0x85,0x0d,0x85,
	0x5a,0x92,0x8a,0x25,0x0d,0x85,0xec,0x74,0x08,0x20,0x28,0x2c,0x0d,0x85,0x2d,0x7d,0xa0,0x80,0xa2,0x00,
	0x2c,0x85,0xed,0x7c,0xea,0xfa,0xbf,0xbf,0x2c,0x85,0xed,0x7c,0xff,0xfe,0xba,0xaa,0x2c,0x85,0x0d,0x85,
	0xb5,0xf5,0x77,0x5f,0x2d,0x85,0x0d,0x85,0x5a,0x7f,0x5f,0xfd,0x0d,0x85,0x2b,0x75,0x20,0x8a,0x28,0xa2,
	0x2d,0x85,0x0d,0x85,0x55,0xbd,0xef,0x5f,0x2d,0x85,0x0d,0x85,0xd5,0x77,0xd5,0x5d,0x2d,0x85,0x0d,0x85,
	0x8b,0xe5,0xfd,0x55,0x2c,0x85,0x0d,0x85,0xff,0x57,0x95,0xd5,0x2d,0x85,0x0c,0x85,0xaa,0x23,0x7a,0xe0,
	0x2c,0x85,0x0d,0x85,0xdf,0xde,0x57,0x75,0x2d,0x85,0x0d,0x85,0x8a,0x02,0x23,0xbd,0x2d,0x85,0x0d,0x85,
	0x5f,0x5a,0x60,0x40,0x2d,0x85,0xec,0x7c,0xaf,0xfe,0xbe,0x2d,0x2d,0x85,0xcc,0x7c,0x9e,0x7a,0xfe,0xb8,
	0x2d,0x85,0xcc,0x7c,0xaa,0xcb,0xaa,0x68,0x2d,0x85,0xec,0x7c,0xba,0x2f,0x2d,0x2d,0x2d,0x85,0x0d,0x85,
	0x76,0xf8,0xdc,0xef,0x0d,0x85,0x0c,0x7d,0x80,0x20,0x20,0x88,0x2c,0x85,0xed,0x7c,0xab,0xab,0xff,0xfd,
	0x0d,0x85,0x2b,0x75,0x22,0x82,0x08,0xaa,0x2d,0x85,0xec,0x7c,0xfe,0xff,0x2f,0x02,0x2d,0x85,0x0d,0x85,
	0xb5,0xaf,0x02,0x50,0x0c,0x85,0xed,0x7c,0xaa,0x8e,0xe8,0xa2,0x0d,0x85,0xec,0x7c,0xaa,0x3f,0xd7,0xbf,
	0x0d,0x85,0x0c,0x7d,0xab,0xfa,0xef,0xff,0x2e,0x8d,0x0c,0x7d,0xef,0xd5,0x55,0xdd,0x2d,0x85,0x0d,0x85,
	0xad,0x02,0x25,0xd5,0x4c,0x85,0xed,0x7c,0xee,0xf7,0x2f,0xba,0x2d,0x8d,0x0c,0x7d,0xa7,0xaa,0x28,0xaa,
	0x2d,0x85,0xec,0x7c,0xbe,0xe8,0xdc,0x5e,0x2d,0x85,0xcc,0x7c,0x68,0xfe,0xbf,0x0b,0x2d,0x85,0xec,0x7c,
	0xad,0x2f,0xaa,0xfe,0x2d,0x85,0x0d,0x85,0xa2,0x60,0xbf,0xe7,0x2d,0x85,0xcc,0x7c,0xba,0xca,0xe8,0x7e,
	0x2d,0x85,0xcc,0x7c,0x2a,0x2f,0xef,0xed,0x2d,0x85,0xec,0x7c,0xa0,0xaa,0x7f,0x7f,0x2d,0x85,0xec,0x7c,
	0xa2,0x7e,0x5f,0x57,0x0d,0x85,0xec,0x7c,0xab,0xef,0xfd,0xaa,0x2c,0x85,0x0d,0x85,0x57,0xab,0x55,0xfb,
	0x0d,0x85,0x2c,0x7d,0x08,0x02,0x88,0x80,0x2d,0x85,0xed,0x7c,0x6e,0xee,0x82,0x8c,0x0d,0x85,0xec,0x7c,
	0xaf,0xba,0xc0,0x08,0xed,0x84,0x0c,0x7d,0xd5,0xff,0x77,0xff,0x2d,0x8d,0x0c,0x7d,0xff,0x5f,0xdf,0x55,
	0x2d,0x85,0x0d,0x85,0x33,0xe5,0x55,0x55,0x2d,0x8d,0x0c,0x7d,0x5f,0x5f,0xfd,0x7d,0x0d,0x85,0x2d,0x7d,
	0xa0,0xaa,0x0a,0x8a,0x2c,0x85,0x0d,0x85,0xde,0xbf,0xf5,0x57,0x2d,0x85,0xec,0x7c,0x6a,0xfe,0xea,0xeb,
	0x0c,0x85,0xec,0x7c,0xf9,0xd7,0xdf,0xfe,0x0d,0x85,0xec,0x7c,0xb9,0xff,0xed,0xaa,0x0d,0x85,0xcc,0x7c,
	0xfc,0xbb,0xbf,0xee,0x0d,0x85,0xcc,0x7c,0xea,0xba,0xea,0xfd,0x0d,0x85,0xcc,0x7c,0xef,0x7a,0xd5,0x2a,
	0x90,0x8d,0x0d,0x85,0x55,0x55,0x5d,0x00,0x90,0x95,0x0d,0x85,0x55,0x55,0x55,0x00,0x90,0x8d,0x0d,0x85,
	0x55,0x75,0x5d,0x28,0x6f,0x8d,0xec,0x7c,0xff,0x77,0xff,0xa0,0x2d,0x85,0xec,0x7c,0xfe,0xff,0xfb,0x00,
	0x2d,0x85,0xec,0x7c,0xf7,0xaa,0xff,0x00,0x0d,0x85,0x0c,0x7d,0xff,0xea,0xfb,0xaa,0x2d,0x85,0xec,0x7c,
	0x2e,0x6e,0xee,0x22,0x2d,0x85,0xed,0x84,0xe2,0x7f,0xfe,0x8a,0x2d,0x85,0xec,0x7c,0x7f,0xd5,0x7f,0xaa,
	0x2d,0x85,0xec,0x7c,0xff,0x7f,0xef,0x8b,0x2d,0x85,0xec,0x7c,0xff,0xf5,0xef,0xa2,0x2d,0x85,0xcc,0x7c,
	0x7f,0xaa,0x22,0xa2,0x2d,0x85,0xcc,0x84,0xf7,0x8a,0xa8,0x8a,0x2d,0x85,0x0d,0x85,0x75,0xde,0xab,0x22,
	0x2d,0x85,0x0d,0x85,0x55,0xd5,0xee,0xf2,0x9f,0xcf,0xdc,0x8d,0x00,0xaa,0xbf,0x55,0xbf,0xcf,0xdc,0x8d,
	0x00,0xaa,0xff,0x55,0xbf,0xcf,0xdc,0x8d,0x00,0xaa,0xff,0x55,0xbf,0xcf,0xdd,0x8d,0x00,0xaa,0xfe,0x55,
	0x9f,0xcf,0xbc,0x8d,0x00,0xaa,0xef,0x55,0x9e,0xcf,0xbc,0x8d,0x00,0xaa,0xfe,0x55,0x3d,0xbf,0xbc,0x8d,
	0x00,0x00,0xff,0x55,0x3d,0xbf,0xbc,0x8d,0x00,0x00,0xff,0x55,0x1d,0xbf,0xdd,0x8d,0x00,0x00,0xfb,0xb5,
	0x7e,0xd7,0x5c,0xa6,0xfe,0xea,0x55,0x2d,0x7e,0xdf,0x3b,0x9e,0x7f,0xbb,0x55,0x20,0x3e,0xcf,0x3a,0x9e,
	0x55,0xaa,0x55,0x80,0x3f,0xc7,0x19,0x9e,0xf5,0x02,0xf5,0xea,0x9f,0xcf,0x3b,0x9e,0x55,0x00,0xff,0x55,
	0xbf,0xd7,0x3b,0x9e,0xd5,0x00,0xaf,0x55,0xbf,0xcf,0x7b,0xa6,0x55,0x00,0xba,0xf5,0x3a,0x7d,0xd4,0x5b,
	0x00,0xaa,0xdf,0x55,0x3a,0x7d,0xd4,0x5b,0x00,0xaa,0xff,0x55,0x3a,0x7d,0xd4,0x5b,0x00,0xaa,0xff,0x55,
	0x3a,0x7d,0xd4,0x5b,0x00,0xaa,0xff,0x55,0x1a,0x7d,0xd4,0x5b,0x00,0xaa,0x7f,0x55,0xf9,0x74,0xb4,0x5b,
	0x00,0xaa,0xff,0x55,0xf9,0x74,0xb4,0x5b,0x00,0xaa,0xff,0x55,0xf9,0x7c,0xd4,0x5b,0x00,0xaa,0xf7,0x55,
	0x19,0x7d,0xd4,0x5b,0x00,0xaa,0xf7,0x55,0xbb,0x95,0xd4,0x5b,0x0a,0xef,0xdf,0x55,0x9a,0x95,0xf5,0x5b,
	0x00,0xfe,0xff,0x55,0xbb,0x95,0x15,0x64,0x00,0xaa,0xfd,0x55,0xfd,0xc6,0x36,0x64,0x02,0x02,0x7f,0x55,
	0xde,0xbe,0x97,0x74,0xa8,0xa0,0x55,0x55,0x5d,0xae,0x97,0x6c,0xaa,0xe0,0xdf,0x55,0xdc,0x95,0xb8,0x74,
	0x00,0xaa,0xff,0x55,0x72,0x53,0x8d,0x3a,0x00,0xaa,0xff,0x55,0x92,0x53,0x8e,0x3a,0x00,0xaa,0xff,0x55,
	0x92,0x53,0x8e,0x3a,0x00,0xaa,0xff,0x55,0x92,0x53,0xae,0x3a,0x00,0xaa,0xff,0x55,0x72,0x53,0xae,0x3a,
	0x00,0xaa,0xff,0x5d,0x72,0x53,0xaf,0x42,0x00,0xaa,0xff,0x55,0x72,0x53,0xae,0x3a,0x00,0xaa,0xff,0x75,
	0x72,0x53,0xcf,0x42,0x00,0xaa,0xff,0x55,0x93,0x53,0xcf,0x42,0x00,0xaa,0xff,0x55,0x93,0x53,0xef,0x42,
	0x00,0x2a,0xff,0x55,0xb4,0x5b,0x10,0x4b,0x00,0x2a,0xff,0x55,0xb7,0x74,0x51,0x4b,0xa2,0xff,0x55,0x55,
	0x59,0x95,0x72,0x53,0xbb,0x0b,0xd5,0x55,0xda,0xa5,0x72,0x53,0xea,0xe0,0x6b,0x55,0x56,0x6c,0x93,0x5b,
	0x00,0xae,0xff,0xd5,0x77,0x6c,0xd3,0x5b,0x00,0xab,0xfd,0x55,0x4c,0x32,0x89,0x21,0x00,0xba,0xff,0x55,
	0x4c,0x32,0x89,0x21,0x00,0xaa,0xff,0xd5,0x4d,0x3a,0xa9,0x21,0x00,0x2a,0xff,0xf5,0x6d,0x3a,0xca,0x29,
	0x00,0xaa,0xff,0xd5,0x8e,0x3a,0xea,0x29,0x00,0xae,0xff,0x55,0x8e,0x3a,0xeb,0x29,0x00,0xba,0xff,0x75,
	0x8e,0x3a,0x0b,0x32,0x00,0xae,0xf7,0x55,0x8e,0x3a,0x0b,0x32,0x00,0xaa,0xff,0xd5,0xaf,0x42,0x0b,0x2a,
	0x08,0xaa,0xff,0xfd,0xcf,0x42,0x2c,0x32,0x02,0xaa,0xff,0xd5,0xf0,0x42,0x4d,0x3a,0x02,0xbb,0xff,0xd5,
	0x10,0x4b,0x6d,0x3a,0x22,0xab,0xff,0x55,0x31,0x53,0x8d,0x3a,0x22,0xab,0xff,0xd5,0x51,0x4b,0xae,0x42,
	0x02,0xaa,0xff,0xf5,0x72,0x53,0xef,0x4a,0x02,0xaa,0xbd,0x55,0xb3,0x5b,0x10,0x4b,0x02,0x2a,0xbb,0xd5,
	0x68,0x19,0xc5,0x10,0x00,0xaa,0xff,0x77,0x68,0x21,0xe5,0x10,0x00,0xaa,0xfd,0x55,0x89,0x21,0xe5,0x10,
	0x00,0xae,0xef,0xf5,0xa9,0x21,0x27,0x19,0x00,0xab,0xfd,0x55,0xca,0x29,0x47,0x19,0x00,0xaa,0xbd,0x55,
	0xea,0x29,0x68,0x21,0x08,0xaa,0xff,0x55,0xeb,0x29,0x89,0x21,0x00,0xaa,0xf5,0x55,0x0b,0x32,0x89,0x21,
	0x22,0xaa,0xff,0xfd,0x0b,0x32,0xa9,0x21,0x08,0xaa,0xef,0xdd,0x2c,0x32,0xca,0x29,0x22,0xae,0xff,0x55,
	0x4c,0x32,0xca,0x29,0x22,0xaa,0xff,0xfd,0x6d,0x3a,0xea,0x29,0x0a,0xaa,0xff,0xf5,0x8d,0x3a,0x0a,0x32,
	0x22,0xaa,0xbf,0xfd,0xae,0x42,0x4c,0x3a,0x02,0xaf,0xff,0xd5,0xef,0x4a,0x6d,0x3a,0x2a,0xab,0xff,0xd5,
	0x10,0x4b,0xae,0x42,0x0a,0xaf,0xdd,0x55,0x47,0x21,0x84,0x08,0xff,0x5d,0x55,0x2d,0x47,0x21,0x84,0x08,
	0xff,0x55,0x55,0xe8,0xe6,0x10,0x83,0x08,0x22,0xaf,0xd5,0x55,0x06,0x19,0x83,0x08,0x02,0xaa,0xbf,0xf5,
	0x47,0x19,0xc5,0x10,0x0a,0xab,0xf7,0xf5,0x68,0x21,0xe6,0x18,0x0a,0xbb,0xef,0xf7,0x89,0x21,0x07,0x19,
	0x2a,0xab,0xff,0xf7,0x88,0x21,0x47,0x19,0x00,0x2f,0xef,0xd5,0xa9,0x29,0x68,0x21,0x0a,0xbf,0xfd,0x55,
	0xc9,0x29,0x67,0x21,0x0a,0xae,0x9f,0xfd,0xeb,0x29,0x88,0x21,0x2a,0xab,0xdf,0xf5,0x0b,0x2a,0xa9,0x29,
	0x2a,0xab,0xbf,0xf5,0x2b,0x32,0xc9,0x29,0x0a,0xab,0xbf,0xfd,0x6c,0x3a,0xea,0x31,0xa8,0xaf,0xff,0xf5,
	0x6d,0x3a,0x0b,0x32,0x02,0x2a,0xaf,0xfd,0xae,0x42,0x4c,0x3a,0x2b,0xaf,0xdd,0xd5,0xed,0x52,0xc4,0x10,
	0xaf,0x80,0x60,0x56,0x0a,0x3a,0x41,0x00,0x78,0x5e,0x55,0x55,0xc5,0x10,0x21,0x00,0xff,0xdd,0xd5,0x2d,
	0x46,0x21,0x83,0x08,0x55,0x55,0x55,0x2a,0xcd,0x52,0xa4,0x10,0x55,0x55,0x7d,0x82,0xed,0x52,0xe5,0x10,
	0x55,0x55,0xf5,0x02,0x68,0x21,0xe5,0x10,0xbf,0xfd,0x54,0x54,0x47,0x19,0xe5,0x18,0x0a,0xaa,0xaf,0xfd,
	0x68,0x21,0x27,0x19,0x2a,0xff,0xfd,0x55,0x68,0x21,0x47,0x21,0x0a,0x2a,0xa5,0x55,0x88,0x21,0x48,0x21,
	0x00,0x0e,0x3b,0xbf,0xa9,0x29,0x88,0x21,0x0e,0x39,0xb5,0xd5,0xea,0x29,0x89,0x29,0x2a,0xab,0xe7,0xff,
	0x0b,0x32,0xca,0x29,0x2b,0xaf,0xfd,0x55,0x2b,0x3a,0xea,0x29,0x2a,0xbf,0xfd,0xd5,0x4c,0x3a,0x0b,0x32,
	0x0a,0xaf,0xfd,0xd5,0x8b,0x4a,0xa4,0x10,0xf5,0xea,0x70,0x78,0x2a,0x3a,0x62,0x08,0x57,0xb5,0x2f,0x2f,
	0x6f,0x63,0x06,0x19,0xf5,0xef,0xaa,0x2a,0x15,0x95,0xe9,0x31,0xd5,0xbd,0x0b,0x02,0x56,0xa5,0x8f,0x63,
	0xfd,0x2a,0x00,0xfa,0x35,0x9d,0x2b,0x3a,0xea,0x60,0x58,0xfe,0xcd,0x4a,0xe5,0x10,0x57,0x5e,0x7a,0x58,
	0x06,0x19,0xc5,0x10,0x0b,0xef,0xf5,0xd5,0x26,0x19,0xe5,0x10,0x22,0x2f,0xbd,0xfd,0x47,0x21,0x06,0x19,
	0x2a,0xef,0xbf,0xfd,0x68,0x21,0x26,0x19,0x2a,0xef,0xaf,0xbf,0x88,0x21,0x47,0x19,0x0a,0x2f,0xbb,0xbf,
	0xa9,0x29,0x68,0x21,0x0a,0xaf,0xab,0xff,0xc9,0x29,0x88,0x21,0x03,0x0f,0x3e,0xed,0xea,0x31,0xa9,0x29,
	0x02,0x3b,0xef,0xbf,0x0b,0x32,0xea,0x29,0x02,0x2f,0xbd,0x55,0x11,0x7c,0xec,0x52,0x2b,0x2f,0x3f,0x35,
	0x58,0xbe,0xb3,0x8c,0xad,0x2d,0x0b,0xa9,0xba,0xce,0x18,0xbe,0xfd,0x8a,0xab,0xfd,0xba,0xce,0x58,0xbe,
	0x77,0x0a,0x2a,0xed,0x59,0xbe,0x2e,0x5b,0x78,0x60,0xe0,0xe0,0x6f,0x63,0xa8,0x29,0x7a,0x7a,0x78,0x78,
	0x84,0x10,0xa5,0x08,0xfb,0x5f,0x7d,0x7d,0xe5,0x10,0xa4,0x10,0xbd,0xaf,0xef,0x2b,0x47,0x21,0xc5,0x10,
	0xfd,0xf7,0xff,0x2f,0x26,0x19,0x06,0x19,0x95,0xa5,0x29,0xaa,0x47,0x21,0x26,0x19,0xd5,0x95,0xad,0x07,
	0x68,0x21,0x47,0x19,0xb5,0xad,0x2b,0x0a,0x88,0x29,0x68,0x21,0xd5,0xad,0x2d,0x02,0xc9,0x29,0x88,0x21,
	0xf5,0xfd,0xff,0x2f,0xca,0x29,0xa9,0x29,0xb5,0x2d,0x0a,0x02,0x0b,0x32,0xc9,0x29,0xf5,0xbd,0x9b,0x2b,
	0xb0,0x6b,0x42,0x08,0x0a,0x2a,0x3f,0xb5,0x75,0xa5,0x11,0x7c,0x02,0x03,0x02,0xa9,0x17,0xbe,0x34,0x9d,
	0x0b,0xbd,0xa5,0xb5,0x79,0xc6,0xf7,0xb5,0xaf,0xad,0x2d,0x2d,0x79,0xc6,0xb3,0x8c,0x78,0x78,0xf8,0xa0,
	0xf4,0x94,0x2a,0x3a,0x7e,0xfa,0xa0,0xa0,0x6f,0x63,0xe5,0x10,0x55,0x57,0x5e,0x78,0x27,0x21,0xc4,0x10,
	0xf5,0xfd,0xbf,0xa0,0xee,0x52,0x06,0x19,0xf5,0x8d,0x0b,0xeb,0xaa,0x29,0x06,0x19,0xff,0xfe,0xfc,0xff,
	0x88,0x21,0x47,0x19,0xf5,0xbd,0xbf,0x2b,0xa9,0x29,0x68,0x21,0xf5,0xfd,0xaf,0x0b,0xca,0x29,0x88,0x21,
	0xfd,0xbf,0xef,0x0a,0xea,0x31,0xa9,0x29,0xfd,0xff,0x2f,0x3a,0x0b,0x32,0xca,0x29,0xbd,0xaf,0x0a,0x02,
	0x4c,0x3a,0xea,0x29,0xf7,0x9f,0xaf,0x2a,0x05,0x19,0x21,0x00,0x35,0x55,0x55,0x55,0xb3,0x8c,0x42,0x08,
	0x0b,0xad,0xf5,0x55,0x55,0x9d,0x05,0x19,0x00,0x0a,0xab,0xd5,0xf7,0xb5,0x8c,0x4a,0x00,0x0a,0xfa,0x55,
	0x59,0xbe,0xf1,0x73,0x80,0x80,0xab,0x6d,0x15,0x95,0xcd,0x4a,0xe0,0xa8,0xfa,0x57,0xb0,0x6b,0xa9,0x29,
	0xb8,0xa8,0xfe,0x57,0xcd,0x52,0x06,0x19,0x5c,0x5c,0x5c,0xd7,0x67,0x21,0x06,0x19,0xe9,0xb7,0xaf,0x2b,
	0xa9,0x29,0x47,0x19,0xf5,0xfd,0xaf,0x3b,0xca,0x29,0x67,0x21,0xfd,0xaf,0x3a,0x02,0xea,0x29,0xa9,0x29,
	0xd5,0xdd,0xaf,0x2a,0x0b,0x32,0xca,0x29,0xd5,0x9d,0xab,0x0a,0x2c,0x32,0xea,0x29,0xf5,0xbf,0x2b,0x02,
	0x6d,0x3a,0x0b,0x32,0xf5,0xfd,0xaf,0x2a,0x8e,0x42,0x2c,0x32,0xfd,0xff,0xaf,0x02,0xc5,0x10,0x42,0x08,
	0x5d,0xff,0xea,0x00,0xa4,0x10,0x21,0x00,0x77,0xff,0xaa,0x00,0xa4,0x10,0x42,0x00,0x95,0xff,0xab,0x00,
	0xa8,0x21,0x63,0x08,0xbf,0xb5,0x3d,0xff,0x90,0x63,0x67,0x21,0x8b,0xad,0xb5,0xb5,0xf4,0x8c,0x88,0x29,
	0x57,0xaf,0x02,0x02,0xb4,0x8c,0x68,0x21,0x55,0x57,0x78,0x5e,0xa9,0x29,0x27,0x19,0x75,0xfd,0xaf,0x2a,
	0xea,0x29,0x68,0x21,0xd5,0xf5,0xab,0x0a,0x2c,0x32,0xa9,0x29,0xd5,0xfd,0xaf,0x8a,0x2c,0x32,0xca,0x29,
	0xfd,0xbf,0xaa,0x02,0x6d,0x3a,0xea,0x29,0x75,0xff,0xab,0x00,0x8e,0x3a,0x0b,0x32,0xd5,0xff,0xab,0x28,
	0xae,0x42,0x2c,0x32,0xdd,0xbf,0xab,0x0a,0xcf,0x42,0x4c,0x3a,0xfd,0xbf,0xaa,0x02,0xf9,0xad,0xae,0x42,
	0x55,0x55,0xd5,0x2d,0x53,0x7c,0x26,0x19,0x55,0x55,0x57,0xa0,0xee,0x4a,0xe6,0x10,0x55,0xf5,0xdf,0x80,
	0x4b,0x3a,0xe5,0x10,0x57,0xfa,0xf7,0x0a,0x0a,0x32,0xe6,0x10,0x55,0xf7,0xff,0xf8,0x15,0x95,0x48,0x21,
	0xb5,0xad,0xb5,0x2d,0x39,0xb6,0x12,0x74,0xe9,0xad,0xea,0x80,0xf5,0x8c,0xca,0x29,0x57,0x56,0x5e,0x80,
	0xef,0x4a,0xa9,0x21,0xd5,0xdd,0xff,0xe8,0x8e,0x3a,0xea,0x29,0xd5,0xff,0xab,0x02,0x34,0x6c,0x4c,0x32,
	0x55,0x55,0xd5,0x3f,0x3a,0xb6,0x6d,0x3a,0x55,0x55,0xbf,0x0a,0x95,0x7c,0x8e,0x3a,0x55,0x55,0x57,0xbc,
	0x92,0x5b,0x8e,0x3a,0x55,0xfd,0xff,0x2a,0x1d,0xd7,0xef,0x4a,0x55,0xd5,0xad,0x03,0x5d,0xdf,0x30,0x53,
	0x55,0xaf,0x0a,0x00,0x9e,0xe7,0x37,0x95,0xad,0x2a,0x00,0xaa,0xba,0xce,0x2f,0x53,0xa0,0x00,0xaa,0x55,
	0x99,0xc6,0x91,0x63,0x02,0x20,0x2a,0xb5,0xba,0xce,0xd7,0xad,0x2e,0x00,0xf8,0x62,0x9a,0xc6,0x90,0x63,
	0x78,0x00,0x02,0xaf,0x59,0xbe,0x90,0x63,0xb5,0x00,0x00,0x00,0xdb,0xce,0x39,0xb6,0x09,0x00,0xd5,0x5d,
	0x3c,0xd7,0x77,0xa5,0x7a,0xe8,0x02,0x2b,0xbb,0xc6,0xcf,0x42,0x5e,0xfa,0x00,0x00,0x7b,0xbe,0xaf,0x3a,
	0x55,0xdf,0x68,0xa8,0x5d,0xdf,0x51,0x53,0xb5,0xd5,0xb5,0x02,0x1c,0xd7,0x57,0x95,0x7f,0x55,0xa0,0x00,
	0x1c,0xd7,0x92,0x5b,0x5f,0xbf,0x00,0x00,0x1d,0xd7,0x34,0x6c,0x2d,0xa0,0xa8,0x00,0x3c,0xd7,0x3a,0xb6,
	0x00,0xa9,0xad,0x00,0x1c,0xd7,0x77,0x95,0x00,0x20,0x80,0x78,0xfc,0xce,0xf6,0x8c,0x00,0x80,0xfa,0xd5,
	0xf4,0x63,0x8d,0x3a,0x55,0xff,0xaa,0x00,0xf6,0x8c,0xcf,0x42,0xd5,0x55,0x2f,0x0b,0xba,0xce,0x0f,0x4b,
	0xdd,0xf5,0x02,0x2a,0x99,0xc6,0xf2,0x6b,0x55,0x2b,0x00,0x00,0x99,0xce,0x73,0x7c,0x35,0xfa,0x80,0x00,
	0x9a,0xce,0xf5,0x8c,0x00,0xb5,0xaf,0x00,0x1c,0xd7,0x5a,0xbe,0xff,0x9f,0x02,0xef,0x1c,0xd7,0x7b,0xbe,
	0x02,0x00,0x80,0x55,0x3d,0xd7,0x37,0x95,0x00,0x88,0xea,0x5f,0xdb,0xce,0x78,0x9d,0x00,0x80,0xbf,0xf5,
	0x9b,0xc6,0x98,0xa5,0xa0,0xb5,0x5e,0xff,0xbb,0xc6,0x96,0x7c,0x0a,0xfe,0x57,0xfa,0xbb,0xc6,0x14,0x6c,
	0x00,0x7f,0x55,0xab,0x9a,0xc6,0x75,0x74,0x80,0x55,0xfd,0x00,0x5a,0xbe,0x74,0x74,0x5e,0xd5,0xaf,0x20,
	0x7a,0xbe,0x95,0x7c,0xbd,0xbd,0x00,0xaa,0xba,0xbe,0x96,0x6c,0x55,0xff,0xaa,0x00,0x79,0xbe,0x15,0x5c,
	0x55,0xff,0xaa,0x00,0xf7,0xad,0xb3,0x5b,0x55,0x7f,0xaa,0x20,0x75,0x9d,0xf3,0x63,0xfd,0xd5,0x2a,0x00,
	0x18,0xae,0xf3,0x63,0x0b,0x75,0xba,0x82,0xf8,0xa5,0x75,0x6c,0x20,0xd5,0x02,0xea,0xdc,0xc6,0x58,0x8d,
	0xe2,0xfd,0xff,0xfd,0x9b,0xbe,0x37,0x8d,0x0b,0x7f,0xff,0xff,0x5a,0xbe,0x56,0x95,0xe0,0x03,0x7f,0x57,
	0x39,0xb6,0x56,0x95,0x57,0x00,0xfd,0xf5,0x39,0xbe,0x97,0x95,0xfd,0x80,0x5d,0xd5,0x5b,0xbe,0x15,0x85,
	0x0a,0x7e,0xdf,0x7f,0x7a,0xbe,0xf5,0x84,0x00,0x5d,0xf7,0x55,0x39,0xb6,0xd4,0x7c,0x80,0xf5,0x0a,0x55,
	0x19,0xae,0x93,0x74,0x5e,0xab,0x00,0xff,0x39,0xae,0x94,0x7c,0x55,0x8a,0x00,0xff,0x2c,0x85,0xcf,0x7c,
	0xdf,0xaa,0x88,0x08,0x2d,0x85,0xce,0x7c,0x7f,0x2a,0x88,0x28,0x0d,0x85,0x8d,0x7c,0x56,0x00,0x00,0x00,
	0x2d,0x85,0xad,0x7c,0xd5,0x2a,0x8a,0x28,0x2c,0x85,0xee,0x84,0xf5,0xaa,0xaa,0xaa,0x2d,0x85,0x0d,0x85,
	0xd5,0xcd,0xff,0xdf,0x2d,0x85,0x0d,0x85,0x03,0xfa,0xff,0x7f,0x2d,0x85,0x0d,0x85,0xea,0xff,0xaf,0x55,
	0x2d,0x85,0x0d,0x85,0x2a,0x02,0x08,0xeb,0x2d,0x8d,0x0d,0x7d,0xea,0x08,0x00,0xab,0x2d,0x85,0x0d,0x85,
	0xff,0x88,0x78,0xe2,0x2d,0x85,0x0d,0x85,0x5f,0x7f,0xd5,0xdf,0x0d,0x85,0x2d,0x7d,0xaa,0xaa,0x8a,0x02,
	0x2d,0x8d,0x0c,0x7d,0xff,0xf7,0xdf,0x55,0x2d,0x85,0x0d,0x85,0xbe,0x2a,0xfd,0xf5,0x2d,0x85,0x0d,0x85,
	0xfe,0xfa,0xfe,0xff,0x2d,0x85,0x0d,0x85,0xd7,0xb5,0x00,0x80,0x2c,0x85,0x0d,0x85,0x5f,0xaa,0x22,0xd7,
	0x2c,0x85,0x0d,0x85,0x55,0xbb,0xbf,0x57,0x2d,0x85,0xec,0x7c,0x0a,0x0a,0xe8,0x5e,0x2d,0x85,0xec,0x7c,
	0x88,0xba,0xbf,0x0d,0x2c,0x85,0x0c,0x85,0x2a,0x61,0x4a,0x90,0x2d,0x85,0xec,0x7c,0x88,0x36,0x2b,0x32,
	0x2d,0x85,0x0d,0x85,0xf5,0xfe,0xfe,0xef,0x2c,0x85,0x0d,0x85,0xdf,0xaa,0xbf,0xff,0x2c,0x85,0x0d,0x85,
	0xea,0x5e,0xfe,0x5e,0x2d,0x85,0xec,0x7c,0xea,0xaa,0xff,0xff,0x0d,0x85,0xeb,0x7c,0x00,0x02,0xa2,0x02,
	0x0d,0x85,0xec,0x7c,0xba,0x20,0xa0,0xf6,0x0d,0x85,0xec,0x7c,0xaa,0xbf,0x0a,0xab,0x0d,0x85,0xec,0x7c,
	0x88,0xa2,0x2a,0xa2,0x0c,0x85,0xed,0x7c,0x82,0x2e,0xbb,0xf2,0x2d,0x85,0x0d,0x85,0xff,0x77,0x55,0x55,
	0x0d,0x85,0x2c,0x7d,0x2a,0x00,0x02,0x80,0x0c,0x85,0xed,0x74,0xaa,0xaa,0x2a,0x00,0x2d,0x85,0xec,0x7c,
	0xff,0xbf,0xaa,0xa2,0x2d,0x85,0x0d,0x85,0x09,0x00,0x0b,0x8e,0x2d,0x85,0x0c,0x85,0xe0,0x8a,0xf2,0x5f,
	0x2d,0x85,0x0d,0x85,0xeb,0x7e,0xfb,0xbd,0x2c,0x85,0x0d,0x85,0xd5,0xb5,0xf5,0xae,0x2c,0x85,0x0d,0x85,
	0xff,0x75,0x77,0x56,0x0d,0x85,0xed,0x7c,0xa0,0x88,0xaa,0x20,0x0d,0x85,0x2c,0x75,0x22,0x88,0x28,0xa0,
	0x0d,0x85,0xec,0x7c,0xfa,0x52,0x60,0xa0,0x0d,0x85,0xec,0x7c,0x57,0x7f,0xff,0x38,0x0d,0x85,0xec,0x7c,
	0xcd,0xf7,0xcf,0x00,0x0d,0x85,0xec,0x7c,0x2a,0x2f,0xbb,0xae,0x0d,0x85,0xec,0x7c,0xaa,0x02,0xb2,0x5f,
	0x2d,0x85,0xec,0x7c,0xea,0xfa,0xbf,0xaf,0x2c,0x85,0x0d,0x85,0xbd,0x95,0xb5,0xca,0x2d,0x85,0x0d,0x85,
	0x7a,0xfe,0xf2,0xd7,0x2d,0x85,0x0d,0x85,0xff,0xdf,0x75,0x5f,0x2d,0x85,0x0d,0x85,0xff,0x5f,0x5f,0x55,
	0x2c,0x8d,0x0d,0x7d,0x7f,0xf5,0xf5,0xd5,0x2d,0x85,0x0d,0x85,0xbd,0xbf,0xb7,0xfd,0x2c,0x85,0x0d,0x85,
	0xbe,0xff,0xdf,0x7b,0x2d,0x85,0x0d,0x85,0x7f,0xdf,0xbb,0xbe,0x2c,0x85,0x0d,0x85,0x57,0x7f,0xfa,0xee,
	0x0c,0x85,0x2d,0x7d,0xa0,0xa8,0x8a,0xaa,0x0d,0x85,0xec,0x7c,0x02,0xa2,0x28,0x80,0x0d,0x85,0xed,0x7c,
	0xa0,0x0a,0x02,0x0a,0x2d,0x85,0x0d,0x85,0x55,0xd5,0xfd,0xf5,0x0c,0x85,0x0d,0x7d,0xab,0xbb,0xbb,0xef,
	0x0d,0x85,0xec,0x7c,0xfd,0x5e,0xf0,0xa8,0x2c,0x85,0x0d,0x85,0xbf,0xff,0xb7,0xfe,0x2d,0x85,0x0d,0x85,
	0x5e,0xf5,0xff,0x5f,0x2d,0x85,0xec,0x7c,0xaa,0xaa,0xfe,0xff,0x0d,0x85,0xec,0x7c,0x00,0x00,0x80,0xc0,
	0x0c,0x85,0xed,0x7c,0x82,0x88,0x8a,0x82,0x0d,0x85,0xec,0x7c,0xea,0xf2,0xaa,0x02,0x2d,0x85,0x0d,0x85,
	0xe5,0xfb,0xbf,0xdd,0x2c,0x85,0x0d,0x85,0xfb,0x7b,0xfe,0xfa,0x0d,0x85,0x2c,0x7d,0x82,0x08,0x00,0x2a,
	0x2c,0x85,0x0d,0x85,0xee,0xb5,0xb5,0xdd,0x2d,0x85,0x0c,0x85,0xab,0x02,0x2a,0x2f,0x2d,0x85,0x0d,0x85,
	0x7a,0xe2,0x88,0x00,0x2d,0x85,0xec,0x7c,0xff,0xbe,0xaa,0xaa,0x0d,0x85,0x2c,0x75,0x88,0x82,0x0a,0x28,
	0x0d,0x85,0x0d,0x7d,0x00,0xa0,0xa2,0x00,0x0d,0x85,0xec,0x7c,0xa8,0xce,0xaa,0x20,0x2c,0x85,0x0d,0x85,
	0xef,0xf7,0xef,0xea,0x0d,0x85,0x2c,0x7d,0x02,0x00,0x0a,0x82,0x0c,0x85,0xed,0x7c,0x2a,0x02,0xa8,0x80,
	0x0d,0x85,0xec,0x7c,0xa8,0x38,0x2e,0xa2,0x2c,0x85,0xed,0x7c,0xff,0xfe,0xba,0xab,0x2d,0x85,0x0d,0x85,
	0xdd,0x5e,0x5f,0x77,0x0d,0x85,0xec,0x7c,0x28,0x22,0x2a,0x20,0x2d,0x85,0x0d,0x85,0xee,0xeb,0x2f,0x95,
	0x2d,0x85,0x0d,0x85,0x7f,0x5f,0xf7,0x76,0x2d,0x85,0x0d,0x85,0xf9,0xfd,0xf7,0x5f,0x2c,0x85,0x0d,0x85,
	0xff,0xdf,0xde,0x75,0x2c,0x8d,0x2d,0x85,0x55,0x57,0xf7,0xd7,0x2d,0x85,0x0c,0x7d,0x5f,0x70,0xc3,0x3f,
	0x2d,0x85,0x0d,0x85,0xbd,0xfd,0xd5,0x7f,0x2d,0x85,0x0d,0x85,0xfe,0x03,0x0b,0x8a,0x2c,0x85,0xed,0x7c,
	0xfe,0xfe,0xa8,0xaa,0x0d,0x85,0x2d,0x7d,0x0a,0x20,0x08,0x80,0x0d,0x85,0xec,0x7c,0x80,0x20,0x88,0x00,
	0x2d,0x85,0xec,0x7c,0xef,0xbb,0xfa,0xfa,0x2d,0x85,0x0d,0x85,0x55,0x7f,0xf5,0xbd,0x2d,0x85,0x0d,0x85,
	0xf7,0xfd,0xdf,0xff,0x2d,0x85,0x0d,0x85,0x7f,0x7d,0x77,0x5f,0x0d,0x85,0xec,0x7c,0x20,0x0a,0x22,0xa2,
	0x0c,0x85,0xed,0x84,0x0a,0x02,0x0a,0x08,0x2d,0x85,0x0d,0x85,0xbe,0xab,0x2f,0x0b,0x2c,0x85,0x0d,0x85,
	0x5f,0x5f,0x5e,0x58,0x2d,0x85,0xec,0x7c,0x2f,0x3f,0xaf,0x8b,0x2d,0x85,0x0c,0x85,0xa0,0xc0,0xeb,0xdf,
	0x2d,0x85,0x0d,0x85,0x56,0x5b,0x7f,0x7d,0x2c,0x85,0x0d,0x85,0xdf,0x7b,0x7d,0x79,0x2d,0x85,0x0c,0x85,
	0x8a,0x03,0x09,0xaf,0x2d,0x85,0x0c,0x85,0xea,0xa3,0xbe,0xfe,0x2d,0x85,0x0d,0x85,0xb5,0xfb,0xea,0xf2,
	0x2c,0x85,0x0d,0x85,0xd7,0xaf,0xfb,0x5f,0x0c,0x85,0x0d,0x7d,0xab,0xaf,0xfa,0xfa,0x2d,0x85,0x0d,0x85,
	0x8b,0xe3,0xc3,0x8a,0x2d,0x85,0x0d,0x85,0x77,0xf7,0xef,0xfe,0x0d,0x85,0xec,0x7c,0x00,0x00,0x08,0x2a,
	0x0c,0x85,0xec,0x7c,0xfc,0xf3,0x5c,0x7c,0x0d,0x85,0x0c,0x7d,0xaf,0xaf,0xbb,0xaf,0x2d,0x85,0x0c,0x85,
	0x83,0xe2,0x88,0x20,0x2d,0x85,0x0d,0x85,0xba,0x8b,0x2e,0x2e,0x2c,0x85,0x0d,0x85,0xef,0xfe,0xfe,0xaa,
	0x0d,0x85,0x2d,0x7d,0x02,0x0a,0x82,0x0a,0x0c,0x85,0xec,0x84,0x02,0x00,0x0a,0xe2,0x2c,0x85,0x0d,0x85,
	0x69,0xfe,0x62,0xeb,0x2d,0x85,0x0d,0x85,0xcf,0x05,0x15,0xdd,0x2d,0x85,0x0d,0x85,0xfa,0xf2,0xfa,0xd2,
	0xac,0x4a,0xa4,0x10,0x78,0xf8,0xd7,0xd5,0x6f,0x63,0x05,0x19,0xb5,0xbd,0xaf,0x2b,0xb7,0xad,0xed,0x52,
	0xb5,0xbd,0x2f,0x0b,0xd7,0xad,0x72,0x84,0xea,0x62,0x70,0xf0,0x72,0x84,0xcc,0x4a,0x7e,0x5f,0xfa,0xa0,
	0x11,0x74,0xcc,0x4a,0xb5,0x2d,0x0f,0x0a,0x4f,0x63,0x83,0x08,0x5c,0x5c,0x5c,0x5c,0xc4,0x10,0x83,0x08,
	0x0b,0x3e,0xe5,0xd5,0x05,0x11,0xa4,0x10,0x2e,0xab,0xaf,0xfd,0x26,0x19,0xe5,0x10,0x2b,0x3b,0xbd,0xbd,
	0x47,0x21,0x06,0x19,0x2a,0x2f,0xef,0xaf,0x67,0x21,0x47,0x19,0x27,0xad,0x95,0xa5,0x88,0x21,0x68,0x21,
	0xad,0x25,0xa5,0x15,0xa9,0x29,0x88,0x21,0x2b,0x29,0xa9,0x29,0xc9,0x29,0xa9,0x29,0xa9,0xa9,0xa9,0x85,
	0xea,0x31,0xc9,0x29,0xa9,0x06,0x3b,0x89,0xed,0x52,0x63,0x08,0xb5,0x3d,0x2b,0x0a,0x14,0x95,0x8c,0x4a,
	0xbd,0x2f,0x2f,0x0b,0xd7,0xb5,0xd4,0x8c,0x2d,0x0b,0x8a,0xff,0xd7,0xad,0x72,0x84,0xe8,0xb0,0xea,0x5f,
	0xf4,0x94,0x4b,0x42,0xa0,0x80,0x80,0x7a,0xd0,0x6b,0x41,0x00,0x00,0x00,0x7e,0x55,0x2e,0x5b,0x42,0x08,
	0x58,0x5c,0x57,0x55,0x83,0x08,0x42,0x08,0x0a,0x2f,0xbd,0xd5,0xc8,0x29,0x83,0x08,0xdd,0xd5,0xf5,0x3d,
	0xac,0x4a,0xe5,0x18,0x55,0x55,0x7f,0xa0,0xea,0x31,0x26,0x19,0x55,0x55,0x55,0x5c,0x67,0x21,0x26,0x19,
	0xaf,0x3f,0xaf,0x3d,0x88,0x29,0x67,0x21,0x95,0x95,0x95,0x15,0xa9,0x29,0x88,0x21,0x25,0x27,0xa9,0x09,
	0xa9,0x31,0xc9,0x29,0xdf,0x7f,0xdf,0x5b,0x0a,0x32,0xc9,0x29,0xbf,0xaf,0xbf,0xaf,0xb3,0x84,0xed,0x52,
	0x75,0xff,0xaa,0x02,0x93,0x84,0x8f,0x63,0x2d,0xff,0xff,0x2a,0x93,0x84,0x11,0x74,0x80,0x55,0x5f,0xe2,
	0x52,0x84,0x47,0x21,0x00,0xa2,0xea,0x7e,0x12,0x74,0x21,0x00,0x78,0x5e,0x57,0x55,0x21,0x00,0x00,0x00,
	0xee,0xbf,0xf7,0xee,0x21,0x00,0x00,0x00,0x0a,0xaa,0x8b,0xbf,0xc4,0x10,0x21,0x00,0xf5,0xb5,0xb5,0x35,
	0xcd,0x52,0xe5,0x18,0x35,0x2d,0xeb,0x7b,0x2e,0x5b,0xe5,0x10,0xe8,0x5e,0x55,0x55,0xa8,0x29,0xe5,0x10,
	0xf8,0xf5,0xfd,0xf5,0x67,0x21,0x26,0x19,0xaf,0xbf,0xad,0x3f,0x88,0x29,0x67,0x21,0x35,0x25,0x2d,0x0d,
	0xc9,0x29,0x88,0x29,0xef,0xbf,0x3b,0xaf,0xea,0x31,0xc9,0x29,0xd5,0x95,0x89,0xa9,0x0a,0x32,0xea,0x31,
	0xf5,0x95,0xb5,0x2d,0x76,0xa5,0xd4,0x8c,0x6d,0xc2,0xe2,0x5d,0x76,0xa5,0x73,0x84,0x55,0xd5,0xab,0x02,
	0x55,0x9d,0xd0,0x73,0x7a,0x7a,0x78,0xe0,0xf1,0x73,0x42,0x08,0x5e,0x5e,0x7a,0xe8,0x62,0x08,0x00,0x00,
	0x77,0x3d,0xb7,0x7f,0x62,0x08,0x00,0x00,0x50,0xdc,0x77,0x57,0x21,0x00,0x00,0x00,0xef,0xb7,0xef,0xbb,
	0x4b,0x42,0x42,0x00,0xb5,0xa5,0x35,0x2d,0x8f,0x6b,0xc4,0x10,0x7a,0x7a,0x62,0xe2,0xe5,0x18,0xa4,0x10,
	0x35,0xf5,0x35,0x35,0x47,0x21,0xe5,0x10,0xad,0xbf,0xad,0x2f,0x88,0x21,0x47,0x21,0x95,0xf5,0xbd,0x3d,
	0xc9,0x31,0x67,0x21,0xbd,0xaf,0xbf,0x2a,0xe9,0x31,0xa8,0x29,0xbd,0x3f,0x0e,0x82,0x2b,0x3a,0xea,0x31,
	0x55,0xd5,0xf5,0xab,0x2b,0x3a,0xea,0x31,0xbf,0x2b,0x2a,0x08,0x76,0xa5,0xf1,0x73,0xbf,0xbd,0x25,0x2d,
	0x18,0xb6,0x55,0x9d,0xa9,0x03,0x02,0x02,0xf8,0xb5,0xf4,0x94,0x7e,0x78,0xe8,0xa0,0xf4,0x94,0xe9,0x31,
	0x7a,0xe8,0xe0,0xa0,0xf1,0x73,0x83,0x08,0x55,0x5f,0xea,0x80,0x47,0x29,0x00,0x00,0x55,0x55,0x77,0x7c,
	0x21,0x00,0x00,0x00,0x3b,0xbb,0xae,0x2a,0x0a,0x3a,0x21,0x00,0x2f,0xf5,0x55,0x55,0x8c,0x4a,0x83,0x08,
	0x60,0x5f,0x55,0x55,0xa8,0x29,0xa4,0x10,0xf5,0xf5,0x8d,0xc3,0x67,0x21,0x05,0x19,0xbd,0xbd,0x2f,0x39,
	0xc9,0x31,0x67,0x21,0xf5,0xbd,0x3d,0x0b,0x2a,0x3a,0xa8,0x29,0xf5,0xbf,0xab,0x0a,0x6c,0x42,0xe9,0x31,
	0xf5,0xff,0xab,0x0a,0x8c,0x42,0x0a,0x3a,0xf5,0xff,0xae,0x22,0x8c,0x42,0x2b,0x3a,0xdd,0xff,0xae,0x22,
	0x56,0xa5,0x32,0x7c,0x2d,0x2d,0x2d,0x2d,0x38,0xb6,0x76,0xa5,0x2b,0x8b,0xbf,0x55,0x38,0xbe,0x96,0xa5,
	0xea,0xc2,0xeb,0xad,0xd7,0xad,0x72,0x84,0x5e,0xfe,0x2a,0x00,0xf7,0xb5,0x11,0x74,0x7f,0x6a,0xe2,0xe0,
	0x93,0x84,0xa4,0x10,0x5e,0xfa,0x88,0x80,0x05,0x19,0x21,0x00,0x55,0x56,0x54,0x56,0x62,0x08,0x21,0x00,
	0xb7,0x2d,0xab,0x2b,0xc4,0x10,0x63,0x08,0xb5,0x3d,0xad,0x2f,0x87,0x29,0xe5,0x10,0xf3,0xf5,0xf5,0xf5,
	0xc9,0x31,0x06,0x19,0xbd,0xaf,0x2b,0x2b,0x8c,0x4a,0xa8,0x29,0xf5,0xfd,0xaf,0x2f,0x2e,0x5b,0x0a,0x3a,
	0xf5,0xff,0xaf,0x0a,0x4f,0x63,0x8b,0x42,0x55,0xfd,0xaa,0x00,0x4f,0x63,0x8c,0x42,0xd5,0xff,0xea,0x80,
	0x0e,0x5b,0x8c,0x42,0x55,0xff,0xea,0xa0,0xf4,0x94,0xd0,0x73,0x0b,0xab,0xbd,0xb5,0x55,0xa5,0x92,0x84,
	0x2a,0x3d,0x2d,0x2d,0x18,0xb6,0x76,0xa5,0xa9,0x09,0x2d,0x0b,0x59,0xbe,0xf7,0xb5,0xad,0x8b,0xc2,0xfa,
	0x59,0xbe,0x76,0xa5,0x7e,0xfe,0xaa,0x2a,0x38,0xbe,0xcd,0x52,0x62,0x68,0x60,0xe0,0x26,0x21,0x21,0x00,
	0x57,0x55,0x77,0xd4,0x83,0x08,0x42,0x08,0xb5,0xad,0x2f,0x2d,0xe5,0x18,0x83,0x08,0xbd,0xbd,0x2d,0xaf,
	0x67,0x29,0xe4,0x10,0xbd,0x2d,0x2f,0x2d,0x6b,0x42,0x67,0x29,0xbd,0xbd,0xaf,0x2f,0xd0,0x73,0x4a,0x3a,
	0xf5,0xb5,0xad,0x2b,0xd6,0xb5,0x2e,0x5b,0xd5,0xfd,0xaf,0x0b,0x18,0xbe,0xb0,0x6b,0x55,0xff,0xea,0x80,
	0xf4,0x94,0x6f,0x63,0x5d,0x7f,0xfa,0xe0,0xd0,0x6b,0xee,0x52,0x5f,0xfe,0xfa,0xe8,0x93,0x84,0xed,0x52,
	0x2b,0x2f,0x2f,0xb5,0x55,0x9d,0x72,0x84,0x2f,0x2b,0x2f,0x2d,0x79,0xc6,0x96,0xa5,0xad,0xad,0x2d,0x29,
	0x79,0xc6,0xd7,0xad,0xfa,0xe8,0xe8,0x78,0x39,0xbe,0x72,0x84,0x00,0x00,0xa0,0x7a,0xf7,0xad,0x4e,0x63,
	0xe0,0x68,0x7a,0xfb,0x11,0x74,0x83,0x08,0x57,0x57,0xaa,0x00,0xc8,0x31,0x63,0x08,0x55,0x55,0x57,0x54,
	0xe5,0x18,0x83,0x08,0x2f,0x2d,0x2f,0x2d,0x88,0x29,0x05,0x19,0x2d,0x3d,0x2d,0x2d,0xac,0x4a,0xe9,0x31,
	0xb5,0x35,0x35,0x35,0xf4,0x94,0xed,0x52,0xb5,0x2d,0x2d,0x2d,0xdd,0xf7,0x35,0x9d,0x2d,0x0b,0x03,0x03,
	0xfd,0xf7,0x79,0xc6,0x78,0xc0,0x00,0x80,0x79,0xc6,0x52,0x84,0x5e,0x7c,0x78,0x78,0x11,0x7c,0x4e,0x5b,
	0x7a,0x78,0x78,0xf8,0x72,0x84,0xc9,0x31,0xad,0xbd,0x2f,0x0b,0xb7,0xad,0x52,0x7c,0xb5,0xbd,0x2d,0x0a,
	0x79,0xc6,0xd7,0xad,0x0d,0x09,0xab,0xff,0x59,0xbe,0x56,0x9d,0x78,0x7c,0xaa,0x0a,0xf8,0xb5,0x52,0x7c,
	0x5f,0x5e,0xf8,0xf8,0xd3,0x94,0x52,0x7c,0xbd,0x3a,0x3e,0xa8,0x76,0xa5,0x93,0x8c,0x43,0x42,0x43,0x83,
	0x56,0x9d,0xe5,0x18,0x57,0x57,0xaa,0x00,0x93,0x84,0xc4,0x10,0x55,0x5f,0x5a,0x70,0x87,0x29,0xe5,0x10,
	0x2d,0x2f,0xad,0x3d,0x8b,0x4a,0x88,0x29,0x2f,0x2d,0xaf,0xbd,0xb3,0x8c,0xcc,0x52,0x2d,0x2d,0xbd,0xf5,
	0x9c,0xef,0x52,0x84,0x02,0x0b,0xbd,0xf5,0xfd,0xf7,0x76,0xa5,0x80,0xa0,0x7e,0x55,0xf7,0xb5,0x11,0x7c,
	0xf0,0x78,0x5e,0x57,0x11,0x74,0x0e,0x5b,0xe8,0xf8,0x7e,0x7e,0xd3,0x8c,0x6e,0x63,0x2f,0x2a,0xaf,0xd5,
	0xb7,0xad,0x52,0x7c,0x0a,0xaa,0xef,0x55,0xf7,0xb5,0xd3,0x8c,0x00,0x2b,0xaf,0xad,0x79,0xc6,0xd7,0xad,
	0x0b,0xa9,0xad,0xfd,0x18,0xb6,0xf4,0x94,0x58,0x7c,0xfa,0xea,0xf8,0xb5,0x93,0x84,0xd7,0x9f,0xaf,0x0a,
	0xf7,0xb5,0x15,0x9d,0xad,0x0a,0x00,0x00,0xf8,0xb5,0x8f,0x63,0x00,0xc0,0xe0,0x7a,0xb4,0x8c,0xe5,0x18,
	0x78,0x7e,0x5e,0x5e,0x46,0x21,0xa3,0x10,0x2b,0x2f,0xaf,0xbd,0x2a,0x3a,0x46,0x21,0x2f,0xad,0xbd,0xb5,
	0x2e,0x5b,0xe9,0x31,0x2b,0xaf,0xbd,0xf5,0x31,0x7c,0xac,0x4a,0x0a,0xaf,0xfd,0x55,0x72,0x84,0xed,0x52,
	0x00,0xaa,0xff,0x55,0x32,0x7c,0xed,0x52,0xa8,0xfa,0x7f,0x55,0x6f,0x63,0xcd,0x4a,0xe8,0x7a,0x5f,0x55,
	0x0d,0x5b,0x67,0x21,0x0a,0xbf,0xbd,0x75,0xd0,0x73,0xc8,0x31,0x0a,0x2a,0xbf,0x95,0x55,0xa5,0xd0,0x73,
	0x0b,0x0b,0x2d,0x2d,0xf7,0xb5,0x51,0x7c,0x02,0xa2,0xea,0x5f,0x76,0xa5,0x11,0x7c,0x00,0x28,0x2f,0xad,
	0x17,0xb6,0x55,0x9d,0x2b,0x2f,0x2d,0xad,0x18,0xb6,0x96,0xa5,0xc8,0xea,0x4a,0xff,0xf7,0xb5,0xd0,0x73,
	0x5e,0xbe,0x22,0x00,0xd3,0x8c,0x83,0x08,0x7a,0x78,0xe0,0xe0,0x26,0x21,0x83,0x10,0xad,0xad,0xbd,0xa8,
	0x88,0x29,0x05,0x19,0x0f,0x2d,0xbd,0x95,0x2a,0x3a,0x67,0x21,0x2b,0xaf,0xbd,0xfd,0x8c,0x4a,0xe9,0x31,
	0x0a,0xbf,0xb5,0xd5,0xcd,0x52,0x2a,0x3a,0x02,0xbb,0xfd,0x55,0xcd,0x52,0x4b,0x3a,0x80,0xae,0xff,0x55,
	0xad,0x4a,0x4b,0x3a,0x80,0xaa,0xff,0xdd,0x67,0x21,0xc4,0x10,0xa0,0x7a,0xdd,0xbd,0x11,0x74,0xc4,0x10,
	0xb5,0xb5,0xad,0x2b,0x79,0xc6,0x6f,0x63,0xbd,0xad,0x2b,0x0a,0x18,0xb6,0xaf,0x6b,0x5f,0x5e,0x58,0x58,
	0xb6,0xad,0xf0,0x73,0xbd,0xad,0x2d,0x0b,0xd7,0xb5,0x34,0x95,0x0b,0xa2,0xf8,0x5a,0xb6,0xad,0xd3,0x8c,
	0x00,0xa8,0xeb,0x7f,0x96,0xa5,0x87,0x29,0x00,0x80,0xe8,0x7e,0x93,0x8c,0xa8,0x31,0xf8,0xf6,0xbd,0x29,
	0x0d,0x53,0xe5,0x18,0x7a,0x70,0x60,0x60,0x47,0x21,0xc4,0x10,0x2f,0x2f,0xad,0xbf,0xa8,0x29,0x47,0x21,
	0x2f,0xbd,0xf5,0x55,0xe9,0x31,0x88,0x21,0x0b,0xaf,0x9d,0xf5,0x0a,0x3a,0xc9,0x31,0x02,0x2f,0xbd,0xd5,
	0x2b,0x3a,0xea,0x31,0x08,0x8b,0xbf,0xd5,0x4b,0x3a,0x0a,0x32,0x0a,0xbb,0xf7,0xd5,0x2e,0x5b,0xe5,0x18,
	0xf5,0xb5,0x2d,0x2d,0x95,0xa5,0x8c,0x4a,0xbd,0xad,0x2b,0x2b,0xba,0xce,0x76,0xa5,0x29,0x09,0x2b,0x2b,
	0x79,0xc6,0x32,0x7c,0x58,0xf8,0xa8,0xa0,0x75,0xa5,0xf0,0x73,0x02,0x80,0xe0,0x78,0x35,0x9d,0xf0,0x73,
	0x80,0xba,0xff,0xf5,0xf4,0x94,0xd0,0x73,0xc0,0xea,0xea,0x7f,0x4e,0x63,0x83,0x08,0x70,0xf8,0x78,0x78,
	0xd0,0x6b,0x26,0x21,0x0b,0x09,0x09,0x09,0x93,0x8c,0x4b,0x42,0x5f,0xff,0x0a,0x02,0xd0,0x6b,0x26,0x19,
	0x55,0x56,0x5c,0x5c,0x67,0x21,0x06,0x19,0x2b,0xaf,0xaf,0xbd,0xa8,0x29,0x47,0x21,0x2b,0xbf,0x9f,0xbd,
	0xc9,0x31,0x88,0x21,0x2b,0xef,0xbf,0xbd,0xe9,0x31,0xa9,0x29,0x02,0x8f,0xbb,0xff,0x0a,0x32,0xc9,0x31,
	0x08,0x32,0xab,0x2d,0xf0,0x73,0x47,0x21,0x2d,0x0f,0x2f,0x2b,0x96,0xa5,0x72,0x84,0x2d,0x29,0x2d,0x2d,
	0x79,0xc6,0xd7,0xad,0x0d,0xad,0xad,0xad,0x58,0xbe,0x31,0x7c,0xa0,0xa0,0x68,0x78,0xf4,0x94,0x11,0x7c,
	0x5c,0xf6,0xd7,0xff,0xb3,0x8c,0x11,0x7c,0xff,0xea,0x0a,0x4a,0x11,0x74,0x00,0x00,0x80,0xe0,0x78,0x5e,
	0x0a,0x42,0x41,0x00,0x58,0x57,0x55,0x55,0x4e,0x5b,0x63,0x08,0x03,0xeb,0x57,0x55,0x6f,0x63,0xc4,0x10,
	0x80,0x7f,0x55,0x55,0x88,0x29,0xe5,0x10,0xdc,0xf5,0xd5,0x75,0x47,0x21,0x06,0x19,0x2f,0xbb,0xaf,0x3f,
	0x67,0x21,0x47,0x21,0x29,0x85,0x25,0xa5,0xa8,0x29,0x67,0x21,0x2b,0xaf,0xaf,0xbf,0xc9,0x29,0xa9,0x29,
	0xa9,0xa5,0xa5,0xd5,0xea,0x31,0xc9,0x29,0xa9,0x2b,0x95,0x65,0xaf,0x6b,0xc8,0x31,0x2d,0x2d,0x2d,0x2d,
	0xb6,0xad,0x72,0x84,0x2d,0x2d,0x2d,0x29,0x79,0xc6,0xd7,0xad,0x2d,0xa9,0xaf,0xa9,0x18,0xb6,0x72,0x84,
	0x78,0xf8,0xe0,0xa8,0x55,0x9d,0x72,0x84,0x55,0xdf,0xea,0xe8,0x93,0x8c,0xa3,0x08,0x80,0xe0,0x60,0x5a,
	0x46,0x21,0x21,0x00,0x54,0x57,0x55,0xd5,0x83,0x08,0x22,0x00,0xfd,0xbf,0xaf,0x0a,0xc4,0x10,0x63,0x08,
	0xf5,0xbd,0xab,0x2b,0xe5,0x10,0xa4,0x10,0xbd,0x2b,0x3b,0x0a,0x26,0x19,0xe5,0x10,0xbd,0xed,0x2f,0x3b,
	0x47,0x21,0x26,0x19,0xb5,0x15,0xb5,0xa5,0x67,0x21,0x47,0x21,0x25,0xa5,0x25,0xa9,0x88,0x29,0x68,0x21,
	0x8b,0x29,0x2b,0x8d,0xc9,0x29,0x88,0x29,0xef,0x3f,0xaf,0xbf,0xca,0x31,0xa9,0x29,0x0e,0x03,0x0e,0x0e,
	0x10,0x7c,0xc9,0x31,0xad,0x2f,0x2b,0x2a,0x96,0xa5,0x72,0x84,0x09,0x09,0x2f,0x29,0x17,0xb6,0x96,0xad,
	0x0b,0xab,0xfd,0xaf,0x17,0xbe,0x96,0xa5,0x7e,0x5f,0xff,0x82,0x75,0xa5,0xed,0x52,0xa0,0xe0,0xe8,0x78,
	0x2e,0x5b,0x83,0x08,0x58,0x78,0x7a,0xea,0x83,0x08,0x22,0x00,0xbd,0xab,0x0a,0x02,0xc4,0x10,0x63,0x08,
	0xfd,0xbf,0xab,0x0a,0xe5,0x10,0xa4,0x10,0xbd,0xad,0x2f,0x2a,0x06,0x19,0xc5,0x10,0xaf,0x3b,0x0a,0x0a,
	0x26,0x19,0x06,0x19,0xa5,0x29,0x2b,0x2a,0x47,0x21,0x26,0x19,0x25,0x2b,0x2d,0x0b,0x67,0x21,0x47,0x21,
	0x29,0x2a,0x2a,0x0e,0x68,0x29,0x88,0x21,0x7f,0xdc,0x7f,0x7f,0xc9,0x29,0x88,0x21,0xef,0xaf,0xef,0x3b,
	0xea,0x31,0xa9,0x29,0xef,0xaf,0xef,0xaf,0x0d,0x85,0xec,0x7c,0x8b,0xeb,0xff,0xff,0x0d,0x85,0xec,0x7c,
	0x35,0x27,0xbf,0x25,0x2c,0x8d,0x0d,0x85,0x29,0x26,0xa9,0x89,0x2d,0x85,0x0d,0x85,0x78,0xf8,0xa0,0xe0,
	0x2d,0x85,0xec,0x84,0xbf,0xfe,0xda,0xdc,0x2d,0x85,0x0d,0x85,0x2a,0x21,0x09,0x0b,0x2d,0x85,0x0d,0x85,
	0xd8,0x78,0x60,0x40,0x2c,0x85,0x0d,0x85,0xfb,0x5f,0x5d,0x5f,0x2c,0x85,0x0d,0x85,0x9e,0xdf,0x9f,0xd7,
	0x2d,0x85,0x0d,0x85,0x5c,0xfc,0x8a,0x82,0x2d,0x85,0x0d,0x85,0xff,0xdf,0xf7,0xf5,0x2d,0x85,0x0d,0x85,
	0xaf,0x2d,0xaf,0xb5,0x2d,0x85,0xec,0x7c,0xfa,0xee,0x7a,0x78,0x0d,0x85,0xec,0x7c,0xab,0x2f,0xab,0x09,
	0x2d,0x85,0x0d,0x85,0xfd,0xfd,0xd5,0xf5,0x2d,0x85,0x0d,0x85,0xff,0xdf,0xff,0xf7,0x0d,0x85,0xcc,0x7c,
	0xaf,0x8f,0x2f,0x2b,0x0d,0x85,0xec,0x7c,0x29,0x2e,0x22,0x22,0x2c,0x85,0x0d,0x85,0xeb,0xe2,0x5a,0x5d,
	0x2d,0x85,0x0d,0x85,0x70,0x5e,0x5d,0x55,0x2c,0x85,0xed,0x7c,0xff,0xaf,0xab,0x8e,0x2d,0x85,0x0d,0x85,
	0x0b,0x0b,0xc3,0x8a,0x2d,0x85,0x0c,0x85,0xf8,0xb2,0xaa,0xfb,0x0d,0x85,0xec,0x7c,0xa0,0x80,0x28,0x08,
	0x2d,0x85,0x0d,0x85,0xff,0xdd,0xdf,0x7b,0x2d,0x85,0x0d,0x85,0x6b,0xfb,0xff,0xf5,0x2d,0x85,0x0d,0x85,
	0xbf,0xbf,0xa7,0xbf,0x2d,0x85,0x0d,0x85,0xb5,0xb7,0xbe,0x5e,0x2d,0x85,0xec,0x7c,0x7a,0x5a,0xfa,0xfe,
	0x0d,0x85,0xec,0x7c,0x09,0x22,0x02,0x02,0x0d,0x85,0x2d,0x7d,0x80,0x88,0x08,0x0a,0x0d,0x85,0x0c,0x7d,
	0x08,0xa8,0xaa,0x22,0x0d,0x85,0xec,0x7c,0xe9,0x42,0xe2,0x8b,0x0c,0x85,0xec,0x7c,0xe2,0xaf,0x2f,0x96,
	0x0d,0x85,0xcb,0x7c,0xa2,0xa8,0xba,0xda,0x0d,0x85,0xec,0x7c,0x02,0x02,0x2a,0x2e,0x2d,0x85,0x0d,0x85,
	0xb5,0xbd,0xef,0x7f,0x2d,0x8d,0x0c,0x7d,0xff,0xff,0x57,0xdd,0x2c,0x85,0x0d,0x85,0xea,0xfb,0x7f,0xfe,
	0x2c,0x85,0x0d,0x85,0xd5,0xd5,0x72,0x7b,0x2d,0x85,0x0d,0x85,0x7b,0x7f,0x5f,0xf5,0x2d,0x85,0x0d,0x85,
	0xf5,0xbd,0xff,0xd7,0x2c,0x85,0x0d,0x85,0xbf,0xaf,0xaf,0xbe,0x2d,0x85,0x0d,0x85,0x7e,0x7e,0xfe,0xde,
	0x2d,0x85,0x0d,0x85,0x7f,0xfd,0x75,0xdf,0x0d,0x85,0x2d,0x7d,0x80,0x28,0x22,0x0a,0x0d,0x85,0x0c,0x7d,
	0xa8,0x2a,0xaa,0x82,0x2d,0x85,0x0d,0x85,0xf5,0xfd,0x75,0xf7,0x0d,0x85,0xcc,0x7c,0x8b,0xef,0x2d,0xaf,
	0xec,0x84,0x0c,0x7d,0x8a,0x0b,0x8a,0xaa,0x0d,0x85,0xec,0x7c,0xdf,0xeb,0xea,0xe2,0x0d,0x85,0xec,0x7c,
	0xcd,0x0d,0xcd,0x4f,0x0d,0x85,0xec,0x7c,0xa0,0xc2,0xba,0xeb,0x2d,0x85,0x0d,0x85,0x55,0x55,0xc9,0xad,
	0x2d,0x85,0x0d,0x85,0xef,0xde,0xfe,0xe7,0x2d,0x85,0x0d,0x85,0x6b,0x4b,0xeb,0xfe,0x2d,0x85,0x0d,0x85,
	0x7d,0xfd,0x77,0xff,0x2c,0x85,0x0d,0x85,0xbf,0xff,0xf7,0xb7,0x2d,0x85,0x0d,0x85,0xab,0x8b,0x8a,0x82,
	0x2c,0x85,0x0d,0x85,0xdf,0xff,0xb7,0xab,0x2d,0x85,0xec,0x7c,0xaa,0xaa,0xec,0xf6,0x0d,0x85,0xec,0x7c,
	0x80,0x20,0xa0,0xe2,0x0d,0x85,0x2d,0x7d,0x08,0x00,0xa0,0xa0,0x2c,0x85,0x0d,0x85,0xff,0xdf,0xdf,0xab,
	0x0c,0x85,0xec,0x7c,0x2e,0xbe,0xfa,0x75,0x0d,0x85,0xec,0x7c,0xab,0x8b,0xaa,0x22,0x0d,0x85,0xec,0x84,
	0xc3,0xcc,0x40,0x7c,0x0c,0x85,0xec,0x7c,0x6a,0xf2,0xb9,0xa9,0x0d,0x85,0xec,0x7c,0xbf,0xb5,0xa6,0x2f,
	0x2d,0x85,0x0d,0x85,0x8f,0x29,0xbb,0xdb,0x2d,0x85,0x0d,0x85,0xff,0x54,0x9d,0xff,0x2c,0x85,0x0d,0x85,
	0x96,0xbd,0xff,0xef,0x2d,0x85,0x0c,0x85,0xea,0xf2,0xfa,0x52,0x2c,0x85,0x0d,0x85,0xbd,0xbd,0x2d,0x2d,
	0x2d,0x85,0x0c,0x85,0xaa,0xb0,0x94,0x14,0x2d,0x85,0x0c,0x85,0xaa,0xe2,0x48,0x60,0xed,0x84,0x0d,0x7d,
	0xfd,0xe7,0x7f,0xb7,0x0c,0x85,0xed,0x7c,0xaa,0x02,0x0a,0x02,0x2d,0x85,0x0d,0x85,0x7f,0x5f,0xd5,0xf5,
	0x2d,0x85,0x0d,0x85,0xab,0x0b,0x22,0xfd,0xec,0x84,0x0c,0x7d,0xa0,0xaa,0xba,0xec,0x0c,0x85,0xec,0x7c,
	0xba,0xa2,0x2a,0xb2,0x0d,0x85,0xec,0x7c,0x78,0xea,0x02,0x00,0x0d,0x85,0xec,0x7c,0xbb,0xb2,0x22,0x82,
	0x0d,0x85,0xed,0x7c,0x2a,0x02,0x0a,0x82,0x0d,0x85,0x0c,0x85,0x82,0x00,0x00,0x88,0x2c,0x85,0x0d,0x85,
	0xff,0xfb,0x7e,0x9a,0x2d,0x85,0x0d,0x85,0xab,0x0b,0x2b,0x2f,0x2d,0x85,0x0d,0x85,0x5c,0x5c,0x53,0x14,
	0x2d,0x85,0x0d,0x85,0x0b,0x0f,0x0b,0x82,0x2d,0x85,0xec,0x84,0xba,0xbe,0xfc,0xfe,0x2d,0x85,0x0c,0x85,
	0xea,0xa3,0xfb,0xef,0x0d,0x85,0xec,0x7c,0x58,0x48,0xe0,0xa0,0x2c,0x85,0x0d,0x85,0x55,0x75,0x79,0x7b,
	0x0d,0x85,0xed,0x7c,0x00,0xbc,0x2a,0x22,0x2d,0x85,0x0d,0x85,0xbd,0x0f,0x2a,0x8b,0x0d,0x85,0xab,0x7c,
	0x0a,0xaa,0xfa,0x9a,0x0d,0x85,0xec,0x7c,0xaa,0x0b,0x0b,0x8a,0x0d,0x85,0xec,0x7c,0x20,0x20,0xe0,0xaa,
	0x0d,0x85,0x0c,0x7d,0x2a,0x2a,0x8a,0x02,0x0d,0x85,0x2d,0x7d,0x28,0x80,0x82,0x20,0x2d,0x85,0x0d,0x85,
	0xbd,0xdf,0xdf,0xad,0x2d,0x85,0x0d,0x85,0xba,0xa2,0xca,0xa2,0x2d,0x85,0x0d,0x85,0xee,0xeb,0x2f,0x8a,
	0x2d,0x85,0x0c,0x85,0xae,0x3a,0x1e,0xb2,0x2d,0x85,0x0d,0x85,0x50,0x54,0x5c,0x54,0x0d,0x85,0x0c,0x7d,
	0xbb,0xae,0xeb,0xab,0xee,0x8c,0x0c,0x7d,0xd5,0x7f,0x5d,0x77,0xed,0x8c,0x0c,0x7d,0x77,0xf7,0x5d,0x77,
	0x2d,0x85,0x0d,0x85,0x7b,0x7f,0x6a,0xef,0x0d,0x85,0xed,0x7c,0x8a,0x22,0x0a,0xa0,0x2c,0x85,0x0d,0x85,
	0xa5,0x2d,0xab,0x87,0x0d,0x85,0xec,0x7c,0xdf,0xad,0x29,0xfd,0x0d,0x85,0x0c,0x7d,0x8a,0x0a,0x0a,0x2a,
	0x0c,0x85,0x2d,0x75,0x82,0x28,0x82,0x2a,0x2d,0x85,0xec,0x7c,0xaa,0xaf,0xfe,0xfe,0xed,0x84,0x2c,0x7d,
	0xfe,0xce,0xef,0xfa,0x2d,0x85,0x0d,0x85,0xbb,0xfb,0xff,0xeb,0x2d,0x85,0x0c,0x85,0xaa,0xb2,0xbb,0xbf,
	0x2d,0x85,0x0d,0x85,0xa2,0x82,0xa2,0x8a,0x2e,0x85,0x0d,0x85,0xfa,0x7e,0x7e,0x7f,0x2d,0x85,0x0d,0x85,
	0x55,0xdd,0x75,0xd7,0x0d,0x85,0xec,0x7c,0x08,0x08,0x08,0xa0,0x2d,0x85,0x0d,0x85,0xbd,0xbf,0xf7,0xff,
	0x2e,0x85,0x0d,0x85,0xa5,0xb5,0x85,0xed,0x2d,0x85,0x0d,0x85,0xf7,0xf5,0xf5,0xd5,0x2c,0x85,0x0d,0x85,
	0x7f,0xef,0xeb,0xaa,0x2d,0x85,0x0d,0x85,0xb5,0xf5,0xbd,0xbf,0xec,0x7c,0xcc,0x7c,0x2d,0x1f,0x97,0x57,
	0x0d,0x85,0xec,0x7c,0x2a,0x0b,0x02,0x03,0x0d,0x85,0xed,0x7c,0x00,0x80,0x22,0x2a,0x0d,0x85,0x2d,0x7d,
	0x00,0x08,0x0a,0x08,0x0d,0x85,0xec,0x7c,0x22,0x02,0xa0,0x80,0x2c,0x85,0x0d,0x85,0xbf,0xbf,0xb7,0xb5,
	0x2d,0x85,0x0c,0x85,0xbe,0xea,0x02,0x28,0x2d,0x85,0x0c,0x85,0xaa,0x02,0x80,0x2a,0x2c,0x85,0x0d,0x85,
	0xff,0x5f,0xf6,0xfe,0xed,0x84,0x2c,0x7d,0xfb,0xfe,0xaa,0xbb,0x0d,0x85,0xed,0x7c,0xa8,0x88,0x28,0x80,
	0x0d,0x85,0x2d,0x7d,0x28,0x08,0x82,0x00,0x2d,0x85,0x0d,0x85,0xf5,0xd7,0xbd,0xff,0x2d,0x85,0x0d,0x85,
	0xdf,0xdf,0xd6,0xf5,0x2d,0x85,0x0d,0x85,0xab,0xe2,0xca,0xc2,0x2c,0x85,0x0d,0x85,0xef,0xaf,0x29,0xad,
	0xec,0x7c,0xac,0x7c,0xfa,0xfa,0xb4,0xac,0x0c,0x85,0xeb,0x7c,0x0d,0xcd,0x31,0x57,0x0d,0x85,0xec,0x7c,
	0xba,0xb6,0xb5,0x2d,0x2d,0x85,0x0d,0x85,0xeb,0xe3,0x8b,0xbb,0x2d,0x85,0x0c,0x7d,0x5c,0x73,0x54,0xd7,
	0x2d,0x85,0xec,0x7c,0xab,0x62,0xf0,0xaa,0x2d,0x85,0x0d,0x85,0x2f,0x2f,0x29,0xad,0x2d,0x85,0x0c,0x85,
	0xb8,0xb2,0xbb,0xab,0x2d,0x85,0x0d,0x85,0x37,0xbe,0xae,0xbe,0x2d,0x85,0x0d,0x85,0x5f,0x5b,0xba,0xf2,
	0x0d,0x85,0xec,0x7c,0xa0,0xba,0x22,0xe8,0x0d,0x85,0xec,0x7c,0x2a,0x2a,0x0a,0x25,0x2d,0x85,0x0d,0x85,
	0xff,0xeb,0xaa,0x02,0x2c,0x85,0x0d,0x85,0xfd,0xff,0xd5,0xad,0x2d,0x85,0x0c,0x85,0xaa,0x02,0x08,0x0a,
	0x2d,0x85,0x0d,0x85,0xaf,0x8a,0xbe,0xf8,0xec,0x84,0xcc,0x7c,0x54,0xd4,0x5e,0x1f,0x0c,0x85,0xcc,0x7c,
	0xd7,0x97,0x17,0xbe,0x0d,0x85,0xec,0x7c,0x2b,0x02,0x82,0x02,0x2d,0x85,0xec,0x7c,0x0e,0x8a,0x3b,0xb9,
	0x0c,0x85,0x2d,0x75,0x82,0x22,0xa2,0x22,0x2d,0x85,0x0d,0x85,0x5b,0xfa,0x52,0xd4,0x2d,0x85,0x0d,0x85,
	0xf9,0xb7,0xa5,0xfd,0x2d,0x85,0x0d,0x85,0xa9,0x22,0x8a,0x82,0x2d,0x85,0xec,0x7c,0xaa,0xaa,0xfa,0xfa,
	0x2d,0x85,0x0c,0x7d,0xd0,0x73,0x53,0x57,0x0d,0x85,0xec,0x7c,0x6a,0x82,0x82,0x00,0x2d,0x85,0xec,0x7c,
	0xbd,0xa9,0xeb,0xaa,0x2d,0x85,0x0c,0x85,0x82,0x02,0xfb,0xfb,0x2d,0x85,0x0d,0x85,0xf5,0xf5,0xb5,0xbf,
	0x2d,0x85,0x0c,0x85,0xaa,0x22,0xfa,0x62,0x2d,0x85,0x0c,0x85,0xf8,0xa2,0xeb,0xf9,0x0c,0x7d,0xac,0x7c,
	0xbf,0xbf,0xbe,0x1e,0x0d,0x85,0xec,0x7c,0x97,0x36,0x2a,0xa0,0x0d,0x85,0xed,0x7c,0xa2,0x02,0x0a,0x02,
	0x2d,0x85,0xed,0x7c,0xee,0x26,0x33,0x8a,0x2d,0x85,0x0d,0x85,0x7e,0x7b,0x7f,0x5f,0xec,0x84,0x2d,0x7d,
	0x7b,0xbe,0xaf,0xaa,0x2d,0x85,0x0d,0x85,0x96,0xc5,0x8d,0x05,0x0d,0x8d,0x2d,0x85,0x57,0x56,0x57,0x55,
	0x2c,0x85,0xed,0x7c,0xfa,0xfa,0x7e,0xd8,0x0d,0x85,0xec,0x7c,0xae,0x0a,0x03,0x02,0x2d,0x85,0x0d,0x85,
	0xfe,0xdf,0xbe,0xfd,0x2d,0x85,0x0d,0x85,0xeb,0x8b,0xaa,0x8f,0x2d,0x85,0x0c,0x85,0xad,0x2b,0x00,0xa8,
	0x2d,0x85,0x0d,0x85,0xfe,0xfc,0x70,0x70,0x2c,0x85,0x0d,0x85,0x6b,0x7f,0x5f,0x79,0x2c,0x85,0x0d,0x85,
	0xbd,0xbf,0xa5,0x25,0x0d,0x85,0xcc,0x7c,0x97,0xbe,0x8a,0x2b,0x0d,0x85,0x0c,0x7d,0xa2,0x22,0x02,0x00,
	0x2d,0x85,0x0d,0x85,0xf5,0xff,0x5f,0x67,0x2c,0x85,0x0d,0x85,0xef,0x7f,0xee,0xfb,0x2d,0x85,0xec,0x7c,
	0xea,0x62,0xfe,0xbe,0x0d,0x85,0xed,0x84,0x33,0x0f,0x07,0xf7,0x2d,0x85,0x0d,0x85,0x2d,0x2f,0x0f,0x0f,
	0x4d,0x8d,0x0d,0x85,0x7b,0x58,0x7b,0x6e,0x2d,0x85,0xec,0x7c,0xda,0xfa,0xbe,0xab,0x2d,0x85,0x0d,0x85,
	0xb5,0xeb,0xc5,0xe5,0x2d,0x85,0x0d,0x85,0x51,0x41,0x54,0x51,0x2d,0x85,0xec,0x7c,0x8a,0x8b,0xad,0xaf,
	0x2d,0x85,0x0c,0x85,0xba,0x2f,0xbe,0x2d,0x2d,0x85,0x0c,0x85,0xe2,0xc8,0xd2,0xca,0x2c,0x85,0x0d,0x85,
	0xff,0xad,0xa7,0x2d,0x2d,0x85,0x0d,0x85,0xaf,0x8a,0xa8,0xf0,0x0d,0x85,0xec,0x7c,0x2b,0x3b,0x0a,0x22,
	0x0d,0x85,0x2d,0x7d,0x82,0xa0,0x80,0x20,0x2d,0x8d,0x0c,0x7d,0x7f,0x7f,0xd7,0xf5,0x2e,0x85,0x0d,0x85,
	0xdb,0xfd,0x7f,0x5a,0x0d,0x85,0xeb,0x74,0x28,0x2a,0x28,0xa8,0x2d,0x85,0xec,0x7c,0xff,0xff,0x2f,0xab,
	0x2d,0x85,0x0c,0x85,0xb2,0xbb,0x25,0x25,0x2d,0x85,0x0d,0x85,0x60,0xf0,0x60,0xc0,0x2d,0x85,0x0c,0x85,
	0xb7,0xe7,0xbb,0xfb,0x0d,0x85,0x0c,0x7d,0xaf,0xae,0xfe,0xfa,0x2d,0x85,0xec,0x7c,0x78,0x68,0x5c,0x96,
	0x0d,0x85,0xec,0x7c,0x2b,0x2d,0x2e,0x02,0x2d,0x85,0x0d,0x85,0xe9,0x8b,0xab,0x82,0x2c,0x85,0x0d,0x85,
	0xeb,0xf2,0xaa,0xbf,0x4c,0x8d,0x0d,0x85,0xbd,0xaf,0xaf,0xbf,0x4d,0x8d,0x0d,0x85,0x7b,0x58,0x7b,0x6e,
	0x0d,0x85,0x2d,0x7d,0x00,0x08,0x88,0x88,0x0d,0x85,0x0c,0x7d,0x00,0x02,0xa8,0x08,0x0c,0x85,0x2c,0x7d,
	0x80,0x08,0x38,0x8c,0x2e,0x8d,0x0c,0x7d,0x5b,0x77,0x75,0xd5,0x0d,0x85,0xed,0x7c,0xa8,0xbe,0x08,0x00,
	0x2d,0x85,0x0d,0x85,0x65,0x8d,0x8b,0x62,0x2d,0x85,0x0d,0x85,0xaf,0x2d,0x8d,0x0a,0x2d,0x85,0x0d,0x85,
	0xe8,0xf0,0xc8,0xe2,0xec,0x84,0x2d,0x7d,0xbf,0xaf,0xab,0xaa,0x0d,0x85,0xed,0x7c,0x02,0x02,0x0a,0x0b,
	0x0d,0x85,0xec,0x7c,0xdc,0xba,0x08,0x00,0x2c,0x85,0x0d,0x85,0xd5,0x95,0xbf,0xea,0x2d,0x85,0x0c,0x85,
	0xe2,0xc8,0xe0,0xc0,0x2c,0x85,0x0d,0x85,0xff,0x69,0xeb,0x49,0x2d,0x85,0x0c,0x7d,0x33,0x0d,0xfd,0x55,
	0x2d,0x85,0x0d,0x85,0x60,0x70,0x7a,0xed,0x0d,0x85,0x2d,0x7d,0xa0,0x08,0x00,0xa8,0x0d,0x85,0x2b,0x7d,
	0x00,0x80,0xaa,0x08,0x0d,0x85,0x2c,0x7d,0x28,0x00,0x0a,0x2a,0x0c,0x85,0xed,0x7c,0x8a,0xb2,0xfb,0xcb,
	0x2d,0x85,0x0c,0x7d,0xfd,0x35,0xfd,0x3d,0x2d,0x85,0x0d,0x85,0xe2,0x82,0x2a,0xa2,0x2d,0x85,0x0d,0x85,
	0x2a,0xa2,0x0a,0x28,0x2d,0x85,0x0d,0x85,0x2a,0xa2,0x8a,0xa0,0x0d,0x85,0xec,0x7c,0xaa,0x20,0x80,0x80,
	0x0d,0x85,0xec,0x7c,0x2e,0xae,0xbf,0x2d,0x2d,0x85,0x0d,0x85,0xfd,0xb5,0xf5,0x75,0x2d,0x85,0x0c,0x85,
	0xaa,0x23,0xaa,0x8b,0x2d,0x85,0x0c,0x85,0xa0,0x80,0xa0,0x82,0x2d,0x85,0x0c,0x7d,0xcf,0xfc,0x60,0x73,
	0x0d,0x85,0xec,0x7c,0xb7,0xa6,0x2d,0x2d,0x2d,0x85,0x0d,0x85,0x25,0x2d,0x2f,0x2d,0x2d
};

CubeTextureLoadTask::CubeTextureLoadTask(CubeTextureClass* texture)
{
	Data = texture;
}
void CubeTextureLoadTask::LoadResource()
{
	CubeTextureClass* texture = (CubeTextureClass*) Data;
	FileClass *file = Get_Data_File(texture->Name);
	if ((file) && (file->Open(1)))
	{
		char *textureData; 
		int textureData_size = file->Size();
		textureData = new char[textureData_size];
		file->Read(textureData,textureData_size);
		D3DXCreateCubeTextureFromFileInMemory(Direct3DDevice,textureData,textureData_size,&texture->D3DTexture);
		file->Close();
		Close_Data_File(file);
	}
	else
	{
		D3DXCreateCubeTextureFromFileInMemory(Direct3DDevice,defaultCubeTextureConst,12417,&texture->D3DTexture);
		texture->IsMissing = true;
	}
	texture->Initialized = true;
	texture->TextureLoadTask = 0;
}
