/*********
Runs a luminance filter on the previous source which is then used to retrieve a color from a gradient map. 
Use with ToneMapPostProccessShaderClass.
**********/
texture SceneBuffer: SceneTexture;
texture InputBuffer: InputTexture;
texture TransferTexture: TransferTexture;

sampler2D SceneBufferSampler =
sampler_state
{
    Texture = <SceneBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler2D InputBufferSampler = sampler_state
{
    Texture = <InputBuffer>;
    AddressU = Clamp;
    AddressV = Clamp;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

sampler TransferTextureSampler = sampler_state
{
    Texture = <TransferTexture>;
    MinFilter = Point;
    MagFilter = Linear;
    MipFilter = Linear;
};

static const float3 fColorWeight = { 0.2125f, 0.7154f, 0.0721f };

float4 ToneMapPS(float2 Tex : TEXCOORD0): COLOR0
{
	half4 color = tex2D(InputBufferSampler, Tex);
	half4 luminance = dot(color.rgb,fColorWeight);
	return tex1D(TransferTextureSampler, luminance);
}

technique SceneShader
{
    pass p0
    {
        PixelShader = compile ps_1_4 ToneMapPS();
    }
}