/*	Renegade Scripts.dll
	Shader State Manager
	Copyright 2007 Jonathan Wilson, Mark Sararu

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#define SM_CACHEDSAMPLERS 8

class ShaderStateManager : public ID3DXEffectStateManager {
private:
	unsigned long *RenderStates;
	unsigned long *SamplerStates[SM_CACHEDSAMPLERS];
	unsigned long *TextureStates[SM_CACHEDSAMPLERS];
	IDirect3DBaseTexture9 *Textures[SM_CACHEDSAMPLERS];
	IDirect3DSurface9* RenderTarget;
	bool *RenderStatesCached;
	bool *SamplerStatesCached[SM_CACHEDSAMPLERS];
	bool *TextureStatesCached[SM_CACHEDSAMPLERS];

	IDirect3DPixelShader9 *PixelShader;
	IDirect3DVertexShader9 *VertexShader;
	float NPatchMode;
protected:
	long ref; 
public:
	ShaderStateManager();
	~ShaderStateManager();
	void Reset();
	HRESULT __stdcall QueryInterface(const IID &iid,LPVOID *ppv);
	unsigned long __stdcall AddRef();
	unsigned long __stdcall Release();
	HRESULT __stdcall LightEnable(DWORD Index,BOOL Enable);
	HRESULT __stdcall SetFVF(DWORD FVF);
	HRESULT __stdcall SetLight(DWORD Index,CONST D3DLIGHT9* pLight);
	HRESULT __stdcall SetMaterial(CONST D3DMATERIAL9* pMaterial);
	HRESULT __stdcall SetNPatchMode(FLOAT nSegments);
	HRESULT __stdcall SetPixelShader(LPDIRECT3DPIXELSHADER9 pShader);
	HRESULT __stdcall SetPixelShaderConstantB(UINT StartRegister, CONST BOOL* pConstantData, UINT RegisterCount);
	HRESULT __stdcall SetPixelShaderConstantF(UINT StartRegister, CONST FLOAT* pConstantData, UINT RegisterCount);
	HRESULT __stdcall SetPixelShaderConstantI(UINT StartRegister, CONST INT* pConstantData, UINT RegisterCount);
	HRESULT __stdcall SetRenderState(D3DRENDERSTATETYPE State, DWORD Value);
	HRESULT __stdcall GetRenderState(D3DRENDERSTATETYPE State, DWORD* pValue);
	DWORD   __stdcall GetRenderState(D3DRENDERSTATETYPE State);
	HRESULT __stdcall SetRenderTarget(DWORD RenderTargetIndex,LPDIRECT3DSURFACE9 pRenderTarget);
	HRESULT __stdcall SetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD Value);
	HRESULT __stdcall GetSamplerState(DWORD Sampler, D3DSAMPLERSTATETYPE Type, DWORD *pValue);
	HRESULT __stdcall SetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD Value);
	HRESULT __stdcall GetTextureStageState(DWORD Stage, D3DTEXTURESTAGESTATETYPE Type, DWORD *pValue);
	HRESULT __stdcall SetTexture(DWORD Stage, LPDIRECT3DBASETEXTURE9 pTexture);
	HRESULT __stdcall SetTransform(D3DTRANSFORMSTATETYPE State, CONST D3DMATRIX* pMatrix);
	HRESULT __stdcall SetVertexShader(LPDIRECT3DVERTEXSHADER9 pShader);
	HRESULT __stdcall SetVertexShaderConstantB(UINT StartRegister,CONST BOOL* pConstantData,UINT RegisterCount);
	HRESULT __stdcall SetVertexShaderConstantF(UINT StartRegister, CONST FLOAT* pConstantData, UINT RegisterCount);
	HRESULT __stdcall SetVertexShaderConstantI(UINT StartRegister, CONST INT* pConstantData, UINT RegisterCount);
};

class ShaderStateSaver
{
protected:
	bool StateSaved;
	D3DRENDERSTATETYPE State;
	DWORD Value;
public:
	ShaderStateSaver(D3DRENDERSTATETYPE state);
	ShaderStateSaver(D3DRENDERSTATETYPE state, float MinVertexShaderVersion, float MinPixelShaderVersion);
	ShaderStateSaver(D3DRENDERSTATETYPE state, float MinShaderVersion);
	~ShaderStateSaver();
};

extern ShaderStateManager *StateManager;
