#include "stinc.h"
#include "stmisc.h"
#include "stgame.h"
#include "stgamesniper.h"

const char *gzGameSniper::m_allowChar[] = {
	"CnC_Nod_Minigunner_2SF",
	"CnC_GDI_Minigunner_2SF",
	"CnC_Nod_Minigunner_3Boss",
	"CnC_GDI_Minigunner_3Boss",
};
gzGameSniper::gzGameSniper()
{
	this->RegisterEvent(EVT_GAME_THINK);
	this->RegisterEvent(EVT_PLAYER_PURCHASE);
	this->RegisterEvent(EVT_OBJECT_DAMAGE);

	// Override the default spawn character settings
	this->m_settings->m_SpawnChar[0] = this->m_allowChar[0];
	this->m_settings->m_SpawnChar[1] = this->m_allowChar[1];
}
void gzGameSniper::Think()
{
	for (nc_GenericSLNode<nc_SmartGameObj> *smartList = nc_GameObjManager::SmartGameObjList->HeadNode; smartList != NULL; smartList = smartList->NodeNext)
	{
		if (smartList->NodeData->Player)
		{
			nc_ArmedGameObjDef *armDef = gzStatic_Cast(nc_ArmedGameObjDef, smartList->NodeData->definition);
			for (int i = 1; i < smartList->NodeData->WeaponBag->Vector.Count(); i++)
			{
				if (smartList->NodeData->WeaponBag->Vector[i]->WeaponDef->Get_ID() != (unsigned long)armDef->WeaponDefID)
				{
					smartList->NodeData->WeaponBag->Remove_Weapon(i);
					i--;
				}
			}
			smartList->NodeData->WeaponBag->Select_Next();
		}
	}
}
void gzGameSniper::Player_Purchase(gzEventPlayerPurchase &evt)
{
	switch (evt.GetInt())
	{
		case PURCHASE_SECRET_INFANTRY:
		case PURCHASE_FREE_INFANTRY:
		case PURCHASE_SECRET_VEHICLE:
		case PURCHASE_VEHICLE:
		case PURCHASE_POWERUP:
			evt.Skip();
			evt.m_retCode = 4;
			return;

		case PURCHASE_REFILL:
			return;
	}
	bool canPurchase = false;
	nc_DefinitionClass *def = nc_DefinitionMgrClass::Find_Definition(evt.m_presetId, true);
	for (int i = 0; i < (sizeof(this->m_allowChar) / 4); i++)
	{
		if (!stricmp(def->Get_Name(), this->m_allowChar[i]))
		{
			canPurchase = true;
			break;
		}
	}
	if (!canPurchase)
	{
		evt.Skip();
		evt.m_retCode = 4;
		return;
	}
	evt.m_cost = 0;
}
void gzGameSniper::Object_Damaged(gzEventObjectDamage &evt)
{
	if (evt.m_defender)
	{
		if (evt.m_defender->As_SoldierGameObj())
		{
			// Invincible spawn
			if ((GetTickCount() - SystemTime - evt.m_defender->CreationTime) / 1000 <= gzGameMgr->GetSettings()->m_InvincibleSecs)
				evt.Skip();
			return;
		}
	}
	evt.Skip();
}


/**************/
/* 500 sniper */
/**************/
void gzGame500Snip::Player_Purchase(gzEventPlayerPurchase &evt)
{
	if (evt.GetInt() == PURCHASE_REFILL)
		return;
	evt.Skip();
	evt.m_retCode = 4;
}
