#include "stinc.h"
#include "stmisc.h"
#include "sttranslate.h"

gzTranslateManager *gzTranslator = NULL;
gzTranslateManager::gzTranslateManager()
{
	this->RegisterEvent(EVT_GAME_LEVEL_LOADED);

	this->m_fileModTime = 0;
}
void gzTranslateManager::Delete()
{
	for (aListNode<gzTranslateItem>* list = this->m_list.GetHead(); list != NULL; list = list->GetNext())
		delete list->GetData();
	this->m_list.RemoveAll();

	for (aListNode<gzTranslateItem>* list = this->m_beaconWarningList.GetHead(); list != NULL; list = list->GetNext())
		delete list->GetData();
	this->m_beaconWarningList.RemoveAll();

	for (aListNode<gzTranslateItem>* list = this->m_beaconStrikeList.GetHead(); list != NULL; list = list->GetNext())
		delete list->GetData();
	this->m_beaconStrikeList.RemoveAll();
}
void gzTranslateManager::Level_Loaded()
{
	struct stat attrib;
	stat("Translate.ini", &attrib);
	if (this->m_fileModTime != attrib.st_mtime)
	{
		this->m_fileModTime = attrib.st_mtime;
		
		this->Delete();

		aTextConfig* cfg = new aTextConfig("Translate.ini");
		for (int i = 1; i <= cfg->GetSubCount("Preset"); i++)
		{
			gzTranslateItem *item = new gzTranslateItem;
			item->preset = cfg->GetItem(aString::Format("Preset.[%d]", i), "");
			item->translated = cfg->GetData(aString::Format("Preset.[%d]", i), "UnknownString");
			this->m_list.AddTail(item);
		}
		for (int i = 1; i <= cfg->GetSubCount("BeaconStrikeString"); i++)
		{
			gzTranslateItem *item = new gzTranslateItem;
			item->preset = cfg->GetItem(aString::Format("BeaconStrikeString.[%d]", i), "");
			item->translated = cfg->GetData(aString::Format("BeaconStrikeString.[%d]", i), "UnknownString");
			this->m_beaconStrikeList.AddTail(item);
		}
		for (int i = 1; i <= cfg->GetSubCount("BeaconWarningString"); i++)
		{
			gzTranslateItem *item = new gzTranslateItem;
			item->preset = cfg->GetItem(aString::Format("BeaconWarningString.[%d]", i), "");
			item->translated = cfg->GetData(aString::Format("BeaconWarningString.[%d]", i), "UnknownString");
			this->m_beaconWarningList.AddTail(item);
		}
		delete cfg;
	}
}
const char *gzTranslateManager::Get(const char *name)
{
	for (aListNode<gzTranslateItem>* list = this->m_list.GetHead(); list != NULL; list = list->GetNext())
	{
		if (list->GetData()->preset == name)
			return list->GetData()->translated.GetString();
	}

	nc_DamageableGameObjDef *def = gzStatic_Cast(nc_DamageableGameObjDef, nc_DefinitionMgrClass::Find_Named_Definition(name, true));
	if (def)
	{
		for (int i = 0; i < nc_TranslateDBClass::m_ObjectList.Count(); i++)
		{
			if (def->TranslatedNameID == nc_TranslateDBClass::m_ObjectList[i]->Get_ID())
				return nc_TranslateDBClass::m_ObjectList[i]->Get_English_String()->m_Buffer;
		}
	}
	return name;
}
const char *gzTranslateManager::Get(nc_BaseGameObj *obj)
{
	if (obj != NULL)
	{
		for (aListNode<gzTranslateItem>* list = this->m_list.GetHead(); list != NULL; list = list->GetNext())
		{
			if (list->GetData()->preset == obj->definition->Get_Name())
				return list->GetData()->translated.GetString();
		}

		if (obj->As_ScriptableGameObj() && obj->As_ScriptableGameObj()->As_DamageableGameObj())
		{
			nc_DamageableGameObjDef *def = gzStatic_Cast(nc_DamageableGameObjDef, obj->definition);
			for (int i = 0; i < nc_TranslateDBClass::m_ObjectList.Count(); i++)
			{
				if (def->TranslatedNameID == nc_TranslateDBClass::m_ObjectList[i]->Get_ID())
					return nc_TranslateDBClass::m_ObjectList[i]->Get_English_String()->m_Buffer;
			}
		}
		return obj->definition->Get_Name();
	}
	return NULL;
}
