#ifndef STSETTING_H
#define STSETTING_H

#include "fds.h"
#include "stevent.h"

class stSettingsBase;
class gzSettingsManager : public EventHandler {
public:
	const char *GetName()
	{
		return "gzSettingsManager";
	};
	gzSettingsManager();
	void Delete();
	void Level_Loaded();

	aVector<stSettingsBase *> m_list;
};
extern gzSettingsManager *gzSettingsMgr;

class stSettingsBase {
	gzSettingsEvent *m_owner;
protected:
	bool Load_Bool(const char *item, bool default, bool map = true, bool global = true)
	{
		bool ret = default;
		if (this->m_cfg != NULL)
		{
			if (global)
				ret = this->m_cfg->GetData(aString::Format("General.%s", item), ret).ToLong();
			if (map)
				ret = this->m_cfg->GetData(aString::Format("\"%s\".%s", cGame->MapName.m_Buffer, item), ret).ToLong();
		}
		return ret;
	};
	bool Load_Bool(const char *section, const char *item, bool default)
	{
		if (this->m_cfg != NULL)
			return (this->m_cfg->GetData(aString::Format("\"%s\".%s", section, item), default).ToLong() == 0) ? false : true;
		return default;
	};
	float Load_Float(const char *item, float default, bool map = true, bool global = true)
	{
		float ret = default;
		if (this->m_cfg != NULL)
		{
			if (global)
				ret = (float)this->m_cfg->GetData(aString::Format("General.%s", item), ret).ToDouble();
			if (map)
				ret = (float)this->m_cfg->GetData(aString::Format("\"%s\".%s", cGame->MapName.m_Buffer, item), ret).ToDouble();
		}
		return ret;
	};
	float Load_Float(const char *section, const char *item, float default)
	{
		if (this->m_cfg != NULL)
			return (float)this->m_cfg->GetData(aString::Format("\"%s\".%s", section, item), default).ToDouble();
		return default;
	};
	int Load_Int(const char *item, int default, bool map = true, bool global = true)
	{
		int ret = default;
		if (this->m_cfg != NULL)
		{
			if (global)
				ret = this->m_cfg->GetData(aString::Format("General.%s", item), ret).ToLong();
			if (map)
				ret = this->m_cfg->GetData(aString::Format("\"%s\".%s", cGame->MapName.m_Buffer, item), ret).ToLong();
		}
		return ret;
	};
	int Load_Int(const char *section, const char *item, int default)
	{
		if (this->m_cfg != NULL)
			return this->m_cfg->GetData(aString::Format("\"%s\".%s", section, item), default).ToLong();
		return default;
	};
	aString Load_String(const char *item, const char *default, bool map = true, bool global = true)
	{
		aString ret = default;
		if (this->m_cfg != NULL)
		{
			if (global)
				ret = this->m_cfg->GetData(aString::Format("General.%s", item), ret);
			if (map)
				ret = this->m_cfg->GetData(aString::Format("\"%s\".%s", cGame->MapName.m_Buffer, item), ret);
		}
		return ret;
	};
	aString Load_String(const char *section, const char *item, const char *default)
	{
		if (this->m_cfg != NULL)
			return this->m_cfg->GetData(aString::Format("\"%s\".%s", section, item), default);
		return default;
	}

	aTextConfig* m_cfg;
	time_t m_confModTime;
public:
	stSettingsBase()
	{
		this->m_cfg = NULL;
		this->m_confModTime = 0;
		this->m_owner = NULL;
		gzSettingsMgr->m_list.Add(this);
	};
	virtual void Delete() { };
	virtual void Load() = 0;
	void Close();
	bool Open(const aString& file);
	inline gzSettingsEvent *GetOwner() { return this->m_owner; };
	void SetOwner(gzSettingsEvent *owner) { this->m_owner = owner; };
};

#endif
