#ifndef STVEHICLE_H
#define STVEHICLE_H

#if ISDEV()
#define VOMSG
#endif

#define VO_NONE 0
#define VO_BIND 1
#define VO_LOCK 2

typedef enum {
	VORESP_ERROR = -1,
	VORESP_SUCCESS = 0,
	VORESP_NOT_IN_VEHICLE = 1,
	VORESP_NOT_DRIVER = 2,
	VORESP_NOT_OWNER = 3,
	VORESP_QUOTA_MAXXED = 4,
} VehicleOwnerRespondEnum;

class gzPlayer;

struct gzVehicleWreckageStruct {
	aString vehicle;
	aString wreckage;
};
struct gzVehicleBoneData {
	aString Vehicle;
	aStringArray Bone;
};
struct gzVehicleDestroyAnimStruct {
	aString vehicle;
	aString anim;
};
class gzSettingsVehicleClass : public stSettingsBase {
public:
	const char *GetName()
	{
		return "gzVehicleSettings";
	};
	void Delete();
	void Load();
	aVector<gzVehicleWreckageStruct *> m_wreckageList;
	aVector<gzVehicleDestroyAnimStruct *> m_destroyAnimList;
	int m_maxEnemyVehicle;
	int m_maxTeamVehicle;
	aString m_bindIcon;
	aString m_lockIcon;
	aVector<gzVehicleBoneData *> m_boneList;
	float m_kickTime;
	bool m_bindOnPurchase;
	bool m_bindWreckageToMostRepair;
};

struct gzVehicleOwnerBanData {
	gzPlayer *m_owner;
	float Counter;
};

class gzVehicleData;
class gzVehicleSellClass : public EventHandler {
	gzVehicleData *m_vehicle;
	float          m_delay;
public:
	const char *Get_Name()
	{
		return "gzVehicleSellClass";
	};
	void Delete() { };
	gzVehicleSellClass();
	void Think();
};

class gzVehicleData : public EventHandler {
	unsigned int m_vehId;
	gzPlayer     *m_owner;
	int           m_bindType;
	unsigned int  m_boneObj[2];
	gzPlayer     *m_purchaser;
	bool          m_canSetPurchaser;
	aVector<gzVehicleOwnerBanData> m_bans;
#if ISDEV()
	gzVehicleSellClass *m_sell;
#endif
public:
	const char *GetName()
	{
		return "gzVehicleData";
	};
	void Delete();
	gzVehicleData(nc_VehicleGameObj *vehicle);
	void Think();
	void Object_Damaged(gzEventObjectDamage &);
	void Object_Killed(gzEventObjectKill &);
	void Object_Transition(gzEventObjectTransition &);
	gzPlayer *GetOwner();
	void SetOwner(gzPlayer *owner);
	void SetBindType(int type);
	unsigned int GetVehicleId();
	unsigned int GetBoneObjId(unsigned int index);
	aVector<gzVehicleOwnerBanData> &GetBanList();
};

class gzVehicleOwnerClass : public EventHandler {
	gzPlayer *m_owner;
	gzPlayer *m_lastEnter;
	unsigned int m_lastEnterVehId;
	aVector<gzVehicleData *> m_boundList;
public:
	const char *GetName()
	{
		return "gzVehicleOwnerClass";
	};
	void Delete() {	};
	gzVehicleOwnerClass(gzPlayer *owner);
	void Think();
	int Set(int Type, unsigned int vehicleId = 0);
	int Unset(unsigned int vehID, int Type);
	void UnsetAll();
	void GetCount(int &team, int &enemy);
	gzPlayer *GetOwner();
	gzPlayer *GetLastEnter();
	void SetLastEnter(gzPlayer *player, unsigned int vehicle);
	aVector<gzVehicleData *> &GetBoundList();
};

class gzManagerVehicle : public EventHandler, public gzManagerEvent {
	gzSettingsVehicleClass *m_settings;
	aList<gzVehicleData> m_vehList;
public:
	const char *GetName()
	{
		return "gzManagerVehicle";
	};
	gzManagerVehicle();
	void Delete();
	void Level_Loaded();
	void Object_Created(gzEventObjectCreate &);
	void Object_Killed(gzEventObjectKill &);
	void Object_FlipKill(gzEventObjectFlipKill &);
	void ChildObjDeletion(gzBase *);
	gzVehicleData *Find(unsigned long);
	gzSettingsVehicleClass *GetSettings();
};
extern gzManagerVehicle *gzVehicleMgr;

// Observers
class gzObserverVehicle : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *);
	void Custom(nc_ScriptableGameObj *obj, int message, int param, nc_ScriptableGameObj *sender);
	void Killed(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *shooter);
	nc_VehicleGameObj* m_vehicle;
	bool               m_flipKilled;
};

class gzObserverVehicleWreckage : public nc_ScriptImpClass {
	void Created(nc_ScriptableGameObj *obj);
	void Damaged(nc_ScriptableGameObj *obj, nc_ScriptableGameObj *damager, float damage);
	float m_damage[128];
};
#endif
