#ifndef __SERIAL__
#define __SERIAL__

#define MINIMUM_HOOKS_VERSION 1.01
#define VERSION_STATE "1.0"

class NC_Base {
public:
	NC_Base();
	virtual char *Get_Name() = 0;
	virtual void Init()
	{
	}
	virtual void Think()
	{
	}
};

struct SerialDataStruct {
	bool Received;
	bool Kick;
	int Count;
	unsigned int LastSend;
};
class SerialClass : public NC_Base {
public:
	SerialClass();
	char *Get_Name()
	{
		return "SerialClass";
	};
	void Think();
	void Reset(int pID);
	SerialDataStruct SerialData[128];
};
extern SerialClass Serial;

class ConsoleIO {
public:
	static void Input(const char *msg, ...);
	static void Output(const char *msg, ...);
};
extern ConsoleIO Console;

class Init_Class {
public:
	Init_Class();
	static void Init_Hook();
};
extern Init_Class InitClass;

struct GCDSerialData {
	bool IsValid;
	char Hash[33];
};
class GCDValidationClass : public NC_Base {
	std::vector<GCDSerialData> Data;
public:
	char *Get_Name()
	{
		return "GCDValidationClass";
	}
	void Init();
	void Think();
	void Add(const char *Hash, bool IsValid);
	bool IsValid(const char *Hash);
};
extern GCDValidationClass *GCDValidation;

class GetSerialConsoleFunction : public nc_ConsoleFunctionClass {
	const char *Get_Name()
	{
		return "getserial";
	}
	const char *Get_Help()
	{
		return "GETSERIAL [player_id] - Request serial hash from player.";
	}
	void Activate(char *text)
	{
		if (!text || !*text || !isdigit(text[0]) || !nc_cPlayerManager::Find_Player(atoi(text)))
			return;
		Request_Serial(atoi(text));
	}
};
GetSerialConsoleFunction *GetSerial;

extern int Exe;
void DLL_Init();

#endif
