#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include <psapi.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <time.h>
#include "date.h"
#include "ncString.h"
#include "scripts.h"
#include "fds.h"
#include "Hooks_Base.h"
#include "Serial.h"

#pragma warning(disable: 4100 4740)

int Exe = -1;
std::vector<NC_Base *> ClassList;

extern "C" {

const unsigned char Code[19] = {0x6A,0x40,0xFF,0x74,0x24,0x0C,0xFF,0x74,0x24,0x0C,0xE8,0xC0,0xFF,0xFF,0xFF,0x83,0xC4,0x0C,0xC3};
int Get_Renegade_Version() {
	if (!memcmp((void *)0x0078C6E9,(void *)Code,19)) Exe = 1;
	return Exe;
}

BOOL __declspec(dllexport) __stdcall DllMain(HINSTANCE hinstDLL,
						DWORD	ul_reason_for_call,
						LPVOID	lpReserved
					 )
{
	return TRUE;
}

} // extern "C"

void PatchData(void *buf, unsigned long size, unsigned long addr) {
	unsigned long PID = GetCurrentProcessId();
	HANDLE PHandle = OpenProcess(PROCESS_ALL_ACCESS, false, PID);
	WriteProcessMemory(PHandle, (void *)addr, buf, size, NULL);
	CloseHandle(PHandle);
}
void PatchJump(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char jmp = 0xE9;
	PatchData(&jmp,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchCall(void *buf, unsigned long addr) {
	int patchbuf = (int)*&buf - addr -5;
	unsigned char call = 0xE8;
	PatchData(&call,1,addr);
	PatchData(&patchbuf,4,addr +1);
}
void PatchByte(unsigned char Byte, unsigned long size, unsigned long addr) {
	for (unsigned long i = 0; i < size; i++) PatchData(&Byte,1,addr +i);
}

NC_Base::NC_Base()
{
	ClassList.push_back(this);
}

SerialClass::SerialClass()
{
}
void SerialClass::Think()
{
	for (int i = 1; i <= 127; i++)
	{
		nc_cPlayer *pData = nc_cPlayerManager::Find_Player(i);
		if (pData && !this->SerialData[i].Received)
		{
			if ((cGame->GameDuration_Seconds - this->SerialData[i].LastSend) >= 5)
			{
				if (this->SerialData[i].Kick)
				{
					nc_cNetwork::Server_Kill_Connection(i);
					nc_cNetwork::Cleanup_After_Client(i);
					this->Reset(i);
				}
				else if (this->SerialData[i].Count >= 3)
				{
					this->SerialData[i].Kick = true;
					Console.Output("Timeout for waiting serial hash from player %S\n",pData->PlayerName.m_Buffer);
				}
				else
				{
					this->SerialData[i].Count++;
					this->SerialData[i].LastSend = cGame->GameDuration_Seconds;
					Request_Serial(i);
				}
			}
		}
	}
}
void SerialClass::Reset(int pID)
{
	this->SerialData[pID].Received = false;
	this->SerialData[pID].Kick = false;
	this->SerialData[pID].Count = 0;
	this->SerialData[pID].LastSend = 0;
}
SerialClass Serial;

ConsoleIO Console;
//void ConsoleIO::Input(const char *msg, ...) {
//	if (!*msg) return;
//	char buf[256];
//	va_list args;
//	va_start(args,msg);
//	_vsnprintf(buf,255,msg,args);
//	va_end(args);
//	_asm {
//		mov eax, 0x428960
//		lea edx, buf
//		push edx
//		call eax
//	}
//}
void ConsoleIO::Output(const char *msg, ...) {
	if (!msg || !*msg)
		return;
	va_list args;
	va_start(args,msg);
	int size = _vscprintf(msg,args);
	char *tmp = new char[size +1];
	vsprintf(tmp,msg,args);
	va_end(args);
	date logdate;
	logdate.refreshdate();
	ncString renlog;
	renlog.Format("renlog_%s.txt",logdate.get_date_string());
	FILE *logFile = fopen(renlog.Get_Buffer(),"a");
	if (logFile)
	{
		time_t rawtime;
		tm *timeinfo;
		time(&rawtime);
		timeinfo = localtime(&rawtime);
		fprintf(logFile,"[%.2d:%.2d:%.2d] ",timeinfo->tm_hour,timeinfo->tm_min,timeinfo->tm_sec);
		fputs(tmp,logFile);
		fclose(logFile);
	}
	printf("%s",tmp);
	renlog.Free_String();
	delete [] tmp;
}

Init_Class::Init_Class()
{
	if (!Init_Hooks())
	{
		MessageBox(0,"Failed to load Hooks.dll. Serial.dll has been disabled.","FATAL ERROR",MB_OK);
		return;
	}
	if (Get_Hooks_Version() < MINIMUM_HOOKS_VERSION)
	{
		char msg[512];
		sprintf(msg,"Error - Serial.dll is incompatible with Hooks.dll version below 1.01. Current Hooks.dll version is %.2f, please upgrade.",Get_Hooks_Version());
		MessageBox(0,msg,"Error",MB_OK);
		return;
	}
	RegisterFDSStartUpHook(Init_Class::Init_Hook);
}
void Init_Class::Init_Hook()
{
	DLL_Init();
}
Init_Class InitClass;

void GCDValidationClass::Init()
{
	gcd_init();
}
void GCDValidationClass::Think()
{
	gcd_think();
}
void GCDValidationClass::Add(const char *Hash, bool IsValid)
{
	if (!Hash || strlen(Hash) != 32)
		return;
	if (!this->Data.empty())
	{
		for (unsigned int i = 0; i < this->Data.size(); i++)
		{
			if (!stricmp(this->Data[i].Hash,Hash))
				return;
		}
	}
	GCDSerialData data;
	memset(data.Hash,0,sizeof(data.Hash));
	strncpy(data.Hash,Hash,32);
	data.IsValid = IsValid;
	this->Data.push_back(data);
}
bool GCDValidationClass::IsValid(const char *Hash)
{
	if (!Hash || strlen(Hash) != 32 || this->Data.empty())
		return false;
	for (unsigned int i = 0; i < this->Data.size(); i++)
	{
		if (!stricmp(this->Data[i].Hash,Hash))
			return this->Data[i].IsValid;
	}
	return false;
}
GCDValidationClass *GCDValidation;

// Hooks
bool Chat_Hook(nc_cCsTextObj *CsTextObj)
{
	if (CsTextObj->Type >= 0 && CsTextObj->Type <= 2)
	{
		if (!Serial.SerialData[CsTextObj->Sender].Received)
			return false;
	}
	return true;
}

bool Radio_Hook(nc_CSAnnouncement *Radio)
{
	if (!Serial.SerialData[Radio->ID].Received)
		return false;
	return true;
}

void Join_Hook(nc_cPlayer *pData)
{
	Serial.SerialData[pData->PlayerId].Received = false;
	Serial.SerialData[pData->PlayerId].Count = 1;
	Serial.SerialData[pData->PlayerId].Kick = false;
	Serial.SerialData[pData->PlayerId].LastSend = cGame->GameDuration_Seconds;
}

void Frame_Hook()
{
	for (unsigned int i = 0; i < ClassList.size(); i++)
		ClassList[i]->Think();
}

void SerialHash_Hook(const nc_cGameSpyCsChallengeResponseEvent *Response)
{
	nc_cPlayer *pData = nc_cPlayerManager::Find_Player(Response->ID);
	if (!pData)
		return;
	if (!Response->Hash.m_Buffer || !*Response->Hash.m_Buffer)
	{
		Console.Output("Empty serial hash detected from %S\n",pData->PlayerName.m_Buffer);
		nc_cNetwork::Server_Kill_Connection(Response->ID);
		nc_cNetwork::Cleanup_After_Client(Response->ID);
		Console.Output("%S was kicked\n",pData->PlayerName.m_Buffer);
		return;
	}
	if (strlen(Response->Hash.m_Buffer) != 72)
	{
		Console.Output("Invalid serial hash detected from %S\n",pData->PlayerName.m_Buffer);
		nc_cNetwork::Server_Kill_Connection(Response->ID);
		nc_cNetwork::Cleanup_After_Client(Response->ID);
		Console.Output("%S was kicked\n",pData->PlayerName.m_Buffer);
		return;
	}
	char Hash[33];
	strncpy(Hash,Response->Hash.m_Buffer,32);
	Hash[32] = 0;
	OSVERSIONINFO osvi;
	osvi.dwOSVersionInfoSize = sizeof(OSVERSIONINFO);
	GetVersionEx(&osvi);
	if (osvi.dwMajorVersion >= 5) { // If it is Windows 2000 or above
		HMODULE hMods[1024];
		DWORD cbNeeded;
		if (EnumProcessModules(GetCurrentProcess(),hMods,sizeof(hMods),&cbNeeded)) {
			typedef void (*SerialHashHook)(int, const char *);
			for (unsigned int i = 0; i < (cbNeeded / sizeof(HMODULE)); i++) {
				if (hMods[i])
				{
					SerialHashHook SerialHash_Hook = (SerialHashHook)GetProcAddress(hMods[i],"SerialHashHook");
					if (SerialHash_Hook)
						SerialHash_Hook(Response->ID,Hash);
				}
			}
		}
	}
	Serial.SerialData[Response->ID].Received = true;
	Serial.SerialData[Response->ID].Kick = false;
	Console.Output("Serial hash response from %S -> %s.\n",pData->PlayerName.m_Buffer,Hash);
}

void PlayerLeft_Hook(int pID)
{
	Serial.Reset(pID);
}

bool Spawn_Hook(int pID)
{
	if (!Serial.SerialData[pID].Received)
		return false;
	return true;
}

void CDKeyAuthCallback(int ID, int Type, const char *msg)
{
	nc_cPlayer *pData = nc_cPlayerManager::Find_Player(ID);
	if (pData)
	{
		if (!pData->IsActive)
			return;
		if (!strncmp(msg,"Your CD Key is disabled.",24))
			Console.Output("CD key from %S is banned by GameSpy\n",pData->PlayerName.m_Buffer);
		else if (!stricmp(msg,"Invalid CD Key"))
			Console.Output("%S is using an invalid serial\n",pData->PlayerName.m_Buffer);
		else if (!strcmp(msg,"CD Key in use") || !strcmp(msg,"Validation Timeout"))
		{
			if (GCDValidation->IsValid(pData->GameSpyHashId.m_Buffer))
				Console.Output("%S is using a valid serial\n",pData->PlayerName.m_Buffer);
			else
				Console.Output("%S is using an invalid serial\n",pData->PlayerName.m_Buffer);
		}
		else if (!strcmp(msg,"Validated"))
		{
			GCDValidation->Add(pData->GameSpyHashId.m_Buffer,true);
			Console.Output("%S is using a valid serial\n",pData->PlayerName.m_Buffer);
		}
	}
}
__declspec(naked) void CDKeyAuthCallback_Hook(int ID, int Type, const char *msg, int unk) {
	_asm {
		push ebp
		mov ebp, esp
	}
	CDKeyAuthCallback(ID,Type,msg);
	_asm {
		mov esp, ebp
		pop ebp
		retn
	}
}


// Initial stuff
void DLL_Init()
{
	// Hooks.dll initial check routines
	if (!Init_Hooks())
	{
		MessageBox(0,"Failed to load Hooks.dll. Serial.dll has been disabled.","FATAL ERROR",MB_OK);
		return;
	}
	if (Get_Hooks_Version() < MINIMUM_HOOKS_VERSION)
	{
		char msg[512];
		sprintf(msg,"Error - Serial.dll is incompatible with Hooks.dll version below 1.04. Current Hooks.dll version is %.2f, please upgrade.",Get_Hooks_Version());
		MessageBox(0,msg,"Error",MB_OK);
		return;
	}

	// Initial serial validation class
	//GCDValidation = new GCDValidationClass;

	// Initial console commands
	GetSerial = new GetSerialConsoleFunction;

	// Hooks registration
	RegisterRadioHook(Radio_Hook);
	RegisterChatHook(Chat_Hook);
	RegisterJoinHook(Join_Hook);
	RegisterFrameHook(Frame_Hook);
	RegisterSerialHashHook(SerialHash_Hook);
	RegisterPlayerLeftHook(PlayerLeft_Hook);
	RegisterSpawnHook(Spawn_Hook);

	// Hooks
	//PatchJump(&CDKeyAuthCallback_Hook,0x4E2180);

	PatchByte(0xC3,1,0x4E2180);

	// Patch to correct GID to GameSpy CD Key Authentication
	//unsigned char GSA_GID_Patch[] = { 0xBA, 0x41, 0x02, 0x00, 0x00, 0x90 };
	//PatchData(&GSA_GID_Patch,6,0x772E2E);

	// Just a message...
	Console.Output("Serial.dll %s by Adad loaded - Built-on %s %s\n",VERSION_STATE,__DATE__,__TIME__);
}
