/*	Renegade Scripts.dll
	Copyright 2011 Tiberian Technologies

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "General.h"
#include "Parachute.h"
#include "gmgame.h"
#include "engine_tt.h"
#include "engine_io.h"
#include "SoldierGameObj.h"
#include "VehicleGameObj.h"

Parachute::Parachute()
{
	RegisterEvent(EVENT_CHAT_HOOK,this);
	RegisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}

Parachute::~Parachute()
{
	UnregisterEvent(EVENT_CHAT_HOOK,this);
	UnregisterEvent(EVENT_OBJECT_CREATE_HOOK,this);
}


bool Parachute::OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID)
{
	if (Message[0] == L'!')
	{
		if ((wcsistr(Message,L"!para") == Message) || (wcsistr(Message,L"!parachute") == Message))
		{
			//attach para script to player here instead of on object create if you want them to have to purchase it.
			return false;
		}
	}
	return true;
}

void Parachute::OnObjectCreate(void *data,GameObject *obj)
{
	if (obj->As_SoldierGameObj()) {
		Attach_Script_Once(obj,"Para","");
	}
	else if (obj->As_VehicleGameObj()) {
		//if (obj->As_PhysicalGameObj()->Peek_Physical_Object()->As_DecorationPhysClass() && (Is_VTOL(obj))) {
		if (Is_VTOL(obj)) {
			Attach_Script_Once(obj,"Para","");
		}
	}
}

void Para::Created(GameObject *obj) 
{
	isFalling = false;
	floaterID = 0;
	pchuteID = 0;
	fallin = 0;
	health = Commands->Get_Health(obj);
}

void Para::Damaged(GameObject *obj, GameObject *damager, float amount) {
	if (!damager && isFalling && (amount < 1000)) {
		Commands->Set_Health(obj,health);
		isFalling = false;
	}
	else {
		health = Commands->Get_Health(obj);
	}
}

void Para::Killed(GameObject *obj, GameObject *killer) 
{
	if (obj->As_VehicleGameObj()) 
	{
		VehicleGameObj *veh = obj->As_VehicleGameObj();
		if (Commands->Get_ID(veh) && veh ) 
		{
			int x = veh->Get_Occupant_Count();
			for (int i = 0;i < x;i++)
			{
				if (veh->Get_Occupant(i))
				{
					Commands->Send_Custom_Event(veh->Get_Occupant(i),veh->Get_Occupant(i),4612,0,0);
				}
			}
		}
	}
	else if (obj->As_SoldierGameObj()) 
	{
		Commands->Enable_Collisions(obj);
		if (Commands->Find_Object(pchuteID)) {
			Commands->Destroy_Object(Commands->Find_Object(pchuteID));
			pchuteID = 0;
		}
		if (Commands->Find_Object(floaterID)) {
			Commands->Destroy_Object(Commands->Find_Object(floaterID));
			floaterID = 0;
		}
		isFalling = false;
	}
}

void Para::Timer_Expired(GameObject *obj,int number) {
	if (number == 1) {
		newpos = Commands->Get_Position(obj);
		if (newpos.Z < pos.Z) {
			fallin += pos.Z - newpos.Z;
			if (fallin > 10 && !isFalling) {
				isFalling = true;
				GameObject *floater = Commands->Create_Object("CnC_Beacon_IonCannon",Commands->Get_Position(obj));
				Commands->Set_Model(floater,"null");
				Commands->Set_Facing(floater,Commands->Get_Facing(obj));
				GameObject *pchute = Commands->Create_Object("Generic_Cinematic",Commands->Get_Position(obj));
				Commands->Set_Model(pchute,"X5D_Parachute");
				Commands->Disable_All_Collisions(pchute);
				Commands->Disable_Physical_Collisions(obj);
				Commands->Attach_To_Object_Bone(obj,floater,"");
				Commands->Attach_To_Object_Bone(pchute,obj,"");
				floaterID = Commands->Get_ID(floater);
				pchuteID = Commands->Get_ID(pchute);
			}
			pos = Commands->Get_Position(obj);
			Commands->Start_Timer(obj, this, 0.1f, 1);
		}
		else {
			Commands->Enable_Collisions(obj);
			if (Commands->Find_Object(pchuteID)) {
				Commands->Destroy_Object(Commands->Find_Object(pchuteID));
				pchuteID = 0;
			}
			if (Commands->Find_Object(floaterID)) {
				Commands->Destroy_Object(Commands->Find_Object(floaterID));
				floaterID = 0;
			}
			Commands->Start_Timer(obj, this, 2.0f, 2);
		}
	}
	else if (number == 2) {
		isFalling = false;
	}
}

void Para::Custom(GameObject *obj,int type,int param,GameObject *sender) {
	if (type == CUSTOM_EVENT_VEHICLE_EXITED) {
		Commands->Send_Custom_Event(sender,sender,4612,0,0);
	}
	else if (type == CUSTOM_EVENT_VEHICLE_ENTERED) {
		Commands->Send_Custom_Event(sender,sender,4613,0,0);
	}
	else if (type == 4612) {
		health = Commands->Get_Health(obj);
		fallin = 0;
		pos = Commands->Get_Position(obj);
		Commands->Start_Timer(obj, this, 0.1f, 1);
	}
	else if (type == 4613) {
		isFalling = false;
		if (Commands->Find_Object(pchuteID)) {
			Commands->Destroy_Object(Commands->Find_Object(pchuteID));
			pchuteID = 0;
		}
		if (Commands->Find_Object(floaterID)) {
			Commands->Destroy_Object(Commands->Find_Object(floaterID));
			floaterID = 0;
		}
	}
}


ScriptRegistrant<Para> Para_Registrant("Para","");

Parachute parachute;


extern "C" __declspec(dllexport) Plugin* Plugin_Init()
{
	return &parachute;
}
