#pragma once

#include "gmplugin.h"

struct LastDamageDataStruct
{
	int Warhead;
	float Damage;
	int KillsFromVehicle;
	bool KillDetected;
	int LastDamageTime;
};

struct DamageValuesStruct
{
	float BodyShot;
	int Warhead;
	bool VehicleWeapon;
	const char* Weapon;
};

class CustomKillMessages :	public Plugin
{
public:
	
	CustomKillMessages();
	~CustomKillMessages();
	
	virtual void OnLoadGlobalINISettings(INIClass *SSGMIni);
	virtual void OnObjectCreate(void *data,GameObject *obj);
	virtual void OnLoadLevel();
	virtual void OnPlayerLeave(int PlayerID);
	virtual bool OnTtDamage(PhysicalGameObj* damager, PhysicalGameObj* target, const AmmoDefinitionClass* ammo, const char* bone);
	virtual bool OnStockDamage(PhysicalGameObj* damager, PhysicalGameObj* target, float damage, uint warheadId);
};

class Iran_Detect_Player_Kill : public ScriptImpClass {
	bool WasSquish;
	StringClass KillWeapon;
	GameObject *Explosion;
	GameObject* VictimObj;
	GameObject* KillerObj;
	void Created(GameObject *obj);
	void Killed(GameObject *obj, GameObject *Killer);
	void Timer_Expired(GameObject *obj, int number);
};

void Console(const char *Format, ...);

void Load_All_Damage_Values();
void Load_Last_Vehicle();
void Load_Randomized_Kill_Message();
const char* Get_Head_Neck_Shot_String(int Warhead, float Damage);
const char* Get_Kill_Weapon(int Warhead, float Damage, int PlayerID);
void Damage_Check(PhysicalGameObj* damager, PhysicalGameObj* target, int Warhead, float Damage);

StringClass Get_Random_Squish_String();
StringClass Get_Random_Killed_String();