#pragma once

#include "gmplugin.h"

struct PromoteInfo
{
	StringClass Name;
	float Health;
	float Armor;
	float Regeneration;
	float Discount;
	int Points;
	int Level;
};

struct PlayerVetInfo
{
	float DamageDone;
	int VetLevel;
	int VetPoints;

	time_t VetVehicle;
	time_t VetCharacter;
	time_t VetWeapon;
};


class VeteranSystem :
	public Plugin
{

public:
	
	VeteranSystem();
	~VeteranSystem();
	
	virtual bool OnChat(int PlayerID,TextMessageEnum Type,const wchar_t *Message,int recieverID);
	virtual void OnObjectCreate(void *data,GameObject *obj);
	virtual void OnLoadLevel();
	virtual void OnGameOver();
	virtual void OnPlayerJoin(int PlayerID,const char *PlayerName);
	virtual void OnLoadGlobalINISettings(INIClass *SSGMIni);
};

void Page(int ID, const char *Format, ...); // Use hard-coded green colour
void Console(const char *Format, ...);

void Set_Max_Shield_Strength_Only(GameObject *obj,float shieldstrength);
void Set_Max_Health_Only(GameObject *obj,float health);
void Update_Player(int ID, GameObject *obj);
void Check_Vet_Levels();
void Load_Soldier_Tiers(INIClass* SSGMIni);
void Load_Promotion_Info();

void Do_Vet_Points_Command(int PlayerID);
void Do_Character_Command(int PlayerID);
void Do_Weapon_Command(int PlayerID);
void Do_Vehicle_Command(int PlayerID);

const PromoteInfo* Get_Promotion_Info(int Level);
void Init_Vet_Info(const char* PlayerName);
void Update_Vet_Points(PlayerVetInfo* VetInfo);

const char* Get_Random_Character(int Team, int Number, int Type);
const char* Get_Random_Weapon(int Number, int Type);
const char* Get_Random_Vehicle(int Team, int Number, int Type);
void Drop_Off(GameObject *Place, const char *Preset);

class Drop_Off_Control : public ScriptImpClass
{
	int transbone_id;
 	int trans_id;
	int vehharness_id;
	int vehicle_id;
 	int fakeharness_id;
	void Created(GameObject *obj);
	void Timer_Expired(GameObject *obj, int number);
};

class Veteran_Vehicle : public ScriptImpClass
{
//	float MaxHealth, MaxArmor;
//	int Cost;
//	bool IsRepaired;
//	int *VehicleDamage;
	void Created(GameObject *o);
	void Damaged(GameObject *o, GameObject *attacker, float damage);
//	void Killed(GameObject *o, GameObject *killer);
//	void Destroyed(GameObject *o);
	void Timer_Expired(GameObject *o, int number);
};

class Veteran_Player : public ScriptImpClass
{
	float MaxHealth, MaxArmor;
	int Cost;
	bool IsRepaired;
	int *PlayerDamage;
	void Created(GameObject *obj);
	void Damaged(GameObject *obj, GameObject *attacker, float damage);
	void Killed(GameObject *obj, GameObject *killer);
//	void Destroyed(GameObject *obj);
//	void Timer_Expired(GameObject *o, int number);
};

class Veteran_Think : public ScriptImpClass
{
	void Created(GameObject *o);
	void Timer_Expired(GameObject *o, int number);
};

class Veteran_C4 : public ScriptImpClass
{
	void Killed(GameObject *obj, GameObject *killer);
};

class Veteran_Beacon : public ScriptImpClass
{
	void Killed(GameObject *obj, GameObject *killer);
};

class Veteran_Building : public ScriptImpClass
{
	void Damaged(GameObject *obj, GameObject *attacker, float damage);
	void Killed(GameObject *obj, GameObject *killer);
};