/*	Renegade Scripts.dll
	INI Functions
	Copyright 2006 xuyifeng

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
//
// profile.h
// Profile support.
// Programed by	XuYiFeng 1995.4.25,	All	rights reserved.
//
#ifdef WIN32

#ifndef	__PROFILE_H
#define	__PROFILE_H

int	getProfileInt( const char *section,	const char *entry, int defaultInt,
				  const	char *fileName );
float getProfileFloat( const char *section,	const char *entry, float defaultInt,
					  const	char *fileName );
int	getProfileString( const	char *section, const char *entry,
					 const char	*defaultString,	char *buffer,
					 int   bufLen, const char *fileName	);
int	writeProfileString(	const char *section, const char	*entry,
					   const char *string, const char *fileName	);

int	deleteProfileString( const char	*section,
						const char *entry,
						const char *string,
						const char *fileName );
#endif

#else

#ifndef	__PROFILE_H
#define	__PROFILE_H

int	getProfileInt( const char *section,	const char *entry, int defaultInt,
				  const	char *fileName );
float getProfileFloat( const char *section,	const char *entry, float defaultInt,
					  const	char *fileName );
int	getProfileString( const	char *section, const char *entry,
					 const char	*defaultString,	char *buffer,
					 int   bufLen, const char *fileName	);
int	writeProfileString(	const char *section, const char	*entry,
					   const char *string, const char *fileName	);

bool isSection(	char sLine[256]	);
void writeSection( const char *psName, FILE	*FP	);
bool getSection( char sLine[256], char *psSection );

bool isEntry( char sLine[256] );
void writeEntry( const char	*psKey,	const char *psValue, FILE *FP );
bool getEntry( char	sLine[256],	char *psKey, char *psValue );

int	writeProfileString(	const char *section, const char	*entry,
					   const char *string, const char *fileName	);

int	deleteProfileString( const char	*section,
						const char *entry,
						const char *string,
						const char *fileName );

#endif
#endif
