/*	Renegade Scripts.dll
	Scripts that play sounds
	Copyright 2006 Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "scripts.h"
#include "engine.h"
#include "jfwsnd.h"

void JFW_2D_Sound_Timer::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_2D_Sound_Timer::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	float timertime;
	int repeat;
	const char *c;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_2D_Sound(c);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_2D_Sound_Timer_Random::Created(GameObject *obj)
{
	float timertime,timemin,timemax;
	int timernumber;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	timertime = Commands->Get_Random(timemin,timemax);
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_2D_Sound_Timer_Random::Timer_Expired(GameObject *obj,int number)
{
	float timertime,timemin,timemax;
	int timernumber;
	int repeat;
	const char *c;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_2D_Sound(c);
		if (repeat == 1)
		{	
			timertime = Commands->Get_Random(timemin,timemax);
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_3D_Sound_Timer_Random::Created(GameObject *obj)
{
	float timertime,timemin,timemax;
	int timernumber;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	timertime = Commands->Get_Random(timemin,timemax);
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_3D_Sound_Timer_Random::Timer_Expired(GameObject *obj,int number)
{
	float timertime,timemin,timemax;
	int timernumber;
	int repeat;
	Vector3 v;
	const char *c;
	timemin = Get_Float_Parameter("Time_Min");
	timemax = Get_Float_Parameter("Time_Max");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	v = Get_Vector3_Parameter("Position");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Commands->Create_Sound(c,v,obj);
		if (repeat == 1)
		{	
			timertime = Commands->Get_Random(timemin,timemax);
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_2D_Sound_Timer_Health::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_2D_Sound_Timer_Health::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	float minhealth,maxhealth,health;
	float timertime;
	int repeat;
	const char *c;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	minhealth = Get_Float_Parameter("Min_Health");
	maxhealth = Get_Float_Parameter("Max_Health");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		health = Commands->Get_Health(obj);
		if ((health >= minhealth) && (health <= maxhealth))
		{
			Commands->Create_2D_Sound(c);
		}
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_2D_Sound_Damage::Created(GameObject *obj)
{
	enabled = true;
}

void JFW_2D_Sound_Damage::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if (Commands->Get_Health(obj) <= Get_Float_Parameter("Health"))
	{
		if (enabled)
		{
			enabled = false;
			Commands->Create_2D_Sound(Get_Parameter("Sound"));
		}
	}
	else
	{
		enabled = true;
	}
}

void JFW_2D_Sound_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_3D_Sound_Damage::Created(GameObject *obj)
{
	enabled = true;
}

void JFW_3D_Sound_Damage::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if (Commands->Get_Health(obj) <= Get_Float_Parameter("Health"))
	{
		if (enabled)
		{
			enabled = false;
			Vector3 pos = Commands->Get_Position(obj);
			Vector3 offset = Get_Vector3_Parameter("Offset");
			pos.X += offset.X;
			pos.Y += offset.Y;
			pos.Z += offset.Z;
			Commands->Create_Sound(Get_Parameter("Sound"),pos,obj);
		}
	}
	else
	{
		enabled = true;
	}
}

void JFW_3D_Sound_Damage::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_2D_Sound_Damage_Range::Created(GameObject *obj)
{
	enabled = true;
}

void JFW_2D_Sound_Damage_Range::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if ((Commands->Get_Health(obj) <= Get_Float_Parameter("MaxHealth")) && (Commands->Get_Health(obj) <= Get_Float_Parameter("MinHealth")))
	{
		if (enabled)
		{
			enabled = false;
			Commands->Create_2D_Sound(Get_Parameter("Sound"));
		}
	}
	else
	{
		enabled = true;
	}
}

void JFW_2D_Sound_Damage_Range::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_3D_Sound_Damage_Range::Created(GameObject *obj)
{
	enabled = true;
}

void JFW_3D_Sound_Damage_Range::Damaged(GameObject *obj,GameObject *damager,float damage)
{
	if ((Commands->Get_Health(obj) <= Get_Float_Parameter("MaxHealth")) && (Commands->Get_Health(obj) >= Get_Float_Parameter("MinHealth")))
	{
		if (enabled)
		{
			enabled = false;
			Vector3 pos = Commands->Get_Position(obj);
			Vector3 offset = Get_Vector3_Parameter("Offset");
			pos.X += offset.X;
			pos.Y += offset.Y;
			pos.Z += offset.Z;
			Commands->Create_Sound(Get_Parameter("Sound"),pos,obj);
		}
	}
	else
	{
		enabled = true;
	}
}

void JFW_3D_Sound_Damage_Range::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

void JFW_3D_Sound_Timer::Created(GameObject *obj)
{
	float timertime;
	int timernumber;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	Commands->Start_Timer(obj,this,timertime,timernumber);
}

void JFW_3D_Sound_Timer::Timer_Expired(GameObject *obj,int number)
{
	int timernumber;
	float timertime;
	int repeat;
	const char *c;
	timertime = Get_Float_Parameter("Time");
	timernumber = Get_Int_Parameter("TimerNum");
	repeat = Get_Int_Parameter("Repeat");
	c = Get_Parameter("Sound");
	if (number == timernumber)
	{
		Vector3 pos = Commands->Get_Position(obj);
		Vector3 offset = Get_Vector3_Parameter("Offset");
		pos.X += offset.X;
		pos.Y += offset.Y;
		pos.Z += offset.Z;
		Commands->Create_Sound(Get_Parameter("Sound"),pos,obj);
		if (repeat == 1)
		{	
			Commands->Start_Timer(obj,this,timertime,timernumber);
		}
	}
}

void JFW_Set_Background_Music_On_Custom::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Set_Background_Music(Get_Parameter("Music"));
	}
}

void JFW_Fade_Background_Music_On_Custom::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Fade_Background_Music(Get_Parameter("Music"),Get_Int_Parameter("unk1"),Get_Int_Parameter("unk2"));
	}
}

void JFW_Stop_Background_Music_On_Custom::Custom(GameObject *obj,int message,int param,GameObject *sender)
{
	if (message == Get_Int_Parameter("Message"))
	{
		Commands->Stop_Background_Music();
	}
}

void JFW_Set_Background_Music_On_Enter::Entered(GameObject *obj,GameObject *enter)
{
	Set_Background_Music_Player(enter,Get_Parameter("Music"));
}

void JFW_Fade_Background_Music_On_Enter::Entered(GameObject *obj,GameObject *enter)
{
	Fade_Background_Music_Player(enter,Get_Parameter("Music"),Get_Int_Parameter("unk1"),Get_Int_Parameter("unk2"));
}

void JFW_Stop_Background_Music_On_Enter::Entered(GameObject *obj,GameObject *enter)
{
	Stop_Background_Music_Player(enter);
}

ScriptRegistrant<JFW_Set_Background_Music_On_Custom> JFW_Set_Background_Music_On_Custom_Registrant("JFW_Set_Background_Music_On_Custom","Message:int,Music:string");
ScriptRegistrant<JFW_Fade_Background_Music_On_Custom> JFW_Fade_Background_Music_On_Custom_Registrant("JFW_Fade_Background_Music_On_Custom","Message:int,Music:string,unk1:int,unk2:int");
ScriptRegistrant<JFW_Stop_Background_Music_On_Custom> JFW_Stop_Background_Music_On_Custom_Registrant("JFW_Stop_Background_Music_On_Custom","Message:int");
ScriptRegistrant<JFW_Set_Background_Music_On_Enter> JFW_Set_Background_Music_On_Enter_Registrant("JFW_Set_Background_Music_On_Enter","Music:string");
ScriptRegistrant<JFW_Fade_Background_Music_On_Enter> JFW_Fade_Background_Music_On_Enter_Registrant("JFW_Fade_Background_Music_On_Enter","Music:string,unk1:int,unk2:int");
ScriptRegistrant<JFW_Stop_Background_Music_On_Enter> JFW_Stop_Background_Music_On_Enter_Registrant("JFW_Stop_Background_Music_On_Enter","");
ScriptRegistrant<JFW_2D_Sound_Damage_Range> JFW_2D_Sound_Damage_Range_Registrant("JFW_2D_Sound_Damage_Range","Sound:string,MinHealth:float,MaxHealth:float");
ScriptRegistrant<JFW_3D_Sound_Damage_Range> JFW_3D_Sound_Damage_Range_Registrant("JFW_3D_Sound_Damage_Range","Sound:string,MinHealth:float,MaxHealth:float,Offset:vector3");
ScriptRegistrant<JFW_3D_Sound_Timer> JFW_3D_Sound_Timer_Registrant("JFW_3D_Sound_Timer","Time:float,TimerNum:int,Repeat:int,Sound:string,Offset:vector3");
ScriptRegistrant<JFW_2D_Sound_Damage> JFW_2D_Sound_Damage_Registrant("JFW_2D_Sound_Damage","Sound:string,Health:float");
ScriptRegistrant<JFW_3D_Sound_Damage> JFW_3D_Sound_Damage_Registrant("JFW_3D_Sound_Damage","Sound:string,Health:float,Offset:vector3");
ScriptRegistrant<JFW_2D_Sound_Timer_Random> JFW_2D_Sound_Timer_Random_Registrant("JFW_2D_Sound_Timer_Random","Time_Min:float,Time_Max:float,TimerNum:int,Repeat:int,Sound:string");
ScriptRegistrant<JFW_3D_Sound_Timer_Random> JFW_3D_Sound_Timer_Random_Registrant("JFW_3D_Sound_Timer_Random","Time_Min:float,Time_Max:float,TimerNum:int,Repeat:int,Sound:string,Position:vector3");
ScriptRegistrant<JFW_2D_Sound_Timer_Health> JFW_2D_Sound_Timer_Health_Registrant("JFW_2D_Sound_Timer_Health","Time:float,TimerNum:int,Repeat:int,Sound:string,Min_Health:float,Max_Health:float");
ScriptRegistrant<JFW_2D_Sound_Timer> JFW_2D_Sound_Timer_Registrant("JFW_2D_Sound_Timer","Time:float,TimerNum:int,Repeat:int,Sound:string");
