/*	Renegade Scripts.dll
	Engine calls
	Copyright 2006 Vloktboky, WhiteDragon(MDB), Joshua "NeoSaber" Kraft, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#if (_MSC_VER >= 1400)
#define _CRT_SECURE_NO_DEPRECATE 1
#define _CRT_NONSTDC_NO_DEPRECATE 1
#endif
#ifdef WIN32
#include <winsock2.h>
#else
#include <wchar.h>
#include <netinet/in.h>
#endif
#include "scripts.h"
#include "engine.h"
#include <float.h>
int Exe = 6;
typedef char DefinitionClass;
#ifdef WIN32
typedef Matrix3D *(*GetTransform) ();
typedef void (*SetTransform) (Matrix3D *mat);
#else
typedef Matrix3D *(*GetTransform) (GameObject *obj);
typedef void (*SetTransform) (GameObject *obj,Matrix3D *mat);
#endif
SetTransform Set_Transform;
GetTransform Get_Transform;
typedef GameObject *(*ago) (GameObject *obj);
typedef const char *(*Get_Name) (char *ro);
typedef const char *(*Get_Htree) (char *ro);
typedef int (*Get_ClassID) (DefinitionClass *def);
typedef char *(*FindTeam) (int team);
FindTeam Find_Team;
#ifdef WIN32
typedef void (*permitted) (void);
#else
typedef void (*permitted) (cGameData *data);
#endif
typedef int (*tts) (int team);
tts TallyTeamSize;
typedef unsigned char *(*Find_Player) (int);
Find_Player FindPlayer;
typedef DefinitionClass *(*Find_Named_Def) (const char *name,bool twiddle);
Find_Named_Def FindNamedDef;
#ifdef WIN32
typedef void (*ReInit) (DefinitionClass *def);
#else
typedef void (*ReInit) (GameObject *obj,DefinitionClass *def);
#endif
ReInit SoldierReInit;
#ifdef WIN32
typedef void (*PostReInit) (void);
#else
typedef void (*PostReInit) (GameObject *obj);
#endif
PostReInit Post_ReInit;
char **ServerConnection;
#ifdef WIN32
typedef char *(*GetRemoteHost) (int player);
#else
typedef char *(*GetRemoteHost) (char *connection,int player);
#endif
GetRemoteHost Get_Remote_Host;
typedef void *(*rennew) (unsigned long size);
rennew RenNew = 0;
rennew RenVecNew = 0;
typedef void (*rendelete) (void *ptr);
rendelete RenDelete;
rendelete RenVecDelete;
#ifdef WIN32
typedef sockaddr_in *(*GetAddress) ();
#else
typedef sockaddr_in *(*GetAddress) (void *host);
#endif
GetAddress Get_Address;
typedef void (*GrantSupplies) (GameObject *obj);
GrantSupplies Grant_Supplies;
#ifdef WIN32
typedef void (*PowerupGrant) (GameObject *obj,int powerup,bool unk);
#else
typedef void (*PowerupGrant) (DefinitionClass *def,GameObject *obj,int powerup,bool unk);
#endif
PowerupGrant Powerup_Grant;
typedef const char *(*GetArmorName) (unsigned int ID);
GetArmorName Get_Armor_Name;
typedef unsigned int(*GetArmorType) (const char *name);
GetArmorType Get_Armor_Type;
#ifdef WIN32
typedef void (*MarkOwnerDirty) (void);
#else
typedef void (*MarkOwnerDirty) (unsigned int *def);
#endif
MarkOwnerDirty Mark_Owner_Dirty;
#ifdef WIN32
typedef bool (*IsAvailable) (void);
#else
typedef bool (*IsAvailable) (GameObject *obj);
#endif
IsAvailable Is_Available_For_Purchase;
#ifdef WIN32
typedef int (*BandwidthOut) (sockaddr_in *addr);
#else
typedef int (*BandwidthOut) (void *packetmgr,sockaddr_in *addr);
#endif
BandwidthOut Bandwidth_Out;
void *PacketManager;
char *Mine_Limit;
#ifdef WIN32
typedef bool (*RequestVehicle) (int Preset,float Delay,GameObject *Owner);
#else
typedef bool (*RequestVehicle) (GameObject *obj,int Preset,float Delay,GameObject *Owner);
#endif
RequestVehicle Request_Vehicle;
#ifdef WIN32
typedef void (*ToggleFlyMode) (void);
#else
typedef void (*ToggleFlyMode) (GameObject *obj);
#endif
ToggleFlyMode ToggleFly;
#ifdef WIN32
typedef void (*SetMax) (float max);
#else
typedef void (*SetMax) (unsigned int *def,float max);
#endif
SetMax SetMaxHealth;
SetMax SetMaxShieldStrength;
typedef void (*ConsoleInput)(const char *);
ConsoleInput Parse_Console_Input;
typedef void (*ConsoleOut) (const char *);
ConsoleOut Output_To_Console;
typedef void (*spt) (unsigned char *playerdata,int type);
spt SetPlayerType;
typedef int (*gpc) (void);
gpc GetPlayerCount;
typedef bool (*CheckTransitions) (GameObject *obj,bool unk);
CheckTransitions Check_Transitions;
typedef void (*GetSafeDataUintRef) (void *Handle,unsigned int *&Data);
GetSafeDataUintRef Get_Safe_Data_Uint_Ref;
typedef void (*SetSafeDataUintRef) (void *Handle,unsigned int &Data);
SetSafeDataUintRef Set_Safe_Data_Uint_Ref;
typedef cGameData *(*TheGame) ();
TheGame Game;
typedef cGameDataSkirmish *(*TheSkirmishGame) ();
TheSkirmishGame Skirmish_Game;
typedef cGameDataCnc *(*TheCncGame) ();
TheCncGame Cnc_Game;
typedef cGameDataSinglePlayer *(*TheSinglePlayerGame) ();
TheSinglePlayerGame Single_Player_Game;
SList<GameObject> *BuildingGameObjList;
SList<GameObject> *SmartGameObjList;
SList<GameObject> *BaseGameObjList;
char *SpawnCharNod;
char *SpawnCharGDI;
char *ObjectsAddress;
typedef void *(*GameModeFind) (const char *mode);
GameModeFind Game_Mode_Find;
bool *IsListed;
int *GameType;
typedef int (*GetSafeDataInt) (void *Handle);
GetSafeDataInt Get_Safe_Data_Int;
typedef float (*GetSafeDataFloat) (void *Handle);
GetSafeDataFloat Get_Safe_Data_Float;
typedef float (*GetSafeDataFloatRef) (void *Handle,float *&Data);
GetSafeDataFloatRef Get_Safe_Data_Float_Ref;

#ifndef BHS
_Set_Background_Music_Player Set_Background_Music_Player;
_Fade_Background_Music_Player Fade_Background_Music_Player;
_Stop_Background_Music_Player Stop_Background_Music_Player;
_Enable_Radar_Player Enable_Radar_Player;
_Display_GDI_Player_Terminal_Player Display_GDI_Player_Terminal_Player;
_Display_NOD_Player_Terminal_Player Display_NOD_Player_Terminal_Player;
_Set_Screen_Fade_Color_Player Set_Screen_Fade_Color_Player;
_Set_Screen_Fade_Opacity_Player Set_Screen_Fade_Opacity_Player;
_Force_Camera_Look_Player Force_Camera_Look_Player;
_Enable_HUD_Player Enable_HUD_Player;
_Create_Sound_Player Create_Sound_Player;
_Create_2D_Sound_Player Create_2D_Sound_Player;
_Create_2D_WAV_Sound_Player Create_2D_WAV_Sound_Player;
_Create_3D_WAV_Sound_At_Bone_Player Create_3D_WAV_Sound_At_Bone_Player;
_Create_3D_Sound_At_Bone_Player Create_3D_Sound_At_Bone_Player;
_Set_Display_Color_Player Set_Display_Color_Player;
_Display_Text_Player Display_Text_Player;
_Display_Int_Player Display_Int_Player;
_Display_Float_Player Display_Float_Player;
ss Set_Scope;
sh Set_HUD_Texture;
aoch AddObjectCreateHook;
roch RemoveObjectCreateHook;
akh AddKeyHook;
rkh RemoveKeyHook;
ach AddChatHook;
ahh AddHostHook;
allh AddLoadLevelHook;
allh AddGameOverHook;
apjh AddPlayerJoinHook;
gcmt GetCurrentMusicTrack;
gbhsv GetBHSVersion;
#endif
#ifdef WIN32
extern "C" extern void Init();
void *operator new (size_t nbytes)
{
	if (!RenNew)
	{
		Init();
	}
	return RenNew((unsigned long)nbytes);
}

void* operator new[](size_t nbytes)
{
	if (!RenVecNew)
	{
		Init();
	}
	return RenVecNew((unsigned long)nbytes);
}

void operator delete(void *ptr)
{
	RenDelete(ptr);
}

void operator delete[](void *ptr)
{
	RenVecDelete(ptr);
}
#endif

void InitEngine()
{
	switch (Exe)
	{
	case 0:  //game.exe
		{
			Get_Safe_Data_Int = (GetSafeDataInt)0x00408280;
			Get_Safe_Data_Float = (GetSafeDataFloat)0x00413510;
			Get_Safe_Data_Float_Ref = (GetSafeDataFloatRef)0x00428F80;
			GameType = (int *)0x00856518;
			IsListed = (bool *)0x0082FD94;
			Game_Mode_Find = (GameModeFind)0x004372B0;
			SpawnCharGDI = (char *)0x007F5428;
			SpawnCharNod = (char *)0x007F5440;
			ObjectsAddress = (char *)0x00811F14;
			PacketManager = (void *)0x00854708;
			Bandwidth_Out = (BandwidthOut)0x0061D310;
			Mine_Limit = (char *)0x0070DD95;
			RenNew = (rennew)0x00672B70;
			RenVecNew = (rennew)0x00672B70;
			RenDelete = (rendelete)0x00672C80;
			RenVecDelete = (rendelete)0x00672C80;
			Get_Address = (GetAddress)0x0061DAF0;
			Get_Remote_Host = (GetRemoteHost)0x0061A840;
			ServerConnection = (char **)0x00820D9C;
			Game = (TheGame)0x00477CA0;
			Find_Team = (FindTeam)0x0041DA10;
			TallyTeamSize = (tts)0x004170D0;
			Skirmish_Game = (TheSkirmishGame)0x00477CC0;
			Cnc_Game = (TheCncGame)0x00477CD0;
			Single_Player_Game = (TheSinglePlayerGame)0x00477CB0;
			Get_Safe_Data_Uint_Ref = (GetSafeDataUintRef)0x00695AF0;
			Set_Safe_Data_Uint_Ref = (SetSafeDataUintRef)0x00696200;
			Check_Transitions = (CheckTransitions)0x006D55C0;
			Set_Transform = (SetTransform)0x006A5EF0;
			Get_Transform = (GetTransform)0x006A5F10;
			BuildingGameObjList = (SList<GameObject> *)0x00856FE8;
			SmartGameObjList = (SList<GameObject> *)0x00856FD8;
			BaseGameObjList = (SList<GameObject> *)0x00856FF8;
			FindPlayer = (Find_Player)0x004157E0;
			FindNamedDef = (Find_Named_Def)0x00526860;
			SoldierReInit = (ReInit)0x006C7410;
			Post_ReInit = (PostReInit)0x006B65F0;
			SetMaxHealth = (SetMax)0x00691820;
			SetMaxShieldStrength = (SetMax)0x006930E0;
			Grant_Supplies = (GrantSupplies)0x00470AC0;
			Powerup_Grant = (PowerupGrant)0x006F09F0;
			Get_Armor_Name = (GetArmorName)0x006877D0;
			Get_Armor_Type = (GetArmorType)0x00687750;
			Mark_Owner_Dirty = (MarkOwnerDirty)0x00693740;
			Is_Available_For_Purchase = (IsAvailable)0x006EE010;
			Request_Vehicle = (RequestVehicle)0x006EE1A0;
			ToggleFly = (ToggleFlyMode)0x006CFC80;
			Parse_Console_Input = (ConsoleInput)0x004287E0;
			Output_To_Console = (ConsoleOut)0x00428B50;
			SetPlayerType = (spt)0x0040D600;
			GetPlayerCount = (gpc)0x00417040;
		}
		break;
	case 1: //server.dat
		{
			Get_Safe_Data_Int = (GetSafeDataInt)0x00408280;
			Get_Safe_Data_Float = (GetSafeDataFloat)0x00413510;
			Get_Safe_Data_Float_Ref = (GetSafeDataFloatRef)0x00429100;
			GameType = (int *)0x00855700;
			IsListed = (bool *)0x0082EF7C;
			Game_Mode_Find = (GameModeFind)0x00437350;
			SpawnCharGDI = (char *)0x007F442C;
			SpawnCharNod = (char *)0x007F4444;
			ObjectsAddress = (char *)0x008110EC;
			PacketManager = (void *)0x008538F0;
			Bandwidth_Out = (BandwidthOut)0x0061CBB0;
			Mine_Limit = (char *)0x0070D355;
			RenNew = (rennew)0x00672410;
			RenVecNew = (rennew)0x00672410;
			RenDelete = (rendelete)0x00672520;
			RenVecDelete = (rendelete)0x00672520;
			Get_Address = (GetAddress)0x0061D390;
			Get_Remote_Host = (GetRemoteHost)0x0061A0E0;
			ServerConnection = (char **)0x0081FF84;
			Game = (TheGame)0x00477370;
			Find_Team = (FindTeam)0x0041DA10;
			TallyTeamSize = (tts)0x004170D0;
			Skirmish_Game = (TheSkirmishGame)0x00477390;
			Cnc_Game = (TheCncGame)0x004773A0;
			Single_Player_Game = (TheSinglePlayerGame)0x00477380;
			Get_Safe_Data_Uint_Ref = (GetSafeDataUintRef)0x00695390;
			Set_Safe_Data_Uint_Ref = (SetSafeDataUintRef)0x00695AA0;
			Check_Transitions = (CheckTransitions)0x006D4E60;
			Set_Transform = (SetTransform)0x006A5790;
			Get_Transform = (GetTransform)0x006A57B0;
			BuildingGameObjList = (SList<GameObject> *)0x008561D0;
			SmartGameObjList = (SList<GameObject> *)0x008561C0;
			BaseGameObjList = (SList<GameObject> *)0x008561E0;
			FindPlayer = (Find_Player)0x004157E0;
			FindNamedDef = (Find_Named_Def)0x00526100;
			SoldierReInit = (ReInit)0x006C6CB0;
			Post_ReInit = (PostReInit)0x006B5E90;
			SetMaxHealth = (SetMax)0x006910C0;
			SetMaxShieldStrength = (SetMax)0x00692980;
			Grant_Supplies = (GrantSupplies)0x00470230;
			Powerup_Grant = (PowerupGrant)0x006EFFB0;
			Get_Armor_Name = (GetArmorName)0x00687700;
			Get_Armor_Type = (GetArmorType)0x00686FF0;
			Mark_Owner_Dirty = (MarkOwnerDirty)0x00692FE0;
			Is_Available_For_Purchase = (IsAvailable)0x006ED5D0;
			Request_Vehicle = (RequestVehicle)0x006ED760;
			ToggleFly = (ToggleFlyMode)0x006CF520;
			Parse_Console_Input = (ConsoleInput)0x00428960;
			Output_To_Console = (ConsoleOut)0x00428CD0;
			SetPlayerType = (spt)0x0040D600;
			GetPlayerCount = (gpc)0x00417040;
		}
		break;
	case 2: //RH73
		{
			Get_Safe_Data_Int = (GetSafeDataInt)0;
			Get_Safe_Data_Float = (GetSafeDataFloat)0;
			Get_Safe_Data_Float_Ref = (GetSafeDataFloatRef)0;
			GameType = (int *)0x086C8F78;
			IsListed = (bool *)0x086C2BA8;
			Game_Mode_Find = (GameModeFind)0x0807FC90;
			SpawnCharGDI = (char *)0x086151D5;
			SpawnCharNod = (char *)0x086151C0;
			ObjectsAddress = (char *)0x08624DC8;
			PacketManager = (void *)0x08BB6420;
			Bandwidth_Out = (BandwidthOut)0x08370754;
			Mine_Limit = (char *)0x080FABCE;
			RenNew = (rennew)0x0804AA48;
			RenVecNew = (rennew)0x0804A7B8;
			RenDelete = (rendelete)0x0804A8F8;
			RenVecDelete = (rendelete)0x0804AA08;
			Get_Address = (GetAddress)0x08371194;
			Get_Remote_Host = (GetRemoteHost)0x0836B438;
			ServerConnection = (char **)0x086C0EDC;
			Game = (TheGame)0x0807CCD0;
			Find_Team = (FindTeam)0x080BFBD4;
			TallyTeamSize = (tts)0x080AA84C;
			Skirmish_Game = (TheSkirmishGame)0x0807CCF0;
			Cnc_Game = (TheCncGame)0x0807CD08;
			Single_Player_Game = (TheSinglePlayerGame)0x0807CCD8;
			Get_Safe_Data_Uint_Ref = (GetSafeDataUintRef)0;
			Set_Safe_Data_Uint_Ref = (SetSafeDataUintRef)0;
			Check_Transitions = (CheckTransitions)0x0817EDAC;
			Set_Transform = (SetTransform)0x0813DA90;
			Get_Transform = (GetTransform)0x0813DAAC;
			BuildingGameObjList = (SList<GameObject> *)0x08BA05FC;
			SmartGameObjList = (SList<GameObject> *)0x08BA05E4;
			BaseGameObjList = (SList<GameObject> *)0x08BA05D8;
			FindPlayer = (Find_Player)0x080A9CDC;
			FindNamedDef = (Find_Named_Def)0x0836557C;
			SoldierReInit = (ReInit)0x0815C23C;
			Post_ReInit = (PostReInit)0x081528EC;
			SetMaxHealth = (SetMax)0x08111B88;
			SetMaxShieldStrength = (SetMax)0x08111C9C;
			Grant_Supplies = (GrantSupplies)0x080C472C;
			Powerup_Grant = (PowerupGrant)0x08144268;
			Get_Armor_Name = (GetArmorName)0x0810F87C;
			Get_Armor_Type = (GetArmorType)0x0810F7B4;
			Mark_Owner_Dirty = (MarkOwnerDirty)0x08111D84;
			Is_Available_For_Purchase = (IsAvailable)0x0818C8C4;
			Request_Vehicle = (RequestVehicle)0x0818CAF0;
			ToggleFly = (ToggleFlyMode)0x08168740;
			Parse_Console_Input = (ConsoleInput)0x0805BBB8;
			Output_To_Console = (ConsoleOut)0x0805BF40;
			SetPlayerType = (spt)0x080A7438;
			GetPlayerCount = (gpc)0x080AA7F0;
		}
		break;
	case 3: //RH8
		{
			Get_Safe_Data_Int = (GetSafeDataInt)0;
			Get_Safe_Data_Float = (GetSafeDataFloat)0;
			Get_Safe_Data_Float_Ref = (GetSafeDataFloatRef)0;
			GameType = (int *)0x085F0670;
			IsListed = (bool *)0x085E9AB8;
			Game_Mode_Find = (GameModeFind)0x0807F36A;
			SpawnCharGDI = (char *)0x084FB353;
			SpawnCharNod = (char *)0x084FB33E;
			ObjectsAddress = (char *)0x0850CCAE;
			PacketManager = (void *)0x089D20E0;
			Bandwidth_Out = (BandwidthOut)0x083238EA;
			Mine_Limit = (char *)0x080EE422;
			RenNew = (rennew)0x08053B04;
			RenVecNew = (rennew)0x08053A14;
			RenDelete = (rendelete)0x08053434;
			RenVecDelete = (rendelete)0x08053A54;
			Get_Address = (GetAddress)0x08324566;
			Get_Remote_Host = (GetRemoteHost)0x0831E694;
			ServerConnection = (char **)0x085E7C2C;
			Game = (TheGame)0x0807C7A8;
			Find_Team = (FindTeam)0x080B82C4;
			TallyTeamSize = (tts)0x080A5AB6;
			Skirmish_Game = (TheSkirmishGame)0x0807C7C2;
			Cnc_Game = (TheCncGame)0x0807C7D6;
			Single_Player_Game = (TheSinglePlayerGame)0x0807C7AE;
			Get_Safe_Data_Uint_Ref = (GetSafeDataUintRef)0;
			Set_Safe_Data_Uint_Ref = (SetSafeDataUintRef)0;
			Check_Transitions = (CheckTransitions)0x08169ADC;
			Set_Transform = (SetTransform)0x0812DA3A;
			Get_Transform = (GetTransform)0x0812DA56;
			BuildingGameObjList = (SList<GameObject> *)0x089A9090;
			SmartGameObjList = (SList<GameObject> *)0x089A9078;
			BaseGameObjList = (SList<GameObject> *)0x089A906C;
			FindPlayer = (Find_Player)0x080A510A;
			FindNamedDef = (Find_Named_Def)0x0831890A;
			SoldierReInit = (ReInit)0x0814A676;
			Post_ReInit = (PostReInit)0x08140AB8;
			SetMaxHealth = (SetMax)0x08103C18;
			SetMaxShieldStrength = (SetMax)0x08103D2E;
			Grant_Supplies = (GrantSupplies)0x080BC8D8;
			Powerup_Grant = (PowerupGrant)0x081332C6;
			Get_Armor_Name = (GetArmorName)0x08101AB8;
			Get_Armor_Type = (GetArmorType)0x081019FC;
			Mark_Owner_Dirty = (MarkOwnerDirty)0x08103E20;
			Is_Available_For_Purchase = (IsAvailable)0x008175F7A;
			Request_Vehicle = (RequestVehicle)0x08176184;
			ToggleFly = (ToggleFlyMode)0x08155762;
			Parse_Console_Input = (ConsoleInput)0x08063F56;
			Output_To_Console = (ConsoleOut)0x080642B2;
			SetPlayerType = (spt)0x080A2E50;
			GetPlayerCount = (gpc)0x080A5A62;
		}
		break;
	case 4: //leveledit
		{
			Get_Safe_Data_Int = (GetSafeDataInt)0;
			Get_Safe_Data_Float = (GetSafeDataFloat)0;
			Get_Safe_Data_Float_Ref = (GetSafeDataFloatRef)0;
			SpawnCharGDI = (char *)0;
			SpawnCharNod = (char *)0;
			ObjectsAddress = (char *)0;
			PacketManager = (void *)0;
			Bandwidth_Out = (BandwidthOut)0;
			Mine_Limit = (char *)0;
			RenNew = (rennew)0x007A783D;
			RenVecNew = (rennew)0x007A783D;
			RenDelete = (rendelete)0x007A7866;
			RenVecDelete = (rendelete)0x007A7866;
			Get_Address = (GetAddress)0;
			Get_Remote_Host = (GetRemoteHost)0;
			ServerConnection = (char **)0;
			Game = (TheGame)0;
			Find_Team = (FindTeam)0;
			TallyTeamSize = (tts)0;
			Skirmish_Game = (TheSkirmishGame)0;
			Cnc_Game = (TheCncGame)0;
			Single_Player_Game = (TheSinglePlayerGame)0;
			Get_Safe_Data_Uint_Ref = (GetSafeDataUintRef)0;
			Set_Safe_Data_Uint_Ref = (SetSafeDataUintRef)0;
			Check_Transitions = (CheckTransitions)0;
			Set_Transform = (SetTransform)0;
			Get_Transform = (GetTransform)0;
			BuildingGameObjList = (SList<GameObject> *)0;
			SmartGameObjList = (SList<GameObject> *)0;
			BaseGameObjList = (SList<GameObject> *)0;
			FindPlayer = (Find_Player)0;
			FindNamedDef = (Find_Named_Def)0;
			SoldierReInit = (ReInit)0;
			Post_ReInit = (PostReInit)0;
			SetMaxHealth = (SetMax)0;
			SetMaxShieldStrength = (SetMax)0;
			Grant_Supplies = (GrantSupplies)0;
			Powerup_Grant = (PowerupGrant)0;
			Get_Armor_Name = (GetArmorName)0;
			Get_Armor_Type = (GetArmorType)0;
			Mark_Owner_Dirty = (MarkOwnerDirty)0;
			Is_Available_For_Purchase = (IsAvailable)0;
			Request_Vehicle = (RequestVehicle)0;
			ToggleFly = (ToggleFlyMode)0;
			Parse_Console_Input = (ConsoleInput)0;
			Output_To_Console = (ConsoleOut)0;
			SetPlayerType = (spt)0;
			GetPlayerCount = (gpc)0;
		}
		break;
	}
}

GameObject *As_ScriptableGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x30]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x34;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x38;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_PhysicalGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x24]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x28;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x2C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_CinematicGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x98]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xC0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0xA0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_VehicleGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x28]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x2C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x30;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_SmartGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x2C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x30;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x34;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_DamageableGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x3C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x4C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x44;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_SoldierGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x44]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x54;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x4C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_ScriptZoneGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x48]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x58;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x50;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_BuildingGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,[ecx]
		mov eax,[ebx+0x40]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x50;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x48;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

const char *Get_Model(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return "DUMMY";
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return "DUMMY";
	}
#ifdef WIN32
	_asm {
		mov eax,o
		mov ebx,[eax+0x774]
		mov ecx,[ebx+0x3C]
		mov eax,[ecx]
		mov ebx,[eax+0x10]
		call ebx
	}
#else
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
	p+=0x54;
	char *r = (char *)*(unsigned int *)p;
#ifndef RH8
	r += 0x1C;
#endif
	char *v = (char *)*(unsigned int *)r;
#ifndef RH8
	r -= 0x1C;
	v += 4;
#endif
	v += 0x14;
	Get_Name *n = (Get_Name*)v;
	Get_Name gn = (Get_Name)*n;
	return gn(r);
#endif
}

int Get_Object_Type(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return 0;
	}
	char *c = (char *)obj;
	c += 0x764;
	return *(int *)c;
}

void Set_Object_Type(GameObject *obj,int type)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return;
	}
	char *c = (char *)obj;
	c += 0x764;
	int *x = (int *)c;
	*x = type;
}

DefinitionClass *Get_Definition(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	char *c = (char *)obj;
	c += 0x6BC;
	return (DefinitionClass *)*(DefinitionClass **)c;
}

DefinitionClass *Get_Phys_Definition(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return 0;
	}
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
#ifdef WIN32
	p += 0x50;
#else
	p += 0x68;
#endif
	return (DefinitionClass *)*(unsigned int *)p;
}

int Get_Class_ID(DefinitionClass *def)
{
#ifdef WIN32
	_asm {
		mov ecx,def
		mov eax,[ecx]
		mov ebx,[eax+0x20]
		call ebx
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)def;
	c += 0x24;
	Get_ClassID *gcid = (Get_ClassID *)c;
	Get_ClassID cid = *gcid;
	return cid(def);
#else
	DefinitionClass *d = def + 4;
	char *c = (char *)*(unsigned int *)d;
	c += 0x28;
	Get_ClassID *gcid = (Get_ClassID *)c;
	Get_ClassID cid = *gcid;
	return cid(def);
#endif
}

const char *Get_Definition_Name(DefinitionClass *def)
{
	char *c = (char *)def;
	c += 0x0C;
	return (const char *)*(unsigned int *)c;
}

unsigned int Get_Definition_ID(DefinitionClass *def)
{
	char *c = (char *)def;
	c += 0x10;
	return (unsigned int)*(unsigned int *)c;
}

void Soldier_Re_Init(GameObject *obj,DefinitionClass *def)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov eax,def
		mov ebx,SoldierReInit
		push eax
		call ebx
	}
#else
	SoldierReInit(obj,def);
#endif
}

DefinitionClass *Find_Named_Definition(const char *name)
{
	return FindNamedDef(name,1);
}

void Post_Re_Init(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ecx,obj
		mov ebx,Post_ReInit
		call ebx
	}
#else
	Post_ReInit(obj);
#endif
}

bool Change_Character(GameObject *obj,const char *Preset_Name)
{
	if (!Commands->Get_ID(obj) || !obj || Get_Vehicle(obj))
	{
		return false;
	}
	DefinitionClass *def = Find_Named_Definition(Preset_Name);
	if (!def)
	{
		return false;
	}
	if (Get_Class_ID(def) != 0x3001)
	{
		return false;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (!o)
	{
		return false;
	}
	Soldier_Re_Init(o,def);
	Post_Re_Init(o);
	return true;
}

const char *WideCharToChar(const wchar_t *wcs)
{
	int length = wcslen(wcs);
	char *text = new char[length+1];
	wcstombs(text,wcs,length+1);
	return text;
}

const char *Get_Player_Name(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_SoldierGameObj(obj);
	char *c = (char *)o;
	if (!o)
	{
		return 0;
	}
	c += 0x960;
	char *x = (char *)*(unsigned int *)c;
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x754;
#else
	x += 0x758;
#endif
	return WideCharToChar((const wchar_t *)*(unsigned int *)x);
}

const char *Get_Player_Name_By_ID(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x754;
#else
	x += 0x758;
#endif
	return WideCharToChar((const wchar_t *)*(unsigned int *)x);
}

void Change_Team_By_ID(int ID,int Team)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ebx,SetPlayerType
		mov ecx,x
		push Team
		call ebx
	}
#else
	SetPlayerType(x,Team);
#endif
	GameObject *obj = Get_GameObj(ID);
	Commands->Destroy_Object(obj);
}

void Change_Team(GameObject *obj,int Team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (!o)
	{
		return;
	}
	char *c = (char *)o;
	c += 0x960;
	unsigned char *x = (unsigned char *)*(unsigned int *)c;
	if (!x)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ebx,SetPlayerType
		mov ecx,x
		push Team
		call ebx
	}
#else
	SetPlayerType(x,Team);
#endif
	Commands->Destroy_Object(obj);
}

int Get_Player_Count()
{
	return GetPlayerCount();
}

long Get_Player_ID(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return -1;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (!o)
	{
		return -1;
	}
	char *c = (char *)o;
	c += 0x960;
	char *x = (char *)*(unsigned int *)c;
	if (!x)
	{
		return -1;
	}
#ifdef RH8
	x += 0x758;
#else
	x += 0x75C;
#endif
	return (long)*(unsigned long*)x;
}

GameObject *Get_GameObj(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (x)
	{
#ifdef WIN32
		unsigned char *playerdata = (unsigned char *)x + 0x14;
#elif defined RH8
		unsigned char *playerdata = (unsigned char *)x + 0x14;
#else
		unsigned char *playerdata = (unsigned char *)x + 0x10;
#endif
		unsigned char *y = (unsigned char*)*((unsigned char **)playerdata);
		if (!y)
		{
			return 0;
		}
		y += 4;
		GameObject *z = (GameObject *)*(GameObject **)y;
		return z;
	}
	else 
	{
		return 0;
	}
}

GameObject *Find_Building_By_Class_ID(int Team,int Class_ID)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			DefinitionClass *d = Get_Definition(o);
			if (Get_Class_ID(d) == Class_ID)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Building_By_Team(int Team)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Building_By_Name(int Team,const char *Preset_Name)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),Preset_Name))
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

void Kill_All_Buildings_By_Team(int Team)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if (Get_Object_Type(o) == Team)
			{
				Commands->Apply_Damage(o,10000,"Explosive",0);
			}
		}
		x = x->NodeNext;
	}
}

void Damage_All_Buildings_By_Team(int Team,float Damage,const char *Warhead,GameObject *Damager)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == Team) || (Team == 2))
			{
				Commands->Apply_Damage(o,Damage,Warhead,Damager);
			}
		}
		x = x->NodeNext;
	}
}

void Repair_All_Buildings_By_Team(int Team,int ConstructionYardID,float Health)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == Team) && (Commands->Get_ID(o) != ConstructionYardID))
			{
				float amount = Commands->Get_Health(o);
				if (amount>0)
				{
					Commands->Set_Health(o,(amount+Health));
				}
			}
		}
		x = x->NodeNext;
	}
}

void Repair_All_Static_Vehicles_By_Team(int Team,int Message)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_VehicleGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if (Get_Object_Type(o) == Team && Is_DecorationPhys(o))
			{
				Commands->Send_Custom_Event(o,o,Message,0,0);
			}
		}
		x = x->NodeNext;
	}
	return;
}

GameObject *Find_Smart_Object_By_Team(int Team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Object_By_Team(int Team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			if (Get_Object_Type(o) == Team)
			{
				return o;
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Non_Player_Object_By_Team(int Team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == Team) && (!Commands->Is_A_Star(o)))
			{
				return o;
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Object_By_Preset(int Team,const char *Preset_Name)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),Preset_Name))
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

GameObject *Find_Power_Plant(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD003);
}

GameObject *Find_Refinery(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD002);
}

GameObject *Find_Repair_Bay(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD009);
}

GameObject *Find_Soldier_Factory(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD004);
}

GameObject *Find_Airstrip(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD006);
}

GameObject *Find_War_Factory(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD007);
}

GameObject *Find_Vehicle_Factory(int Team)
{
	GameObject *o = Find_Airstrip(Team);
	if (o)
	{
		return o;
	}
	return Find_War_Factory(Team);
}

GameObject *Find_Com_Center(int Team)
{
	return Find_Building_By_Class_ID(Team,0xD008);
}

bool Is_Building(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_BuildingGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Soldier(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_SoldierGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Vehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_VehicleGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Cinematic(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_CinematicGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_ScriptZone(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_ScriptZoneGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_TrackedVehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900C)
	{
		return false;
	}
	return true;
}

bool Is_VTOLVehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900D)
	{
		return false;
	}
	return true;
}

bool Is_WheeledVehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9006)
	{
		return false;
	}
	return true;
}

bool Is_Motorcycle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9002)
	{
		return false;
	}
	return true;
}

bool Is_Door(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9080)
	{
		return false;
	}
	return true;
}

bool Is_Elevator(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9081)
	{
		return false;
	}
	return true;
}

bool Is_DamageableStaticPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9082)
	{
		return false;
	}
	return true;
}

bool Is_AccessablePhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9010)
	{
		return false;
	}
	return true;
}

bool Is_DecorationPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9000)
	{
		return false;
	}
	return true;
}

bool Is_HumanPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9001)
	{
		return false;
	}
	return true;
}

bool Is_MotorVehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9003)
	{
		return false;
	}
	return true;
}

bool Is_Phys3(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9004)
	{
		return false;
	}
	return true;
}

bool Is_RigidBody(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9005)
	{
		return false;
	}
	return true;
}

bool Is_ShakeableStatricPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900F)
	{
		return false;
	}
	return true;
}

bool Is_StaticAnimPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9008)
	{
		return false;
	}
	return true;
}

bool Is_StaticPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9007)
	{
		return false;
	}
	return true;
}

bool Is_TimedDecorationPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900A)
	{
		return false;
	}
	return true;
}

bool Is_VehiclePhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900B)
	{
		return false;
	}
	return true;
}

bool Is_DynamicAnimPhys(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x900E)
	{
		return false;
	}
	return true;
}

bool Is_BuildingAggregate(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9083)
	{
		return false;
	}
	return true;
}

bool Is_Projectile(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return false;
	}
	int Class_ID = Get_Class_ID(Get_Phys_Definition(o));
	if (Class_ID != 0x9009)
	{
		return false;
	}
	return true;
}

void Set_Max_Health(GameObject *obj,float health)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	_asm {
		mov ecx,def
		mov eax,health
		mov ebx,SetMaxHealth
		push eax
		call ebx
	}
#else
	SetMaxHealth(def,health);
#endif
	Commands->Set_Health(obj,health);
}

void Set_Max_Shield_Strength(GameObject *obj,float shieldstrength)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	_asm {
		mov ecx,def
		mov eax,shieldstrength
		mov ebx,SetMaxShieldStrength
		push eax
		call ebx
	}
#else
	SetMaxShieldStrength(def,shieldstrength);
#endif
	Commands->Set_Shield_Strength(obj,shieldstrength);
}

GameObject *Find_First_Player(int Team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_SoldierGameObj(o))
		{
			if (Commands->Is_A_Star(o))
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					return o;
				}
			}
		}
		x = x->NodeNext;
	}
	return 0;
}

//doesnt work for CinematicGameObjs
float Get_Animation_Frame(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return 0;
	}
	unsigned char *c = o+0x778;
	unsigned char *x = *(unsigned char **)c;
	float a = (float)*(float *)(x+0x14);
	return a;
}

void Grant_Refill(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (o)
	{
		Grant_Supplies(obj);
	}
}

void Grant_Powerup(GameObject *obj,const char *Preset_Name)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_SmartGameObj(obj);
	if (o)
	{
		DefinitionClass *def = Find_Named_Definition(Preset_Name);
#ifdef WIN32
		_asm {
			mov ecx,def
			mov eax,o
			mov ebx,Powerup_Grant
			push 1
			push 0
			push eax
			call ebx
		}
#else
		Powerup_Grant(def,o,0,true);
#endif
	}
}

GameObject *Get_Vehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (o)
	{
		char *c = (char *)o;
		c += 0x98C;
		unsigned long *l = (unsigned long *)c;
		GameObject *vehicle = (GameObject *)*l;
		if (vehicle)
		{
			GameObject *v = As_VehicleGameObj(vehicle);
			return v;
		}
		return 0;
	}
	return 0;
}

const char *Get_Shield_Type(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return "";
	}
	unsigned int *i;
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return "";
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	def+=0x6;
	void *def2 = (void *)*def;
	Get_Safe_Data_Uint_Ref(def2,i);
	return Get_Armor_Name(*i);
#else
#ifdef RH8
	def+=0x6;
#else
	def+=0x5;
#endif
	unsigned int *def2 = (unsigned int *)def;
	return Get_Armor_Name(*def2);
#endif
}

const char *Get_Skin(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return "";
	}
	unsigned int *i;
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return "";
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	def+=0x3;
	void *def2 = (void *)*def;
	Get_Safe_Data_Uint_Ref(def2,i);
	return Get_Armor_Name(*i);
#else
#ifdef RH8
	def+=0x3;
#else
	def+=0x2;
#endif
	unsigned int *def2 = (unsigned int *)def;
	return Get_Armor_Name(*def2);
#endif
}

void Set_Skin(GameObject *obj,const char *Skintype)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
	unsigned int *defx = def;
	unsigned int skin = Get_Armor_Type(Skintype);
#ifdef WIN32
	def+=0x3;
	void *def2 = (void *)*def;
	Set_Safe_Data_Uint_Ref(def2,skin);
#else
#ifdef RH8
	def+=0x3;
#else
	def+=0x2;
#endif
	unsigned int *sk = (unsigned int *)def;
	*sk = skin;
#endif
#ifdef WIN32
	_asm {
		mov ecx,defx
		mov ebx,Mark_Owner_Dirty
		call ebx
	}
#else
	Mark_Owner_Dirty(defx);
#endif
}

void Create_Vehicle(const char *Preset_Name,float Delay,GameObject *Owner,int Team)
{
	GameObject *o = 0;
	if (Owner)
	{
		o = As_SoldierGameObj(Owner);
	}
	DefinitionClass *def = Find_Named_Definition(Preset_Name);
	if (def)
	{
		if (!Get_Vehicle(o))
		{
			GameObject *factory = Find_Vehicle_Factory(Team);
			if (factory)
			{
				bool IsAvail;
#ifdef WIN32
				_asm {
					mov ecx,factory
					mov ebx,Is_Available_For_Purchase
					call ebx
					mov IsAvail,al;
				}
#else
				IsAvail = Is_Available_For_Purchase(factory);
#endif
				if (IsAvail)
				{
					unsigned int ID = Get_Definition_ID(def);
#ifdef WIN32
					_asm {
						mov ecx,factory
						mov ebx,Request_Vehicle
						mov eax,o
						push eax
						mov eax,Delay
						push eax
						mov eax,ID
						push eax
						call ebx
					}
#else
					Request_Vehicle(factory,ID,Delay,o);
#endif
				}
			}
		}
	}
}

void Toggle_Fly_Mode(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (o)
	{
#ifdef WIN32
		_asm {
			mov ecx,o
			mov ebx,ToggleFly
			call ebx
		}
#else
		ToggleFly(o);
#endif
		Commands->Enable_Collisions(o);
	}
}

void Console_Input(const char *Input)
{
	Parse_Console_Input(Input);
}

void Console_Output(const char *Output)
{
	Output_To_Console(Output);
}

GameObject *As_PowerupGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x88]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x90;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_C4GameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x8C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_BeaconGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x90]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB8;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x98;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_ArmedGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x94]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xBC;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x9C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_SimpleGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_PhysicalGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x9C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xC4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0xA4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_PowerPlantGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x70]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x78;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_SoldierFactoryGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x74]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x98;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x7C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_VehicleFactoryGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x78]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0x9C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x80;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_AirstripGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x7C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x84;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_WarFactoryGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x80]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA4;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x88;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_RefineryGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x84]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xA8;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x8C;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_ComCenterGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x88]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xAC;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x90;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

GameObject *As_RepairBayGameObj(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o2 = As_BuildingGameObj(obj);
	if (!o2)
	{
		return 0;
	}
#ifdef WIN32
	_asm {
		mov ecx,o2
		mov ebx,[ecx]
		mov eax,[ebx+0x8C]
		call eax
	}
#elif defined RH8
	char *c = (char *)*(unsigned int *)obj;
	c += 0xB0;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#else
	GameObject *o = obj + 4;
	char *c = (char *)*(unsigned int *)o;
	c += 0x94;
	ago *t = (ago *)c;
	ago agox = *t;
	return agox(obj);
#endif
}

bool Is_Powerup(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_PowerupGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_C4(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_C4GameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Beacon(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_BeaconGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Armed(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_ArmedGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Simple(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_SimpleGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_PowerPlant(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_PowerPlantGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_SoldierFactory(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_SoldierFactoryGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_VehicleFactory(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_VehicleFactoryGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Airstrip(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_AirstripGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_WarFactory(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_WarFactoryGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_Refinery(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_RefineryGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_ComCenter(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_ComCenterGameObj(obj))
	{
		return true;
	}
	return false;
}

bool Is_RepairBay(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if (As_RepairBayGameObj(obj))
	{
		return true;
	}
	return false;
}

void Damage_All_Objects_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager) 
{
	if (!Commands->Get_ID(Host) || !Host)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) 
	{
		GameObject *obj = (GameObject *)x->NodeData;
		if (obj && As_ScriptableGameObj(obj)) 
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance) && (Commands->Get_ID(obj) != Commands->Get_ID(Host)))
			{
				Commands->Apply_Damage(obj,Damage,Warhead,Damager);
			}
		}
		x = x->NodeNext;
	}
}

void Damage_All_Vehicles_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager)
{
	if (!Commands->Get_ID(Host) || !Host)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) 
	{
		GameObject *obj = As_VehicleGameObj((GameObject *)x->NodeData);
		if (obj && As_ScriptableGameObj(obj)) 
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance) && (Commands->Get_ID(obj) != Commands->Get_ID(Host)))
			{
				Commands->Apply_Damage(obj,Damage,Warhead,Damager);
			}
		}
		x = x->NodeNext;
	}
}

int Get_Team_Player_Count(int Team)
{
	int Total = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SoldierGameObj((GameObject *)x->NodeData);
		if (o && Get_Object_Type(o) == Team)
		{
			Total ++;
		}
		x = x->NodeNext;
	}
	return Total;
}

const char *Get_Building_Type(GameObject *obj)
{
	if (Is_PowerPlant(obj))
	{
		return "Is_PowerPlant";
	}
	else if (Is_SoldierFactory(obj))
	{
		return "Is_SoldierFactory";
	}
	else if (Is_VehicleFactory(obj))
	{
		if (Is_Airstrip(obj))
		{
			return "Is_Airstrip";
		}
		else if (Is_WarFactory(obj))
		{
			return "Is_WarFactory";
		}
	}
	else if (Is_Refinery(obj))
	{
		return "Is_Refinery";
	}
	else if (Is_ComCenter(obj))
	{
		return "Is_ComCenter";
	}
	else if (Is_RepairBay(obj))
	{
		return "Is_RepairBay";
	}
	else
	{
		return "(null)";
	}
	return "(null)";
}

const char *Get_Physics(GameObject *obj)
{
	if (Is_Door(obj)) return "Is_Door";
	else if (Is_Elevator(obj)) return "Is_Elevator";
	else if (Is_DamageableStaticPhys(obj)) return "Is_DamageableStaticPhys";
	else if (Is_AccessablePhys(obj)) return "Is_AccessablePhys";
	else if (Is_DecorationPhys(obj)) return "Is_DecorationPhys";
	else if (Is_HumanPhys(obj)) return "Is_HumanPhys";
	else if (Is_MotorVehicle(obj)) return "Is_MotorVehicle";
	else if (Is_Phys3(obj)) return "Is_Phys3";
	else if (Is_RigidBody(obj)) return "Is_RigidBody";
	else if (Is_ShakeableStatricPhys(obj)) return "Is_ShakeableStatricPhys";
	else if (Is_StaticAnimPhys(obj)) return "Is_StaticAnimPhys";
	else if (Is_StaticPhys(obj)) return "Is_StaticPhys";
	else if (Is_TimedDecorationPhys(obj)) return "Is_TimedDecorationPhys";
	else if (Is_VehiclePhys(obj)) return "Is_VehiclePhys";
	else if (Is_DynamicAnimPhys(obj)) return "Is_DynamicAnimPhys";
	else if (Is_BuildingAggregate(obj)) return "Is_BuildingAggregate";
	else if (Is_Projectile(obj)) return "Is_Projectile";
	else return "(null)";
}

void Disarm_Nearest_Beacon(GameObject *Host,int Team,bool Nearest)
{
	if (!Commands->Get_ID(Host) || !Host)
	{
		return;
	}
	Vector3 HostPos = Commands->Get_Position(Host);
	HostPos.Z = 0;
	float NearestDistanceFound = 5000.0f;
	GameObject *ClosestBeacon = Commands->Create_Object("Invisible_Object",HostPos);
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_BeaconGameObj(o))
		{
			if (Team == 2)
			{
				if (Nearest)
				{
					Vector3 BeaconPos = Commands->Get_Position(o);
					BeaconPos.Z = 0;
					if (Commands->Get_Distance(BeaconPos,HostPos) < NearestDistanceFound)
					{
						NearestDistanceFound = Commands->Get_Distance(BeaconPos,HostPos);
						ClosestBeacon = o;
					}
				}
				else
				{
					Commands->Apply_Damage(o,99999,"Death",0);
				}
			}
			else if (Get_Object_Type(o) == Team)
			{
				if (Nearest)
				{
					Vector3 BeaconPos = Commands->Get_Position(o);
					BeaconPos.Z = 0;
					if (Commands->Get_Distance(BeaconPos,HostPos) < NearestDistanceFound)
					{
						NearestDistanceFound = Commands->Get_Distance(BeaconPos,HostPos);
						ClosestBeacon = o;
					}
				}
				else 
				{
					Commands->Apply_Damage(o,99999,"Death",0);
				}
			}
		}
		x = x->NodeNext;
	}
	if (Nearest && ClosestBeacon && As_BeaconGameObj(ClosestBeacon))
	{
		Commands->Apply_Damage(ClosestBeacon,99999,"Death",0);
	}
}

bool Change_Player_Team(GameObject *obj,bool Retain_Score,bool Retain_Money,bool Show_Host_Message)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	float Score = Commands->Get_Points(obj);
	float Credits = Commands->Get_Money(obj);
	Commands->Give_Points(obj,(Score*-1),false);
	if (Score < 0)
	{
		Commands->Give_Money(obj,Score,false);
	}
	Commands->Give_Money(obj,(Credits*-1),false);
	if (!Commands->Get_Player_Type(obj))
	{
		Change_Team(obj,1);
	}
	else if (Commands->Get_Player_Type(obj) == 1)
	{
		Change_Team(obj,0);
	}
	if (Retain_Score)
	{
		Commands->Give_Points(obj,Score,false);
		if (Score > 0)
		{
			Commands->Give_Money(obj,(Score*-1),false);
		}
	}
	if (Retain_Money)
	{
		Commands->Give_Money(obj,Credits,false);
	}
	if (!As_SoldierGameObj(obj))
	{
		return false;
	}
	else if (Show_Host_Message)
	{
		char outputmsg[100];
		sprintf(outputmsg,"msg %s switched teams",Get_Player_Name_By_ID(Get_Player_ID(obj)));
		Console_Input(outputmsg);
	}
	return true;
}

void Ranged_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				float health = Commands->Get_Health(o);
				if (health > 0)
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if (Distance <= DamageRadius)
					{
						Commands->Apply_Damage(o,Damage,Warhead,Damager);
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Ranged_Scale_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		float Ratio = Damage/DamageRadius;

		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				float health = Commands->Get_Health(o);
				if (health > 0)
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if (Distance <= DamageRadius)
					{
						float scaledamage = (Damage - (Distance*(Ratio)));
						Commands->Apply_Damage(o,scaledamage,Warhead,Damager);
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Ranged_Percentage_Damage_To_Buildings(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				float health = Commands->Get_Health(o);
				if (health > 0)
				{
					Vector3 pos1 = Commands->Get_Position(o);
					Vector3 pos2 = Location;

					float Distance = Commands->Get_Distance(pos1,pos2);

					if (Distance <= DamageRadius)
					{
						float Max_Health = Commands->Get_Max_Health(o);
						float Damage = Max_Health*Percentage;
						Commands->Apply_Damage(o,Damage,Warhead,Damager);
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Ranged_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if (health > 0)
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if (Distance <= DamageRadius)
						{
							Commands->Apply_Damage(o,Damage,Warhead,Damager);
						}
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Ranged_Scale_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		float Ratio = Damage/DamageRadius;

		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if (health > 0)
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if (Distance <= DamageRadius)
						{
							float scaledamage = (Damage - (Distance*(Ratio)));
							Commands->Apply_Damage(o,scaledamage,Warhead,Damager);
						}
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Ranged_Percentage_Damage_To_Buildings_Team(int Team,float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if (DamageRadius > 0)
	{
		GenericSLNode *x = BuildingGameObjList->HeadNode;
		while (x)
		{
			GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
			if (o)
			{
				if ((Get_Object_Type(o) == Team) || (Team == 2))
				{
					float health = Commands->Get_Health(o);
					if (health > 0)
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;
						float Distance = Commands->Get_Distance(pos1,pos2);
						if (Distance <= DamageRadius)
						{
							float Max_Health = Commands->Get_Max_Health(o);
							float Damage = Max_Health*Percentage;
							Commands->Apply_Damage(o,Damage,Warhead,Damager);
						}
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

void Send_Custom_To_Team_Buildings(int Team,GameObject *sender,int message,int param,float delay)
{
	if (!Commands->Get_ID(sender) || !sender)
	{
		return;
	}
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if (Get_Object_Type(o) == Team)
			{
				int ReceiverID = Commands->Get_ID(o);
				int SenderID = Commands->Get_ID(sender);
				if (SenderID != ReceiverID)
				{
					Commands->Send_Custom_Event(sender,o,message,param,delay);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Send_Custom_To_Team_Preset(int Team,const char *PresetName,GameObject *sender,int message,int param,float delay)
{
	if (!Commands->Get_ID(sender) || !sender)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			if (Get_Object_Type(o) == Team)
			{
				if (!stricmp(Commands->Get_Preset_Name(o),PresetName))
				{
					Commands->Send_Custom_Event(sender,o,message,param,delay);
				}
			}
		}
		x = x->NodeNext;
	}
}

#ifndef BHS
void Set_Occupants_Fade(GameObject *obj,float red,float green,float blue,float opacity)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	if (!As_VehicleGameObj(obj))
	{
		return;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	int x = occupants.Length();
	for (int i = 0;i < x;i++)
	{
		if (occupants[i])
		{
			Set_Screen_Fade_Color_Player(occupants[i],red,green,blue,0);
			Set_Screen_Fade_Opacity_Player(occupants[i],opacity,0);
		}
	}
}

void Enable_Team_Radar(int Team,bool Enable)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == Team) || (Team == 2))
			{
				Enable_Radar_Player(o,Enable);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Create_Sound_Team(const char *soundname,const Vector3 & position,GameObject *obj,int team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Create_Sound_Player(o,soundname,position,obj);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Create_2D_Sound_Team(const char *soundname,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Create_2D_Sound_Player(o,soundname);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Create_2D_WAV_Sound_Team(const char *soundname,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Create_2D_WAV_Sound_Player(o,soundname);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Create_3D_WAV_Sound_At_Bone_Team(const char *soundname,GameObject *obj,const char *bonename,int team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Create_3D_WAV_Sound_At_Bone_Player(o,soundname,obj,bonename);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Create_3D_Sound_At_Bone_Team(const char *soundname,GameObject *obj,const char *bonename,int team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Create_3D_Sound_At_Bone_Player(o,soundname,obj,bonename);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Set_Display_Color_Team(unsigned char red,unsigned char green,unsigned char blue,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Set_Display_Color_Player(o,red,green,blue);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Display_Text_Team(int strnum,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Display_Text_Player(o,strnum);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Display_Int_Team(int num,const char *msg,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Display_Int_Player(o,num,msg);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Display_Float_Team(float num,const char *msg,int team)
{
	GenericSLNode *x = SmartGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_SmartGameObj((GameObject *)x->NodeData);
		if (o)
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Display_Float_Player(o,num,msg);
			}
		}
		x = x->NodeNext;
	}
	return;
}

void Remove_Script(GameObject *obj,const char *script)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	void *ptr = (void *)(obj+0x6EC);
	SimpleDynVecClass<GameObjObserverClass *> *observers = (SimpleDynVecClass<GameObjObserverClass *>*)ptr;
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		if (!stricmp((*observers)[i]->Get_Name(),script))
		{
			((ScriptImpClass*)(*observers)[i])->Destroy_Script();
		}
	}
}

void Remove_Duplicate_Script(GameObject *obj, const char *script)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	void *ptr = (void *)(obj+0x6EC);
	SimpleDynVecClass<GameObjObserverClass *>* observers = (SimpleDynVecClass<GameObjObserverClass *>*)ptr;
	bool Found = false;
	for (int i = 0;i < observers->Count();i++)
	{
		if (!stricmp((*observers)[i]->Get_Name(),script))
		{
			if (!Found)
			{
				Found = true;
			}
			else
			{
				((ScriptImpClass*)(*observers)[i])->Destroy_Script();
			}
		}
	}
}

void Remove_Script_Preset(const char *script,const char *preset,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),preset))
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					Remove_Script(o,script);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Remove_Script_Type(const char *script,int type,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (Get_Class_ID(d) == type)
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					Remove_Script(o,script);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Remove_All_Scripts(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	void *ptr = (void *)(obj+0x6EC);
	SimpleDynVecClass<GameObjObserverClass *> *observers = (SimpleDynVecClass<GameObjObserverClass *>*)ptr;
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		((ScriptImpClass*)(*observers)[i])->Destroy_Script();
	}
}
#endif

int Get_Vehicle_Occupant_Count(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	int count = 0;
	int x = occupants.Length();
	for (int i = 0;i < x;i++)
	{
		if (occupants[i])
		{
			count++;
		}
	}
	return count;
}

GameObject *Get_Vehicle_Occupant(GameObject *obj,int seat)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	if (seat >= occupants.Length())
	{
		return 0;
	}
	return occupants[seat];
}

GameObject *Get_Vehicle_Driver(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	if (occupants.Length() <= 0)
	{
		return 0;
	}
	return occupants[0];
}

GameObject *Get_Vehicle_Gunner_Pos(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	if (occupants.Length() <= 1)
	{
		return 0;
	}
	return occupants[1];
}

GameObject *Get_Vehicle_Gunner(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	GameObject *o = Get_Vehicle_Gunner_Pos(obj);
	if ((!o) || (*(bool *)(obj+0x994)))
	{
		o = Get_Vehicle_Driver(obj);
	}
	return o;
}

void Attach_Script_Preset(const char *script,const char *params,const char *preset,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),preset))
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					Commands->Attach_Script(o,script,params);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_Type(const char *script,const char *params,int type,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (Get_Class_ID(d) == type)
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					Commands->Attach_Script(o,script,params);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Copy_Transform(GameObject *in,GameObject *out)
{
	if (!Commands->Get_ID(in) || !in || !Commands->Get_ID(out) || !out)
	{
		return;
	}
	GameObject *i2 = As_PhysicalGameObj(in);
	if (!i2)
	{
		return;
	}
	GameObject *o2 = As_PhysicalGameObj(out);
	if (!o2)
	{
		return;
	}
#ifdef WIN32
	_asm {
		mov ecx,i2
		mov ebx,Get_Transform
		call ebx
		push eax
		mov ecx,o2
		mov ebx,Set_Transform
		call ebx
	}
#else
	Set_Transform(o2,Get_Transform(i2));
#endif
}

const char *Get_Current_Weapon(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_ArmedGameObj(obj);
	if (!o)
	{
		return 0;
	}
	WeaponBagClass *w = *(WeaponBagClass **)(o+0x7B0);
	if (w->current)
	{
		return Get_Definition_Name((DefinitionClass *)*(w->Vector[w->current]));
	}
	return 0;
}

int Get_Weapon_Count(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_ArmedGameObj(obj);
	if (!o)
	{
		return 0;
	}
	WeaponBagClass *w = *(WeaponBagClass **)(o+0x7B0);
	return w->Vector.Count();
}

const char *Get_Weapon(GameObject *obj,int position)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_ArmedGameObj(obj);
	if (!o)
	{
		return 0;
	}
	WeaponBagClass *w = *(WeaponBagClass **)(o+0x7B0);
	if (w->Vector[position])
	{
		return Get_Definition_Name((DefinitionClass *)*(w->Vector[position]));
	}
	return 0;
}

bool Has_Weapon(GameObject *obj,const char *weapon)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_ArmedGameObj(obj);
	if (!o)
	{
		return false;
	}
	WeaponBagClass *w = *(WeaponBagClass **)(o+0x7B0);
	int x = w->Vector.Count();
	for (int i = 0;i < x;i++)
	{
		if (w->Vector[i])
		{
			if (!stricmp(Get_Definition_Name((DefinitionClass *)*(w->Vector[i])),weapon))
			{
				return true;
			}
		}
	}
	return false;
}

float Get_Mass(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return 0;
	}
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
#ifdef WIN32
	p += 0x84;
#else
#ifndef RH8
	p += 0xA0;
#else
	p += 0x9C;
#endif
#endif
	return *(float *)p;
}

const char *Get_Htree_Name(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return "DUMMY";
	}
	GameObject *o = As_PhysicalGameObj(obj);
	if (!o)
	{
		return "DUMMY";
	}
#ifdef WIN32
	_asm {
		mov eax,o
		mov ebx,[eax+0x774]
		mov ecx,[ebx+0x3C]
		mov eax,[ecx]
		mov ebx,[eax+0xC8]
		call ebx
	}
#else
	o+=0x774;
	char *p = (char *)*(unsigned int *)o;
	p+=0x54;
	char *r = (char *)*(unsigned int *)p;
#ifndef RH8
	r += 0x1C;
#endif
	char *v = (char *)*(unsigned int *)r;
#ifndef RH8
	r -= 0x1C;
	v += 4;
#endif
	v += 0xCC;
	Get_Htree *h = (Get_Htree*)v;
	Get_Htree gh = (Get_Htree)*h;
	const char *c = gh(r);
	return c;
#endif
}

char Get_Sex(GameObject *obj)
{
	return Get_Htree_Name(obj)[2];
}

void Force_Occupant_Exit(GameObject *obj,int seat)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	if (seat >= occupants.Length())
	{
		return;
	}
	if (occupants[seat])
	{
		Check_Transitions(occupants[seat],true);
	}
}

void Force_Occupants_Exit(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	int x = occupants.Length();
	for (int i = 0;i < x;i++)
	{
		if (occupants[i])
		{
			Check_Transitions(occupants[i],true);
		}
	}
}

void Damage_Objects_Half()
{
	GenericSLNode *z = BaseGameObjList->HeadNode;
	while (z)
	{
		GameObject *obj = (GameObject *)z->NodeData;
		if (obj)
		{
			if (As_SoldierGameObj(obj) || As_VehicleGameObj(obj))
			{
				float Health = Commands->Get_Max_Health(obj) + Commands->Get_Max_Shield_Strength(obj);
				Commands->Apply_Damage(obj,(Health / 2),"None",0);
			}
		}
		z = z->NodeNext;
	}
}

GameObject *Get_Vehicle_Return(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return obj;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (o)
	{
		char *c = (char *)o;
		c += 0x98C;
		unsigned long *l = (unsigned long *)c;
		GameObject *vehicle = (GameObject *)*l;
		if (vehicle)
		{
			GameObject *v = As_VehicleGameObj(vehicle);
			return v;
		}
		return obj;
	}
	return obj;
}

int Get_Beacon_Count(int Team)
{
	int Total = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_BeaconGameObj(o))
		{
			if (Team == 2)
			{
				Total++;
			}
			else if (Get_Object_Type(o) == Team)
			{
				Total++;
			}
		}
		x = x->NodeNext;
	}
	return Total;
}

GameObject *Find_Beacon(int Number,int Team)
{ 
	if (Number < 0)
	{
		Number = 0;
	}
	if (!Number)
	{
		return 0;
	}
	int Total = 0;
	GameObject *ReturnObj = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_BeaconGameObj(o))
		{
			if (Team == 2)
			{
				Total++;
			}
			else if (Get_Object_Type(o) == Team)
			{
				Total++;
			}
			if (Total == Number) ReturnObj = o;
		}
		x = x->NodeNext;
	}
	return ReturnObj;
}

cGameData *The_Game()
{
	return Game();
}

cGameDataSkirmish *The_Skirmish_Game()
{
	return Skirmish_Game();
}

cGameDataCnc *The_Cnc_Game()
{
	return Cnc_Game();
}

cGameDataSinglePlayer *The_Single_Player_Game()
{
	return Single_Player_Game();
}

bool Is_Script_Attached(GameObject *obj,const char *script)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	void *ptr = (void *)(obj+0x6EC);
	SimpleDynVecClass<GameObjObserverClass *> *observers = (SimpleDynVecClass<GameObjObserverClass *>*)ptr;
	int x = observers->Count();
	for (int i = 0;i < x;i++)
	{
		if (!stricmp((*observers)[i]->Get_Name(),script))
		{
			return true;
		}
	}
	return false;
}

void Attach_Script_Once(GameObject *obj,const char *script,const char *params)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	if (!Is_Script_Attached(obj,script))
	{
		Commands->Attach_Script(obj,script,params);
	}
}

void Attach_Script_Preset_Once(const char *script,const char *params,const char *preset,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),preset))
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					if (!Is_Script_Attached(o,script))
					{
						Commands->Attach_Script(o,script,params);
					}
				}
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_Type_Once(const char *script,const char *params,int type,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (Get_Class_ID(d) == type)
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					if (!Is_Script_Attached(o,script))
					{
						Commands->Attach_Script(o,script,params);
					}
				}
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_Player_Once(const char *script,const char *params,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o)
		{
			DefinitionClass *d = Get_Definition(o);
			if (Get_Class_ID(d) == Soldier)
			{
				if ((Get_Object_Type(o) == team) || (team == 2))
				{
					if (!Is_Script_Attached(o,script))
					{
						Commands->Attach_Script(o,script,params);
					}
				}
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_Building(const char *script,const char *params,int team)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if ((o) && As_BuildingGameObj(o))
		{
			if ((Get_Object_Type(o) == team) || (team == 2))
			{
				Commands->Attach_Script(o,script,params);
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_Is_Preset(GameObject *obj,const char *preset,const char *script,const char *params,int team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	DefinitionClass *d = Get_Definition(obj);
	if (!stricmp(Get_Definition_Name(d),preset))
	{
		if ((Get_Object_Type(obj) == team) || (team == 2))
		{
			Commands->Attach_Script(obj,script,params);
		}
	}
}

void Attach_Script_Is_Type(GameObject *obj,int type,const char *script,const char *params,int team)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return;
	}
	DefinitionClass *d = Get_Definition(obj);
	if (Get_Class_ID(d) == type)
	{
		if ((Get_Object_Type(obj) == team) || (team == 2))
		{
			Commands->Attach_Script(obj,script,params);
		}
	}
}

bool Is_A_Building(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	if ((Is_Building(obj)) || (Is_PowerPlant(obj)) || (Is_SoldierFactory(obj)) || (Is_VehicleFactory(obj)) || (Is_Airstrip(obj)) || (Is_WarFactory(obj)) || (Is_Refinery(obj)) || (Is_ComCenter(obj)) || (Is_RepairBay(obj)))
	{
		return true;
	}
	return false;
}

GameObject *Find_Closest_Non_Building_Object_By_Team(int Team,Vector3 position)
{
	float closestdist = FLT_MAX;
	GameObject *closest = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			if ((Get_Object_Type(o) == Team) && !Is_A_Building(o))
			{
				Vector3 pos = Commands->Get_Position(o);
				float dist = Commands->Get_Distance(pos,position);
				if (dist < closestdist)
				{
					closestdist = dist;
					closest = o;
				}
			}
		}
		x = x->NodeNext;
	}
	return closest;
}

bool Get_Fly_Mode(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_SoldierGameObj(obj);
	if (!o)
	{
		return false;
	}
	char *c = (char *)obj;
	c += 0xD24;
	return *(bool *)c;
}

bool Is_Stealth(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return false;
	}
	GameObject *o = As_SmartGameObj(obj);
	if (!o)
	{
		return false;
	}
	char *c = (char *)obj;
	c += 0x83D;
	return *(bool *)c;
}

void Send_Custom_All_Objects_Area(int message,const Vector3 &Position,float Distance,GameObject *sender,int team)
{
	if (!Commands->Get_ID(sender) || !sender)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) 
	{
		GameObject *obj = (GameObject *)x->NodeData;
		if (obj && As_ScriptableGameObj(obj))
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance))
			{
				if ((Get_Object_Type(obj) == team) || (team == 2))
				{
					Commands->Send_Custom_Event(sender,obj,message,0,0);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Send_Custom_All_Objects(int message,GameObject *sender,int team)
{
	if (!Commands->Get_ID(sender) || !sender)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) 
	{
		GameObject *obj = (GameObject *)x->NodeData;
		if (obj && As_ScriptableGameObj(obj))
		{
			if ((Get_Object_Type(obj) == team) || (team == 2))
			{
				Commands->Send_Custom_Event(sender,obj,message,0,0);
			}
		}
		x = x->NodeNext;
	}
}

void Create_Effect_All_Stealthed_Objects_Area(const Vector3 &Position,float Distance,const char *object,const Vector3 &offset,int team)
{
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) 
	{
		GameObject *obj = (GameObject *)x->NodeData;
		if (obj && As_ScriptableGameObj(obj))
		{
			Vector3 ObjPosition = Commands->Get_Position(obj);
			Vector3 TestPosition = Position;
			ObjPosition.Z = 0;
			TestPosition.Z = 0;
			if ((Commands->Get_Distance(ObjPosition,TestPosition) <= Distance))
			{
				if ((Get_Object_Type(obj) == team) || (team == 2))
				{
					bool stealth = Is_Stealth(obj);
					if (stealth)
					{
						ObjPosition = Commands->Get_Position(obj);
						ObjPosition.X += offset.X;
						ObjPosition.Y += offset.Y;
						ObjPosition.Z += offset.Z;
						Commands->Create_Object(object,ObjPosition);
					}
				}
			}
		}
		x = x->NodeNext;
	}
}

void Kill_Occupants(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	int x = occupants.Length();
	for (int i = 0;i < x;i++)
	{
		if (occupants[i])
		{
			Commands->Apply_Damage(occupants[i],100,"Death",0);
		}
	}
}

int Tally_Team_Size(int team)
{
	return TallyTeamSize(team);
}

float Get_Team_Score(int team)
{
	char *teamdata = Find_Team(team);
	teamdata += 0x6C0;
	return *((float *)teamdata);
}

const char *Get_IP_Address(int PlayerID)
{
	sockaddr_in *addr;
#ifdef WIN32
	_asm {
		push PlayerID
		mov eax,ServerConnection
		mov ecx,[eax]
		call Get_Remote_Host
		mov ecx,eax
		call Get_Address
		mov addr,eax
	}
#else
	char *RemoteHost = Get_Remote_Host(*ServerConnection,PlayerID);
	addr = Get_Address(RemoteHost);
#endif
	char *temp;
	temp = new char[40];
	int ip1 = addr->sin_addr.s_addr&0x000000FF;
	int ip2 = (addr->sin_addr.s_addr&0x0000FF00)>>8;
	int ip3 = (addr->sin_addr.s_addr&0x00FF0000)>>16;
	int ip4 = (addr->sin_addr.s_addr&0xFF000000)>>24;
	sprintf(temp,"%d.%d.%d.%d",ip1,ip2,ip3,ip4);
	return temp;
}

int Get_C4_Count(int Team)
{
	int Total = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_C4GameObj(o))
		{
			if (Team == 2)
			{
				Total++;
			}
			else if (Get_Object_Type(o) == Team)
			{
				Total++;
			}
		}
		x = x->NodeNext;
	}
	return Total;
}

char *newstr(const char *str)
{
	unsigned long len = strlen(str)+1;
	char *s = new char[len];
	memcpy(s,str,len);
	return s;
}

char Get_Mine_Limit()
{
	return *Mine_Limit;
}

bool Is_Gameplay_Permitted()
{
	return The_Game()->Is_Gameplay_Permitted();
}

unsigned long Get_Ping(int PlayerID)
{
	int ping;
#ifdef WIN32
	_asm {
		push PlayerID
		mov eax,ServerConnection
		mov ecx,[eax]
		call Get_Remote_Host
		mov eax,[eax+0x2A4]
		mov ping,eax
	}
#else
	char *RemoteHost = Get_Remote_Host(*ServerConnection,PlayerID);
	RemoteHost += 0x29C;
	ping = *(int *)RemoteHost;
#endif
	return ping;
}

unsigned long Get_Kbits(int PlayerID)
{
	int kbits;
#ifdef WIN32
	_asm {
		push PlayerID
		mov eax,ServerConnection
		mov ecx,[eax]
		call Get_Remote_Host
		mov ecx,eax
		call Get_Address
		mov ecx, PacketManager
		push eax
		call Bandwidth_Out
		mov kbits, eax
	}
#else
	char *RemoteHost = Get_Remote_Host(*ServerConnection,PlayerID);
	sockaddr_in *addr = Get_Address(RemoteHost);
	kbits = Bandwidth_Out(PacketManager,addr);
#endif
	return kbits >> 0x0A;
}

void Send_Custom_Event_To_Object(GameObject *sender,const char *Preset,int message,int param,float delay)
{
	if (!Commands->Get_ID(sender) || !sender)
	{
		return;
	}
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = (GameObject *)x->NodeData;
		if (o && As_ScriptableGameObj(o))
		{
			DefinitionClass *d = Get_Definition(o);
			if (!stricmp(Get_Definition_Name(d),Preset))
			{
				Commands->Send_Custom_Event(sender,o,message,param,delay);
			}
		}
		x = x->NodeNext;
	}
}

int Get_Vehicle_Seat_Count(GameObject *obj,int seat)
{
	if (!Commands->Get_ID(obj) || !obj || !As_VehicleGameObj(obj))
	{
		return 0;
	}
	VectorClass<GameObject *> *ptr = (VectorClass<GameObject *>*)(obj+0x9AC);
	VectorClass<GameObject *> occupants = (VectorClass<GameObject *>)*ptr;
	return occupants.Length();
}

char *Get_Spawn_Char(int Team)
{
	if (Team == 0)
	{
		return SpawnCharNod;
	}
	else if (Team == 1)
	{
		return SpawnCharGDI;
	}
	return "None";
}

void Change_Spawn_Char(int Team,const char *Name)
{
	if (strlen(Name) > 24)
	{
		return;
	}
	else if (Team == 0)
	{
		memcpy((void*)SpawnCharNod,(void*)Name,24);
	}
	else if (Team == 1)
	{
		memcpy((void*)SpawnCharGDI,(void*)Name,24);
	}
}

int Get_Building_Count_Team(int Team)
{
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	int Count = 0;
	while (x)
	{
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o && Commands->Get_Health(o) > 0 && (Get_Object_Type(o) == Team || Team == 2))
		{
			Count++;
		}
		x = x->NodeNext;
	}
	return Count;
}
void Ranged_Percentage_Damage_To_Vehicles(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager)
{
	if(DamageRadius > 0)
	{
		GenericSLNode *x = BaseGameObjList->HeadNode;
		while(x)
		{
			GameObject *o = (GameObject *)x->NodeData;
			if(o)
			{
				if(As_VehicleGameObj(o))
				{
					float health = Commands->Get_Health(o);
					if(health > 0)
					{
						Vector3 pos1 = Commands->Get_Position(o);
						Vector3 pos2 = Location;

						float Distance = Commands->Get_Distance(pos1,pos2);

						if(Distance <= DamageRadius)
						{
							float Max_Health = Commands->Get_Max_Health(o);
							float Max_Shield = Commands->Get_Max_Shield_Strength(o);
							float Damage = (Max_Health + Max_Shield) * Percentage;
							Commands->Apply_Damage(o,Damage,Warhead,Damager);
						}
					}
				}
			}
			x = x->NodeNext;
		}
	}
}

int Get_Bandwidth(int PlayerID)
{
	int bandwidth;
#ifdef WIN32
	_asm {
		push PlayerID
		mov eax,ServerConnection
		mov ecx,[eax]
		call Get_Remote_Host
		mov eax,[eax+0x338]
		mov bandwidth,eax
	}
#else
	char *RemoteHost = Get_Remote_Host(*ServerConnection,PlayerID);
	RemoteHost += 0x330;
	bandwidth = *(int *)RemoteHost;
#endif
	return bandwidth;
}

bool Is_Dedicated()
{
	return Exe;
}

void Soldier_Transition_Vehicle(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_SoldierGameObj(obj))
	{
		return;
	}
	Check_Transitions(obj,true);
}

bool Is_Linux()
{
	if ((Exe == 2) || (Exe == 3))
	{
		return true;
	}
	return false;
}
unsigned int Get_Current_Game_Mode()
{
	if (*GameType == 1)
	{
		return 1;
	}
	if (*GameType == 2)
	{
		return 2;
	}
	if (*GameType == 3)
	{
		if (Game_Mode_Find("WOL") != 0)
		{
			return 3;
		}
		if (Game_Mode_Find("LAN") != 0)
		{
			if (*IsListed)
			{
				return 4;
			}
			else
			{
				return 5;
			}
		}
	}
	return 0;
}

int Get_Team(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x768;
#else
	x += 0x76C;
#endif
	int team;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Int
		mov team, eax
	}
#else
	team = *(int *)x;
#endif
	return team;
}

int Get_Rank(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x76C;
#else
	x += 0x770;
#endif
	int rank;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Int
		mov rank, eax
	}
#else
	rank = *(int *)x;
#endif
	return rank;
}

int Get_Kills(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x760;
#else
	x += 0x764;
#endif
	int kills;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Int
		mov kills, eax
	}
#else
	kills = *(int *)x;
#endif
	return kills;
}

int Get_Deaths(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef RH8
	x += 0x764;
#else
	x += 0x768;
#endif
	int deaths;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Int
		mov deaths, eax
	}
#else
	deaths = *(int *)x;
#endif
	return deaths;
}

float Get_Score(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef WIN32
	x += 0x4;
#else
#ifdef RH8
	x += 0x4;
#endif
#endif
	float score;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Float
		fstp score
	}
#else
	score = *(float *)x;
#endif
	return score;
}

float Get_Money(int ID)
{
	unsigned char *x = FindPlayer(ID);
	if (!x)
	{
		return 0;
	}
#ifdef WIN32
	x += 0x8;
#else
#ifdef RH8
	x += 0x8;
#else
	x += 0x4;
#endif
#endif
	float score;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Float
		fstp score
	}
#else
	score = *(float *)x;
#endif
	return score;
}

float Get_Kill_To_Death_Ratio(int ID)
{
	int kills = Get_Kills(ID);
	int deaths = Get_Deaths(ID);
	if (deaths <= 0)
	{
		return -1.0;
	}
	return (float)kills/(float)deaths;
}

float Get_Damage_Points(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return 0;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	def+=0x7;
#else
#ifdef RH8
	def+=0x7;
#else
#endif
	def+=0x6;
#endif
	float points;
#ifdef WIN32
	_asm {
		mov ecx, def
		call Get_Safe_Data_Float
		fstp points
	}
#else
	points = *(float *)def;
#endif
	return points;
}

float Get_Death_Points(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_DamageableGameObj(obj);
	if (!o)
	{
		return 0;
	}
	unsigned int *def = (unsigned int *)(o+0x72C);
#ifdef WIN32
	def+=0x8;
#else
#ifdef RH8
	def+=0x8;
#else
#endif
	def+=0x7;
#endif
	float points;
#ifdef WIN32
	_asm {
		mov ecx, def
		call Get_Safe_Data_Float
		fstp points
	}
#else
	points = *(float *)def;
#endif
	return points;
}

int Get_C4_Mode(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj)
	{
		return 0;
	}
	GameObject *o = As_C4GameObj(obj);
	if (!o)
	{
		return 0;
	}
	unsigned int *def = (unsigned int *)(o+0x7C8);
	unsigned int *x = (unsigned int *)*def;
	x+=0x23;
	int mode;
#ifdef WIN32
	_asm {
		mov ecx, x
		call Get_Safe_Data_Int
		mov mode, eax
	}
#else
	mode = *(int *)x;
#endif
	return mode;
}

const char *Get_IP_Port(int PlayerID)
{
	sockaddr_in *addr;
#ifdef WIN32
	_asm {
		push PlayerID
		mov eax,ServerConnection
		mov ecx,[eax]
		call Get_Remote_Host
		mov ecx,eax
		call Get_Address
		mov addr,eax
	}
#else
	char *RemoteHost = Get_Remote_Host(*ServerConnection,PlayerID);
	addr = Get_Address(RemoteHost);
#endif
	char *temp;
	temp = new char[40];
	int ip1 = addr->sin_addr.s_addr&0x000000FF;
	int ip2 = (addr->sin_addr.s_addr&0x0000FF00)>>8;
	int ip3 = (addr->sin_addr.s_addr&0x00FF0000)>>16;
	int ip4 = (addr->sin_addr.s_addr&0xFF000000)>>24;
	int port = ntohs(addr->sin_port);
	sprintf(temp,"%d.%d.%d.%d;%d",ip1,ip2,ip3,ip4,port);
	return temp;
}

char *Get_Objects_File() {
	return ObjectsAddress;
}

void Change_Objects_File(const char *Name) {
	memcpy((void*)ObjectsAddress,(void*)Name,3);
}

void Track_New_C4() {
	GenericSLNode *z = BaseGameObjList->HeadNode;
	while (z)
	{
		GameObject *obj = As_ScriptableGameObj((GameObject *)z->NodeData);
		if (obj && Is_C4(obj) && !Is_Script_Attached(obj,"MDB_New_C4"))
		{
			Commands->Attach_Script(obj,"MDB_New_C4","");
			Commands->Send_Custom_Event(obj,obj,9955,0,0);
		}
		z = z->NodeNext;
	}
}

int Get_Veh_Owner(GameObject *obj)
{
	if (!Commands->Get_ID(obj) || !obj || !As_ScriptableGameObj(obj))
	{
		return 0;
	}
	void *ptr = (void *)(obj+0x6EC);
	SimpleDynVecClass<GameObjObserverClass *>* observers = (SimpleDynVecClass<GameObjObserverClass *>*)ptr;
	for (int i = 0;i < observers->Count();i++)
	{
		if (stricmp((*observers)[i]->Get_Name(),"MDB_Vehicle_Owner") == 0)
		{
			return ((ScriptImpClass*)(*observers)[i])->Get_Int_Parameter("ID");
		}
	}
	return 0;
}

GameObject *Find_My_Veh(GameObject *Owner)
{
	if (!Commands->Get_ID(Owner) || !Owner)
	{
		return 0;
	}
	GenericSLNode *z = BaseGameObjList->HeadNode;
	while (z != 0)
	{
		GameObject *obj = As_ScriptableGameObj((GameObject *)z->NodeData);
		if (!Commands->Get_ID(obj) || !obj) return 0;
		if (obj && Is_Vehicle(obj) && Get_Veh_Owner(obj) == Commands->Get_ID(Owner))
		{
			return obj;
		}
		z = z->NodeNext;
	}
	return 0;
}

int Get_C4_Count_Proximity(int Team)
{
	int Total = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_C4GameObj(As_ScriptableGameObj((GameObject *)x->NodeData));
		if (o && Get_C4_Mode(o) == 3) {
			if (Team == 2 || Get_Object_Type(o) == Team) Total++;
		}
		x = x->NodeNext;
	}
	return Total;
}

int Get_C4_Count_Remote(int Team)
{
	int Total = 0;
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x)
	{
		GameObject *o = As_C4GameObj(As_ScriptableGameObj((GameObject *)x->NodeData));
		if (o && Get_C4_Mode(o) == 1) {
			if (Team == 2 || Get_Object_Type(o) == Team) Total++;
		}
		x = x->NodeNext;
	}
	return Total;
}

GameObject *Find_Base_Defense(int Team)
{
	if (!Team) return Find_Building_By_Name(0,"mp_Nod_Obelisk");
	return Find_Building_By_Name(1,"mp_GDI_Advanced_Guard_Tower");
}

void Attach_Script_All_Buildings_Team(int Team,const char *Script,const char *Params,bool Once) {
	GenericSLNode *x = BuildingGameObjList->HeadNode;
	while (x) {
		GameObject *o = As_BuildingGameObj((GameObject *)x->NodeData);
		if (o) {
			if (Get_Object_Type(o) == Team || Team == 2) {
				if (Once) {
					Attach_Script_Once(o,Script,Params);
				}
				else {
					Commands->Attach_Script(o,Script,Params);
				}
			}
		}
		x = x->NodeNext;
	}
}

void Attach_Script_All_DecPhys_Team(int Team,const char *Script,const char *Params,bool Once) {
	GenericSLNode *x = BaseGameObjList->HeadNode;
	while (x) {
		GameObject *o = As_VehicleGameObj((GameObject *)x->NodeData);
		if (o) {
			if (Is_DecorationPhys(o) && (Get_Object_Type(o) == Team || Team == 2)) {
				if (Once) {
					Attach_Script_Once(o,Script,Params);
				}
				else {
					Commands->Attach_Script(o,Script,Params);
				}
			}
		}
		x = x->NodeNext;
	}
}
