/*	Renegade Scripts.dll
	SSAOW crate scripts
	Copyright 2006 Vloktboky, WhiteDragon(MDB), Mac, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/

#include "scripts.h"
#include "engine.h"
#include "crate.h"
#include "gamelog.h"
#include "date.h"
#include <stdlib.h>
#include <time.h>
#include "profile.h"
#include "aow.h"

int	LastCratePickup = -181;
Vector3	GDI_Veh_Spawn;
Vector3	Nod_Veh_Spawn;
Vector3	GDI_VehP_Spawn;
Vector3	Nod_VehP_Spawn;
float GDI_Veh_Facing;
float Nod_Veh_Facing;
float GDI_VehP_Facing;
float Nod_VehP_Facing;
bool CrateExists = false;
int CrateID = 0;
int	Crate_Weapon;
int	Crate_Money;
int	Crate_Points;
int	Crate_Vehicle;
int	Crate_Death;
int	Crate_Tiberium;
int	Crate_Ammo;
int	Crate_Armor;
int	Crate_Health;
int	Crate_Character;
int	Crate_ButterFingers;
int	Crate_Refill;
int	Crate_Beacon;
int	Crate_Spy;
int	Crate_Stealth;
int	Crate_Thief;

char *RandomWeapon[21][3] =
{
	{ "Auto	Rifle",	"POW_AutoRifle_Player",	"m00pwar_aqob0004i1evag_snd.wav" },
	{ "Shotgun", "POW_Shotgun_Player", "m00pwps_aqob0004i1evag_snd.wav"	},
	{ "Flamethrower", "POW_Flamethrower_Player", "m00pwft_aqob0001i1evag_snd.wav" },
	{ "Grenade Launcher", "POW_GrenadeLauncher_Player",	"m00pwgl_aqob0004i1evag_snd.wav" },
	{ "Repair Gun(Weak)", "POW_RepairGun_Player", "m00pwrp_aqob0001i1evag_snd.wav" },
	{ "Remote C4", "CnC_POW_MineRemote_02",	"m00pacp_aqob0004i1evag_snd.wav" },
	{ "Chain Gun", "POW_Chaingun_Player", "m00pwcg_aqob0004i1evag_snd.wav" },
	{ "Rocket Launcher(Weak)", "POW_RocketLauncher_Player",	"m00pwrl_aqob0004i1evag_snd.wav" },
	{ "Chemical	Sprayer", "POW_ChemSprayer_Player",	"m00pwcs_aqob0004i1evag_snd.wav" },
	{ "Tiberium	Auto Rifle", "POW_TiberiumAutoRifle_Player", "m00pwtr_aqob0004i1evag_snd.wav" },
	{ "Sniper Rifle", "POW_SniperRifle_Player",	"m00pwsr_aqob0004i1evag_snd.wav" },
	{ "Laser Chaingun",	"POW_LaserChaingun_Player",	"m00pwlc_aqob0004i1evag_snd.wav" },
	{ "Laser Rifle", "POW_LaserRifle_Player", "m00pwlr_aqob0004i1evag_snd.wav" },
	{ "Rocket Launcher(Strong)", "CnC_POW_RocketLauncher_Player", "m00pwrl_aqob0004i1evag_snd.wav" },
	{ "Tiberium	Flechette Gun",	"POW_TiberiumFlechetteGun_Player", "m00pwtf_aqob0004i1evag_snd.wav"	},
	{ "Personal	Ion	Cannon", "POW_PersonalIonCannon_Player", "m00pwpi_aqob0004i1evag_snd.wav" },
	{ "Railgun", "POW_Railgun_Player", "m00pwrg_aqob0004i1evag_snd.wav"	},
	{ "Ramjet Rifle", "POW_RamjetRifle_Player",	"m00pwrj_aqob0004i1evag_snd.wav" },
	{ "Volt	Auto Rifle", "POW_VoltAutoRifle_Player", "m00pwvr_aqob0004i1evag_snd.wav" },
	{ "Volt	Auto Rifle", "CnC_POW_VoltAutoRifle_Player_Nod", "m00pwvr_aqob0004i1evag_snd.wav" }
};

char *RandomVehicle[12][3] =
{
	{ "GDI Humvee",	"humvee", "CnC_GDI_Humm-vee" },
	{ "Nod Buggy", "buggy", "CnC_Nod_Buggy" },
	{ "GDI APC", "gdiapc", "CnC_GDI_APC" },
	{ "Nod APC", "nodapc", "CnC_Nod_APC" },
	{ "GDI MRLS", "mrls", "CnC_GDI_MRLS" },
	{ "Nod Mobile Artillery", "arty", "CnC_Nod_Mobile_Artillery"},
	{ "GDI Medium Tank", "med", "CnC_GDI_Medium_Tank" },
	{ "Nod Light Tank",	"lighttank", "CnC_Nod_Light_Tank" },
	{ "Nod Flame Tank",	"flamer", "CnC_Nod_Flame_Tank" },
	{ "Nod Stealth Tank", "stank", "CnC_Nod_Stealth_Tank" },
	{ "GDI Mammoth Tank", "mammy", "CnC_GDI_Mammoth_Tank" },
	{ "Nod Recon Bike",	"recon", "CnC_Nod_Recon_Bike"}
};

char *RandomGDIChar[10][2] =
{
	{ "Officer", "CnC_GDI_MiniGunner_1Off" },
	{ "Rocket Soldier",	"CnC_GDI_RocketSoldier_1Off" },
	{ "Sydney",	"CnC_Sydney" },
	{ "Deadeye", "CnC_GDI_MiniGunner_2SF" },
	{ "Gunner",	"CnC_GDI_RocketSoldier_2SF"	},
	{ "Patch", "CnC_GDI_Grenadier_2SF" },
	{ "Havoc", "CnC_GDI_MiniGunner_3Boss" },
	{ "Prototype Sydney", "CnC_Sydney_PowerSuit" },
	{ "Mobius",	"CnC_Ignatio_Mobius" },
	{ "Hotwire", "CnC_GDI_Engineer_2SF"	}
};

char *RandomNodChar[10][2] =
{
	{ "Officer", "CnC_Nod_Minigunner_1Off" },
	{ "Rocket Soldier",	"CnC_Nod_RocketSoldier_1Off" },
	{ "Chem	Warrior", "CnC_Nod_FlameThrower_1Off" },
	{ "Blackhand Sniper", "CnC_Nod_Minigunner_2SF" },
	{ "Laser Chaingunner", "CnC_Nod_RocketSoldier_2SF" },
	{ "Stealth Black Hand",	"CnC_Nod_FlameThrower_2SF" },
	{ "Sakura",	"CnC_Nod_Minigunner_3Boss" },
	{ "Raveshaw", "CnC_Nod_RocketSoldier_3Boss"	},
	{ "Mendoza", "CnC_Nod_FlameThrower_3Boss" },
	{ "Technician",	"CnC_Nod_Technician_0" }
};

void crate_defaults()
{
	Crate_Weapon=13;
	Crate_Money=11;
	Crate_Points=10;
	Crate_Vehicle=8;
	Crate_Death=8;
	Crate_Tiberium=6;
	Crate_Ammo=5;
	Crate_Armor=5;
	Crate_Health=5;
	Crate_Character=8;
	Crate_ButterFingers=3;
	Crate_Spy=3;
	Crate_Stealth=3;
	Crate_Refill=6;
	Crate_Beacon=4;
	Crate_Thief=2;
}

void crate_init() {
	int	total=0;
	GDI_Veh_Spawn.X	= getProfileFloat(CurrMap,"GDIRVC_X",0.0f,"ssaow.ini");
	GDI_Veh_Spawn.Y	= getProfileFloat(CurrMap,"GDIRVC_Y",0.0f,"ssaow.ini");
	GDI_Veh_Spawn.Z	= getProfileFloat(CurrMap,"GDIRVC_Z",0.0f,"ssaow.ini");
	GDI_VehP_Spawn.X = getProfileFloat(CurrMap,"GDIRVCP_X",0.0f,"ssaow.ini");
	GDI_VehP_Spawn.Y = getProfileFloat(CurrMap,"GDIRVCP_Y",0.0f,"ssaow.ini");
	GDI_VehP_Spawn.Z = getProfileFloat(CurrMap,"GDIRVCP_Z",0.0f,"ssaow.ini");
	GDI_Veh_Facing = getProfileFloat(CurrMap,"GDIRVC_Face",0.0f,"ssaow.ini");
	GDI_VehP_Facing	= getProfileFloat(CurrMap,"GDIRVCP_Face",0.0f,"ssaow.ini");
	Nod_Veh_Spawn.X	= getProfileFloat(CurrMap,"NodRVC_X",0.0f,"ssaow.ini");
	Nod_Veh_Spawn.Y	= getProfileFloat(CurrMap,"NodRVC_Y",0.0f,"ssaow.ini");
	Nod_Veh_Spawn.Z	= getProfileFloat(CurrMap,"NodRVC_Z",0.0f,"ssaow.ini");
	Nod_VehP_Spawn.X = getProfileFloat(CurrMap,"NodRVCP_X",0.0f,"ssaow.ini");
	Nod_VehP_Spawn.Y = getProfileFloat(CurrMap,"NodRVCP_Y",0.0f,"ssaow.ini");
	Nod_VehP_Spawn.Z = getProfileFloat(CurrMap,"NodRVCP_Z",0.0f,"ssaow.ini");
	Nod_Veh_Facing = getProfileFloat(CurrMap,"NodRVC_Face",0.0f,"ssaow.ini");
	Nod_VehP_Facing	= getProfileFloat(CurrMap,"NodRVCP_Face",0.0f,"ssaow.ini");

	total+=	Crate_Weapon = getProfileInt("Crates","Weapon",	0, "ssaow.ini");
	total+=	Crate_Money	= getProfileInt("Crates","Money", 0, "ssaow.ini");
	total+=	Crate_Points = getProfileInt("Crates","Points",	0, "ssaow.ini");
	total+=	Crate_Vehicle =	getProfileInt("Crates","Vehicle", 0, "ssaow.ini");
	total+=	Crate_Death	= getProfileInt("Crates","Death", 0, "ssaow.ini");
	total+=	Crate_Tiberium = getProfileInt("Crates","Tiberium",	0,	"ssaow.ini");
	total+=	Crate_Ammo = getProfileInt("Crates","Ammo",	0,	"ssaow.ini");
	total+=	Crate_Armor	= getProfileInt("Crates","Armor", 0, "ssaow.ini");
	total+=	Crate_Health = getProfileInt("Crates","Health",	0, "ssaow.ini");
	total+=	Crate_Character	= getProfileInt("Crates","Character", 0, "ssaow.ini");
	total+=	Crate_ButterFingers	= getProfileInt("Crates","ButterFingers", 0, "ssaow.ini");
	total+=	Crate_Refill = getProfileInt("Crates","Refill",	0, "ssaow.ini");
	total+=	Crate_Beacon = getProfileInt("Crates","Beacon",	0, "ssaow.ini");
	total+=	Crate_Spy =	getProfileInt("Crates","Spy", 0, "ssaow.ini");
	total+=	Crate_Stealth =	getProfileInt("Crates","Stealth", 0, "ssaow.ini");
	total+=	Crate_Thief	= getProfileInt("Crates","Thief", 0, "ssaow.ini");
	if (total != 100) {
		crate_defaults();
		char Msg[200];
		sprintf(Msg,"Total crate percentages equal %d instead of 100. Using default percentages.",total);
		FDSMessage(Msg,"_ERROR");
	}
	LastCratePickup	= -181;
	CrateExists = false;
}

void M00_CNC_Crate::Created(GameObject *obj) {
	Destroy_Script();
}

void MDB_CNC_Crate::Created(GameObject *obj) {

	if (CrateID != Commands->Get_ID(obj)) {
		CrateID = Commands->Get_ID(obj);
	if (!Settings->EnableCrates	|| Settings->GameMode == 3 || Settings->GameMode ==	4) {
		Commands->Destroy_Object(obj);
		return;
	}
	else if	(Settings->EnableCrates	&& Settings->EnableNewCrates) {
		if (CrateExists	|| (The_Game()->GameDuration_Seconds - LastCratePickup)	< 180) {
			Commands->Destroy_Object(obj);
			return;
		}
		else {
			CrateExists	= true;
			if (!Settings->VehCrate) {
				Damage_All_Vehicles_Area(999999.0f,"Laser_NoBuilding",Commands->Get_Position(obj),2.0f,obj,0);
				Commands->Set_Model(obj,"vehcol2m");
				GameObject *vehBlock = Commands->Create_Object("Vehicle_Blocker",Commands->Get_Position(obj));
				Commands->Attach_To_Object_Bone(vehBlock,obj,"Bone");
				char ID[20];
				sprintf(ID,"%d",Commands->Get_ID(obj));
				Commands->Attach_Script(vehBlock,"MDB_Destroy_When_Object_Destroyed",ID);
				vehBlocker = Commands->Get_ID(vehBlock);
			}
			else {
				vehBlocker = 0;
			}
		}
	}
	}
}

void MDB_CNC_Crate::Custom(GameObject *obj,	int	message, int param,	GameObject *sender) {
	if (message	== 1000000025 && PickedUp != true) {
		PickedUp = true;
		if (!Settings->EnableNewCrates) {
			int	Rnd	= Commands->Get_Random_Int(1,4);
			if (Rnd	== 1)
			{
				Commands->Give_Money(sender,100,false);
			}
			else if	(Rnd ==	2)
			{
				Commands->Give_Money(sender,200,false);
			}
			else
			{
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
			}
		}
		else
		{
			LastCratePickup	= The_Game()->GameDuration_Seconds;
			if (Commands->Find_Object(vehBlocker)) {
				Commands->Destroy_Object(Commands->Find_Object(vehBlocker));
			}
			
			CrateExists	= false;
			char message[500],message2[500];
			CrateStart:
			int RandomIntCrate = Commands->Get_Random_Int(1,101);
			int	percent	= 0;
			if ((RandomIntCrate	<= (percent+=Crate_Weapon))	&& (Crate_Weapon > 0))
			{

				Reselect:
				int	Rnd	= Commands->Get_Random_Int(1,101);
				int	Index = 0;
				if (Rnd	<= 10) Index = 0;
				else if	(Rnd<=20) Index	= 1;
				else if	(Rnd<=30) Index	= 2;
				else if	(Rnd<=40) Index	= 3;
				else if	(Rnd<=50) Index	= 4;
				else if	(Rnd<=60) Index	= 5;
				else if	(Rnd<=65) Index	= 6;
				else if	(Rnd<=70) Index	= 7;
				else if	(Rnd<=75) Index	= 8;
				else if	(Rnd<=80) Index	= 9;
				else if	(Rnd<=82) Index	= 10;
				else if	(Rnd<=84) Index	= 11;
				else if	(Rnd<=86) Index	= 12;
				else if	(Rnd<=88) Index	= 13;
				else if	(Rnd<=90) Index	= 14;
				else if	(Rnd<=92) Index	= 15;
				else if	(Rnd<=94) Index	= 16;
				else if	(Rnd<=96) Index	= 17;
				else if	(Rnd<=98) Index	= 18;
				else Index = 19;
				if (IsDisabled(RandomWeapon[Index][1])) goto Reselect;
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;WEAPON;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d",	RandomWeapon[Index][0],	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				sprintf(message,"%s bekommt eine Waffe aus der Wunderkiste.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				Commands->Give_Powerup(sender,RandomWeapon[Index][1],true);
				sprintf(message,"ppage %d [Waffenschrank] Du bekommst ein(e) %s.",Get_Player_ID(sender),RandomWeapon[Index][0]);
				if (RandomWeapon[Index][2][0] != '\0')
				{
					Create_2D_WAV_Sound_Player(sender,RandomWeapon[Index][2]);
				}
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Money))	&& (Crate_Money	> 0))
			{
				int	Amount = Commands->Get_Random_Int(1,1000);
				int	RndGood	= Commands->Get_Random_Int(1,2);
				if (RndGood	== 1)
				{
					Commands->Give_Money(sender,(float)Amount,false);
					Create_2D_WAV_Sound_Player(sender,"m00pc$$_aqob0002i1evag_snd.wav");
				}
				else
				{
					Commands->Give_Money(sender,(float)(Amount*-1),false);
					if (Commands->Get_Money(sender)	< 0) Commands->Give_Money(sender,(Commands->Get_Money(sender) *	-1),false);
				}
				if (RndGood == 1) {
					sprintf(message,"%s bekommt Geld aus der Wunderkiste.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Lottokiste] Du bekommst %d Euros.",Get_Player_ID(sender),(int)Amount);
				}
				else {
					sprintf(message,"%s verliert Geld wegen der Wunderkiste.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Steuerkiste] Du verlierst %d Euros.",Get_Player_ID(sender),(int)Amount);
				}
				if (Settings->Gamelog) {
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					if (RndGood	== 1)
						sprintf	(Message, "CRATE;MONEY;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d", int(Amount),	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					else
						sprintf	(Message, "CRATE;MONEY;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d", int(Amount) * -1, Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}				
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Points)) &&	(Crate_Points >	0))
			{
				int	Amount = Commands->Get_Random_Int(1,500);
				int	RndGood	= Commands->Get_Random_Int(1,2);
				if (RndGood	== 1) {
					Commands->Give_Points(sender,(float)Amount,false);
				}
				else {
					Commands->Give_Points(sender,(float)(Amount*-1),false);
				}

				if (RndGood == 1) {
					sprintf(message,"%s bekommt Punkte aus der Kiste.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Bonuskiste] Du bekommst nun %d Punkte vom Gegner.",Get_Player_ID(sender),(int)Amount);
					sprintf(message2,"msg Freut euch ueber %d Punkte aus der Wunderkiste, %s.",(int)Amount,Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
					Console_Input(message2);
				}
				else {
					sprintf(message,"%s verliert Punkte wegen der Kiste.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Minuskiste] Du verlierst %d Punkte.",Get_Player_ID(sender),(int)Amount);
					sprintf(message2,"msg Die Wunderkiste zieht euch %d Punkte ab, %s.",(int)Amount,Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
					Console_Input(message2);
				}

				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					if (RndGood	== 1) {
						sprintf	(Message, "CRATE;POINTS;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d",	int(Amount), Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
					else {
						sprintf	(Message, "CRATE;POINTS;%d;%d;%s;%f;%f;%f;%f;%f;%f;%d",	int(Amount)	* -1, Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
					}
				}			
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Vehicle)) && (Crate_Vehicle	> 0))
			{
				if (Settings->GameMode != 1) goto CrateStart;
				Vector3	thePos;
				if (GDI_Veh_Spawn.X	== 0 ||	Nod_Veh_Spawn.X	== 0 ||	Nod_VehP_Spawn.X ==	0 || GDI_VehP_Spawn.X == 0)	goto CrateStart;
				if (Commands->Get_Player_Type(sender) == 1)
				{
					Damage_All_Vehicles_Area(999999.0f,"Laser_NoBuilding",GDI_Veh_Spawn,2.0f,obj,0);
					Commands->Set_Position(sender,GDI_Veh_Spawn);
					Commands->Set_Facing(sender,GDI_Veh_Facing);
					thePos = GDI_Veh_Spawn;
				}
				else if	(Commands->Get_Player_Type(sender) == 0)
				{
					Damage_All_Vehicles_Area(999999.0f,"Laser_NoBuilding",Nod_Veh_Spawn,2.0f,obj,0);
					Commands->Set_Position(sender,Nod_Veh_Spawn);
					Commands->Set_Facing(sender,Nod_Veh_Facing);
					thePos = Nod_Veh_Spawn;
				}
				GameObject *temp = Commands->Create_Object("Invisible_Object", thePos);
				Reselect2:
				int	Rnd	= Commands->Get_Random_Int(1,201);
				int	Index = 0;
				char Script[30];
				if (Rnd	<= 25) Index = 0;
				else if	(Rnd <=	50)	Index =	1;
				else if	(Rnd <=	70)	Index =	2;
				else if	(Rnd <=	90)	Index =	3;
				else if	(Rnd <=	110) Index = 4;
				else if	(Rnd <=	130) Index = 5;
				else if	(Rnd <=	145) Index = 6;
				else if	(Rnd <=	160) Index = 7;
				else if	(Rnd <=	170) Index = 8;
				else if	(Rnd <=	180) Index = 9;
				else if	(Rnd <=	190) Index = 10;
				else Index = 11;
				if (IsDisabled(RandomVehicle[Index][2])) goto Reselect2;
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;VEHICLE;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomVehicle[Index][0], Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}			
				sprintf(message,"%s bekommt ein Zufallsfahrzeug geliefert.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [Panzerkiste] Du bekommst ein %s aus dem Fahrzeugpool.",Get_Player_ID(sender), RandomVehicle[Index][0]);
				sprintf(Script,"%sRVC_%s.txt",Commands->Get_Player_Type(sender)	== 0?"Nod":"GDI",RandomVehicle[Index][1]);
				Commands->Attach_Script(temp,"Test_Cinematic",Script);
				sprintf(message2,"msg HRHR %s bekommt als Bonus ein Fahrzeug aus der Kiste!",Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
				Console_Input(message2);
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Death))	&& (Crate_Death	> 0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;DEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				sprintf(message,"%s lief in die Todeskiste.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				Commands->Apply_Damage(sender,99999,"Shrapnel",false);
				Commands->Create_Explosion("Explosion_IonCannonBeacon",Commands->Get_Position(obj),0);
				sprintf(message,"ppage %d [Todeskiste] Du warst zu neugierig und bist tot. Pech!",Get_Player_ID(sender));
				sprintf(message2,"msg Todeskiste: Einer von %s war zu neugierig und wurde gesprengt!",Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
				Console_Input(message2);
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Tiberium)) && (Crate_Tiberium >	0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;TIBERIUMDEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				sprintf(message,"%s hat die Tiberiumkiste erwischt.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				Commands->Apply_Damage(sender,99999,"TiberiumRaw",false);
				Commands->Create_Object("CnC_Visceroid",Commands->Get_Position(sender));
				sprintf(message,"ppage %d [Tiberiumkiste] Du hast die giftige Tiberiumkiste erwischt und bist zum Visceroid geworden.",Get_Player_ID(sender));
				Commands->Create_2D_WAV_Sound("l06b_17_npa01.wav");
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Ammo)) && (Crate_Ammo > 0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;FULLAMMO;;%d;%s;%f;%f;%f;%f;%f;%f;%d",	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				Commands->Give_Powerup(sender,"CnC_POW_Ammo_ClipMax",false);
				sprintf(message,"%s bekommt die Munition aufgefuellt.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [Wunderkiste] Deine Munition ist wieder voll.",Get_Player_ID(sender));
				Create_2D_WAV_Sound_Player(sender,"m00puar_aqob0002i1evag_snd.wav");
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Armor))	&& (Crate_Armor	> 0))
			{
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (Commands->Get_Shield_Strength(sender) <	2) RndGood = 1;
				if (RndGood	== 1)
				{
					Commands->Give_Powerup(sender,"POW_Medal_Armor",true);
					sprintf(message,"%s bekommt mehr Schild.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Reparaturkiste] Dein Schild wurde erhoeht!",Get_Player_ID(sender));
					if (Settings->Gamelog) 
					{
						char Message[512];
						Vector3	pos;
						pos	= Commands->Get_Position(sender);
						sprintf	(Message, "CRATE;ARMORINCREASE;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
						WriteFile(Message);
					}
				}
				else
				{
					Commands->Set_Shield_Strength(sender,1);
					sprintf(message,"%s verliert fast sein gesamtes Schutzschild.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Napalmkiste] Dein Schutzschild betraegt nur noch 1 Punkt.",Get_Player_ID(sender));
					if (Settings->Gamelog) 
					{
						char Message[512];
						Vector3	pos;
						pos	= Commands->Get_Position(sender);
						sprintf	(Message, "CRATE;ARMORLOST;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
						WriteFile(Message);
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Health)) &&	(Crate_Health >	0))
			{
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (Commands->Get_Health(sender) ==	1) RndGood = 1;
				if (RndGood	== 1)
				{
					Commands->Give_Powerup(sender,"POW_Medal_Health",true);
					sprintf(message,"%s bekommt eine Gesundheitssteigerung.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Doktorkiste] Deine Gesundheit wurde verbessert!",Get_Player_ID(sender));
					if (Settings->Gamelog) 
					{
						char Message[512];
						Vector3	pos;
						pos	= Commands->Get_Position(sender);
						sprintf	(Message, "CRATE;HEALTHUPGRADE;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
						WriteFile(Message);
					}
				}
				else
				{
					Commands->Set_Health(sender,1);
					sprintf(message,"%s hat nur noch einen Punkt Gesundheit.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Gefahrenkiste] Deine Gesundheit is instabil, EVA hat Recht.",Get_Player_ID(sender));
					Create_2D_WAV_Sound_Player(sender,"m00evag_dsgn0026i1evag_snd.wav");
					if (Settings->Gamelog) 
					{
						char Message[512];
						Vector3	pos;
						pos	= Commands->Get_Position(sender);
						sprintf	(Message, "CRATE;HEALTHREDUCE;;%d;%s;%f;%f;%f;%f;%f;%f;%d",	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
						WriteFile(Message);
					}
				}
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Character))	&& (Crate_Character	> 0)) {
				if (Settings->GameMode == 3 || Settings->GameMode == 4) goto CrateStart;

				Reselect3:
				int	Rnd	= Commands->Get_Random_Int(1,101);
				int	Index = 0;
				if (Rnd	<= 20) Index = 0;
				else if	(Rnd <=	40)	Index =	1;
				else if	(Rnd <=	50)	Index =	2;
				else if	(Rnd <=	60)	Index =	3;
				else if	(Rnd <=	70)	Index =	4;
				else if	(Rnd <=	80)	Index =	5;
				else if	(Rnd <=	85)	Index =	6;
				else if	(Rnd <=	90)	Index =	7;
				else if	(Rnd <=	95)	Index =	8;
				else Index = 9;
				if (Commands->Get_Player_Type(sender) == 1) {
					if (IsDisabled(RandomGDIChar[Index][1])) goto Reselect3;
				}
				else if (Commands->Get_Player_Type(sender) == 0) {
					if (IsDisabled(RandomNodChar[Index][1])) goto Reselect3;
				}
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					if (Commands->Get_Player_Type(sender) == 1) {
						sprintf	(Message, "CRATE;CHARACTER;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomGDIChar[Index][0],	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
					else {
						sprintf	(Message, "CRATE;CHARACTER;%s;%d;%s;%f;%f;%f;%f;%f;%f;%d", RandomNodChar[Index][0],	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					}
					WriteFile(Message);
				}
				sprintf(message,"%s wurde in eine andere Einheit verwandelt.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				if (Commands->Get_Player_Type(sender) == 1)
				{
					Change_Character(sender,RandomGDIChar[Index][1]);
					sprintf(message,"ppage %d [Zauberkiste] Du bist jetzt ein GDI %s.",Get_Player_ID(sender),RandomGDIChar[Index][0]);
				}
				else
				{
					Change_Character(sender,RandomNodChar[Index][1]);
					sprintf(message,"ppage %d [Zauberkiste] Du bist jetzt ein Nod %s.",Get_Player_ID(sender),RandomNodChar[Index][0]);
				}
			}
			else if	((RandomIntCrate <=	(percent+=Crate_ButterFingers))	&& (Crate_ButterFingers	> 0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;BUTTERFINGER;;%d;%s;%f;%f;%f;%f;%f;%f;%d",	Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z,	Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Commands->Clear_Weapons(sender);
				int	Rnd	= Commands->Get_Random_Int(1,3);
				if (Rnd	== 1) {
					Commands->Give_Powerup(sender,"POW_Pistol_Player",false);
					Commands->Select_Weapon(sender,"Weapon_Pistol_Player");
				}
				else {
					Commands->Give_Powerup(sender,"CnC_POW_MineTimed_Player_01",false);
					Commands->Select_Weapon(sender,"CnC_Weapon_MineTimed_Player");
				}
				sprintf(message,"%s hat Butterfinger bekommen.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [Butterkiste] Du hast Butterfinger, fast alle Waffen flutschen dir weg.",Get_Player_ID(sender));
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Refill)) &&	(Crate_Refill >	0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;REFILL;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Grant_Refill(sender);
				sprintf(message,"%s hat die Refillkiste bekommen.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [KTkiste] Du bist wieder frisch wie am Kaufterminal.",Get_Player_ID(sender));
				Create_2D_WAV_Sound_Player(sender,"m00puar_aqob0002i1evag_snd.wav");
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Beacon)) &&	(Crate_Beacon >	0))
			{
				if (Settings->DisableBeacons ||	Settings->GameMode == 2 || Settings->GameMode == 3 || Settings->GameMode == 4) goto CrateStart;
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;BEACON;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender),	Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender),	Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				int	RndGood	= Commands->Get_Random_Int(1,3);
				if (RndGood	== 1)
				{
					sprintf(message,"%s bekam einen Zielsucher geschenkt.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					if (Commands->Get_Player_Type(sender) == 1)
					{
						Commands->Give_Powerup(sender,"CnC_POW_IonCannonBeacon_Player",true);
						sprintf(message,"ppage %d [Satellitenkiste] Du bekommst einen Ionenzielsucher geschenkt.",Get_Player_ID(sender));
						Commands->Create_2D_WAV_Sound("m00paib_aqob0004i1evag_snd.wav");
					}
					else if	(Commands->Get_Player_Type(sender) == 0)
					{
						Commands->Give_Powerup(sender,"CnC_POW_Nuclear_Missle_Beacon",true);
						sprintf(message,"ppage %d [Nuklearkiste] Du bekommst einen Nuklearzielsucher geschenkt.",Get_Player_ID(sender));
						Commands->Create_2D_WAV_Sound("m07dsgn_dsgn0004i1gbmg_snd.wav");
					}
				}
				else
				{
					Commands->Create_Object("Beacon_Nuke_Strike_Anim_Post",Commands->Get_Position(obj));
					Commands->Create_Explosion("Explosion_NukeBeacon",Commands->Get_Position(obj),0);
					Damage_All_Objects_Area(2500.0f,"None",Commands->Get_Position(obj),15.0f,obj,0);
					if (Settings->Gamelog) 
					{
						char Message[512];
						Vector3	pos;
						pos	= Commands->Get_Position(sender);
						sprintf	(Message, "CRATE;BEACONDEATH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
						WriteFile(Message);
					}
					sprintf(message,"%s wurde Nuklear gekillt.",Get_Player_Name(sender));
					FDSMessage(message,"_CRATE");
					sprintf(message,"ppage %d [Hiroshimakiste] Du hast eben den GAU in Tschernobyl erlebt ROFL.",Get_Player_ID(sender));
					sprintf(message2,"msg Atomkiste: Ein %s Mitglied hat eben Hiroshima und Nagasaki zusammen erlebt.",Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
					Console_Input(message2);
				}
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Spy)) && (Crate_Spy	> 0))
			{
				if (Settings->GameMode != 1) goto CrateStart;
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;SPY;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Change_Character(sender,"CnC_Nod_FlameThrower_2SF");
				Commands->Set_Is_Visible(sender,false);
				sprintf(message,"Ein %s Zocker hat die Spionagekiste erwischt! Alarm!",Commands->Get_Player_Type(sender)==0?"Nod":"GDI");
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [KGBkiste] Du bist ein Spion -Basisverteidigungen des Gegners schiessen nicht.",Get_Player_ID(sender));
				sprintf(message2,"msg Crate: Ein Amoklaeufer von %s hat die Spycrate. %s pat auf eure Basis auf!",Commands->Get_Player_Type(sender)==0?"Nod":"GDI",Commands->Get_Player_Type(sender)==0?"GDI":"Nod");
				Console_Input(message2);
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Stealth)) && (Crate_Stealth	> 0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;STEALTH;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender),	pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Commands->Enable_Stealth( sender, 1);
				add_stealth_user(Get_Player_Name(sender));
				sprintf(message,"%s hat die SBHkiste erwischt.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [Tarnkiste] Du bist jetzt fr alle mit Corepatch unsichtbar.",Get_Player_ID(sender));
			}
			else if	((RandomIntCrate <=	(percent+=Crate_Thief))	&& (Crate_Thief	> 0))
			{
				if (Settings->Gamelog) 
				{
					char Message[512];
					Vector3	pos;
					pos	= Commands->Get_Position(sender);
					sprintf	(Message, "CRATE;THIEF;;%d;%s;%f;%f;%f;%f;%f;%f;%d", Commands->Get_ID(sender), Commands->Get_Preset_Name(sender), pos.Y,pos.X,pos.Z, Commands->Get_Facing(sender), Commands->Get_Max_Health(sender),Commands->Get_Max_Shield_Strength(sender),Get_Object_Type(sender));
					WriteFile(Message);
				}
				Commands->Give_Money(sender,(Commands->Get_Money(sender) * -1),false);
				sprintf(message,"%s picked up a Thief Crate.",Get_Player_Name(sender));
				FDSMessage(message,"_CRATE");
				sprintf(message,"ppage %d [Crate] You got the Thief Crate, you have lost all of your credits.",Get_Player_ID(sender));
				Create_2D_Sound_Player(sender,"m00evag_dsgn0028i1evag_snd.wav");
			}
			else {
				goto CrateStart;
			}
			Console_Input(message);
		}
	}
}


void KAK_Prevent_Destruction_Until_Entered::Created(GameObject *obj) {
	Commands->Set_Player_Type(obj,-2);
	Commands->Start_Timer(obj,this,30,1);
}

void KAK_Prevent_Destruction_Until_Entered::Damaged(GameObject *obj, GameObject *damager, float damage) {
	Commands->Set_Health(obj,Commands->Get_Max_Health(obj));
	Commands->Set_Shield_Strength(obj,Commands->Get_Max_Shield_Strength(obj));
}

void KAK_Prevent_Destruction_Until_Entered::Custom(GameObject *obj, int message, int param, GameObject *sender) {
	if (message == CUSTOM_EVENT_VEHICLE_ENTER) {
		Destroy_Script();
	}
}

void KAK_Prevent_Destruction_Until_Entered::Timer_Expired(GameObject *obj, int number) {
	if (number == 1) {
		Destroy_Script();
	}
}

ScriptRegistrant<MDB_CNC_Crate>	MDB_CNC_Crate_Registrant("MDB_CNC_Crate","");
ScriptRegistrant<M00_CNC_Crate>	M00_CNC_Crate_Registrant("M00_CNC_Crate","");
ScriptRegistrant<KAK_Prevent_Destruction_Until_Entered>	KAK_Prevent_Destruction_Until_Entered_Registrant("KAK_Prevent_Destruction_Until_Entered","");
