/*	Renegade Scripts.dll
	Scripts for RenAlert
	Copyright 2006 Joshua "NeoSaber" Kraft, Tom "Dante" Anderson, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
#include "scripts.h"
#include "engine.h"
#include "renalert.h"

//////////////RA_Thief_Script//////////////

/*
NeoSaber's Note: This script is currently obsolete. It's been
replaced with the combination of the three scripts RA_Allied_Thief, 
RA_Soviet_Refinery_Controller, and RA_Soviet_Refinery_Theft_Zone
*/

void RA_Thief_Script::Entered(GameObject * obj,GameObject *enter)
{
	//0 = Soviet, 1 = Allies for team #
	if ((enabled) && (Get_Int_Parameter("Thief_Preset_ID") == Commands->Get_Preset_ID(enter)))
	{
		enabled = false;
		Commands->Give_Money(enter,Get_Float_Parameter("Credits_To_Award"),true);
		Commands->Start_Timer(obj,this,Get_Float_Parameter("Prevent_Theft_Timer"),1);
	}
}

void RA_Thief_Script::Timer_Expired(GameObject * obj,int number)
{
	enabled = true;
}

void RA_Thief_Script::Created(GameObject * obj)
{
	enabled = true;
}

void RA_Thief_Script::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&enabled);
}

//////////////RA_Soviet_Defence//////////////

void RA_Soviet_Defence::Created(GameObject * obj)
{
	Vector3 pos,pos1,pos2,pos3;
	GameObject * object;
	objtype = Commands->Get_Player_Type(obj);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);
	pos = Commands->Get_Position(obj);
	pos1.X = pos.X - 10;
	pos1.Y = pos.Y - 10;
	pos1.Z = pos.Z + 2;
	pos2.X = pos.X + 10;
	pos2.Y = pos.Y;
	pos2.Z = pos.Z + 2;
	pos3.X = pos.X + 10;
	pos3.Y = pos.Y - 10;
	pos3.Z = pos.Z + 2;
	object = Commands->Create_Object("Invisible_Object", pos1);
	if (object)
		id1 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos2);
	if (object)
		id2 = Commands->Get_ID(object);
	object = Commands->Create_Object("Invisible_Object", pos3);
	if (object)
		id3 = Commands->Get_ID(object);
	Commands->Start_Timer(obj, this, 10, 1);
}
void RA_Soviet_Defence::Enemy_Seen(GameObject * obj,GameObject * seen)
{
	ActionParamsStruct params;
	Vector3 pos,pos2;
	float distance;
	float minattack,maxattack;
	float attacktimer;
	int IgnorePreset;
	IgnorePreset = Commands->Get_Preset_ID(seen);
	if ((IgnorePreset != Get_Int_Parameter("Spy_Preset_ID")) && (IgnorePreset != Get_Int_Parameter("Aircraft_Preset_ID"))) 
	{
		pos = Commands->Get_Position(obj);
		pos2 = Commands->Get_Position(seen);
		distance = Commands->Get_Distance(pos2,pos);
		minattack = Get_Float_Parameter("MinAttackDistance");
		if (distance >= minattack) 
		{
			maxattack = Get_Float_Parameter("MaxAttackDistance");
			params.Set_Basic(this,100,2,-1);
			params.Set_Attack_Hold(seen,maxattack,0.0,true,false);
			Commands->Action_Attack(obj,params);
			attacktimer = Get_Float_Parameter("AttackTimer");
			Commands->Start_Timer(obj,this,attacktimer,2);
		}
	}
}
void RA_Soviet_Defence::Action_Complete(GameObject * obj,int action,ActionCompleteReason reason)
{
	if (action == 2)
	{
		Commands->Action_Reset(obj,100);
	}
}
void RA_Soviet_Defence::Timer_Expired(GameObject * obj,int number)
{
	ActionParamsStruct var;
	GameObject * object;
	float f;
	switch (number)
	{
	case 1:
		f = Commands->Get_Random(0.0f, 2.9999f);
		switch (__min(int(f), 2))
		{
		case 0:
			object = Commands->Find_Object(id1);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		case 1:
			object = Commands->Find_Object(id2);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
			break;
		default:
			object = Commands->Find_Object(id3);
			if (object)
			{
				var.Set_Basic(this, 70, 1, -1);
				var.Set_Attack(object, 0.0, 0.0, true);
				Commands->Action_Attack(obj, var);
			}
		}
	Commands->Start_Timer(obj, this, 10, 1);
	break;
	case 2:
		Commands->Action_Reset(obj, 100);
		break;
	}
}
void RA_Soviet_Defence::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&id1);
	Auto_Save_Variable(2,4,&id2);
	Auto_Save_Variable(3,4,&id3);
	Auto_Save_Variable(4,4,&objtype);
}

//////////////RA_Repair_Controller//////////////

void RA_Repair_Controller::Killed(GameObject * obj,GameObject * shooter)
{
	Commands->Destroy_Object(Commands->Find_Object(Get_Int_Parameter("ScriptZoneID")));
}

//////////////RA_Repair_Script//////////////

void RA_Repair_Script::Timer_Expired(GameObject * obj,int number)
{
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);
	if (distance <= 10.0)
	{
		float Max_Health = Commands->Get_Max_Health(Commands->Find_Object(number));
		float Health = Commands->Get_Health(Commands->Find_Object(number));
		float Max_Shield_Strength = Commands->Get_Max_Shield_Strength(Commands->Find_Object(number));
		float Shield_Strength = Commands->Get_Shield_Strength(Commands->Find_Object(number));
		if (Health < Max_Health)
		{
			Commands->Set_Health(Commands->Find_Object(number), Health + (float)40.0);
		}
		if (Shield_Strength < Max_Shield_Strength)
		{
			Commands->Set_Shield_Strength(Commands->Find_Object(number), Shield_Strength + (float)40.0);
		}
		Commands->Start_Timer(obj, this, 1.0, number);
	}
}
void RA_Repair_Script::Entered(GameObject * obj,GameObject *enter)
{
	if(Commands->Get_Player_Type(enter) == Get_Int_Parameter("TeamSelection"))
	{
		int preset = Commands->Get_Preset_ID(enter);
		switch(preset)
		{
		case 82080019: //Soviet Transport Helicopter
		case 82080024: //Soviet Ore Truck (AI Controlled)
		case 82080026: //Allied Medium Tank
		case 82080029: //Allied Ore Truck (AI Controlled)
		case 82080043: //Allied Apache
		case 82080048: //Allied APC
		case 82080051: //Allied Mobile Artillery
		case 82080052: //Allied Light Tank
		case 82080055: //Soviet Mammoth Tank
		case 82080056: //Soviet Heavy Tank
		case 82080082: //Allied Phase Tank
		case 82080115: //Soviet V2 Launcher
		case 82080121: //Allied Ranger
		case 82080124: //Soviet Hind
		case 82080141: //Allied Ore Truck (Player Controlled)
		case 82080144: //Soviet Ore Truck (Player Controlled)
		case 82080164: //Soviet Tesla Tank
		case 82080178: //Allied Mine Layer
		case 82080181: //Soviet Mine Layer
		case 82080182: //Soviet Demolition Truck
		case 82080183: //Allied Demolition Truck
		case 82080185: //Soviet Attack Sub
		case 82080188: //Soviet MAD Tank
		case 82080189: //Allied Supply Truck
		case 82080190: //Soviet Supply Truck
		case 82080192: //Allied Destroyer
		case 82080193: //Allied Gunboat
		case 82080194: //Allied Naval Transport
		case 82080195: //Soviet Missile Sub
		case 82080196: //Soviet Naval Transport
			Commands->Start_Timer(obj, this, 1.0, Commands->Get_ID(enter));
		}
	}
}

//////////////RA_Soviet_Refinery_Controller//////////////

void RA_Soviet_Refinery_Controller::Killed(GameObject *obj, GameObject *shooter)
{
	GameObject *zone = Commands->Find_Object(Get_Int_Parameter("ScriptZoneID"));
	Commands->Send_Custom_Event(obj, zone, 0, 0, 0.0);
}

//////////////RA_Soviet_Refinery_Theft_Zone//////////////

void RA_Soviet_Refinery_Theft_Zone::Created(GameObject *obj)
{
	refinery = true;
}

void RA_Soviet_Refinery_Theft_Zone::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == 0)
	{
		refinery = false;
	}
}

void RA_Soviet_Refinery_Theft_Zone::Entered(GameObject *obj, GameObject*enter)
{
	if ((refinery) && (Get_Int_Parameter("Thief_Preset_ID") == Commands->Get_Preset_ID(enter)))
	{
		Commands->Send_Custom_Event(obj, enter, 1, /*sovietID*/0, 0.0);
	}
}

void RA_Soviet_Refinery_Theft_Zone::Exited(GameObject *obj, GameObject *exit)
{
	if ((Get_Int_Parameter("Thief_Preset_ID") == Commands->Get_Preset_ID(exit)))
	{
		Commands->Send_Custom_Event(obj, exit, 0, 0, 0.0);
	}
}

void RA_Soviet_Refinery_Theft_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&refinery);
}

//////////////RA_Allied_Thief//////////////

void RA_Allied_Thief::Created(GameObject *obj)
{
	stealing = false;
	ready = true;
}

void RA_Allied_Thief::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == 1)
	{
		stealing = true;

		if(ready) //check if thief has entered zone before timer expired
		{
			ready = false; //prevent another zone entry theft for now
			Commands->Start_Timer(obj,this,0.0,1); //immediately grant money
		}
	}
	else if(message == 0)
	{
		stealing = false;
	}
}

void RA_Allied_Thief::Timer_Expired(GameObject *obj, int number)
{
	if(stealing)
	{
		//Give to teammates
		Commands->Give_Money(obj,Get_Float_Parameter("Credits_To_Award"),true);
		
		//Steal from enemy (code doesn't work, so it was removed)
		//GameObject *victim = 0 //Don't have a way to handle this yet, 0 was a placeholder
		//Commands->Give_Money(victim, (-1 * (Get_Float_Parameter("Credits_To_Award"))), true);

		Commands->Start_Timer(obj,this,Get_Float_Parameter("Prevent_Theft_Timer"),1);
		ready = false; // just making sure this stays false for now
	}
	else
	{
		ready = true; // all timers have expired, thief can now get credits for zone entry again
	}
}

void RA_Allied_Thief::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&stealing);
	Auto_Save_Variable(2,1,&ready);
}

//////////////RA_Infantry_Spy//////////////

void RA_Infantry_Spy::Created(GameObject *obj)
{
	Commands->Set_Is_Visible(obj,false);
}

//////////////RA_Infantry_NotSpy//////////////

void RA_Infantry_NotSpy::Created(GameObject *obj)
{
	Commands->Set_Is_Visible(obj,true);
}

//////////////RA_Helipad_Zone//////////////

void RA_Helipad_Zone::Entered(GameObject *obj, GameObject *enter)
{
	if(Commands->Get_Player_Type(enter) == Get_Int_Parameter("TeamSelection"))
	{
		Commands->Start_Timer(obj, this, 1.0, Commands->Get_ID(enter));
	}
}

void RA_Helipad_Zone::Timer_Expired(GameObject *obj, int number)
{
	//Distance checking code copied from RA_Repair_Script
	Vector3 pos1;
	Vector3 pos2;
	float distance;
	pos1 = Commands->Get_Position(obj);
	pos2 = Commands->Get_Position(Commands->Find_Object(number));
	distance = Commands->Get_Distance(pos1,pos2);

	if (distance <= 10.0) //reloads vehicle up to 10m from zone center
	{
		if(Commands->Get_Preset_ID(Commands->Find_Object(number)) == Get_Int_Parameter("Apache_Preset_ID"))
		{
			Commands->Give_Powerup(Commands->Find_Object(number),Get_Parameter("Apache_Reload_Powerup"),0);
		}
		else if(Commands->Get_Preset_ID(Commands->Find_Object(number)) == Get_Int_Parameter("Hind_Preset_ID"))
		{
			Commands->Give_Powerup(Commands->Find_Object(number),Get_Parameter("Hind_Reload_Powerup"),0);
		}

		Commands->Start_Timer(obj, this, Get_Float_Parameter("Reload_Interval"), number);
	}
}

//////////////RA_MineLayer//////////////

void RA_MineLayer::Created(GameObject *obj)
{
	driverID = 0;
}

void RA_MineLayer::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(!driverID)
		{
			driverID = Commands->Get_ID(sender);
		}
	}
	if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		if(driverID == Commands->Get_ID(sender))
		{
			driverID = 0;
		}
	}
}

void RA_MineLayer::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if(driverID) //If there's no driver, do nothing
	{
		int hitter; //This will store the ID of the damager
		hitter = Commands->Get_ID(damager);

		if(hitter == driverID)//checking if the driver 'shot' the vehicle
		{
			if(damage == 0.0)//checking if precise ammount of damage was done
			{
				Commands->Send_Custom_Event(obj, Commands->Find_Object(Get_Int_Parameter("Mine_Manager_ID")), 300300, driverID, 0.0);
			}
		}
	}
}

void RA_MineLayer::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&driverID);
}

//////////////RA_Mine//////////////

void RA_Mine::Created(GameObject *obj)
{
	//Copied Code: I assume this 'activates' the mine or something...
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);
	Commands->Enable_Enemy_Seen(obj,true);

	int ap_check;
	int at_check;

	ap_check = Get_Int_Parameter("Is_Anti-Personnel");
	at_check = Get_Int_Parameter("Is_Anti-Tank");

	if(!ap_check)
	{
		AP_mine = false;
	}
	else
	{
		AP_mine = true;
	}

	if(!at_check)
	{
		AT_mine = false;
	}
	else
	{
		AT_mine = true;
	}

}

void RA_Mine::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == 656565) //Is the mine manager saying something?
	{
		ownerID = Get_Player_ID(Commands->Find_Object(param));
		Commands->Set_Player_Type(obj, Commands->Get_Player_Type(Commands->Find_Object(param)));
	}
}

void RA_Mine::Enemy_Seen(GameObject *obj, GameObject *seen)
{
	/*Note: The mine will detonate as soon as it sees its target.
	Therefore the proximity range is the 'Sight Range' on the vehicle
	*/
	if(AP_mine) //Is this mine anti-personnel?
	{
//		if(Commands->Is_A_Star(seen))//Is it a player?
		if(Is_Soldier(seen))//using newer, more specific code
		{
			GameObject *damager = Get_GameObj(ownerID);
			int objID = Commands->Get_Player_Type(obj);
			int ownerID = Commands->Get_Player_Type(damager);
			Commands->Set_Player_Type(obj, 2); //Change teams to avoid friendly fire

			if(objID != ownerID) //Did the owner switch teams?
				Commands->Apply_Damage(obj,Get_Float_Parameter("Trigger_Damage"),Get_Parameter("Trigger_Warhead"),0); //Die Infidel!
			else //Still on same side
				Commands->Apply_Damage(obj,Get_Float_Parameter("Trigger_Damage"),Get_Parameter("Trigger_Warhead"),damager); //Die Infidel!

			return; //the mine is dead, end now
		}
	}

	if(AT_mine) //Is this mine anti-tank?
	{
//		if(!Commands->Is_A_Star(seen))//Is it a vehicle?
		if(Is_Vehicle(seen))//using newer, more specific code
		{
			GameObject *damager = Get_GameObj(ownerID);
			int objID = Commands->Get_Player_Type(obj);
			int ownerID = Commands->Get_Player_Type(damager);
			Commands->Set_Player_Type(obj, 2); //Change teams to avoid friendly fire

			if(objID != ownerID) //Did the owner switch teams?
				Commands->Apply_Damage(obj,Get_Float_Parameter("Trigger_Damage"),Get_Parameter("Trigger_Warhead"), 0); //Good-bye cruel world!
			else
				Commands->Apply_Damage(obj,Get_Float_Parameter("Trigger_Damage"),Get_Parameter("Trigger_Warhead"), damager); //Good-bye cruel world!
			
			return; //the mine is dead, end now
		}
	}
}

void RA_Mine::Destroyed(GameObject *obj)
{
	//Blaaargh! I'm dead!
	Commands->Send_Custom_Event(obj, Commands->Find_Object(Get_Int_Parameter("Mine_Manager_ID")), 200200, Commands->Get_Player_Type(obj), 0.0);
}

void RA_Mine::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,1,&AP_mine);
	Auto_Save_Variable(2,1,&AT_mine);
	Auto_Save_Variable(3,4,&ownerID);
}

//////////////RA_Mine_Manager//////////////

void RA_Mine_Manager::Created(GameObject *obj)
{
	all_mines = 0;
	sov_mines = 0;
}

void RA_Mine_Manager::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	// message 300300: MineLayer requesting Mine placement
	// message 200200: Mine announcing its destruction
	// message 656565: MineManager informing Mine of its Owner
	// param is driver's ID number

	/*Variables moved within the 'if's so they aren't created unless
	the mesage is valid. No need to take up space if it isn't needed*/

	if(message == 300300)
	{
		int team = Commands->Get_Player_Type(Commands->Find_Object(param));

		if(team == 0)//check if this is a soviet request
		{
			int limit = Get_Int_Parameter("Mine_Limit");

			if(sov_mines < limit) //is team under the limit
			{
				//Under limit, request approved, mine created
				sov_mines++;
				GameObject *mine;
				mine = Commands->Create_Object_At_Bone(sender,Get_Parameter("Soviet_Mine"),Get_Parameter("BoneName"));
				Commands->Send_Custom_Event(obj, mine, 656565, param, 1.0);
			}
			else
			{
				//Team at mine limit, request denied, refunding ammo
				Commands->Give_Powerup(sender, Get_Parameter("Mine_Reload"), false);
			}
		}
		else if(team == 1)//check if its an allied request
		{
			int limit = Get_Int_Parameter("Mine_Limit");

			if(all_mines < limit) //is team under the limit
			{
				//Under limit, request approved, mine created
				all_mines++;
				GameObject *mine;
				mine = Commands->Create_Object_At_Bone(sender,Get_Parameter("Allied_Mine"),Get_Parameter("BoneName"));
				Commands->Send_Custom_Event(obj, mine, 656565, param, 1.0);
			}
			else
			{
				//Team at mine limit, request denied, refunding ammo
				Commands->Give_Powerup(sender, Get_Parameter("Mine_Reload"), false);
			}
		}
	}
	else if(message == 200200)
	{
		if(param == 0)//Is this a soviet mine? (message param should be team type)
			sov_mines--; //A moment of silence for out fallen comrade
		else if(param == 1)//or is it an allied mine? (message param should be team type)
			all_mines--; //Why, God?! Why did it have to die?!
	}
}

void RA_Mine_Manager::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&all_mines);
	Auto_Save_Variable(2,4,&sov_mines);
}

//////////////RA_ObjectDeath_OnCreate//////////////

void RA_ObjectDeath_OnCreate::Created(GameObject *obj)
{
	/*NeoSaber's Note: The purpose of this script is to create a new 
	object at the location of another object's creation, then kill 
	the script generated one to use its KilledExplosion setting to 
	place a sound on the map. Only way I've found to 'create' sounds 
	with scripts in multiplayer*/

	const char *c;
	const char *war = "Death";
	Vector3 v;
	c = Get_Parameter("Object");
	v = Commands->Get_Position(obj);
	Commands->Apply_Damage(Commands->Create_Object(c,v),100,war,0);
}

//////////////RA_Naval_Yard//////////////

void RA_Naval_Yard::Created(GameObject *obj)
{
	team_count = 0;
	active = true;
	ready = true;
}

void RA_Naval_Yard::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	//951951 = purchase authorization request
	//753753 = naval unit died

	if(message == 951951) //Authorize request?
	{
		if(active) //am I still alive?
		{
			if(ready)//was a unit just built?
			{
				int limit = Get_Int_Parameter("Limit");

				if(team_count < limit) //Are we under limit?
				{			
					//Authorize purchase and increase count by 1
					Commands->Send_Custom_Event(obj, sender, 159159, 1, 0.0);
					team_count++;
					ready = false;
					Commands->Start_Timer(obj, this, Get_Float_Parameter("Disable_Time"), 0);
									}
				else
				{
					//Authorization denied
					Commands->Send_Custom_Event(obj, sender, 159159, 0, 0.0);
				}
			}
			else//Not ready to build yet
			{	
				//Authorization denied
				Commands->Send_Custom_Event(obj, sender, 159159, 0, 0.0);
			}
		}
		else
		{
			//If I'm dead, everyone dies too! Hahahahaha!
			Commands->Destroy_Object(sender);
		}
	}
	else if(message == 753753) //Death Announcement?
	{
		//Why do the young die?! Why!?
		team_count--;
	}
}

void RA_Naval_Yard::Killed(GameObject *obj, GameObject *shooter)
{
	active = false;
}

void RA_Naval_Yard::Timer_Expired(GameObject *obj, int number)
{
	//'cool down' time complete, construction allowed again
	ready = true;
}

void RA_Naval_Yard::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &team_count);
	Auto_Save_Variable(2, 4, &active);
	Auto_Save_Variable(3, 4, &ready);
}

//////////////RA_Naval_PT//////////////

void RA_Naval_PT::Created(GameObject *obj)
{
	storedID = Get_Int_Parameter("TestID");
	Commands->Display_Health_Bar(obj, false);
	Commands->Set_Player_Type(obj, Get_Int_Parameter("Team"));
}

void RA_Naval_PT::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	//159159 = authorization response

	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		bool send = false; //for later use
		//first check if player matches team

		int teamtest = Get_Int_Parameter("Team");

		if((Commands->Get_Player_Type(sender)) == teamtest)
		{
			//ok, player is on my team, does he have the cash?
			float cost = Get_Float_Parameter("Cost");

			if(Commands->Get_Money(sender) >= cost)
			{
				//player has the money, are they allowed?
				storedID = Commands->Get_ID(sender); //remember for later
				send = true; //get ready to ask controller
			}
		}

		//Now to 'refresh' the PT
		//All the info we'll need from this terminal
		Vector3 pos = Commands->Get_Position(obj);
		float face = Commands->Get_Facing(obj);
		GameObject *newobj;
		char params[100];
		sprintf(params,"%s,%s,%s,%s,%s,%d",Get_Parameter("Preset_Name"),Get_Parameter("Cost"),Get_Parameter("Team"),Get_Parameter("Controller_ID"),Get_Parameter("Zone_ID"),storedID); //Get parameters

		//time to die
		Commands->Destroy_Object(obj);
		
		//Create new terminal and attach script
		newobj = Commands->Create_Object(Commands->Get_Preset_Name(obj), pos);
		Commands->Set_Facing(newobj, face);
		Commands->Attach_Script(newobj, "RA_Naval_PT", params);

		if(send) //should I bother the boss?
		{
			//Have the new PT send message so it receives response
			Commands->Send_Custom_Event(newobj, Commands->Find_Object(Get_Int_Parameter("Controller_ID")), 951951, 0, 0.0);
		}
	}
	else if(message == 159159)
	{
		if(param == 1)
		{
			if(storedID) //Do I remember a player?
			{
				float cost = Get_Float_Parameter("Cost");
				cost = -cost;

				Commands->Give_Money(Commands->Find_Object(storedID),cost,false);

				//tell zone to clear the the construction zone
				Commands->Send_Custom_Event(obj, Commands->Find_Object(Get_Int_Parameter("Zone_ID")), 846846, 0, 0.0);

				//1 second delay to allow zone to clear
				Commands->Start_Timer(obj,this,1.0, 0);

				//clear the ID, we don't need it now
				storedID = 0;
			}
		}
		else
		{
			storedID = 0; //request denied, erase ID
		}
	}
}

void RA_Naval_PT::Timer_Expired(GameObject *obj, int number)
{
	GameObject *newobj;
	//Create the object
	newobj = Commands->Create_Object(Get_Parameter("Preset_Name"), Commands->Get_Position(Commands->Find_Object(Get_Int_Parameter("Zone_ID"))));
	Commands->Set_Facing(newobj, Commands->Get_Facing(Commands->Find_Object(Get_Int_Parameter("Zone_ID"))));//Set_Facing won't work on a script zone
	Commands->Attach_Script(newobj, "RA_Naval_Unit", Get_Parameter("Controller_ID"));
}

void RA_Naval_PT::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &storedID);
}

//////////////RA_Naval_PT_Pokable//////////////

void RA_Naval_PT_Pokable::Created(GameObject *obj)
{
	storedID = 0;
	Commands->Display_Health_Bar(obj, false);
	Commands->Set_Player_Type(obj, Get_Int_Parameter("Team"));
	Commands->Enable_HUD_Pokable_Indicator(obj, true);
}

void RA_Naval_PT_Pokable::Poked(GameObject *obj, GameObject *poker)
{
	//first check if player matches team

	int teamtest = Get_Int_Parameter("Team");

	if((Commands->Get_Player_Type(poker)) == teamtest)
	{
		//ok, player is on my team, does he have the cash?
		float cost = Get_Float_Parameter("Cost");

		if(Commands->Get_Money(poker) >= cost)
		{
			//player has the money, are they allowed?
			storedID = Commands->Get_ID(poker); //remember for later
			Commands->Send_Custom_Event(obj, Commands->Find_Object(Get_Int_Parameter("Controller_ID")), 951951, 0, 0.0);
		}
	}
}

void RA_Naval_PT_Pokable::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	//159159 = authorization response

	if(message == 159159)
	{
		if(param == 1)
		{
			if(storedID) //Do I remember a player?
			{
				float cost = Get_Float_Parameter("Cost");
				cost = -cost;

				Commands->Give_Money(Commands->Find_Object(storedID),cost,false);

				//tell zone to clear the the construction zone
				Commands->Send_Custom_Event(obj, Commands->Find_Object(Get_Int_Parameter("Zone_ID")), 846846, 0, 0.0);

				//1 second delay to allow zone to clear
				Commands->Start_Timer(obj,this,1.0, 0);

				//clear the ID, we don't need it now
				storedID = 0;
			}
		}
		else
		{
			storedID = 0; //request denied, erase ID
		}
	}
}

void RA_Naval_PT_Pokable::Timer_Expired(GameObject *obj, int number)
{
	//Create the object
	GameObject *newobj;
	newobj = Commands->Create_Object(Get_Parameter("Preset_Name"), Commands->Get_Position(Commands->Find_Object(Get_Int_Parameter("Zone_ID"))));
	Commands->Set_Facing(newobj, Commands->Get_Facing(Commands->Find_Object(Get_Int_Parameter("Zone_ID"))));
	Commands->Attach_Script(newobj, "RA_Naval_Unit", Get_Parameter("Controller_ID"));
}

void RA_Naval_PT_Pokable::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &storedID);
}

//////////////RA_Naval_Unit//////////////

void RA_Naval_Unit::Destroyed(GameObject *obj)
{
	int controller = Get_Int_Parameter("Controller_ID");

	Commands->Send_Custom_Event(obj, Commands->Find_Object(controller), 753753, 0, 0.0);
}

//////////////RA_Naval_Zone//////////////

void RA_Naval_Zone::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == 846846)
	{
		//Fire in the hole!!!!
		Commands->Create_Explosion(Get_Parameter("Explosion"), Commands->Get_Position(obj), 0);
	}
}

//////////////RA_Damaged_Credits//////////////

void RA_Damaged_Credits::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if(Commands->Is_A_Star(damager)) //Ignore if not a player
	{
		int objtype1 = Commands->Get_Player_Type(obj);
		int objtype2 = Commands->Get_Player_Type(damager);

		if(objtype1 == 0 || objtype1 == 1) //Ignore if not soviet or allied
		{
			if(objtype1 != objtype2) //Test if on different teams
			{
				if(damage > 0) //If 'damage' was harmful
				{
					float divisor = Get_Float_Parameter("Divisor");
					Commands->Give_Money(damager, damage/divisor, false);
				}
			}
			else if(objtype1 == objtype2) //Just to be sure...
			{
				if(damage < 0) //If 'damage' was helpful
				{
					float divisor = Get_Float_Parameter("Divisor");
					Commands->Give_Money(damager, (-damage)/divisor, false);
				}
			}

		}
	}
}

//////////////RA_GameStart_Detector//////////////

void RA_GameStart_Detector::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, Get_Float_Parameter("Interval"), 564);
}

void RA_GameStart_Detector::Killed(GameObject *obj, GameObject *shooter)
{
	int receiverID = Get_Int_Parameter("ReceiverID");
	int message = Get_Int_Parameter("Message");
	int param = Get_Int_Parameter("Parameter");

	Commands->Send_Custom_Event(obj, Commands->Find_Object(receiverID), message, param, 0.0);
}

void RA_GameStart_Detector::Timer_Expired(GameObject *obj, int number)
{
	if(number == 564)
	{
		Commands->Apply_Damage(obj, 100.0, "BlamoKiller", 0);
		Commands->Start_Timer(obj, this, Get_Float_Parameter("Interval"), 564);
	}
}

//////////////RA_DriverDeath//////////////

void RA_DriverDeath::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, 0.5, 12121);
}

void RA_DriverDeath::Timer_Expired(GameObject *obj, int number)
{
	if(number == 12121)
		Commands->Apply_Damage(obj, 100, "Death", 0);
}

//////////////RA_Conyard_Controller//////////////

void RA_Conyard_Controller::Created(GameObject *obj)
{
	GameObject * object;
	int id = 0;
	int message = 3000;
	int param = 230032;
	id = Get_Int_Parameter("Building1_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building2_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building3_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building4_ID");
	if (id) 
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building5_ID");
	if (id) 
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building6_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building7_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building8_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building9_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
	id = Get_Int_Parameter("Building10_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 1);
	}
}

void RA_Conyard_Controller::Killed(GameObject * obj, GameObject * shooter)
{
	GameObject * object;
	int id = 0;
	int message = 3000;
	int param = 320023;
	id = Get_Int_Parameter("Building1_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building2_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building3_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building4_ID");
	if (id) 
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building5_ID");
	if (id) 
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building6_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building7_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building8_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building9_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
	id = Get_Int_Parameter("Building10_ID");
	if (id)
	{
		object = Commands->Find_Object(id);
		Commands->Send_Custom_Event(obj, object, message, param, 0);
	}
}

//////////////RA_Conyard_Repair//////////////

void RA_Conyard_Repair::Created(GameObject * obj)
{
	Enabled = false;
	objID = Commands->Get_ID(obj);
}

void RA_Conyard_Repair::Custom(GameObject * obj, int message, int param, GameObject * sender)
{
	if (message == 3000)
	{
		if(param == 230032)
		{
			if(!Enabled) //prevents more than one timer from starting
			{
				Enabled = true;
				Commands->Start_Timer(obj, this, Get_Float_Parameter("Repair_Frequency"), objID);
			}
		}
		else if(param == 320023)
			Enabled = false;
	}
}

void RA_Conyard_Repair::Timer_Expired(GameObject * obj,int number)
{
	float amount = Commands->Get_Health(obj);
	if(amount > 0) 
	{
		Commands->Set_Health(obj,(amount+2));
		
		//These next checks are to trigger building damage state changes as health refills
		float max = Commands->Get_Max_Health(obj);	
		if(amount < (max * 0.25) && (amount + 2) > (max * 0.25))
			Commands->Apply_Damage(obj, 0, "None", 0);
		else if(amount < (max * 0.5) && (amount + 2) > (max * 0.5))
			Commands->Apply_Damage(obj, 0, "None", 0);
		else if(amount < (max * 0.75) && (amount + 2) > (max * 0.75))
			Commands->Apply_Damage(obj, 0, "None", 0);

		//Only start a new timer if still enabled
		if (Enabled)
			Commands->Start_Timer(obj, this, Get_Float_Parameter("Repair_Frequency"), objID);
		else
			return;
	}
}

void RA_Conyard_Repair::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &Enabled);
	Auto_Save_Variable(2, 4, &objID);
}

//////////////RA_ObjectDeath_OnDeath//////////////

void RA_ObjectDeath_OnDeath::Killed(GameObject *obj, GameObject *shooter)
{
	GameObject *BoomBox;
	BoomBox = Commands->Create_Object(Get_Parameter("Preset"),Commands->Get_Position(obj));
	Commands->Apply_Damage(BoomBox, 100, "BlamoKiller", 0);
}

//////////////RA_Demolition_Truck_Improved//////////////

void RA_Demolition_Truck_Improved::Created(GameObject *obj)
{
	driverID = 0;
	triggered = false;
}

void RA_Demolition_Truck_Improved::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	//checks when someone gets in or out and records ID
	//this should account for when there are passengers too

	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		if(!driverID) //is there a driver already?
		{
			driverID = Commands->Get_ID(sender);
		}
	}
	else if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		int testID;
		testID = Commands->Get_ID(sender);

		if(driverID == testID) //is it the driver that got out?
		{
			driverID = 0;
		}
	}
}

void RA_Demolition_Truck_Improved::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if(!driverID)
		return; //if there's no driver, don't bother

	int testID;
	testID = Commands->Get_ID(damager);

	if(driverID == testID) //did the driver shoot me?
	{
		const char *warhead = "Death";
		//I can't take it any more! *bang*
		Commands->Apply_Damage(obj, 100.00, warhead, 0);
		triggered = true;
	}

}

void RA_Demolition_Truck_Improved::Killed(GameObject *obj, GameObject *shooter)
{
	Vector3 pos;
	pos = Commands->Get_Position(obj);
	int testID;

	testID = Commands->Get_ID(shooter);

	const char *explosion = Get_Parameter("Explosion");
	const char *warhead = Get_Parameter("Warhead");
	float damage = Get_Float_Parameter("DamageStrength");
	float radius = Get_Float_Parameter("DamageRadius");

	if(testID) //is there a real shooter?
	{
		Commands->Create_Explosion(explosion, pos, shooter);
		Ranged_Scale_Damage_To_Buildings(damage, warhead,Commands->Get_Position(obj),radius,shooter);
	}
	else if(triggered)//then was it the driver?
	{
		Commands->Create_Explosion(explosion, pos, Commands->Find_Object(driverID));
		Ranged_Scale_Damage_To_Buildings(damage,warhead,Commands->Get_Position(obj),radius,Commands->Find_Object(driverID));
	}
		
	if(driverID)//If there's a driver, kill him
	{
		Commands->Attach_Script(Commands->Find_Object(driverID),"RA_DriverDeath", "0");
	}
}

void RA_Demolition_Truck_Improved::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &driverID);
	Auto_Save_Variable(2, 4, &triggered);
}


///////////////////RA_CTF_Zone///////////////////

void RA_CTF_Zone::Created(GameObject * obj)
{
	GotFlag = false;
	NumCaptured = 0;
	PlayerId = 0;
	FlagId = 0;
	Vector3 newFlagPos = Commands->Get_Position(obj);
	GameObject * newFlag = Commands->Create_Object(Get_Parameter("Flag_Preset_Name"), newFlagPos);
	DecorFlag = Commands->Get_ID(newFlag);
	DecorFlagPresent = false;
}

void RA_CTF_Zone::Entered(GameObject * obj, GameObject * enter)
{
	if (Get_Int_Parameter("Team_ID") != Commands->Get_Player_Type(enter))
		Commands->Send_Custom_Event(obj, enter, 10004, 0, 0);				//ask player if it has the flag
	else if (!GotFlag)
	{
		Commands->Attach_Script(enter, "TDA_CTF_Attached", "0");			//load up the player script
		GameObject * tmpObj = Commands->Create_Object_At_Bone(enter, Get_Parameter("Flag_Preset_Name"), "LHAND"); //create the flag object
		int objID = Commands->Get_ID(tmpObj);								//get the new flags ID
		FlagId = objID;
		Commands->Send_Custom_Event(obj, enter, 10003, objID, 0);			//tell the player script what the flag id is
		Commands->Attach_To_Object_Bone(tmpObj, enter, "LHAND");			//attach flag to player
		objID = Commands->Get_ID(obj);										//get the current zones ID
		Commands->Send_Custom_Event(obj, enter, 10005, objID, 0);			//let the player know the ID of zone
		PlayerId = Commands->Get_ID(enter);
		GotFlag = true;														//let zone know NOT to create a new flag
		Commands->Start_Timer(obj, this, 10, 411);							//needed to add this for the suicide and lag flags
		/* //Capture Sounds removed
		if (Get_Int_Parameter("Play_Capture_Sounds") == 1)
		{
			Vector3 SoundLocal = Commands->Get_Position(obj);
			Commands->Create_Sound("SFX.Flag_Pickup", SoundLocal, obj);
		}
		*/
		Commands->Give_Points(enter, 75, false);
		Commands->Destroy_Object(Commands->Find_Object(DecorFlag));
		DecorFlagPresent = false;
	}
}

void RA_CTF_Zone::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1,4,&GotFlag);
	Auto_Save_Variable(2,4,&NumCaptured);
	Auto_Save_Variable(3,4,&DecorFlag);
	Auto_Save_Variable(4,4,&DecorFlagPresent);
	Auto_Save_Variable(5,4,&FlagId);
	Auto_Save_Variable(6,4,&PlayerId);
}

void RA_CTF_Zone::Custom(GameObject * obj, int message, int param, GameObject * sender)
{
	GameObject * newFlag;
	Vector3 newFlagPos;
	if ((message == 10002) && (GotFlag))
	{
//		float maxHealth;
		GotFlag = false;													//tell zone that flag can be recaptured
		Commands->Send_Custom_Event(obj, sender, 10002, 1, 0);				//tell player script "kill your flag, it is now captured"
		NumCaptured++;														//increment the # of captures
		newFlagPos = Commands->Get_Position(obj);
		newFlag = Commands->Create_Object(Get_Parameter("Flag_Preset_Name"), newFlagPos);
		DecorFlag = Commands->Get_ID(newFlag);
		Commands->Give_Points(sender, 250, false);

		/* //Capture Sounds Removed
		if (Get_Int_Parameter("Play_Capture_Sounds") == 1)
		{
			Vector3 SoundLocal = Commands->Get_Position(obj);
			Commands->Create_Sound("SFX.Flag_Capture",SoundLocal,obj);
		}
		*/
		if (NumCaptured == Get_Int_Parameter("Max_Capture"))								//check to see if the max captures have been met
		{
			if(Get_Int_Parameter("Team_ID") == 0) //Is this a Soviet Win?
			{
				//Then kill all Allied Buildings
				Kill_All_Buildings_By_Team(1);
			}
			else if(Get_Int_Parameter("Team_ID") == 1) //Is this an Allied Win?
			{
				//Then kill all Allied Buildings
				Kill_All_Buildings_By_Team(0);
			}
		}
	}
	else if ((message == 10005) && (GotFlag))
	{
		/* //Capture Sounds Removed
		if(Get_Int_Parameter("Play_Capture_Sounds") == 1)
		{
			Vector3 SoundLocal = Commands->Get_Position(obj);
			Commands->Create_Sound("SFX.Flag_Drop", SoundLocal, obj);
		}
		*/
		GotFlag = false;
		if (!DecorFlagPresent)
		{
			newFlagPos = Commands->Get_Position(obj);
			newFlag = Commands->Create_Object(Get_Parameter("Flag_Preset_Name"),newFlagPos);
			DecorFlag = Commands->Get_ID(newFlag);
			DecorFlagPresent=true;
		}
	}

}

void RA_CTF_Zone::Timer_Expired(GameObject * obj,int number)
{
	if (GotFlag)
	{
		Vector3 fPos = Commands->Get_Position(Commands->Find_Object(FlagId));
		Vector3 pPos = Commands->Get_Position(Commands->Find_Object(PlayerId));
		float dPos = Commands->Get_Distance(fPos, pPos);

		if (dPos > 2)
		{
			GameObject * flagObj = Commands->Find_Object(FlagId);
			Commands->Destroy_Object(flagObj);
			Commands->Send_Custom_Event(obj, obj, 10005, 0, 0);
			FlagId = 0;
			PlayerId = 0;
			GotFlag = false;
		}
		Commands->Destroy_Object(Commands->Find_Object(DecorFlag));
		DecorFlagPresent = false;
		Commands->Start_Timer(obj, this, 10, 411);
	}
}

/////////////RA_MAD_Tank_Improved/////////////


void RA_MAD_Tank_Improved::Created(GameObject *obj)
{
	//Initializing variables
	driverID = 0;
	deployed = false;
	newobjID = 0;
	ownerID = 0;
}

void RA_MAD_Tank_Improved::Custom(GameObject *obj, int message, int param, GameObject *sender)
{
	if(message == CUSTOM_EVENT_VEHICLE_ENTER)
	{
		driverID = Commands->Get_ID(sender);
	}
	else if(message == CUSTOM_EVENT_VEHICLE_EXIT)
	{
		int testID;
		testID = Commands->Get_ID(sender);

		if(driverID == testID) //is it the driver that got out?
		{
			driverID = 0;

			//This section replaced with Force_Occupants_Exit
/*			if(deployed) //If already deployed, no one gets back in
			{
				//This is to try to correct for the flawed Transition Disable
				Commands->Enable_HUD_Pokable_Indicator(obj, false);	
				//Host uses these next 2, but clients don't see the effect
				Commands->Enable_Vehicle_Transitions(obj, false);
				Commands->Set_Player_Type(obj, Commands->Get_Player_Type(sender));			
			}
*/		}
	}
}

void RA_MAD_Tank_Improved::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if(!deployed) //If already deployed, don't do anything
	{
		if(driverID) //Make sure there's a driver
		{
			int testID = Commands->Get_ID(damager); //Get ID to compare
			if(driverID == testID)
			{
				//Create Object to jam MAD Tank in place
				GameObject *newobj = Commands->Create_Object_At_Bone(obj, "Generic_Cinematic", Get_Parameter("Bone"));
				Commands->Set_Model(newobj, Get_Parameter("Attach_Model"));
				Commands->Attach_To_Object_Bone(newobj, obj, Get_Parameter("Bone"));
				newobjID = Commands->Get_ID(newobj);

				//Animate MAD Tank, record player ID of owner
				Commands->Create_2D_Sound(Get_Parameter("Announcement"));
				Commands->Set_Animation(obj, Get_Parameter("Deployed_Animation"), false, 0, 0, -1, false);
				ownerID = Get_Player_ID(damager);

				//New stuff added for v0.9935
				Force_Occupants_Exit(obj); //kick driver out
				Commands->Enable_HUD_Pokable_Indicator(obj, false);	//this was to correct some issue
				Commands->Enable_Vehicle_Transitions(obj, false); //no getting back in
				Commands->Set_Player_Type(obj, Commands->Get_Player_Type(damager)); //set team
				//End New Stuff

				deployed = true;
			}
		}
	}
}

void RA_MAD_Tank_Improved::Animation_Complete(GameObject *obj, const char *anim)
{
	if(!stricmp(anim, Get_Parameter("Deployed_Animation"))) //Is this the right animation?
	{
		if(Get_GameObj(ownerID)) //sonic pulse only if owner still valid
		{
			//Create/Kill Object for Sonic Pulse, this is meant for visual explosion effect only
			GameObject *SonicBox = Commands->Create_Object(Get_Parameter("Sonic_Preset"), Commands->Get_Position(obj));
			Commands->Set_Player_Type(SonicBox, 2); //just in case
			Commands->Apply_Damage(SonicBox,100,"BlamoKiller",Get_GameObj(ownerID));

			//Setup for building damage
			float percentage = Get_Float_Parameter("Percentage");
			const char *warhead = Get_Parameter("Warhead");
			float range = Get_Float_Parameter("DamageRadius");

			//Time to break a few windows
			Ranged_Percentage_Damage_To_Buildings(percentage, warhead, Commands->Get_Position(obj), range, Get_GameObj(ownerID));
			Ranged_Percentage_Damage_To_Vehicles(percentage, warhead, Commands->Get_Position(obj), range, Get_GameObj(ownerID)); 
		}
		
		//Kill MAD Tank 
		//'0' Damager used so owner won't get points for tank itself
		Commands->Apply_Damage(obj,100,"BlamoKiller",0);
	}
}

void RA_MAD_Tank_Improved::Destroyed(GameObject *obj)
{
	//MAD Tank dead, get rid of piston object if it exists
	if(newobjID)
		Commands->Destroy_Object(Commands->Find_Object(newobjID));
}

void RA_MAD_Tank_Improved::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &driverID);
	Auto_Save_Variable(2, 4, &deployed);
	Auto_Save_Variable(3, 4, &newobjID);
	Auto_Save_Variable(4, 4, &ownerID);
}

//////////////RA_Conyard_Controller_Improved//////////////

void RA_Conyard_Controller_Improved::Created(GameObject *obj)
{
	int message = 3000;
	int param = 230032;
	int team = Get_Int_Parameter("Team");

	Send_Custom_To_Team_Buildings(team,obj,message,param,1);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset1"), obj, message, param, 1);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset2"), obj, message, param, 1);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset3"), obj, message, param, 1);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset4"), obj, message, param, 1);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset5"), obj, message, param, 1);
}

void RA_Conyard_Controller_Improved::Killed(GameObject * obj, GameObject * shooter)
{
	int message = 3000;
	int param = 320023;
	int team = Get_Int_Parameter("Team");

	Send_Custom_To_Team_Buildings(team,obj,message,param,0);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset1"), obj, message, param, 0);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset2"), obj, message, param, 0);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset3"), obj, message, param, 0);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset4"), obj, message, param, 0);
	Send_Custom_To_Team_Preset(team, Get_Parameter("Preset5"), obj, message, param, 0);
}

/////////////////RA_Building_DeathSound/////////////////

void RA_Building_DeathSound::Created(GameObject *obj)
{
	halfdead = false;
}

void RA_Building_DeathSound::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	const float max = Commands->Get_Max_Health(obj);
	const float current = Commands->Get_Health(obj);

	if(current <= (max/2))
	{
		if(!halfdead)
		{
			halfdead = true;
			Commands->Create_Sound(Get_Parameter("HalfSound"), Commands->Get_Position(obj), obj);
		}
	}
	else
	{
		if(halfdead)
		{
			halfdead = false;
		}
	}
}

void RA_Building_DeathSound::Killed(GameObject *obj, GameObject *shooter)
{
	Commands->Create_Sound(Get_Parameter("DeadSound"), Commands->Get_Position(obj), obj);
}

void RA_Building_DeathSound::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &halfdead);
}

/////////////////RA_Base_Defense_Simple/////////////////

void RA_Base_Defense_Simple::Created(GameObject *obj)
{
	//Initialize Variables
	targetID = 0;
	attacking = false;
	current_priority = 10;
	attack_timer = 1.0f;
	loop_count = 0;

	//Standard AI Startup Junk
	Commands->Enable_Enemy_Seen(obj, true);
	Commands->Enable_Vehicle_Transitions(obj, false);
	Commands->Enable_Hibernation(obj,false);
	Commands->Innate_Enable(obj);

	Commands->Start_Timer(obj, this, attack_timer, 11);
}

void RA_Base_Defense_Simple::Damaged(GameObject *obj, GameObject *damager, float damage)
{
	if(Is_VTOLVehicle(damager))
	{
		if(!(Get_Int_Parameter("AntiAir")))
			return; //Ignore the target
	}
	else
	{
		if(!(Get_Int_Parameter("AntiGround")))
			return; //Ignore the target
	}

	if(targetID) //check for current target
	{
		unsigned long newID = Commands->Get_ID(damager);
		if(targetID == newID)
			return; //already firing at target
	}

	int objID = Commands->Get_Player_Type(obj);
	int damagerID = Commands->Get_Player_Type(damager);

	if(objID != damagerID) //Make sure an enemy attacked
		Attack(obj, damager);
}

void RA_Base_Defense_Simple::Enemy_Seen(GameObject *obj, GameObject *seen)
{
	if(Is_VTOLVehicle(seen))
	{
		if(!(Get_Int_Parameter("AntiAir")))
			return; //Ignore the target
	}
	else
	{
		if(!(Get_Int_Parameter("AntiGround")))
			return; //Ignore the target
	}

	if(targetID) //check for current target
	{
		unsigned long newID = Commands->Get_ID(seen);
		if(targetID == newID)
			return; //already firing at target
	}

	Attack(obj, seen);
}

void RA_Base_Defense_Simple::Timer_Expired(GameObject *obj, int number)
{
	if(number != 11)
		return; //If its not the timer we're interested in, end now

	bool call_attack = true;

	if(!attacking)	//skip facing action if attacking
	{
		if(loop_count > 4) //only face new direction every 5th loop
		{
		Vector3 pos = Commands->Get_Position(obj); 
		switch (Commands->Get_Random_Int(0,8))
		{
			case 0:
				pos.X += 10;
				pos.Y -= 10;
				break;
			case 1:
				pos.X -= 10;
				pos.Y -= 10;
				break;
			case 2:
				pos.X += 10;
				pos.Y += 10;
				break;
			case 3:
				pos.X -= 10;
				pos.Y += 10;
				break;
			case 4:
				pos.X += 10;
				break;
			case 5:
				pos.X -= 10;
				break;
			case 6:
				pos.Y += 10;
				break;
			case 7:
				pos.Y -= 10;
				break;
			default: 
				pos.X += 10;
				break;
			}

			ActionParamsStruct params;

			params.Set_Basic(this, 1, 30, -1); //priority low
			params.Set_Face_Location(pos, 4);
			Commands->Action_Face_Location(obj, params);
		}
	}
	else
	{
		//force ceasefire before checking to continue (helps fight client glitches... I hope...)
		Commands->Action_Reset(obj, 1000); //I have no idea what this number does...
		attacking = false;
		current_priority = 10;

		GameObject *target = Commands->Find_Object(targetID);

		if(!(target)) 
		{	//If target invalid, end now
			targetID = 0; //
/*			Commands->Action_Reset(obj, 100); 
			attacking = false;
			current_priority = 10;
*/			call_attack = false;
		}
		else
		{
			////////////////Check Target Health////////////////
			//Note: this health check is removed because it doesn't seem to make a difference
/*			float health = Commands->Get_Health(target);

			if(health < 1) //also tried <= 0
			{
				targetID = 0; //target died
				Commands->Action_Reset(obj, 100); 
				attacking = false;
				current_priority = 10;
				call_attack = false;
			}
*/			/////////////////Check Player Type/////////////////
			int TargetType = Commands->Get_Player_Type(target);
			int myType = Commands->Get_Player_Type(obj);
			if(myType == TargetType) //Check old target for team change
			{
				targetID = 0; //old target a friend now
/*				Commands->Action_Reset(obj, 100); 
				attacking = false;
				current_priority = 10;
*/				call_attack = false;
			}
			////////////////////Check Range////////////////////
			Vector3 objPos = Commands->Get_Position(obj);
			Vector3 targetPos = Commands->Get_Position(target);
			float range = Commands->Get_Distance(objPos, targetPos);
			float max = Get_Float_Parameter("MaxRange");
			float min = Get_Float_Parameter("MinRange");
			if(range < min || range > max)
			{
				targetID = 0; //old target out of range
/*				Commands->Action_Reset(obj, 100); 
				attacking = false;
				current_priority = 10;
*/				call_attack = false;
			}
			///////////////////Check Settings//////////////////
			if(Is_VTOLVehicle(target) || Is_VTOLVehicle(Get_Vehicle(target)))
			{
				if(!(Get_Int_Parameter("AntiAir")))
				{
					targetID = 0; //old target not targetable
/*					Commands->Action_Reset(obj, 100);
					attacking = false;
					current_priority = 10;
*/					call_attack = false;
				}
			}
			else
			{
				if(!(Get_Int_Parameter("AntiGround")))
				{
					targetID = 0; //old target not targetable
/*					Commands->Action_Reset(obj, 100); 
					attacking = false;
					current_priority = 10;
*/					call_attack = false;
				}
			}
		}
		///////////////////////////////////////////////////

		if(call_attack) //if attack and if call_attack was not turned false
			Attack(obj, target);
	}

	if(loop_count > 4)
		loop_count = 0; //reset counter

	loop_count++;
	Commands->Start_Timer(obj, this, attack_timer, 11);
}

void RA_Base_Defense_Simple::Action_Complete(GameObject *obj, int action, ActionCompleteReason reason)
{
	if(action == 100) //Attack completed
	{
		attacking = false;
		targetID = 0;
		current_priority = 10;
	}
}

void RA_Base_Defense_Simple::Register_Auto_Save_Variables()
{
	Auto_Save_Variable(1, 4, &targetID);
	Auto_Save_Variable(2, 4, &attacking);
	Auto_Save_Variable(3, 4, &current_priority);
	Auto_Save_Variable(4, 4, &attack_timer);
	Auto_Save_Variable(5, 4, &loop_count);
}

void RA_Base_Defense_Simple::Attack(GameObject *obj, GameObject *target)
{
	/**************Evaluate Target Threat****************/
	GameObject *FinalTarget = Set_Target(target);

	if(FinalTarget) //Was there a non-NULL return from Set_Target?
		FinalTarget = Select_Target(obj, FinalTarget); //Was Rate_Target

	/****************Execute Final Attack****************/
	if(FinalTarget) //Check if I can still fire
	{
		targetID = Commands->Get_ID(target); //remember new target
		Vector3 objPos = Commands->Get_Position(obj);
		Vector3 targetPos = Commands->Get_Position(FinalTarget);
		float range = Commands->Get_Distance(objPos, targetPos);
		float max = Get_Float_Parameter("MaxRange");
		float min = Get_Float_Parameter("MinRange");
		if(min < range && range < max)
		{
			ActionParamsStruct params;
			params.Set_Basic(this, current_priority, 100, -1);

			if(Adjust_For_Infantry(FinalTarget))
			{
				params.Set_Attack_Position(targetPos, range, 0, true);
				params.Hold_Action = false;
			}
			else
				params.Set_Attack_Hold(FinalTarget, range, 0, true, false);
			
			Commands->Action_Attack(obj, params);
			current_priority++;
			attacking = true;
		}
		else
		{
			attacking = false;
			targetID = 0;
			current_priority = 10;
		}
	}
}

GameObject* RA_Base_Defense_Simple::Select_Target(GameObject *obj, GameObject *target)
{
	//Targets passed into Select_Target have already been
	//checked for "infantry in vehicle" by Set_Target

	if(!(target)) //First see if there is a valid target
		return Commands->Find_Object(targetID);; //no need to test an invalid target

	GameObject *old = Commands->Find_Object(targetID);
	if(!(old)) //is there a current target?
		return target; //no need to test an invalid target

	//////////////////////////////////////////////////////

	int toggle = Get_Int_Parameter("TargetMode");

	switch(toggle)
	{
	/////////////////////////////////////////////
	//Case 0 prioritizes vehicles over infantry//
	/////////////////////////////////////////////
	case 0:
		if(Is_Soldier(old) && !(Is_Soldier(target)))
			return target; //new target is a vehicle
		else if(!(Is_Soldier(old)) && Is_Soldier(target))
			return old; //old target is a vehicle
		else
			return Tie_Breaker(obj, target, old); //both targets the same, let tie breaker decide
		
		break;//just to be safe

	/////////////////////////////////////////////
	//Case 1 prioritizes infantry over vehicles//
	/////////////////////////////////////////////
	case 1:
		if(Is_Soldier(old) && !(Is_Soldier(target)))
		{
			if(Get_Vehicle(old))// Did the old target get in a vehicle?
				return Tie_Breaker(obj, target, old); //both vehicle
			else
				return old; //old soldier
		}
		else if(!(Is_Soldier(old)) && Is_Soldier(target))
		{
			if(Get_Vehicle(target))// Did the new target get in a vehicle? 
				return Tie_Breaker(obj, target, old); //both vehicle 
			//Needs to pass in the vehicle instead of old?
			else
				return target; //target soldier
		}
		else
			return Tie_Breaker(obj, target, old); //both targets the same, let tie breaker decide

		break; //just to be safe

	//////////////////////////////////////////
	//Default doesn't prioritize target type//
	//////////////////////////////////////////
	default: 
		return Tie_Breaker(obj, target, old); //all people are equal in my gun sights
		break; //yes, being safe still
	}
}

GameObject* RA_Base_Defense_Simple::Set_Target(GameObject *target)
{
	if(target) //confirm non-NULL pointer
	{
		if(Commands->Is_A_Star(target)) //Is it a player?
		{
			GameObject *vehicle = Get_Vehicle(target); 

			if(vehicle) //Are they in a vehicle
			{
			///////////////////////////////////////////
				if(Is_VTOLVehicle(vehicle))
					if(!(Get_Int_Parameter("AntiAir")))
						return 0; //Ignore the target
				else
					if(!(Get_Int_Parameter("AntiGround")))
						return 0; //Ignore the target
			///////////////////////////////////////////
				return vehicle; //if so, return vehicle
			}
			else
			{
			///////////////////////////////////////////
				if(Is_VTOLVehicle(target))
					if(!(Get_Int_Parameter("AntiAir")))
						return 0; //Ignore the target
				else
					if(!(Get_Int_Parameter("AntiGround")))
						return 0; //Ignore the target
			///////////////////////////////////////////
				return target; //if not, return player
			}
		}
		return target; //nothing left but the target

	}
	return 0;	
}

GameObject* RA_Base_Defense_Simple::Tie_Breaker(GameObject *obj, GameObject *new_target, GameObject *old_target)
{
	//This function compiles several methods of breaking ties
	//-lower health gives higher rating
	//-closer distance gives higher rating
	//-being player gives higher rating
	
	float old_rating = 0;
	float new_rating = 0;
	////////////////Player Evaluation////////////////

	if(Commands->Is_A_Star(old_target))
		old_rating += 100; //automatic +100 for being human

	if(Commands->Is_A_Star(new_target))
		new_rating += 100; //automatic +100 for being human

	////////////////Health Evaluation////////////////
	GameObject *old = old_target;
	GameObject *target = new_target;

	//Health needs to be tested for vehicle being driven, if it exists
	if(Get_Vehicle(old_target))
		old = Get_Vehicle(old_target);

	if(Get_Vehicle(new_target))
		target = Get_Vehicle(old_target);
	
	float new_max = Commands->Get_Max_Health(target);
	float old_max = Commands->Get_Max_Health(old);
	float new_percent = 0; //set to minimum
	float old_percent = 0; //set to minimum

	if(new_max > 0) //just to be sure
		new_percent = ((100 * Commands->Get_Health(target)) / (new_max));
	else
		new_percent += 100; //If maximum health is 0, always at 100% health

	if(old_max > 0) //just to be sure
		old_percent = ((100 * Commands->Get_Health(old)) / (old_max));
	else
		old_percent += 100; //If maximum health is 0, always at 100% health

	new_max = Commands->Get_Max_Shield_Strength(target);
	old_max = Commands->Get_Max_Shield_Strength(old);

	if(new_max > 0) //just to be sure
		new_percent += ((100 * Commands->Get_Health(target)) / (new_max)); //Add in shield percent
	else
		new_percent += 100; //If maximum shield is 0, always at 100% shield

	if(old_max > 0) //just to be sure
		old_percent += ((100 * Commands->Get_Health(old)) / (old_max)); //Add in shield percent
	else
		old_percent += 100; //If maximum shield is 0, always at 100% shield
	
	old_rating += 200 - old_percent;
	new_rating += 200 - new_percent;

	////////////////Range Evaluation////////////////

	float max_range = Get_Float_Parameter("MaxRange");
	float min_range = Get_Float_Parameter("MinRange");
	Vector3 obj_pos = Commands->Get_Position(obj);
	Vector3 new_pos = Commands->Get_Position(new_target);
	Vector3 old_pos = Commands->Get_Position(old_target);
	float new_range = Commands->Get_Distance(obj_pos, new_pos);
	float old_range = Commands->Get_Distance(obj_pos, old_pos);

	if(new_range < max_range && new_range > min_range)
		new_rating += max_range - (new_range - min_range); //not sure if this is good

	if(old_range < max_range && old_range > min_range)
		old_rating += max_range - (old_range - min_range);

	////////////////Final Evaluation////////////////

	float max_potential = 300 + max_range; //300 = 100 from Player vs AI + 200 from health

	if(old_rating > new_rating)
		return old_target;
	else if(old_rating < new_rating)
	{
		float test = new_rating - old_rating;

		if(test > (max_potential * 0.1)) //new target must be at least 10% greater priority
			return new_target;
		else
			return old_target;
	}
	else
		return old_target; //rating tie, don't change targets
}

bool RA_Base_Defense_Simple::Adjust_For_Infantry(GameObject *target)
{
	if(Get_Int_Parameter("AdjustAim"))
	{
		if(Is_Soldier(target))
			return true;
	}

	//No need to adjust if parameter says not to
	return false;
}

//////////////Script Registrants//////////////

/********************************************************************/
ScriptRegistrant<RA_Thief_Script> RA_Thief_Script_Registrant("RA_Thief_Script","Credits_To_Award=500.00:float,Prevent_Theft_Timer=30.00:float,Thief_Preset_ID:int");
ScriptRegistrant<RA_Repair_Controller> RA_Repair_Controller_Registrant("RA_Repair_Controller","ScriptZoneID=0:int");
ScriptRegistrant<RA_Soviet_Defence> RA_Soviet_Defence_Registrant("RA_Soviet_Defence","MinAttackDistance=0.0:float,MaxAttackDistance=300.0:float,AttackTimer=10.00:float,Spy_Preset_ID:int,Aircraft_Preset_ID:int");
ScriptRegistrant<RA_Repair_Script> RA_Repair_Script_Registrant("RA_Repair_Script","TeamSelection=0:int");
ScriptRegistrant<RA_Soviet_Refinery_Controller> RA_Soviet_Refinery_Controller_Registrant("RA_Soviet_Refinery_Controller", "ScriptZoneID=0:int");
ScriptRegistrant<RA_Soviet_Refinery_Theft_Zone> RA_Soviet_Refinery_Theft_Zone_Registrant("RA_Soviet_Refinery_Theft_Zone", "Thief_Preset_ID=0:int");
ScriptRegistrant<RA_Allied_Thief> RA_Allied_Thief_Registrant("RA_Allied_Thief", "Credits_To_Award=500.00:float, Prevent_Theft_Timer=30.00:float");
ScriptRegistrant<RA_Infantry_Spy> RA_Infantry_Spy_Registrant("RA_Infantry_Spy", "");
ScriptRegistrant<RA_Infantry_NotSpy> RA_Infantry_NotSpy_Registrant("RA_Infantry_NotSpy", "");
ScriptRegistrant<RA_Helipad_Zone> RA_Helipad_Zone_Registrant("RA_Helipad_Zone", "TeamSelection=0:int,Reload_Interval=2.00:float,Apache_Preset_ID=0:int,Apache_Reload_Powerup=Blank:string,Hind_Preset_ID=0:int,Hind_Reload_Powerup=Blank:string");
ScriptRegistrant<RA_MineLayer> RA_MineLayer_Registrant("RA_MineLayer", "Mine_Manager_ID=0:int");
ScriptRegistrant<RA_Mine> RA_Mine_Registrant("RA_Mine", "Mine_Manager_ID=0:int,Is_Anti-Personnel=0:int,Is_Anti-Tank=0:int,Trigger_Damage=1.0:float,Trigger_Warhead=Death:string");
ScriptRegistrant<RA_Mine_Manager> RA_Mine_Manager_Registrant("RA_Mine_Manager", "Allied_Mine=Blank:string,Soviet_Mine=Blank:string,Mine_Reload=Blank:string,BoneName=mine:string,Mine_Limit=30:int");
ScriptRegistrant<RA_ObjectDeath_OnCreate> RA_ObjectDeath_OnCreate_Registrant("RA_ObjectDeath_OnCreate","Object=null:string");
ScriptRegistrant<RA_Naval_Yard> RA_Naval_Yard_Registrant("RA_Naval_Yard", "Limit=8:int,Disable_Time=5.0:float");
ScriptRegistrant<RA_Naval_PT> RA_Naval_PT_Registrant("RA_Naval_PT", "Preset_Name=blank:string,Cost=0.0:float,Team=0:int,Controller_ID=0:int,Zone_ID=0:int,TestID=0:int");
ScriptRegistrant<RA_Naval_PT_Pokable> RA_Naval_PT_Pokable_Registrant("RA_Naval_PT_Pokable", "Preset_Name=blank:string,Cost=0.0:float,Team=0:int,Controller_ID=0:int,Zone_ID=0:int");
ScriptRegistrant<RA_Naval_Unit> RA_Naval_Unit_Registrant("RA_Naval_Unit", "Controller_ID=0:int");
ScriptRegistrant<RA_Naval_Zone> RA_Naval_Zone_Registrant("RA_Naval_Zone", "Explosion=blank:string");
ScriptRegistrant<RA_Damaged_Credits> RA_Damaged_Credits_Registrant("RA_Damaged_Credits","Divisor=4.0:float");
ScriptRegistrant<RA_GameStart_Detector> RA_GameStart_Detector_Registrant("RA_GameStart_Detector", "Interval=5.0:float,ReceiverID=0:int,Message=0:int,Parameter=0:int");
ScriptRegistrant<RA_DriverDeath> RA_DriverDeath_Registrant("RA_DriverDeath", "");
ScriptRegistrant<RA_Conyard_Controller> RA_Conyard_Controller_Registrant("RA_Conyard_Controller", "Building1_ID=0:int,Building2_ID=0:int,Building3_ID=0:int,Building4_ID=0:int,Building5_ID=0:int,Building6_ID=0:int,Building7_ID=0:int,Building8_ID=0:int,Building9_ID=0:int,Building10_ID=0:int");
ScriptRegistrant<RA_Conyard_Repair> RA_Conyard_Repair_Registrant("RA_Conyard_Repair", "Repair_Frequency=1.0:float");
ScriptRegistrant<RA_ObjectDeath_OnDeath> RA_ObjectDeath_OnDeath_Registrant("RA_ObjectDeath_OnDeath","Preset=blank:string");
ScriptRegistrant<RA_Demolition_Truck_Improved> RA_Demolition_Truck_Improved_Registrant("RA_Demolition_Truck_Improved", "Explosion=Explosion_Invis_Nuke:string,Warhead=Nuke:string,DamageStrength=480.0:float,DamageRadius=120.0:float");
ScriptRegistrant<RA_CTF_Zone> RA_CTF_Zone_Registrant("RA_CTF_Zone","Team_ID=0:int,Max_Capture=5:int,Flag_Preset_Name:string");
ScriptRegistrant<RA_MAD_Tank_Improved> RA_MAD_Tank_Improved_Registrant("RA_MAD_Tank_Improved", "Attach_Model=pistons:string,Deployed_Animation=V_SO_MADTANK.ANIM_MADTANK:string,Sonic_Preset=Sonic_Box:string,Percentage=0.34:float,Warhead=Sonic:string,DamageRadius=250.0:float,Announcement=MAD_Tank_Deployed:string,Bone=ROOTTRANSFORM:string");
ScriptRegistrant<RA_Conyard_Controller_Improved> RA_Conyard_Controller_Improved_Registrant("RA_Conyard_Controller_Improved", "Team=0:int,Preset1=blank:string,Preset2=blank:string,Preset3=blank:string,Preset4=blank:string,Preset5=blank:string");
ScriptRegistrant<RA_Building_DeathSound> RA_Building_DeathSound_Registrant("RA_Building_DeathSound", "HalfSound=ExploSound_Bldg_Half:string,DeadSound=ExploSound_Bldg_Dead:string");
ScriptRegistrant<RA_Base_Defense_Simple> RA_Base_Defense_Simple_Registrant("RA_Base_Defense_Simple","MinRange=0.0:float,MaxRange=100.0:float,AntiAir=0:int,AntiGround=1:int,AdjustAim=0:int,TargetMode=0:int");
