/*	Renegade Scripts.dll
	Engine calls
	Copyright 2006 Vloktboky, WhiteDragon(MDB), Joshua "NeoSaber" Kraft, Jonathan Wilson

	This file is part of the Renegade scripts.dll
	The Renegade scripts.dll is free software; you can redistribute it and/or modify it under
	the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2, or (at your option) any later
	version. See the file COPYING for more details.
	In addition, an exemption is given to allow Run Time Dynamic Linking of this code with any closed source module that does not contain code covered by this licence.
	Only the source code to the module(s) containing the licenced code has to be released.
*/
typedef void (*ChatHook) (int PlayerID,int Type,const wchar_t *Message);
typedef void (*HostHook) (int PlayerID,int Type,const char *Message);
typedef void (*ObjectCreateHook) (void *data,GameObject *obj);
typedef void (*PlayerJoin) (int PlayerID,const char *PlayerName);
typedef void (*LoadLevelHook) ();

struct ObjectCreateHookStruct {
	ObjectCreateHook hook;
	void *data;
};

typedef void (*KeyHook) (void *data);
struct KeyHookStruct {
	KeyHook hook;
	const char *key;
	int ID;
	void *data;
};

#ifdef WIN32
struct GenericSLNode {
	GenericSLNode *NodeNext;
	void *NodeData;
};
#elif defined RH8
struct GenericSLNode {
	GenericSLNode *NodeNext;
	void *NodeData;
};
#else
struct GenericSLNode {
	int unknown;
	GenericSLNode *NodeNext;
	void *NodeData;
};
#endif

template <class T1,class T2> class TypedEventPair {
	T1 signal;
	T2 data;
};

template <class T> class Signaler {
public:
	int unknown;
	virtual void ReceiveSignal(T &signal)
	{
	}
	virtual void SignalDropped(Signaler &sig)
	{
	}
	virtual ~Signaler()
	{
	}
};

template <class T> class SList {
public:
	GenericSLNode *HeadNode;
	GenericSLNode *TailNode;
	virtual ~SList()
	{
	}
	virtual bool Add_Head(T *data)
	{
		return false;
	}
	virtual bool Add_Head(SList<T> &list)
	{
		return false;
	}
	virtual bool Add_Tail(T *data)
	{
		return false;
	}
	virtual bool Add_Tail(SList<T> &list)
	{
		return false;
	}
	virtual T *Remove_Head()
	{
		return 0;
	}
	virtual T *Remove_Tail()
	{
		return 0;
	}
	virtual bool Remove(T *element)
	{
		return false;
	}
	virtual void Remove_All()
	{
	}
	virtual bool Insert_Before(T *newnode,T *oldnode)
	{
		return false;
	}
	virtual bool Insert_After(T *newnode,T *oldnode)
	{
		return false;
	}
	virtual bool Is_Empty()
	{
		return false;
	}
	virtual long Get_Count()
	{
		return 0;
	}
};

template <class T> class SimpleVecClass {
protected:
	T *Vector;
	int VectorMax;
public:
	SimpleVecClass(unsigned int size)
	{
		Vector = 0;
		VectorMax = 0;
		if (size > 0)
		{
			Resize(size);
		}
	}
	virtual bool Uninitialised_Grow(int newsize)
	{
		if ((newsize > 0) && (newsize > VectorMax))
		{
			delete Vector;
			T *vec = new T[newsize*4];
			Vector = vec;
			VectorMax = newsize;
		}
		return true;
	}
	SimpleVecClass(const SimpleVecClass<T> &cl)
	{
		Uninitialised_Grow(cl.VectorMax);
		memcpy(Vector,cl.Vector,VectorMax);
	}
	int Length()
	{
		return VectorMax;
	}
	T &operator[](int index)
	{
		return Vector[index];
	}
	virtual ~SimpleVecClass()
	{
		if (Vector)
		{
			delete Vector;
			Vector = 0;
		}
	}
	virtual bool Resize(int newsize)
	{
		T *vec;
		if (VectorMax == newsize)
		{
			return true;
		}
		if (newsize > 0)
		{
			vec = new T[newsize*4];
			if (Vector)
			{
				int count;
				count = VectorMax;
				if (newsize < count)
				{
					count = newsize;
				}
				memcpy(vec,Vector,count*4);
				delete Vector;
				Vector = 0;
			}
			Vector = vec;
			VectorMax = newsize;
		}
		else
		{
			VectorMax = 0;
			if (Vector)
			{
				delete Vector;
				Vector = 0;
			}
		}
		return true;
	}
};

template <class T> class SimpleDynVecClass : public SimpleVecClass<T> {
protected:
	int ActiveCount;
public:
	SimpleDynVecClass(int size) : SimpleVecClass<T>(size)
	{
		ActiveCount = 0;
	}
	SimpleDynVecClass(const SimpleDynVecClass<T> &cl) : SimpleVecClass<T>(cl)
	{
		ActiveCount = cl.ActiveCount;
	}
	int Count()
	{
		return ActiveCount;
	}
	virtual ~SimpleDynVecClass()
	{
		if (Vector)
		{
			delete Vector;
			Vector = 0;
		}
	}
	virtual bool Resize(int newsize)
	{
		if (SimpleVecClass<T>::Resize(newsize))
		{
			if (VectorMax < ActiveCount)
			{
				ActiveCount = VectorMax;
			}
			return true;
		}
		return false;
	}
	int Add(T& data)
	{
		for (int i = 0;i < VectorMax;i++)
		{
			if (!Vector[i])
			{
				Vector[i] = data;
				ActiveCount++;
				return i;
			}
		}
		Resize(VectorMax+1);
		Vector[VectorMax-1] = data;
		ActiveCount++;
		return VectorMax-1;
	}
	void Delete(int position)
	{
		Vector[position] = 0;
		ActiveCount--;
	}
};

template <class T> class VectorClass {
private:
	T *Vector;
	int VectorMax;
	bool IsValid;
	bool IsAllocated;
public:
	virtual ~VectorClass()
	{
	}
	int Length()
	{
		return VectorMax;
	}
	T &operator[](int index)
	{
		return Vector[index];
	}
	virtual bool operator==(VectorClass<T> &vector)
	{
		return false;
	}
	virtual bool Resize(int newsize,T *array)
	{
		return false;
	}
	virtual void Clear()
	{
	}
	virtual int ID(T &object)
	{
		return 0;
	}
	virtual int ID(T *ptr)
	{
		return 0;
	}
};

template <class T> class DynamicVectorClass : public VectorClass<T> {
private:
	int ActiveCount;
	int GrowthStep;
public:
	int Count()
	{
		return ActiveCount;
	}
	virtual ~DynamicVectorClass()
	{
	}
	virtual bool Resize(int newsize,T *array)
	{
		return false;
	}
	virtual void Clear()
	{
	}
	virtual int ID(T &object)
	{
		return 0;
	}
	virtual int ID(T *ptr)
	{
		return 0;
	}
};

class WideStringClass {
public:
	wchar_t* m_Buffer;
	class WideStringClass& operator=(class WideStringClass&);
};

#ifdef WIN32
struct TIME {
	short wYear;
	short wMonth;
	short wDayOfWeek;
	short wDay;
	short wHour;
	short wMinute;
	short wSecond;
	short wMilliseconds;
};
#else
struct TIME {
	int wMonth;
	int wDay;
	int wYear;
	int wHour;
	int wMinute;
	int wSecond;
};
#endif

class cGameDataCnc;
class cGameDataSkirmish;
class cGameDataSinglePlayer;

class cGameData : public Signaler<TypedEventPair<bool,int> > {
public:
	bool GameplayPermitted;
	bool IsDedicated;
	bool IsAutoRestart;
	bool IsFriendlyFirePermitted;
	bool IsTeamChangingAllowed;
	bool IsPassworded;
	bool Unknown;
	bool IsLaddered;
	bool IsClanGame;
	bool UseLagReduction;
	bool RemixTeams;
	bool CanRepairBuildings;
	bool DriverIsAlwaysGunner;
	bool SpawnWeapons;
	bool DoMapsLoop;
	bool MapCycleOver;
	unsigned int MapNumber;
	WideStringClass GameTitle;
	WideStringClass Motd;
	WideStringClass Password;
	char *MapName;
	char *ModName;
	char *MapList[100];
	WideStringClass Owner;
	DynamicVectorClass<WideStringClass> unknown2;
	DynamicVectorClass<WideStringClass> unknown3;
	WideStringClass SettingsDescription;
	unsigned int MaxPlayers;
	unsigned int TimeLimit_Minutes;
	unsigned int IntermissionTime_Seconds;
	unsigned int ExeKey;
	bool ExeVersionsMatch;
	bool StringVersionsMatch;
	unsigned int IP;
	unsigned int Port;
	char *INI;
	unsigned int RadarMode;
	unsigned int CFGModTime;
	unsigned int CurrentPlayers;
	float IntermissionTimeLeft;
	unsigned int TimeRemaining_Seconds;
	float MaxWorldDistance;
	unsigned int MinQualifyingTime_Minutes;
	unsigned int WinnerID;
	unsigned int WinType;
	TIME unknown4;
	unsigned int GameStartTime;
	unsigned long FrameCount;
	WideStringClass MVPName;
	unsigned int MVPCount;
	unsigned int GameDuration_Seconds;
	bool IsQuickMatch;
	unsigned long Clan1;
	unsigned long Clan2;
	bool BaseDestructionEndsGame;
	bool BeaconPlacementEndsGame;
	unsigned int StartingCredits;
	virtual void ReceiveSignal(TypedEventPair<bool,int> &signal)
	{
	}
	virtual cGameData::~cGameData()
	{
	}
	virtual void On_Game_Begin()
	{
	}
	virtual void On_Game_End()
	{
	}
	virtual void Think()
	{
	}
	virtual void Render()
	{
	}
	virtual void Reset_Game()
	{
	}
	virtual WideStringClass Get_Game_Name() = 0;
	virtual int Get_Game_Type() = 0;
	virtual int Choose_Player_Type(void *Player,int type,bool unk)
	{
	}
	virtual void Load_From_Server_Config()
	{
	}
	virtual void Save_To_Server_Config()
	{
	}
	virtual bool Is_Editable_Teaming()
	{
	}
	virtual bool Is_Editable_Clan_Game()
	{
	}
	virtual bool Is_Editable_Friendly_Fire()
	{
	}
	virtual void Soldier_Added(GameObject *obj)
	{
	}
	virtual void Show_Game_Settings_Limits()
	{
	}
	virtual bool Is_Single_Player()
	{
	}
	virtual bool Is_Skirmish()
	{
	}
	virtual bool Is_Cnc()
	{
	}
	virtual cGameDataSinglePlayer *As_Single_Player()
	{
	}
	virtual cGameDataSkirmish *As_Skirmish()
	{
	}
	virtual cGameDataCnc *As_Cnc()
	{
	}
	virtual unsigned int Get_Min_Players()
	{
	}
	virtual bool Is_Game_Over()
	{
	}
	virtual bool Is_Limited()
	{
	}
	virtual bool Is_Valid_Settings(WideStringClass &w,bool b)
	{
	}
	virtual void Export_Tier_1_Data(void *packet)
	{
	}
	virtual void Import_Tier_1_Data(void *packet)
	{
	}
	virtual void Import_Tier_1_Data_Wol(void *packet)
	{
	}
	virtual void Export_Tier_2_Data(void *packet)
	{
	}
	virtual void Import_Tier_2_Data(void *packet)
	{
	}
	virtual bool Is_Gameplay_Permitted()
	{
	}
	virtual bool Remember_Inventory()
	{
	}
	virtual void Get_Description(WideStringClass &w)
	{
	}
};

class cGameDataCnc : public cGameData {
public:
	virtual cGameDataCnc::~cGameDataCnc()
	{
	}
	virtual void On_Game_Begin()
	{
	}
	virtual void On_Game_End()
	{
	}
	virtual void Think()
	{
	}
	virtual void Reset_Game()
	{
	}
	virtual WideStringClass Get_Game_Name()
	{
	}
	virtual int Get_Game_Type()
	{
	}
	virtual void Load_From_Server_Config()
	{
	}
	virtual void Save_To_Server_Config()
	{
	}
	virtual bool Is_Editable_Teaming()
	{
	}
	virtual bool Is_Editable_Clan_Game()
	{
	}
	virtual bool Is_Editable_Friendly_Fire()
	{
	}
	virtual void Soldier_Added(GameObject *obj)
	{
	}
	virtual void Show_Game_Settings_Limits()
	{
	}
	virtual bool Is_Cnc()
	{
	}
	virtual cGameDataCnc *As_Cnc()
	{
	}
	virtual bool Is_Game_Over()
	{
	}
	virtual bool Is_Limited()
	{
	}
	virtual bool Is_Valid_Settings(WideStringClass &w,bool b)
	{
	}
	virtual void Export_Tier_2_Data(void *packet)
	{
	}
	virtual void Import_Tier_2_Data(void *packet)
	{
	}
	virtual bool Is_Gameplay_Permitted()
	{
	}
	virtual void Get_Description(WideStringClass &w)
	{
	}
};

class cGameDataSkirmish : public cGameData {
public:
	virtual cGameDataSkirmish::~cGameDataSkirmish()
	{
	}
	virtual void On_Game_Begin()
	{
	}
	virtual void On_Game_End()
	{
	}
	virtual void Think()
	{
	}
	virtual void Reset_Game()
	{
	}
	virtual WideStringClass Get_Game_Name()
	{
	}
	virtual int Get_Game_Type()
	{
	}
	virtual void Load_From_Server_Config()
	{
	}
	virtual void Save_To_Server_Config()
	{
	}
	virtual bool Is_Editable_Teaming()
	{
	}
	virtual bool Is_Editable_Clan_Game()
	{
	}
	virtual bool Is_Editable_Friendly_Fire()
	{
	}
	virtual void Soldier_Added(GameObject *obj)
	{
	}
	virtual void Show_Game_Settings_Limits()
	{
	}
	virtual bool Is_Skirmish()
	{
	}
	virtual cGameDataSkirmish *As_Skirmish()
	{
	}
	virtual bool Is_Game_Over()
	{
	}
	virtual bool Is_Limited()
	{
	}
	virtual void Get_Description(WideStringClass &w)
	{
	}
};

class cGameDataSinglePlayer : public cGameData {
public:
	virtual cGameDataSinglePlayer::~cGameDataSinglePlayer()
	{
	}
	virtual WideStringClass Get_Game_Name()
	{
	}
	virtual int Get_Game_Type()
	{
	}
	virtual int Choose_Player_Type(void *Player,int type,bool unk)
	{
	}
	virtual bool Is_Single_Player()
	{
	}
	virtual cGameDataSinglePlayer *As_Single_Player()
	{
	}
	virtual bool Is_Limited()
	{
	}
	virtual bool Remember_Inventory()
	{
	}
};

typedef unsigned long WeaponClass;
class WeaponBagClass {
public:
	GameObject *owner;
	DynamicVectorClass<WeaponClass *> Vector;
	unsigned int current;
	bool flag1;
	bool flag2;
};

struct Vector4 {
	float X;
	float Y;
	float Z;
	float W;
};

struct Matrix3D {
	Vector4 Row[3];
};


//type values for various things
#define Beacon 0x3016
#define Building 0xD001 //only covers generic buildings,not the special stuff like PowerPlant or Refinery
#define C4 0x3006
#define PowerPlant 0xD003
#define PowerUp 0x3003
#define Refinery 0xD002
#define RepairBay 0xD009
#define SamSite 0x3007
#define ScriptZone 0x300E
#define Simple 0x3004
#define Soldier 0x3001
#define SoldierFactory 0xD004
#define SpecialEffects 0x3013
#define Vehicle 0x3010
#define VehicleFactory 0xD005 //for WarFactory or Airstrip,use the relavent values
#define WarFactory 0xD007
#define Airstrip 0xD006
#define Cinematic 0x3011
#define ComCenter 0xD008

//start per-player script commands stuff
typedef void (*_Set_Background_Music_Player) (GameObject *obj,const char *music);
typedef void (*_Fade_Background_Music_Player) (GameObject *obj,const char *music,int unk1,int unk2);
typedef void (*_Stop_Background_Music_Player) (GameObject *obj);
typedef void (*_Enable_Radar_Player) (GameObject *obj,bool enable);
typedef void (*_Display_GDI_Player_Terminal_Player) (GameObject *obj);
typedef void (*_Display_NOD_Player_Terminal_Player) (GameObject *obj);
typedef void (*_Set_Screen_Fade_Color_Player) (GameObject *obj,float red,float green,float blue,float transition);
typedef void (*_Set_Screen_Fade_Opacity_Player) (GameObject *obj,float opacity,float transition);
typedef void (*_Force_Camera_Look_Player) (GameObject *obj,const Vector3 & look);
typedef void (*_Enable_HUD_Player) (GameObject *obj,bool enable);
typedef int (*_Create_Sound_Player) (GameObject *obj,const char *soundname,const Vector3 & position,GameObject *obj2);
typedef int (*_Create_2D_Sound_Player) (GameObject *obj,const char *soundname);
typedef int (*_Create_2D_WAV_Sound_Player) (GameObject *obj,const char *soundname);
typedef int (*_Create_3D_WAV_Sound_At_Bone_Player) (GameObject *obj,const char *soundname,GameObject *obj2,const char *bonename);
typedef int (*_Create_3D_Sound_At_Bone_Player) (GameObject *obj,const char *soundname,GameObject *obj2,const char *bonename);
typedef void (*_Set_Display_Color_Player) (GameObject *obj,unsigned char red,unsigned char green,unsigned char blue);
typedef void (*_Display_Text_Player) (GameObject *obj,int strnum);
typedef void (*_Display_Int_Player) (GameObject *obj,int num,const char *msg);
typedef void (*_Display_Float_Player) (GameObject *obj,float num,const char *msg);
typedef int (*aoch) (ObjectCreateHookStruct *h);
typedef void (*roch) (int pos);
typedef int (*akh) (KeyHookStruct *h);
typedef void (*rkh) (int pos);
typedef void (*ss) (GameObject *obj,int scope);
typedef void (*sh) (GameObject *obj,const char *texture);
typedef void (*ach) (ChatHook h);
typedef void (*ahh) (HostHook h);
typedef void (*allh) (LoadLevelHook h);
typedef void (*apjh) (PlayerJoin h);
typedef const char *(*gcmt) ();
typedef double (*gbhsv) ();
#ifndef BHS
extern ach AddChatHook;
extern ahh AddHostHook;
extern ss Set_Scope;
extern sh Set_HUD_Texture;
extern aoch AddObjectCreateHook;
extern roch RemoveObjectCreateHook;
extern akh AddKeyHook;
extern rkh RemoveKeyHook;
extern gcmt GetCurrentMusicTrack;
extern gbhsv GetBHSVersion;
extern allh AddLoadLevelHook;
extern allh AddGameOverHook;
extern apjh AddPlayerJoinHook;
extern _Set_Background_Music_Player Set_Background_Music_Player;
extern _Fade_Background_Music_Player Fade_Background_Music_Player;
extern _Stop_Background_Music_Player Stop_Background_Music_Player;
extern _Enable_Radar_Player Enable_Radar_Player;
extern _Display_GDI_Player_Terminal_Player Display_GDI_Player_Terminal_Player;
extern _Display_NOD_Player_Terminal_Player Display_NOD_Player_Terminal_Player;
extern _Set_Screen_Fade_Color_Player Set_Screen_Fade_Color_Player;
extern _Set_Screen_Fade_Opacity_Player Set_Screen_Fade_Opacity_Player;
extern _Force_Camera_Look_Player Force_Camera_Look_Player;
extern _Enable_HUD_Player Enable_HUD_Player;
extern _Create_Sound_Player Create_Sound_Player;
extern _Create_2D_Sound_Player Create_2D_Sound_Player;
extern _Create_2D_WAV_Sound_Player Create_2D_WAV_Sound_Player;
extern _Create_3D_WAV_Sound_At_Bone_Player Create_3D_WAV_Sound_At_Bone_Player;
extern _Create_3D_Sound_At_Bone_Player Create_3D_Sound_At_Bone_Player;
extern _Set_Display_Color_Player Set_Display_Color_Player;
extern _Display_Text_Player Display_Text_Player;
extern _Display_Int_Player Display_Int_Player;
extern _Display_Float_Player Display_Float_Player;
#endif

#ifndef BHS
class JFW_Key_Hook_Base : public ScriptImpClass {
public:
	KeyHookStruct *k;
	int hookid;
	int is_keyhook_set;
	void Detach(GameObject *obj);
	void Destroyed(GameObject *obj);
	void InstallHook(const char *keyname,GameObject *obj);
	void RemoveHook();
	virtual void KeyHook() = 0;
};

class JFW_Object_Created_Hook_Base : public ScriptImpClass {
public:
	int hookid;
	ObjectCreateHookStruct *h;
	void Detach(GameObject *obj);
	void Created(GameObject *obj);
	void InstallHook();
	void RemoveHook();
	virtual void ObjectCreateHook(GameObject *obj) = 0;
};
#endif

extern int Exe; //0 = game.exe,1 = server.dat,2 = RH73 LFDS,3 = RH8 LFDS,4 = leveledit,6 = invalid
void InitEngine(); //initalize pointers to engine functions
GameObject *Get_GameObj(int ID); //convert a player ID into a GameObject
long Get_Player_ID(GameObject *obj); //convert a GameObject into a player ID
const char *Get_Model(GameObject *obj); //get the name of the 3d model used by an object,opposite of Set_Model
int Get_Object_Type(GameObject *obj); //get the team of an object,0 = Nod,1 = GDI,2 = neutral,works on buildings
void Set_Object_Type(GameObject *obj,int type); //set the team of an object,0 = Nod,1 = GDI,2 = neutral,works on buildings
bool Change_Character(GameObject *obj,const char *Preset_Name); //will change the character of the passed in object to the passed in preset
const char *Get_Player_Name(GameObject *obj); //converts a GameObject into a player name
GameObject *Find_Building_By_Team(int Team); //finds the first building of this team,0 = Nod,1 = GDI
GameObject *Find_Building_By_Name(int Team,const char *Preset_Name); //finds the first building of team where preset name matches name,0 = Nod,1 = GDI
void Kill_All_Buildings_By_Team(int Team); //kill all buildings of the specified team,ending the game with the other team winning,0 = Nod,1 = GDI
void Damage_All_Buildings_By_Team(int Team,float Damage,const char *Warhead,GameObject *Damager); //damages all buildings of the specified team,the Damager is the object that will be passed to the Damaged callback for the buildings and also the one that will get the points,0 = Nod,1 = GDI,2 = both
void Repair_All_Buildings_By_Team(int Team,int ConstructionYardID,float Health); //repairs all buildings for the team except the passed in ConstructionYardID,0 = Nod,1 = GDI
void Repair_All_Static_Vehicles_By_Team(int Team,int Message); //sends a custom to all vechicles of the team with the DecorationPhys physics type (i.e. all base defence vechicles etc),0 = Nod,1 = GDI,Message is the message to send. Use with JFW_Repair_On_Custom on the vechicles you want repaired to do the actual repairing
GameObject *Find_Smart_Object_By_Team(int Team); //will find the first SmartGameObj (i.e. soldier or vechicle) for the team,0 = Nod,1 = GDI
GameObject *Find_Object_By_Team(int Team); //will find the first object for the team,0 = Nod,1 = GDI
GameObject *Find_Non_Player_Object_By_Team(int Team); //will find the first non player object for the team,0 = Nod,1 = GDI
GameObject *Find_Object_By_Preset(int Team,const char *Preset_Name); //will find the first object of team matching preset,0 = Nod,1 = GDI,2 = either
GameObject *Find_Power_Plant(int Team); //finds the first powerplant for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Refinery(int Team); //finds the first refinery for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Repair_Bay(int Team); //finds the first repair bay for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Soldier_Factory(int Team); //finds the first soldier factory for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Airstrip(int Team); //finds the first airstrip for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_War_Factory(int Team); //finds the first war factory for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Vehicle_Factory(int Team); //finds the first airstrip for Team,if none is found,finds the first war factory for Team,0 = Nod,1 = GDI,2 = either
GameObject *Find_Com_Center(int Team); //finds the first communications center for Team,0 = Nod,1 = GDI,2 = either
bool Is_Building(GameObject *obj); //is a BuildingGameObj
bool Is_Soldier(GameObject *obj); //is a SoldierGameObj
bool Is_Vehicle(GameObject *obj); //is a VechicleGameObj
bool Is_Cinematic(GameObject *obj); //is a CinematicGameObj
bool Is_ScriptZone(GameObject *obj); //is a ScriptZoneGameObj
void Set_Max_Health(GameObject *obj,float health); //set the max health of obj
void Set_Max_Shield_Strength(GameObject *obj,float shieldstrength); //set the max shield strength of obj
GameObject *Find_First_Player(int Team); //finds the first player of Team,0 = Nod,1 = GDI,2 = either
float Get_Animation_Frame(GameObject *obj); //gets the current animation frame for obj,may not work for all objects
void Grant_Refill(GameObject *obj); //triggers the same code as the refill button on the PT
void Grant_Powerup(GameObject *obj,const char *Preset_Name); //grants a powerup
GameObject *Get_Vehicle(GameObject *obj); //gets the vechicle that obj is driving
const char *Get_Shield_Type(GameObject *obj); //gets the shield type of obj
const char *Get_Skin(GameObject *obj); //gets the skin type of obj
void Set_Skin(GameObject *obj,const char *Skintype); //sets the skin type of obj
void Create_Vehicle(const char *Preset_Name,float Delay,GameObject *Owner,int Team); //creates a vechicle,dont know what Delay is for,Owner is for the owner of the vechicle,Team says which sides factories to create it at
void Toggle_Fly_Mode(GameObject *obj); //makes a soldier fly if they arent flying or not fly if they are
void Console_Input(const char *Input); //triggers console input (i.e. passes the string in as though it was typed into the console)
void Console_Output(const char *Output); //prints stuff to the console
bool Is_TrackedVehicle(GameObject *obj); //has TrackedVechicle physics
bool Is_VTOLVehicle(GameObject *obj); //has VTOLVechicle physics
bool Is_WheeledVehicle(GameObject *obj); //has WheeledVechicle physics
bool Is_Motorcycle(GameObject *obj); //has Morotcycle physics
bool Is_Door(GameObject *obj); //has Door physics
bool Is_Elevator(GameObject *obj); //has Elevator physics
bool Is_DamageableStaticPhys(GameObject *obj); //has DamageableStaticPhys physics
bool Is_AccessablePhys(GameObject *obj); //has AccessablePhys physics
bool Is_DecorationPhys(GameObject *obj); //has DecorationPhys physics
bool Is_HumanPhys(GameObject *obj); //has HumanPhys physics
bool Is_MotorVehicle(GameObject *obj); //has MotorVehicle physics
bool Is_Phys3(GameObject *obj); //has Phys3 physics
bool Is_RigidBody(GameObject *obj); //has RigidBody physics
bool Is_ShakeableStatricPhys(GameObject *obj); //has ShakeableStaticPhys physics
bool Is_StaticAnimPhys(GameObject *obj); //has StaticAnimPhys physics
bool Is_StaticPhys(GameObject *obj); //has StaticPhys physics
bool Is_TimedDecorationPhys(GameObject *obj); //has TimedDecorationPhys physics
bool Is_VehiclePhys(GameObject *obj); //has VechiclePhys physics
bool Is_DynamicAnimPhys(GameObject *obj); //has DenamicAnimPhys physics
bool Is_BuildingAggregate(GameObject *obj); //has BuildingAggregate physics
bool Is_Projectile(GameObject *obj); //has Projectile physics
const char *Get_Player_Name_By_ID(int ID); //gets the player name from a player ID
void Change_Team(GameObject *obj,int Team); //changes the team of a player given their ID and also kills the player so they respwan,passing anything other than 0 = Nod,1 = GDI will crash
void Change_Team_By_ID(int ID,int Team); //changes the team of a player given their GameObject and also kills the player so they respwan,passing anything other than 0 = Nod,1 = GDI will crash
int Get_Player_Count(); //gets the count of how many players there are
bool Is_Powerup(GameObject *obj); //is a PowerUpGameObj
bool Is_C4(GameObject *obj); //is a C4GameObj
bool Is_Beacon(GameObject *obj); //is a BeaconGameObj
bool Is_Armed(GameObject *obj); //is an ArmedGameObj
bool Is_Simple(GameObject *obj); //is a SimpleGameObj
bool Is_PowerPlant(GameObject *obj); //is a PowerPlantGameObj
bool Is_SoldierFactory(GameObject *obj); //is a SoldierFactoryGameObj
bool Is_VehicleFactory(GameObject *obj); //is a VehicleFactoryGameObj
bool Is_Airstrip(GameObject *obj); //is an AirstripGameObj
bool Is_WarFactory(GameObject *obj); //is a WarFactoryGameObj
bool Is_Refinery(GameObject *obj); //is a RefineryGameObj
bool Is_ComCenter(GameObject *obj); //is a ComCenterGameObj
bool Is_RepairBay(GameObject *obj); //is a RepairBayGameObj
void Damage_All_Vehicles_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager); //damages all vechicles in a given area except the host
void Damage_All_Objects_Area(float Damage,const char *Warhead,const Vector3 &Position,float Distance,GameObject *Host,GameObject *Damager); //damages all objects in a given area except the host
int Get_Team_Player_Count(int Team); //gets the count of players for a given team,0 = Nod,1 = GDI)
const char *Get_Physics(GameObject *obj); //returns a string indicating the physics type of an object
const char *Get_Building_Type(GameObject *obj); //returns a string indicating the building type of an object
void Disarm_Nearest_Beacon(GameObject *Host,int Team,bool Nearest); //disarms the nearest beacon
bool Change_Player_Team(GameObject *obj,bool Retain_Score,bool Retain_Money,bool Show_Host_Message); //changes the players team
#ifndef BHS
void Set_Occupants_Fade(GameObject *obj,float red,float green,float blue,float opacity); //sets the screen fade of all the occupants of a vehicle
void Enable_Team_Radar(int Team,bool Enable); //enable radar for a given team
void Create_Sound_Team(const char *soundname,const Vector3 & position,GameObject *obj,int team); //play a 3D sound for a team
void Create_2D_Sound_Team(const char *soundname,int team); //play a 2D sound for a team
void Create_2D_WAV_Sound_Team(const char *soundname,int team); //play a 2D WAV sound for a team
void Create_3D_WAV_Sound_At_Bone_Team(const char *soundname,GameObject *obj,const char *bonename,int team); //play a 3D WAV sound at a bone for a team
void Create_3D_Sound_At_Bone_Team(const char *soundname,GameObject *obj,const char *bonename,int team); //play a 3D sound at a bone for a team
void Set_Display_Color_Team(unsigned char red,unsigned char green,unsigned char blue,int team); //set the display color for a team
void Display_Text_Team(int strnum,int team); //display a text string for a team
void Display_Int_Team(int num,const char *msg,int team); //display a message with an int for a team
void Display_Float_Team(float num,const char *msg,int team); //display a message with a float for a team
#endif
//these only do damage if the building is close enough
void Ranged_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings
void Ranged_Scale_Damage_To_Buildings(float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings based on a scale factor
void Ranged_Percentage_Damage_To_Buildings(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings based on a percentage factor
void Ranged_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team
void Ranged_Scale_Damage_To_Buildings_Team(int Team,float Damage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team based on a scale factor
void Ranged_Percentage_Damage_To_Buildings_Team(int Team,float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage buildings per team based on a percentage factor
void Send_Custom_To_Team_Buildings(int Team,GameObject *sender,int message,int param,float delay); //send custom to team buildings
void Send_Custom_To_Team_Preset(int Team,const char *PresetName,GameObject *sender,int message,int param,float delay); //send custom to team preset
void Remove_Script(GameObject *obj,const char *script); //removes all copies of <script> from an object
void Remove_All_Scripts(GameObject *obj); //removes all scripts from an object
int Get_Vehicle_Occupant_Count(GameObject *obj); //gets the count of occupants in a vehicle
//these next 3 may return NULL (e.g. if no-one is in the seat or if its not a vehicle)
GameObject *Get_Vehicle_Occupant(GameObject *obj,int seat); //gets the occupant in the given seat of the vehicle
GameObject *Get_Vehicle_Driver(GameObject *obj); //gets the driver of a vehicle
GameObject *Get_Vehicle_Gunner(GameObject *obj); //gets the gunner of a vehicle,if there is only one person this should be the driver as well as the gunner
void Attach_Script_Preset(const char *script,const char *params,const char *preset,int team); //attached <script> to all objects of <preset> in team <team>
void Attach_Script_Type(const char *script,const char *params,int type,int team); //attaches <script> to all objects of <type> in team <team>
void Remove_Script_Preset(const char *script,const char *preset,int team); //removes all copies of <script> from all objects of <preset> in team <team>
void Remove_Script_Type(const char *script,int type,int team); //removes all copies of <script> from all objects of <type> in team <team>
void Copy_Transform(GameObject *in,GameObject *out); //copies the complete transform (including rotation) from one object to another
const char *Get_Current_Weapon(GameObject *obj); //gets the current weapon of an object
int Get_Weapon_Count(GameObject *obj); //gets the weapon count for an object
const char *Get_Weapon(GameObject *obj,int position); //get the specified position in the weapon bag
bool Has_Weapon(GameObject *obj,const char *weapon); //does the object have the weapon
float Get_Mass(GameObject *obj); //returns the mass of an object
const char *Get_Htree_Name(GameObject *obj); //returns the Hierarchy Tree name for an object
char Get_Sex(GameObject *obj); //gets the character (e.g. "A" for male or "B" for female) for use with animations
void Force_Occupant_Exit(GameObject *obj,int seat); //kick the object in <seat> out of the vehicle,if anyone is in that seat
void Force_Occupants_Exit(GameObject *obj); //kick all occupants out of the vehicle
void Damage_Objects_Half(); //damage all objects by half
GameObject *Get_Vehicle_Return(GameObject *obj); //like Get_Vehicle but will return the soldier if its not inside a vehicle instead of NULL
GameObject *Find_Beacon(int Number,int Team); //find a beacon
int Get_C4_Count(int Team); //get the C4 count
int Get_Beacon_Count(int Team); //get the beacon count
cGameData *The_Game(); //get the cGameData
cGameDataSkirmish *The_Skirmish_Game(); //get the cGameDataSkirmish
cGameDataCnc *The_Cnc_Game(); //get the cGameDataCnc
cGameDataSinglePlayer *The_Single_Player_Game(); //get the cGameDataSinglePlayer
bool Is_Script_Attached(GameObject *obj,const char *script); //is the script attached
void Attach_Script_Once(GameObject *obj,const char *script,const char *params); //attach a script if its not already attached
void Attach_Script_Preset_Once(const char *script,const char *params,const char *preset,int team); //attach a script to all objects of preset if its not already attached
void Attach_Script_Type_Once(const char *script,const char *params,int type,int team); //attach a script to all objects of type if its not already attached
void Attach_Script_Building(const char *script,const char *params,int team); //attach a script to all buildings
void Attach_Script_Is_Preset(GameObject *obj,const char *preset,const char *script,const char *params,int team); //attach the script if object is of preset
void Attach_Script_Is_Type(GameObject *obj,int type,const char *script,const char *params,int team); //attach the script if object is of type
void Attach_Script_Player_Once(const char *script,const char *params,int team); //attach a script to all players if its not already attached
bool Is_A_Building(GameObject *obj); //is this object any building type
GameObject *Find_Closest_Non_Building_Object_By_Team(int Team,Vector3 position); //find the closest non building object to position
bool Is_Stealth(GameObject *obj); //is this object stealth
bool Get_Fly_Mode(GameObject *obj); //is this infantry flying via Set_Fly_Mode
void Send_Custom_All_Objects_Area(int message,const Vector3 &Position,float Distance,GameObject *sender,int team); //sends a custom to all objects in a given area
void Create_Effect_All_Stealthed_Objects_Area(const Vector3 &Position,float Distance,const char *object,const Vector3 &offset,int team); //creates an indicator object near every stealthed object in a given area
void Send_Custom_All_Objects(int message,GameObject *sender,int team); //sends a custom to all objects
void Kill_Occupants(GameObject *obj); //kill all the occupants of a vehicle
int Tally_Team_Size(int team); //gets the team size for a team
float Get_Team_Score(int team); //gets the score for a team (same as Game_Info uses)
const char *Get_IP_Address(int PlayerID); //gets the IP address for a player as a string in 1.2.3.4 format
char Get_Mine_Limit(); //gets the current mine limit (use the MLIMIT console command to set it)
bool Is_Gameplay_Permitted(); //is gameplay permitted
unsigned long Get_Ping(int PlayerID); //get the ping of a player
unsigned long Get_Kbits(int PlayerID); //get the Kbits/s of a player
void Remove_Duplicate_Script(GameObject *obj, const char *script); //remove duplicate scripts from an object
void Send_Custom_Event_To_Object(GameObject *sender,const char *Preset,int message,int param,float delay); //this is like Send_Custom_Event except it sends to all objects of the passed in preset
int Get_Vehicle_Seat_Count(GameObject *obj,int seat); //get the seat count for a vehicle
char *Get_Spawn_Char(int Team); //get the spawn character for a team
void Change_Spawn_Char(int Team,const char *Name); //change the spawn character for a team (does not reset after the map ends)
int Get_Building_Count_Team(int Team); //number of buildings a team has that are alive
void Ranged_Percentage_Damage_To_Vehicles(float Percentage,const char *Warhead,Vector3 Location,float DamageRadius,GameObject *Damager); //damage vehicles based on a percentage factor
int Get_Bandwidth(int PlayerID); //Get players current bandwidth (same as set by sbbo)
bool Is_Dedicated(); //returns false if game.exe, true if WFDS/LFDS
void Soldier_Transition_Vehicle(GameObject *obj); //makes the soldier exit the vehicle they are in (or if right next to a vehicle, get in)
bool Is_Linux(); //returns true if linux, false if win32
unsigned int Get_Current_Game_Mode(); //Get the current game mode, 0 = function error, 1 = single player, 2 = skirmish, 3 = WOL, 4 = GameSpy, 5 = LAN. May not always differentiate correctly between WOL, Gamespy and LAN, especially when running as a non-dedicated server.
int Get_Team(int ID); //get the team of a player
int Get_Rank(int ID); //get the rank of a player
int Get_Kills(int ID); //get the kills of a player
int Get_Deaths(int ID); //get the deaths of a player
float Get_Score(int ID); //get the score of a player
float Get_Money(int ID); //get the money of a player
float Get_Kill_To_Death_Ratio(int ID); //get the kill/death ratio of a player
float Get_Damage_Points(GameObject *obj); //get the damage points for an object
float Get_Death_Points(GameObject *obj); //get the death points for an object
int Get_C4_Mode(GameObject *obj); //get the C4 mode for a C4GameObj, 1 = remote, 2 = timed, 3 = proximity, anything else is invalid
const char *Get_IP_Port(int PlayerID); //gets the IP address and port for a player as a string in 1.2.3.4;5 format
char *Get_Objects_File(); //returns the extension of the current objects file
void Change_Objects_File(const char *Name); //changes the extension of the objects file to load
int Get_Veh_Owner(GameObject *obj); //get the owner of a vehicle
GameObject *Find_My_Veh(GameObject *obj); //find my vehicle
int Get_C4_Count_Proximity(int Team); //get the Proxy C4 count
int Get_C4_Count_Remote(int Team); //get the Remote C4 count
void Track_New_C4(); //track new C4
GameObject *Find_Base_Defense(int Team); //find the base defence for this team
void Attach_Script_All_Buildings_Team(int Team,const char *Script,const char *Params,bool Once); //Attaches a script to all buildings on a team
void Attach_Script_All_DecPhys_Team(int Team,const char *Script,const char *Params,bool Once); //Attaches a script to all decoration objects on a team
